/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileStoreFilter;
import java.io.File;

public class ChineseFinder {
    public static void main(String[] args) throws CMyException {
        if (args.length >= 3) {
            ChineseFinder.handleFolder(args[0], args[1], args[2]);
        } else {
            ChineseFinder.handleFolder(args[0], args[1]);
        }
    }

    public static void handleFolder(String sSrcPath, String sDestPath) throws CMyException {
        FileService srcFile = new FileService(sSrcPath);
        FileStore[] srcFiles = srcFile.listFiles();
        for (int i = 0; i < srcFiles.length; ++i) {
            String sSubSrcPath = srcFiles[i].getAbsolutePath();
            String sFileName = srcFiles[i].getName();
            String sSubDestPath = sDestPath + File.separator + sFileName;
            if (srcFiles[i].isDirectory()) {
                ChineseFinder.handleFolder(sSubSrcPath, sSubDestPath);
                continue;
            }
            ChineseFinder.handleFile(sSubSrcPath, sSubDestPath);
        }
    }

    public static void handleFolder(String sSrcPath, String sDestPath, final String sFileExt) throws CMyException {
        FileService srcFile = new FileService(sSrcPath);
        FileStore[] srcFiles = srcFile.listFiles(new FileStoreFilter(){

            @Override
            public boolean accept(FileStore pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(sFileExt);
            }
        });
        for (int i = 0; i < srcFiles.length; ++i) {
            String sSubSrcPath = srcFiles[i].getAbsolutePath();
            String sFileName = srcFiles[i].getName();
            String sSubDestPath = sDestPath + File.separator + sFileName;
            if (srcFiles[i].isDirectory()) {
                ChineseFinder.handleFolder(sSubSrcPath, sSubDestPath, sFileExt);
                continue;
            }
            ChineseFinder.handleFile(sSubSrcPath, sSubDestPath);
        }
    }

    public static void handleFile(String sSrcFileName, String sDestFileName) throws CMyException {
        String sEncoding = CharsetDetector.detect(sSrcFileName);
        String sContent = CMyFile.readFile(sSrcFileName, sEncoding);
        if (CMyString.isContainChineseChar(sContent)) {
            CMyFile.writeFile(sDestFileName, sContent, sEncoding);
        }
    }
}

