/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.WCMException;
import com.trs.scm.domain.ISCMMicroUserMgr;
import com.trs.scm.domain.SCMAuthServer;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.Accounts;
import com.trs.scm.sdk.model.MicroUser;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.ArrayList;
import java.util.List;

public class SCMMicroUserServiceProvider
implements ISelfDefinedServiceProvider {
    private ISCMMicroUserMgr m_oSCMMicroUserMgr = (ISCMMicroUserMgr)DreamFactory.createObjectById("ISCMMicroUserMgr");

    public MicroUser findRelateMicroUser(MethodContext _oMethodContext) throws Throwable {
        int nAccountId = _oMethodContext.getValue("AccountId", 0);
        Account oAccount = Account.findById(nAccountId);
        if (oAccount == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u8d26\u53f7\u4e0d\u5b58\u5728\u3002[ID=" + nAccountId + "]");
        }
        User oUser = ContextHelper.getLoginUser();
        if (!SCMAuthServer.hasRight(oUser, oAccount, 44)) {
            throw new WCMException("\u60a8\u6ca1\u6709\u4f7f\u7528\u8d26\u53f7\u7684\u6743\u9650\u3002[ID=" + nAccountId + "]");
        }
        return this.m_oSCMMicroUserMgr.findRelateMicroUser(oAccount);
    }

    public List<MicroUser> findRelateMicroUsers(MethodContext _oMethodContext) throws Throwable {
        String sAccountIds;
        User oUser = ContextHelper.getLoginUser();
        Accounts oAccounts = Accounts.findByIds(oUser, sAccountIds = _oMethodContext.getValue("AccountIds"));
        if (oAccounts == null || oAccounts.size() == 0) {
            throw new WCMException("\u6307\u5b9a\u7684\u8d26\u53f7\u96c6\u5408\u4e3a\u7a7a\u3002[IDS=" + sAccountIds + "]");
        }
        ArrayList<MicroUser> oMicroUsers = new ArrayList<MicroUser>();
        int nSize = oAccounts.size();
        for (int i = 0; i < nSize; ++i) {
            Account oAccount = (Account)oAccounts.getAt(i);
            if (oAccount == null) continue;
            if (!SCMAuthServer.hasRight(oUser, oAccount, 44)) {
                throw new WCMException("\u60a8\u6ca1\u6709\u4f7f\u7528\u8d26\u53f7\u7684\u6743\u9650\u3002[ID=" + oAccount.getId() + "]");
            }
            oMicroUsers.add(this.m_oSCMMicroUserMgr.findRelateMicroUser(oAccount));
        }
        return oMicroUsers;
    }
}

