/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.util;

import com.trs.infra.util.CMyString;
import com.trs.scm.sdk.model.Comment;
import com.trs.scm.sdk.model.CommentWrapper;
import com.trs.scm.sdk.model.Favorite;
import com.trs.scm.sdk.model.FavoriteWrapper;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.model.MicroContentWrapper;
import com.trs.scm.sdk.model.MicroMessage;
import com.trs.scm.sdk.model.MicroUser;
import com.trs.scm.sdk.model.TencentErrorMessage;
import com.trs.scm.sdk.util.TencentException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class TencentObjectUtil {
    private static Logger log = Logger.getLogger(TencentObjectUtil.class);

    public static MicroContent constructMicroContent(String _sResponseString) throws Exception {
        TencentObjectUtil.validResult(_sResponseString, "\u83b7\u53d6\u5fae\u535a");
        JSONObject oJsonObject = JSONObject.fromObject((Object)_sResponseString);
        oJsonObject = oJsonObject.getJSONObject("data");
        return TencentObjectUtil.constructMicroContent(oJsonObject);
    }

    public static MicroContentWrapper constructMicroContents(String _sResponseString) throws Exception {
        TencentObjectUtil.validResult(_sResponseString, "\u83b7\u53d6\u5fae\u535a");
        JSONObject oJsonObject = JSONObject.fromObject((Object)_sResponseString);
        oJsonObject = oJsonObject.getJSONObject("data");
        if (oJsonObject.isNullObject()) {
            log.warn((Object)("\u83b7\u53d6\u5230\u7684data\u5bf9\u8c61\u4e3anull\u3002\u5b8c\u6210\u7684\u8fd4\u56de\u503c\u4e3a\uff1a" + _sResponseString));
            return null;
        }
        String sInfo = "";
        try {
            sInfo = oJsonObject.getString("info");
        }
        catch (JSONException e) {
            throw new TencentException(8, "\u817e\u8baf\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff01\u8fd4\u56de\u6570\u636e\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u60a8\u7a0d\u540e\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        long lTotalNumber = -1L;
        try {
            String sTotalNum = oJsonObject.getString("totalnum");
            if (sTotalNum != null) {
                lTotalNumber = Long.parseLong(sTotalNum);
            }
        }
        catch (Exception sTotalNum) {
            // empty catch block
        }
        ArrayList<MicroContent> oMicroContents = new ArrayList<MicroContent>();
        MicroContentWrapper oMicroContentWrapper = new MicroContentWrapper(oMicroContents, lTotalNumber);
        int nHasNext = oJsonObject.getInt("hasnext");
        oMicroContentWrapper.setExtraAttribute("hasnext", nHasNext);
        if (sInfo == null) {
            return oMicroContentWrapper;
        }
        JSONArray jsonArray = oJsonObject.getJSONArray("info");
        int nSize = jsonArray.size();
        for (int i = 0; i < nSize; ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            MicroContent oMicroContent = TencentObjectUtil.constructMicroContent(jsonObject);
            oMicroContents.add(oMicroContent);
            if (nSize != i + 1) continue;
            String sLastId = oMicroContent.getId();
            String sTimeStamp = Long.toString(oMicroContent.getCreateDate().getTime() / 1000L);
            oMicroContentWrapper.setExtraAttribute("lastId", sLastId);
            oMicroContentWrapper.setExtraAttribute("timestamp", sTimeStamp);
        }
        oMicroContentWrapper.setMicroContents(oMicroContents);
        return oMicroContentWrapper;
    }

    public static void validResult(String _sResponseString, String _sOperDesc) throws TencentException {
        JSONObject _oJsonObject = JSONObject.fromObject((Object)_sResponseString);
        int nReturn = _oJsonObject.getInt("ret");
        if (nReturn == 0) {
            return;
        }
        int nErrCode = _oJsonObject.getInt("errcode");
        String sMsg = _oJsonObject.getString("msg");
        TencentException oCMyException = TencentErrorMessage.getCMyException(nReturn, nErrCode, sMsg);
        throw oCMyException;
    }

    private static MicroContent constructMicroContent(JSONObject _oJsonObject) {
        if (_oJsonObject.isNullObject()) {
            log.warn((Object)"\u8981\u8f6c\u6362\u7684json\u5bf9\u8c61\u4e3anull");
            return null;
        }
        MicroContent oMicroContent = new MicroContent();
        oMicroContent.setId(_oJsonObject.getString("id"));
        oMicroContent.setRepostCount(_oJsonObject.getInt("count"));
        oMicroContent.setSource(_oJsonObject.getString("from"));
        oMicroContent.setCommentCount(_oJsonObject.getInt("mcount"));
        oMicroContent.setContent(_oJsonObject.getString("text"));
        String sImage = _oJsonObject.getString("image");
        if (sImage == null || sImage.length() == 0 || "null".equalsIgnoreCase(sImage)) {
            oMicroContent.setBmiddlePic("");
            oMicroContent.setOriginalPic("");
            oMicroContent.setThumbnailPic("");
        } else {
            JSONArray oJsonArray = _oJsonObject.getJSONArray("image");
            int length = oJsonArray.size();
            for (int i = 0; i < length; ++i) {
                String sImageUrl = oJsonArray.getString(i);
                oMicroContent.addBmiddlePic(sImageUrl + "/460");
                oMicroContent.addOriginalPic(sImageUrl + "/2000");
                oMicroContent.addThumbnailPic(sImageUrl + "/160");
            }
        }
        long lTimeStamp = _oJsonObject.getLong("timestamp");
        oMicroContent.setExtraAttribute("timestamp", (Object)lTimeStamp);
        Date oCreateDate = new Date(lTimeStamp * 1000L);
        oMicroContent.setCreateDate(oCreateDate);
        int nType = _oJsonObject.getInt("type");
        boolean bRetweeded = false;
        if (nType == 2) {
            bRetweeded = true;
        }
        JSONObject oRetweedJson = _oJsonObject.getJSONObject("source");
        MicroContent oRetweed = null;
        if (!oRetweedJson.isNullObject()) {
            oRetweed = TencentObjectUtil.constructMicroContent(_oJsonObject.getJSONObject("source"));
        }
        oMicroContent.setRetweeted(bRetweeded);
        if (oRetweed != null && !CMyString.isEmpty(oRetweed.getContent())) {
            oMicroContent.setRetweetedMicroContent(oRetweed);
        } else {
            oMicroContent.setRetweetedMicroContent(null);
        }
        MicroUser oMicroUser = new MicroUser();
        oMicroUser.setId(_oJsonObject.getString("openid"));
        oMicroUser.setName(_oJsonObject.getString("nick"));
        String sHead = _oJsonObject.getString("head");
        if (sHead != null && sHead.length() > 0) {
            oMicroUser.setHead(sHead + "/50");
        }
        oMicroContent.setUser(oMicroUser);
        return oMicroContent;
    }

    public static MicroMessage constructMessage(String _sResponseString) throws Exception {
        TencentObjectUtil.validResult(_sResponseString, "\u83b7\u53d6\u672a\u8bfb\u6d88\u606f");
        JSONObject oJsonObject = JSONObject.fromObject((Object)_sResponseString);
        oJsonObject = oJsonObject.getJSONObject("data");
        if (oJsonObject.isNullObject()) {
            log.warn((Object)("\u83b7\u53d6\u5230\u7684data\u5bf9\u8c61\u4e3anull\u3002\u5b8c\u6210\u7684\u8fd4\u56de\u503c\u4e3a\uff1a" + _sResponseString));
            return null;
        }
        MicroMessage oMessage = new MicroMessage();
        long lUnReadAt = oJsonObject.getLong("mentions");
        long lUnReadComment = 0L;
        long lUnReadMicroContent = oJsonObject.getLong("home");
        oMessage.setUnreadCount(3, lUnReadAt);
        oMessage.setUnreadCount(2, lUnReadComment);
        oMessage.setUnreadCount(1, lUnReadMicroContent);
        return oMessage;
    }

    public static FavoriteWrapper constructFavorites(String _responseString, int _nReqNum) throws Exception {
        if (_responseString.contains("tweet has  been deleted")) {
            return null;
        }
        TencentObjectUtil.validResult(_responseString, "\u83b7\u53d6\u6536\u85cf\u4fe1\u606f");
        JSONObject jsonObject = JSONObject.fromObject((Object)_responseString);
        return TencentObjectUtil.constructFavorites(jsonObject.getJSONObject("data"), _nReqNum);
    }

    private static FavoriteWrapper constructFavorites(JSONObject _json, int _nReqNum) throws Exception {
        int nSize;
        String sInfo;
        List<Favorite> favorites = new ArrayList<Favorite>();
        long lTotalNumber = 0L;
        FavoriteWrapper favoriteWrapper = null;
        if (_json == null || _json.toString().equals("null")) {
            return favoriteWrapper;
        }
        favoriteWrapper = new FavoriteWrapper(favorites, lTotalNumber);
        try {
            sInfo = _json.getString("info");
            if (sInfo == null || sInfo.equals("null")) {
                return favoriteWrapper;
            }
        }
        catch (Exception e) {
            return favoriteWrapper;
        }
        sInfo = _json.getString("info");
        lTotalNumber = _json.getLong("totalnum");
        favoriteWrapper.setTotalNumber(lTotalNumber);
        int nHasNext = _json.getInt("hasnext");
        favoriteWrapper.setExtraAttribute("hasnext", nHasNext);
        if (sInfo == null) {
            return favoriteWrapper;
        }
        JSONArray oJsonArray = _json.getJSONArray("info");
        int nFavoriteListSize = nSize = oJsonArray.size();
        if (nHasNext != 1) {
            nFavoriteListSize = _nReqNum;
        }
        favorites = TencentObjectUtil.initFavoriteList(favorites, nFavoriteListSize);
        String sLastId = "0";
        String sTimeStamp = "0";
        for (int i = 0; i < nSize; ++i) {
            JSONObject oFavoriteInfo = oJsonArray.getJSONObject(i);
            Favorite oFavorite = TencentObjectUtil.constructFavorite(oFavoriteInfo);
            favorites.set(i, oFavorite);
            if (nSize != i + 1) continue;
            sLastId = oFavorite.getMicroContent().getId();
            sTimeStamp = Long.toString(oFavorite.getFavoriteTime().getTime() / 1000L);
        }
        favoriteWrapper.setFavorites(favorites);
        favoriteWrapper.setExtraAttribute("lastId", sLastId);
        favoriteWrapper.setExtraAttribute("timestamp", sTimeStamp);
        return favoriteWrapper;
    }

    private static List<Favorite> initFavoriteList(List<Favorite> _oFavorites, int _nSize) {
        if (_oFavorites == null) {
            _oFavorites = new ArrayList<Favorite>();
        }
        for (int i = 0; i < _nSize; ++i) {
            _oFavorites.add(null);
        }
        return _oFavorites;
    }

    private static Favorite constructFavorite(JSONObject _oJsonObject) {
        MicroContent oMicroContent = TencentObjectUtil.constructMicroContent(_oJsonObject);
        Favorite oFavorite = new Favorite();
        oFavorite.setMicroContent(oMicroContent);
        long stroreTime = _oJsonObject.getLong("timestamp");
        Date oFavoriteTime = new Date(stroreTime * 1000L);
        oFavorite.setFavoriteTime(oFavoriteTime);
        return oFavorite;
    }

    public static MicroUser constructMicroUser(String _sResponseString) throws Exception {
        return TencentObjectUtil.constructMicroUser(_sResponseString, true);
    }

    public static MicroUser constructMicroUser(String _sResponseString, boolean _bSelf) throws Exception {
        TencentObjectUtil.validResult(_sResponseString, "\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
        JSONObject oJsonObject = JSONObject.fromObject((Object)_sResponseString);
        oJsonObject = oJsonObject.getJSONObject("data");
        if (oJsonObject.isNullObject()) {
            return null;
        }
        String sUId = oJsonObject.getString("openid");
        String sNickName = oJsonObject.getString("nick");
        String sAccountName = oJsonObject.getString("name");
        String sHead = oJsonObject.getString("head");
        String sDesc = oJsonObject.getString("introduction");
        int nSex = oJsonObject.getInt("sex");
        long lFlowerCount = oJsonObject.getLong("fansnum");
        long lFriendCount = oJsonObject.getLong("idolnum");
        long lTweetCount = oJsonObject.getLong("tweetnum");
        String sCityCode = oJsonObject.getString("city_code");
        int nCityCode = 0;
        if (sCityCode != null && sCityCode.length() > 0) {
            nCityCode = Integer.parseInt(sCityCode);
        }
        String sProvinceCode = oJsonObject.getString("province_code");
        int nProvinceCode = 0;
        if (sProvinceCode != null && sProvinceCode.length() > 0) {
            nProvinceCode = Integer.parseInt(sProvinceCode);
        }
        String sLocation = oJsonObject.getString("location");
        int isVip = oJsonObject.getInt("isvip") + oJsonObject.getInt("isent");
        boolean bVip = isVip != 0;
        MicroUser oUser = new MicroUser();
        oUser.setId(sUId);
        oUser.setName(sNickName);
        oUser.setExtraAttribute("AccountName", sAccountName);
        if (sHead != null && sHead.length() > 0) {
            oUser.setHead(sHead + "/50");
        }
        oUser.setDescription(sDesc);
        oUser.setMale(nSex == 1);
        oUser.setFollowersCount(lFlowerCount);
        oUser.setFriendsCount(lFriendCount);
        oUser.setMicroContentCount(lTweetCount);
        oUser.setCityCode(nCityCode);
        oUser.setProvinceCode(nProvinceCode);
        oUser.setLocation(sLocation);
        oUser.setVip(bVip);
        if (!_bSelf) {
            int isMyFriends = oJsonObject.getInt("ismyidol");
            int isFollowedMe = oJsonObject.getInt("ismyfans");
            oUser.setFollowing(isMyFriends == 1);
            oUser.setFollowMe(isFollowedMe == 1);
        }
        return oUser;
    }

    public static CommentWrapper constructComments(String _sResponseString) throws Exception {
        TencentObjectUtil.validResult(_sResponseString, "\u83b7\u53d6\u8bc4\u8bba");
        long lTotalNumber = 0L;
        ArrayList<Comment> comments = new ArrayList<Comment>();
        CommentWrapper commentWrapper = new CommentWrapper(comments, lTotalNumber);
        JSONObject oJsonObject = JSONObject.fromObject((Object)_sResponseString);
        oJsonObject = oJsonObject.getJSONObject("data");
        if (oJsonObject.isNullObject()) {
            log.warn((Object)("\u83b7\u53d6\u5230\u7684data\u5bf9\u8c61\u4e3anull\u3002\u5b8c\u6210\u7684\u8fd4\u56de\u503c\u4e3a\uff1a" + _sResponseString));
            return commentWrapper;
        }
        lTotalNumber = oJsonObject.getLong("totalnum");
        commentWrapper.setTotalNumber(lTotalNumber);
        int nHasNext = oJsonObject.getInt("hasnext");
        commentWrapper.setExtraAttribute("hasnext", nHasNext);
        String sInfo = null;
        try {
            sInfo = oJsonObject.getString("info");
        }
        catch (NullPointerException e) {
            return commentWrapper;
        }
        catch (JSONException e) {
            return commentWrapper;
        }
        if (sInfo == null) {
            return commentWrapper;
        }
        JSONArray jsonArray = oJsonObject.getJSONArray("info");
        int nSize = jsonArray.size();
        for (int i = 0; i < nSize; ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Comment comment = TencentObjectUtil.constructComment(jsonObject);
            comments.add(comment);
            if (nSize != i + 1) continue;
            String sLastId = comment.getCommentId();
            String sTimeStamp = Long.toString(comment.getCreateDate().getTime() / 1000L);
            commentWrapper.setExtraAttribute("lastId", sLastId);
            commentWrapper.setExtraAttribute("timestamp", sTimeStamp);
        }
        commentWrapper.setComments(comments);
        return commentWrapper;
    }

    private static Comment constructComment(JSONObject _oJsonObject) {
        MicroContent oMicroContent = TencentObjectUtil.constructMicroContent(_oJsonObject);
        if (oMicroContent == null) {
            return null;
        }
        Comment comment = new Comment();
        comment.setCommentId(oMicroContent.getId());
        comment.setContent(oMicroContent.getContent());
        comment.setCreateDate(oMicroContent.getCreateDate());
        comment.setReplyMicroContent(oMicroContent.getRetweetedMicroContent());
        comment.setSource(oMicroContent.getSource());
        comment.setUser(oMicroContent.getUser());
        return comment;
    }
}

