/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.impl;

import com.trs.infra.util.CMyException;
import com.trs.scm.sdk.impl.AbstractCommentMgr;
import com.trs.scm.sdk.model.Comment;
import com.trs.scm.sdk.model.CommentWrapper;
import com.trs.scm.sdk.model.ExtraParams;
import com.trs.scm.sdk.model.OAuth;
import com.trs.scm.sdk.model.SinaErrorMessage;
import com.trs.scm.sdk.util.SinaObjectUtil;
import org.apache.log4j.Logger;
import weibo4j.Comments;
import weibo4j.Timeline;
import weibo4j.Weibo;
import weibo4j.model.CommentWapper;
import weibo4j.model.Paging;
import weibo4j.model.Status;
import weibo4j.model.WeiboException;

public class SinaCommentMgr
extends AbstractCommentMgr {
    private static Logger logger = Logger.getLogger(SinaCommentMgr.class);
    private Weibo m_oWeibo = new Weibo();
    private Comments m_oSinaComments;

    public SinaCommentMgr(OAuth auth) {
        super(auth);
        this.m_oWeibo.setToken(this.m_oOAuth.getOAuth_token());
        this.m_oSinaComments = new Comments();
        this.m_oSinaComments.setToken(this.m_oOAuth.getOAuth_token());
    }

    @Override
    public Comment createComment(String content, String microContentId, ExtraParams extraParams) throws Exception {
        if (microContentId == null || microContentId.length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u7684\u5fae\u535aID\u4e3a\u7a7a\uff01");
        }
        this.checkContentLength(content);
        Timeline oTimeline = new Timeline();
        oTimeline.setToken(this.m_oOAuth.getOAuth_token());
        Status oStatus = null;
        try {
            oStatus = oTimeline.showStatus(microContentId);
        }
        catch (WeiboException _oWeiboException) {
            int nTimeOut;
            if (_oWeiboException.getErrorCode() == -1 && (nTimeOut = extraParams.getParamAsInt("StatusTimeOut", 0)) < 3) {
                extraParams.setParam("StatusTimeOut", nTimeOut + 1);
                Thread.currentThread();
                Thread.sleep(300L);
                return this.createComment(content, microContentId, extraParams);
            }
            CMyException oCMyException = SinaErrorMessage.getCMyException((Exception)((Object)_oWeiboException));
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        catch (Exception e) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        int comment_ori = -1;
        if (oStatus.getRetweetedStatus() != null) {
            comment_ori = extraParams.getParamAsInt("comment_ori", 0);
        }
        weibo4j.model.Comment oSinaComment = null;
        try {
            oSinaComment = comment_ori >= 0 ? this.m_oSinaComments.createComment(content, microContentId, Integer.valueOf(comment_ori)) : this.m_oSinaComments.createComment(content, microContentId);
        }
        catch (WeiboException _oWeiboException) {
            int nTimeOut;
            if (_oWeiboException.getErrorCode() == -1 && (nTimeOut = extraParams.getParamAsInt("CommentTimeOut", 0)) < 3) {
                extraParams.setParam("CommentTimeOut", nTimeOut + 1);
                Thread.currentThread();
                Thread.sleep(300L);
                return this.createComment(content, microContentId, extraParams);
            }
            CMyException oCMyException = SinaErrorMessage.getCMyException((Exception)((Object)_oWeiboException));
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        catch (Exception e) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        Comment oResult = null;
        try {
            oResult = SinaObjectUtil.constructMicroComment(oSinaComment);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u521b\u5efaMicroComment\u5bf9\u8c61\u629b\u9519\uff01");
            throw new Exception("\u521b\u5efaMicroComment\u5bf9\u8c61\u629b\u9519\uff01", _oException);
        }
        return oResult;
    }

    @Override
    public boolean destroyComment(String commentId) throws Exception {
        if (commentId == null || commentId.length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u7684\u8bc4\u8bbaID\u4e3a\u7a7a\uff01");
        }
        weibo4j.model.Comment oSinaComment = null;
        try {
            oSinaComment = this.m_oSinaComments.destroyComment(commentId);
        }
        catch (Exception _oWeiboException) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        return oSinaComment != null;
    }

    @Override
    public CommentWrapper getCommentMentions(int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        Paging page = SinaObjectUtil.constructSinaPaging(pageIndex, pageSize, extraParams);
        Integer filter_by_source = extraParams.getParamAsInt("filter_by_source", 0);
        Integer filter_by_author = extraParams.getParamAsInt("filter_by_author", 0);
        CommentWapper oSinaCommentWrapper = null;
        try {
            oSinaCommentWrapper = this.m_oSinaComments.getCommentMentions(page, filter_by_source, filter_by_author);
        }
        catch (WeiboException _oWeiboException) {
            int nTimeOut;
            if (_oWeiboException.getErrorCode() == -1 && (nTimeOut = extraParams.getParamAsInt("TimeOut", 0)) < 3) {
                extraParams.setParam("TimeOut", nTimeOut + 1);
                Thread.currentThread();
                Thread.sleep(300L);
                return this.getCommentMentions(pageIndex, pageSize, extraParams);
            }
            CMyException oCMyException = SinaErrorMessage.getCMyException((Exception)((Object)_oWeiboException));
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        catch (Exception e) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        CommentWrapper oResult = null;
        try {
            oResult = SinaObjectUtil.constructMicroCommentWrapper(oSinaCommentWrapper, pageIndex, pageSize);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u521b\u5efaMicroCommentWrapper\u5bf9\u8c61\u629b\u9519\uff01");
            throw new Exception("\u521b\u5efaMicroCommentWrapper\u5bf9\u8c61\u629b\u9519\uff01", _oException);
        }
        return oResult;
    }

    @Override
    public CommentWrapper getCommentsByMCId(String microContentId, int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        if (microContentId == null || microContentId.length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u7684\u5fae\u535aID\u4e3a\u7a7a\uff01");
        }
        Paging page = SinaObjectUtil.constructSinaPaging(pageIndex, pageSize, extraParams);
        Integer filter_by_author = extraParams.getParamAsInt("filter_by_author", 0);
        CommentWapper oSinaCommentWrapper = null;
        try {
            oSinaCommentWrapper = this.m_oSinaComments.getCommentById(microContentId, page, filter_by_author);
        }
        catch (WeiboException _oWeiboException) {
            int nTimeOut;
            if (_oWeiboException.getErrorCode() == -1 && (nTimeOut = extraParams.getParamAsInt("TimeOut", 0)) < 3) {
                extraParams.setParam("TimeOut", nTimeOut + 1);
                Thread.currentThread();
                Thread.sleep(300L);
                return this.getCommentsByMCId(microContentId, pageIndex, pageSize, extraParams);
            }
            CMyException oCMyException = SinaErrorMessage.getCMyException((Exception)((Object)_oWeiboException));
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        catch (Exception e) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        CommentWrapper oResult = null;
        try {
            oResult = SinaObjectUtil.constructMicroCommentWrapper(oSinaCommentWrapper, pageIndex, pageSize);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u521b\u5efaMicroCommentWrapper\u5bf9\u8c61\u629b\u9519\uff01");
            throw new Exception("\u521b\u5efaMicroCommentWrapper\u5bf9\u8c61\u629b\u9519\uff01", _oException);
        }
        return oResult;
    }

    @Override
    public CommentWrapper getCommentsByMe(int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        Paging page = SinaObjectUtil.constructSinaPaging(pageIndex, pageSize, extraParams);
        Integer filter_by_source = extraParams.getParamAsInt("filter_by_author", 0);
        CommentWapper oSinaCommentWrapper = null;
        try {
            oSinaCommentWrapper = this.m_oSinaComments.getCommentByMe(page, filter_by_source);
        }
        catch (WeiboException _oWeiboException) {
            int nTimeOut;
            if (_oWeiboException.getErrorCode() == -1 && (nTimeOut = extraParams.getParamAsInt("TimeOut", 0)) < 3) {
                extraParams.setParam("TimeOut", nTimeOut + 1);
                Thread.currentThread();
                Thread.sleep(300L);
                return this.getCommentsByMe(pageIndex, pageSize, extraParams);
            }
            CMyException oCMyException = SinaErrorMessage.getCMyException((Exception)((Object)_oWeiboException));
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        catch (Exception e) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        CommentWrapper oResult = null;
        try {
            oResult = SinaObjectUtil.constructMicroCommentWrapper(oSinaCommentWrapper, pageIndex, pageSize);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u521b\u5efaMicroCommentWrapper\u5bf9\u8c61\u629b\u9519\uff01");
            throw new Exception("\u521b\u5efaMicroCommentWrapper\u5bf9\u8c61\u629b\u9519\uff01", _oException);
        }
        return oResult;
    }

    @Override
    public CommentWrapper getCommentsToMe(int pageIndex, int pageSize, ExtraParams extraParams) throws Exception {
        Paging page = SinaObjectUtil.constructSinaPaging(pageIndex, pageSize, extraParams);
        Integer filter_by_source = extraParams.getParamAsInt("filter_by_source", 0);
        Integer filter_by_author = extraParams.getParamAsInt("filter_by_author", 0);
        CommentWapper oSinaCommentWrapper = null;
        try {
            oSinaCommentWrapper = this.m_oSinaComments.getCommentToMe(page, filter_by_source, filter_by_author);
        }
        catch (WeiboException _oWeiboException) {
            int nTimeOut;
            if (_oWeiboException.getErrorCode() == -1 && (nTimeOut = extraParams.getParamAsInt("TimeOut", 0)) < 3) {
                extraParams.setParam("TimeOut", nTimeOut + 1);
                Thread.currentThread();
                Thread.sleep(300L);
                return this.getCommentsToMe(pageIndex, pageSize, extraParams);
            }
            CMyException oCMyException = SinaErrorMessage.getCMyException((Exception)((Object)_oWeiboException));
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        catch (Exception e) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        CommentWrapper oResult = null;
        try {
            oResult = SinaObjectUtil.constructMicroCommentWrapper(oSinaCommentWrapper, pageIndex, pageSize);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u521b\u5efaMicroCommentWrapper\u5bf9\u8c61\u629b\u9519\uff01");
            throw new Exception("\u521b\u5efaMicroCommentWrapper\u5bf9\u8c61\u629b\u9519\uff01", _oException);
        }
        return oResult;
    }

    @Override
    public Comment replyComment(String content, String commentId, ExtraParams extraParams) throws Exception {
        if (commentId == null || commentId.length() < 1) {
            throw new NullPointerException("\u8f93\u5165\u7684\u8bc4\u8bbaID\u4e3a\u7a7a\uff01");
        }
        this.checkContentLength(content);
        String oMicroContentID = extraParams.getParamAsString("MicroContentId");
        if (oMicroContentID == null || oMicroContentID.length() < 1) {
            throw new NullPointerException("\u65b0\u6d6aAPI\u63a5\u53e3\u5fc5\u987b\u540c\u65f6\u8f93\u5165\u8bc4\u8bbaID\u548c\u5fae\u535aID\uff0c\u8bf7\u5728\u989d\u5916\u53c2\u6570\u4e2d\u52a0\u5165\u5fae\u535aID\uff1a<\"MicroContentId\",\u5fae\u535aID>\uff01");
        }
        Integer without_mention = extraParams.getParamAsInt("without_mention", 0);
        Integer comment_ori = extraParams.getParamAsInt("comment_ori", 0);
        weibo4j.model.Comment oSinaComment = null;
        try {
            oSinaComment = this.m_oSinaComments.replyComment(commentId, oMicroContentID, content, without_mention, comment_ori);
        }
        catch (WeiboException _oWeiboException) {
            int nTimeOut;
            if (_oWeiboException.getErrorCode() == -1 && (nTimeOut = extraParams.getParamAsInt("TimeOut", 0)) < 3) {
                extraParams.setParam("TimeOut", nTimeOut + 1);
                Thread.currentThread();
                Thread.sleep(300L);
                return this.replyComment(oMicroContentID, commentId, extraParams);
            }
            CMyException oCMyException = SinaErrorMessage.getCMyException((Exception)((Object)_oWeiboException));
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        catch (Exception e) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(e);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        Comment oResult = null;
        try {
            oResult = SinaObjectUtil.constructMicroComment(oSinaComment);
        }
        catch (Exception _oException) {
            logger.error((Object)"\u521b\u5efaMicroComment\u5bf9\u8c61\u629b\u9519\uff01");
            throw new Exception("\u521b\u5efaMicroComment\u5bf9\u8c61\u629b\u9519\uff01", _oException);
        }
        return oResult;
    }
}

