/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.util;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.LockerMgr;
import com.trs.components.common.message.Message;
import com.trs.components.common.message.MessageServer;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public final class CmsObjUnlockTools {
    private static Logger s_logger = Logger.getLogger(CmsObjUnlockTools.class);
    private static final CMSBaseObjs EMPTY_OBJS = new CMSBaseObjs(User.getSystem()){

        @Override
        protected String getDbTableName() {
            return null;
        }

        @Override
        public String getIdFieldName() {
            return null;
        }

        @Override
        public Class getElementClass() {
            return null;
        }

        @Override
        public BaseObjs newInstance() throws Exception {
            return null;
        }
    };

    public static CMSObj findLockedObj(int _nObjType, int _nObjId) throws WCMException {
        CMSObj object = null;
        try {
            object = (CMSObj)BaseObj.findById(_nObjType, _nObjId);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return object;
    }

    public static boolean forceUnLocke(User _opUser, CMSObj _lockedobj) throws WCMException {
        if (_lockedobj == null) {
            return true;
        }
        User lockedUser = _lockedobj.getLockerUser();
        if (!_opUser.isAdministrator()) {
            throw new WCMException(1002, CMyString.format(I18NMessage.get(CmsObjUnlockTools.class, "CmsObjUnlockTools.label1", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u89e3\u9501[{0}]\u9501\u5b9a\u7684[{1}]."), new String[]{lockedUser.toString(), _lockedobj.toString()}) + I18NMessage.get(CmsObjUnlockTools.class, "CmsObjUnlockTools.label3", "]!\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u53ef\u4ee5\u5f3a\u5236\u89e3\u9664\u5bf9\u8c61\u7684\u9501\u5b9a."));
        }
        _lockedobj.unlock();
        CmsObjUnlockTools.notifyUnlock(_opUser, lockedUser, _lockedobj);
        return true;
    }

    private static void notifyUnlock(User _opUser, User _lockedUser, CMSObj _lockedobj) {
        try {
            Message message = new Message();
            message.setTitle(I18NMessage.get(CmsObjUnlockTools.class, "CmsObjUnlockTools.label4", "\u5bf9\u8c61\u89e3\u9501\u901a\u77e5"));
            String name = _lockedUser.getNickName();
            if (CMyString.isEmpty(name)) {
                name = _lockedUser.getName();
            }
            message.setBody(name + I18NMessage.get(CmsObjUnlockTools.class, "CmsObjUnlockTools.label5", ",\u60a8\u597d.\n    \u56e0\u5de5\u4f5c\u9700\u8981,\u60a8\u9501\u5b9a\u7f16\u8f91\u7684[") + _lockedobj + I18NMessage.get(CmsObjUnlockTools.class, "CmsObjUnlockTools.label6", "]\u5df2\u88ab\u7cfb\u7edf\u7ba1\u7406\u5458[") + _opUser.getName() + I18NMessage.get(CmsObjUnlockTools.class, "CmsObjUnlockTools.label7", "]\u5f3a\u5236\u89e3\u9501!\n    \u8bf7\u624b\u5de5\u5907\u4efd\u60a8\u5f53\u524d\u7684\u64cd\u4f5c,\u8c22\u8c22!"));
            message.setCrUser(_opUser);
            message.setReceivers(204, String.valueOf(_lockedUser.getId()));
            message.setSendTypes("Message,Email");
            MessageServer.send(message);
        }
        catch (Exception e) {
            s_logger.error((Object)("[" + _opUser + "] failed to notify unlock[" + _lockedobj + "]"), (Throwable)e);
        }
    }

    public static CMSBaseObjs listLockedObjs(User _opUser, int _nObjType) throws WCMException {
        LockerMgr manager = (LockerMgr)DreamFactory.createObjectById("LockerMgr");
        String lockedids = manager.getLockedObjIds(_nObjType);
        if (CMyString.isEmpty(lockedids)) {
            return EMPTY_OBJS;
        }
        CMSBaseObjs lockedobjs = null;
        switch (_nObjType) {
            case 605: {
                lockedobjs = Documents.findByIds(_opUser, lockedids);
                break;
            }
            case 102: {
                lockedobjs = Templates.findByIds(_opUser, lockedids);
                break;
            }
            case 101: {
                lockedobjs = Channels.findByIds(_opUser, lockedids);
                break;
            }
            case 103: {
                lockedobjs = WebSites.findByIds(_opUser, lockedids);
                break;
            }
            default: {
                lockedobjs = EMPTY_OBJS;
            }
        }
        return lockedobjs;
    }
}

