/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.store;

import jcifs.smb.SmbException;
import jcifs.smb.SmbRandomAccessFile;

public class SmbRandomAccessFileWrapper {
    private SmbRandomAccessFile file;

    public SmbRandomAccessFileWrapper(SmbRandomAccessFile file) {
        this.file = file;
    }

    public int read() throws SmbException {
        return this.file.read();
    }

    public int read(byte[] b) throws SmbException {
        return this.file.read(b);
    }

    public int read(byte[] b, int off, int len) throws SmbException {
        return this.file.read(b, off, len);
    }

    public void readFully(byte[] b) throws SmbException {
        this.file.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws SmbException {
        int count;
        int n = 0;
        do {
            if ((count = this.read(b, off + n, len - n)) >= 0) continue;
            throw new RuntimeException("EOF");
        } while ((n += count) < len);
    }

    public int skipBytes(int n) throws SmbException {
        return this.file.skipBytes(n);
    }

    public void write(int b) throws SmbException {
        this.file.write(b);
    }

    public void write(byte[] b) throws SmbException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws SmbException {
        this.file.write(b, off, len);
    }

    public long getFilePointer() throws SmbException {
        return this.file.getFilePointer();
    }

    public void seek(long pos) throws SmbException {
        this.file.seek(pos);
    }

    public long length() throws SmbException {
        return this.file.length();
    }

    public void setLength(long newLength) throws SmbException {
        this.file.setLength(newLength);
    }

    public void close() throws SmbException {
        this.file.close();
    }

    public boolean readBoolean() throws SmbException {
        return this.file.readBoolean();
    }

    public byte readByte() throws SmbException {
        return this.file.readByte();
    }

    public int readUnsignedByte() throws SmbException {
        return this.file.readUnsignedByte();
    }

    public short readShort() throws SmbException {
        return this.file.readShort();
    }

    public int readUnsignedShort() throws SmbException {
        return this.file.readUnsignedShort();
    }

    public char readChar() throws SmbException {
        return this.file.readChar();
    }

    public int readInt() throws SmbException {
        return this.file.readInt();
    }

    public long readLong() throws SmbException {
        return this.file.readLong();
    }

    public float readFloat() throws SmbException {
        return this.file.readFloat();
    }

    public double readDouble() throws SmbException {
        return this.file.readDouble();
    }

    public String readLine() throws SmbException {
        return this.file.readLine();
    }

    public String readUTF() throws SmbException {
        return this.file.readUTF();
    }

    public void writeBoolean(boolean v) throws SmbException {
        this.file.writeBoolean(v);
    }

    public void writeByte(int v) throws SmbException {
        this.file.writeByte(v);
    }

    public void writeShort(int v) throws SmbException {
        this.file.writeShort(v);
    }

    public void writeChar(int v) throws SmbException {
        this.file.writeChar(v);
    }

    public void writeInt(int v) throws SmbException {
        this.file.writeInt(v);
    }

    public void writeLong(long v) throws SmbException {
        this.file.writeLong(v);
    }

    public void writeFloat(float v) throws SmbException {
        this.file.writeFloat(v);
    }

    public void writeDouble(double v) throws SmbException {
        this.file.writeDouble(v);
    }

    public void writeBytes(String s) throws SmbException {
        this.file.writeBytes(s);
    }

    public void writeChars(String s) throws SmbException {
        this.file.writeChars(s);
    }

    public void writeUTF(String str) throws SmbException {
        this.file.writeUTF(str);
    }
}

