/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.web;

import com.trs.components.web.IFieldHTMLParser;
import com.trs.components.web.IPropertiesBuilder;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseFieldHTMLParser
implements IFieldHTMLParser {
    private Map templatesCache = null;

    public abstract String getTemplatePath() throws WCMException;

    public String getTemplateEncoding(String sFileName) {
        return "GBK";
    }

    public String getTemplateKey(String sFileName) {
        return CMyFile.extractMainFileName(sFileName).toUpperCase();
    }

    private void loadTemplates() throws CMyException {
        String sCacheOrNot = ConfigServer.getServer().getSysConfigValue("NotCache4ModifyDocumentProperties", "false");
        if (this.templatesCache != null && "false".equalsIgnoreCase(sCacheOrNot)) {
            return;
        }
        this.templatesCache = new HashMap();
        FileService baseDir = new FileService(this.getTemplatePath());
        FileStore[] files = baseDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String sPath = files[i].getAbsolutePath();
            String sKey = this.getTemplateKey(sPath);
            String sContent = CMyFile.readFile(sPath, this.getTemplateEncoding(sPath));
            this.templatesCache.put(sKey, sContent);
        }
    }

    public String getTemplate(String sFieldName) throws CMyException {
        this.loadTemplates();
        String sContent = (String)this.templatesCache.get(sFieldName.toUpperCase());
        if (sContent == null) {
            sContent = (String)this.templatesCache.get("default");
        }
        return sContent;
    }

    @Override
    public String parse(String sFieldName, IPropertiesBuilder builder) throws CMyException {
        String sContent = this.getTemplate(sFieldName);
        return CMyString.parsePageVariables(sContent, builder.build());
    }
}

