/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.publisher.PageGenerator;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.epress.EpressFolderWrapper;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;

public class EPressHistoryGenerator {
    private Channel m_oChannel = null;
    private boolean m_zPubAction = true;

    public EPressHistoryGenerator(Channel _channel) {
        this(_channel, true);
    }

    public EPressHistoryGenerator(Channel _channel, boolean _zPubAction) {
        this.m_oChannel = _channel;
        this.m_zPubAction = _zPubAction;
    }

    public void generate() throws WCMException {
        this.generate(CMyDateTime.now());
    }

    public void generate(CMyDateTime _history) throws WCMException {
        if (this.m_oChannel == null) {
            throw new WCMException(20, "\u6ca1\u6709\u6307\u5b9a\u6709\u6548\u7684\u7535\u5b50\u62a5\u9891\u9053,\u4e0d\u80fd\u4ea7\u751f\u5386\u53f2\u6570\u636e!");
        }
        ContextHelper.initContext(User.getSystem());
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(this.m_oChannel);
        if (!folder.canDoOutlinePageTask()) {
            return;
        }
        EpressFolderWrapper wrapper = new EpressFolderWrapper(folder, _history);
        PublishTask task = null;
        if (this.m_zPubAction) {
            task = new PublishTask();
        }
        PublishTaskContext taskContext = new PublishTaskContext(task, wrapper);
        PublishPageContext pageContext = new PublishPageContext(wrapper, taskContext);
        if (_history != null) {
            pageContext.setExtraAttribute("HISTORYDATE", _history.toString());
        }
        PageGenerator.generateOutlines(pageContext);
    }

    public static void main(String[] arsgs) {
        try {
            Channel channel = Channel.findById(510);
            EPressHistoryGenerator genrator = new EPressHistoryGenerator(channel);
            CMyDateTime dt = CMyDateTime.now();
            dt.setDateWithString("2007-03-04", 0);
            genrator.generate(dt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

