/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.customize;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.customize.UserSettings;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class UserSetting
extends CMSObj {
    public static final int OBJ_TYPE = 314;
    public static final String DB_TABLE_NAME = "WCMUSERSETTING";
    public static final String DB_ID_NAME = "SETTINGID";
    public static final int CHANNEL_GROUP_TYPE = 800;
    public static final int TOP_REGION_NUMBER = 1;
    public static final int BOTTOM_REGION_NUMBER = 2;
    public static final int LEFT_REGION_NUMBER = 3;
    public static final int MIDDLE_REGION_NUMBER = 4;
    public static final int RIGHT_REGION_NUMBER = 5;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 314;
    }

    public String getValue() {
        return this.getPropertyAsString("CVALUE");
    }

    public boolean setValue(String _sValue) throws WCMException {
        return this.setProperty("CVALUE", _sValue);
    }

    public int getRegion() {
        return this.getPropertyAsInt("CREGION", 3);
    }

    public boolean setRegion(int _nRegionNumber) throws WCMException {
        return this.setProperty("CREGION", _nRegionNumber);
    }

    public int getUser() {
        return this.getPropertyAsInt("USERID", 0);
    }

    public User getOwner() throws WCMException {
        int nOwnerId = this.getUser();
        return User.findById(nOwnerId);
    }

    public boolean setUser(int _userId) throws WCMException {
        if (_userId <= 0) {
            throw new WCMException(10, I18NMessage.get(UserSetting.class, "UserSetting.label1", "\u65e0\u6548\u7684\u7528\u6237ID(UserSetting.setUser)"));
        }
        User user = User.findById(_userId);
        if (user == null) {
            throw new WCMException(10, I18NMessage.get(UserSetting.class, "UserSetting.label2", "\u65e0\u6548\u7684\u7528\u6237ID\uff1a\u7528\u6237\u4e0d\u5b58\u5728(UserSetting.setUser)"));
        }
        return this.setProperty("USERID", _userId);
    }

    public boolean setUser(User _user) throws WCMException {
        if (_user == null || !_user.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(UserSetting.class, "UserSetting.label3", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61(UserSetting.setUser)"));
        }
        return this.setUser(_user.getId());
    }

    public int getObjType() {
        return this.getPropertyAsInt("OBJTYPE", 0);
    }

    public boolean setObjType(int _objType) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(UserSetting.class, "UserSetting.label4", "ObjType\u503c\u4e0d\u5141\u8bb8\u4fee\u6539(UserSetting.setObjType)"));
        }
        return this.setProperty("OBJTYPE", _objType);
    }

    public int getObjId() {
        return this.getPropertyAsInt("OBJID", 0);
    }

    public boolean setObjId(int _objId) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1102, I18NMessage.get(UserSetting.class, "UserSetting.label5", "ObjId\u503c\u4e0d\u5141\u8bb8\u4fee\u6539(UserSetting.setObjId)"));
        }
        if (_objId < 0) {
            throw new WCMException(1104, I18NMessage.get(UserSetting.class, "UserSetting.label6", "ObjId\u503c\u65e0\u6548(UserSetting.setObjId)"));
        }
        return this.setProperty("OBJID", _objId);
    }

    public int getOrder() {
        return this.getPropertyAsInt("RANGEINDEX", 0);
    }

    public boolean setOrder(int _rangeIndex) throws WCMException {
        return this.setProperty("RANGEINDEX", _rangeIndex);
    }

    @Override
    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    @Override
    public boolean setAttribute(String _attribute) throws WCMException {
        return this.setProperty("ATTRIBUTE", _attribute);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void changeOrder(int _nNewOrder) throws WCMException {
        Statement oStmt;
        Connection oConn;
        block20: {
            oConn = null;
            oStmt = null;
            try {
                boolean bMoveToPrev;
                String sOrderRange;
                if (this.isAddMode()) {
                    sOrderRange = "RANGEINDEX>=" + _nNewOrder;
                    bMoveToPrev = true;
                } else {
                    int nOldOrder = this.getOrder();
                    if (_nNewOrder == nOldOrder) {
                        return;
                    }
                    if (_nNewOrder < nOldOrder) {
                        sOrderRange = " (RANGEINDEX>=" + _nNewOrder + ") and (RANGEINDEX<" + nOldOrder + ") and USERID=" + this.getUser();
                        bMoveToPrev = true;
                    } else {
                        sOrderRange = " (RANGEINDEX>" + nOldOrder + ") and (RANGEINDEX<=" + _nNewOrder + ") and USERID=" + this.getUser();
                        bMoveToPrev = false;
                    }
                }
                oConn = this.getDBManager().getConnection();
                oStmt = oConn.createStatement();
                String strSQL = "update " + this.getDbTableName() + " set RANGEINDEX=RANGEINDEX" + (bMoveToPrev ? "+1" : "-1") + " where " + sOrderRange;
                oStmt.executeUpdate(strSQL);
                if (oStmt == null) break block20;
            }
            catch (SQLException ex) {
                throw new WCMException(40, I18NMessage.get(UserSetting.class, "UserSetting.label7", "\u66f4\u65b0\u5c5e\u6027Order\u65f6\u5931\u8d25\uff08UserSetting.changeOrder\uff09"), ex);
            }
            catch (Exception ex) {
                throw new WCMException(0, I18NMessage.get(UserSetting.class, "UserSetting.label7", "\u66f4\u65b0\u5c5e\u6027Order\u65f6\u5931\u8d25\uff08UserSetting.changeOrder\uff09"), ex);
            }
            try {
                oStmt.close();
            }
            catch (Exception nOldOrder) {
                // empty catch block
            }
        }
        if (oConn == null) return;
        this.getDBManager().freeConnection(oConn);
        return;
        finally {
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
    }

    @Override
    public boolean isValid() throws WCMException {
        Number iOrder = null;
        if (this.isAddMode()) {
            Number iUserId = (Number)this.getAllProperty().get("USERID");
            Number iObjType = (Number)this.getAllProperty().get("OBJTYPE");
            Number iObjId = (Number)this.getAllProperty().get("OBJID");
            if (iUserId == null) {
                throw new WCMException(1106, I18NMessage.get(UserSetting.class, "UserSetting.label8", "\u5c5e\u6027UserId\u6ca1\u6709\u8bbe\u7f6e(UserSetting.isValid)"));
            }
            if (iObjType == null) {
                throw new WCMException(1106, I18NMessage.get(UserSetting.class, "UserSetting.label9", "\u5c5e\u6027ObjType\u6ca1\u6709\u8bbe\u7f6e(UserSetting.isValid)"));
            }
            if (iObjId == null) {
                throw new WCMException(1106, I18NMessage.get(UserSetting.class, "UserSetting.label10", "\u5c5e\u6027ObjId\u6ca1\u6709\u8bbe\u7f6e(UserSetting.isValid)"));
            }
            iOrder = (Number)this.getAllProperty().get("RANGEINDEX");
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(UserSetting.class, "UserSetting.label11", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(UserSetting.isValid)"));
            }
            iOrder = (Number)this.getNewProperty("RANGEINDEX");
        }
        if (iOrder != null) {
            try {
                this.changeOrder(iOrder.intValue());
            }
            catch (WCMException ex) {
                throw new WCMException(1100, I18NMessage.get(UserSetting.class, "UserSetting.label12", "\u8bbe\u7f6e\u5c5e\u6027Order\u65f6\u5931\u8d25(UserSetting.isValid)"), ex);
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(_currUser);
        }
    }

    public Channel getObjAsChannel(User _currUser) throws WCMException {
        int nObjType = this.getObjType();
        if (nObjType != 101) {
            return null;
        }
        int nObjId = this.getObjId();
        return Channel.findById(nObjId);
    }

    public static final UserSetting findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (UserSetting)BaseObj.findById(UserSetting.class, _nId);
    }

    public static final UserSetting createNewInstance() throws WCMException {
        return (UserSetting)BaseObj.createNewInstance(UserSetting.class);
    }

    public static final UserSetting findByKey(Object _oKey) throws WCMException {
        return (UserSetting)BaseObj.findByKey(UserSetting.class, _oKey);
    }

    public static final UserSetting findOf(User _currUser, int _nObjType, int _nObjId) throws WCMException {
        String sWhere = "USERID=? and ObjType=? and ObjId=?";
        int nUserId = _nObjType == 800 && _nObjId == 101 ? 0 : _currUser.getId();
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(0, nUserId);
        filter.addSearchValues(1, _nObjType);
        filter.addSearchValues(2, _nObjId);
        UserSettings userSettings = UserSettings.openWCMObjs(null, filter);
        if (userSettings.isEmpty()) {
            return null;
        }
        return (UserSetting)userSettings.getAt(0);
    }
}

