/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.ContentLinkType;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;

public class ContentLink
extends CMSObj {
    public static final int OBJ_TYPE = 106;
    public static final String DB_TABLE_NAME = "WCMCONTENTLINK";
    public static final String DB_ID_NAME = "CONTENTLINKID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 106;
    }

    @Override
    public boolean isValid() throws WCMException {
        String sLinkName = null;
        if (this.isAddMode()) {
            if (this.getProperty("LINKNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(ContentLink.class, "ContentLink.label1", "\u5c5e\u6027LINKNAME\u6ca1\u6709\u8bbe\u7f6e(ContentLink.isValid)"));
            }
            if (this.getProperty("SITEID") == null) {
                throw new WCMException(1106, I18NMessage.get(ContentLink.class, "ContentLink.label2", "\u5c5e\u6027SITEID\u6ca1\u6709\u8bbe\u7f6e(ContentLink.isValid)"));
            }
            if (this.getProperty("LINKURL") == null) {
                throw new WCMException(1106, I18NMessage.get(ContentLink.class, "ContentLink.label3", "\u5c5e\u6027LINKURL\u6ca1\u6709\u8bbe\u7f6e(ContentLink.isValid)"));
            }
            sLinkName = this.getPropertyAsString("LINKNAME");
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(ContentLink.class, "ContentLink.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ContentLink.isValid)"));
            }
            if (this.isChangeProperty("LINKNAME")) {
                sLinkName = this.getNewPropertyAsString("LINKNAME");
            }
        }
        if (!CMyString.isEmpty(sLinkName)) {
            sLinkName = sLinkName.toUpperCase();
            this.setProperty("LINKNAME", sLinkName);
        }
        return true;
    }

    public boolean setName(String _name) throws WCMException {
        return this.setPropertyWithString("LINKNAME", _name);
    }

    public String getName() {
        return this.getPropertyAsString("LINKNAME");
    }

    public boolean setLinkUrl(String _linkUrl) throws WCMException {
        return this.setPropertyWithString("LINKURL", _linkUrl);
    }

    public String getLinkUrl() {
        return this.getPropertyAsString("LINKURL");
    }

    public boolean setLinkTitle(String _linkTitle) throws WCMException {
        return this.setPropertyWithString("LINKTITLE", _linkTitle);
    }

    public String getLinkTitle() {
        return this.getPropertyAsString("LINKTITLE");
    }

    public boolean setSiteId(int _siteId) throws WCMException {
        return this.setProperty("SITEID", _siteId);
    }

    public int getSiteId() {
        return this.getPropertyAsInt("SITEID", 0);
    }

    public WebSite getSite() throws WCMException {
        return WebSite.findById(this.getSiteId());
    }

    public static final ContentLink findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (ContentLink)BaseObj.findById(ContentLink.class, _nId);
    }

    public static final ContentLink createNewInstance() throws WCMException {
        return (ContentLink)BaseObj.createNewInstance(ContentLink.class);
    }

    public static final ContentLink findByKey(Object _oKey) throws WCMException {
        return (ContentLink)BaseObj.findByKey(ContentLink.class, _oKey);
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(ContentLink.class, "ContentLink.label5", "[\u5185\u5bb9\u8d85\u94fe\u63a5-") + this.getId() + "]";
    }

    public int getLinkType() {
        return this.getPropertyAsInt("CONTENTLINKTYPE", 0);
    }

    public boolean setLinkType(int _nType) throws WCMException {
        return this.setProperty("CONTENTLINKTYPE", _nType);
    }

    public String getLinkTypeName() throws WCMException {
        int nTypeId = this.getLinkType();
        ContentLinkType type = ContentLinkType.findById(nTypeId);
        return type != null ? type.getTypeName() : I18NMessage.get(ContentLink.class, "ContentLink.label6", "\u672a\u77e5");
    }
}

