/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.resource.Status;
import com.trs.components.wcm.resource.Statuses;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ChannelSyn
extends CMSObj {
    public static final int OBJ_TYPE = 903;
    public static final String DB_TABLE_NAME = "WCMCHANNELSYN";
    public static final String DB_ID_NAME = "CHANNELSYNID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 903;
    }

    public int getSrcChannelId() {
        return this.getPropertyAsInt("SRCCHANNEL", 0);
    }

    public Channel getSrcChannel() throws WCMException {
        return Channel.findById(this.getSrcChannelId());
    }

    public boolean setSrcChannelId(int _nSrcChannelId) throws WCMException {
        if (!this.isAddMode() && _nSrcChannelId == this.getSrcChannelId()) {
            return false;
        }
        return this.setProperty("SRCCHANNEL", _nSrcChannelId);
    }

    public int getToChannelId() {
        return this.getPropertyAsInt("TOCHANNEL", 0);
    }

    public Channel getToChannel() throws WCMException {
        return Channel.findById(this.getToChannelId());
    }

    public boolean setToChannelId(int _nToChannelId) throws WCMException {
        if (!this.isAddMode() && _nToChannelId == this.getToChannelId()) {
            return false;
        }
        return this.setProperty("TOCHANNEL", _nToChannelId);
    }

    public String getWhereSql() {
        return this.getPropertyAsString("WHERESQL");
    }

    public boolean setWhereSql(String _sWhereSql) throws WCMException {
        return this.setProperty("WHERESQL", _sWhereSql);
    }

    public CMyDateTime getStartTime() {
        return (CMyDateTime)this.getProperty("SDATE");
    }

    public boolean setStartTime(CMyDateTime _startTime) throws WCMException {
        if (_startTime == null || _startTime.isNull()) {
            throw new WCMException(10, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label1", "\u65e0\u6548\u7684\u65f6\u95f4\u5bf9\u8c61(ChannelSyn.setStartTime)"));
        }
        return this.setProperty("SDATE", _startTime);
    }

    public CMyDateTime getEndTime() {
        return (CMyDateTime)this.getProperty("EDATE");
    }

    public boolean setEndTime(CMyDateTime _endTime) throws WCMException {
        if (_endTime == null || _endTime.isNull()) {
            throw new WCMException(10, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label2", "\u65e0\u6548\u7684\u65f6\u95f4\u5bf9\u8c61(ChannelSyn.setEndTime)"));
        }
        return this.setProperty("EDATE", _endTime);
    }

    public CMyDateTime getDocStartTime() {
        return (CMyDateTime)this.getProperty("DOCSDATE");
    }

    public boolean setDocStartTime(CMyDateTime _startTime) throws WCMException {
        if (_startTime == null || _startTime.isNull()) {
            throw new WCMException(10, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label3", "\u65e0\u6548\u7684\u65f6\u95f4\u5bf9\u8c61(ChannelSyn.setDocStartTime)"));
        }
        return this.setProperty("DOCSDATE", _startTime);
    }

    public CMyDateTime getDocEndTime() {
        return (CMyDateTime)this.getProperty("DOCEDATE");
    }

    public boolean setDocEndTime(CMyDateTime _endTime) throws WCMException {
        if (_endTime == null || _endTime.isNull()) {
            throw new WCMException(10, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label4", "\u65e0\u6548\u7684\u65f6\u95f4\u5bf9\u8c61(ChannelSyn.setDocEndTime)"));
        }
        return this.setProperty("DOCEDATE", _endTime);
    }

    public String getStatusIds() {
        String sIds = this.getPropertyAsString("STATUSES");
        return sIds == null ? "" : sIds;
    }

    public Statuses getStatuses(User _currUser) throws WCMException {
        Statuses pubStatuses = null;
        try {
            String sIds = this.getStatusIds();
            pubStatuses = new Statuses(_currUser);
            if (sIds == null || sIds.length() == 0) {
                return pubStatuses;
            }
            StringTokenizer stIds = new StringTokenizer(sIds, ",");
            Status status = null;
            while (stIds.hasMoreElements()) {
                int nId = Integer.parseInt((String)stIds.nextElement());
                status = Status.findById(nId);
                if (status == null) continue;
                pubStatuses.addElement(status);
            }
            return pubStatuses;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label5", "\u53d6\u5141\u8bb8\u5206\u53d1\u7684\u6587\u6863\u72b6\u6001\u96c6\u5408\u5931\u8d25\uff08ChannelSyn.getStatuses\uff09"), ex);
        }
    }

    public boolean setStatus(String _statusIds) throws WCMException {
        if (_statusIds == null) {
            _statusIds = "";
        } else if ((_statusIds = _statusIds.trim()).length() > 0) {
            StringTokenizer stIds = new StringTokenizer(_statusIds, ",");
            while (stIds.hasMoreElements()) {
                String sId = (String)stIds.nextElement();
                try {
                    Integer.parseInt(sId);
                }
                catch (Exception ex) {
                    throw new WCMException(10, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label6", "\u65e0\u6548\u7684\u6587\u6863\u72b6\u6001\uff1a") + sId + "\uff08ChannelSyn.setStatus\uff09");
                }
            }
        }
        return this.setProperty("STATUSES", _statusIds);
    }

    public boolean addStatus(int _statusId) throws WCMException {
        Status status = Status.findById(_statusId);
        return this.addStatus(status);
    }

    public boolean addStatus(Status _status) throws WCMException {
        if (_status == null) {
            throw new WCMException(10, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label7", "\u6307\u5b9a\u7684\u6587\u6863\u72b6\u6001\u5bf9\u8c61\u4e3a\u7a7a\uff08ChannelSyn.addStatus\uff09"));
        }
        try {
            String sIdNew = String.valueOf(_status.getId());
            String sIds = (String)this.getNewProperty("STATUSES");
            if (sIds == null) {
                sIds = this.getStatusIds();
            }
            if (("," + sIds + ",").indexOf("," + sIdNew + ",") >= 0) {
                return false;
            }
            return this.setProperty("STATUSES", (sIds.length() == 0 ? "" : sIds + ",") + sIdNew);
        }
        catch (WCMException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label8", "\u6dfb\u52a0\u5141\u8bb8\u5206\u53d1\u7684\u6587\u6863\u72b6\u6001\u5931\u8d25\uff08ChannelSyn.addStatus\uff09"), ex);
        }
    }

    public int getTransmitType() {
        String sValue = this.getAttributeValue("TransmitType");
        if (CMyString.isEmpty(sValue)) {
            return 2;
        }
        return Integer.parseInt(sValue);
    }

    public void setTransmitType(int _nTransmitType) throws WCMException {
        this.setAttribute("TransmitType", Integer.toString(_nTransmitType));
    }

    private boolean validateTransmitType() {
        int nTransmitType = this.getTransmitType();
        switch (nTransmitType) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getAllProperty().get("SRCCHANNEL") == null) {
                throw new WCMException(1106, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label9", "\u5c5e\u6027SrcChannelId\u6ca1\u6709\u8bbe\u7f6e(ChannelSyn.isValid)"));
            }
            if (this.getAllProperty().get("TOCHANNEL") == null) {
                throw new WCMException(1106, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label10", "\u5c5e\u6027ToChannelId\u6ca1\u6709\u8bbe\u7f6e(ChannelSyn.isValid)"));
            }
            if (!this.validateTransmitType()) {
                throw new WCMException(1104, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label11", "\u4f20\u5165\u4e86\u65e0\u6548\u7684\u8f6c\u53d1\u7c7b\u578b\uff01(ChannelSyn.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(ChannelSyn.class, "ChannelSyn.label12", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ChannelSyn.isValid)"));
        }
        return true;
    }

    public static final ChannelSyn findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (ChannelSyn)BaseObj.findById(ChannelSyn.class, _nId);
    }

    public static final ChannelSyn createNewInstance() throws WCMException {
        return (ChannelSyn)BaseObj.createNewInstance(ChannelSyn.class);
    }

    public static final ChannelSyn findByKey(Object _oKey) throws WCMException {
        return (ChannelSyn)BaseObj.findByKey(ChannelSyn.class, _oKey);
    }

    public static boolean isValid(int _nSrcChannelId, int _nDstChannelId) throws WCMException {
        ArrayList<Integer> arToChannelIds = new ArrayList<Integer>();
        arToChannelIds.add(new Integer(_nSrcChannelId));
        arToChannelIds.add(new Integer(_nDstChannelId));
        return !ChannelSyn.containsToChannelId(_nDstChannelId, arToChannelIds);
    }

    private static boolean containsToChannelId(int _nSrcChannelId, ArrayList _arToChannelIds) throws WCMException {
        WCMFilter filter = new WCMFilter(DB_TABLE_NAME, "SRCCHANNEL=?", "", "distinct ToChannel");
        filter.addSearchValues(_nSrcChannelId);
        int[] pNewToChannelIds = DBManager.getDBManager().sqlExecuteIntsQuery(filter);
        if (pNewToChannelIds == null || pNewToChannelIds.length == 0) {
            return false;
        }
        for (int i = 0; i < pNewToChannelIds.length; ++i) {
            Integer iNewToChannelId = new Integer(pNewToChannelIds[i]);
            if (_arToChannelIds.indexOf(iNewToChannelId) >= 0) {
                return true;
            }
            _arToChannelIds.add(iNewToChannelId);
            if (!ChannelSyn.containsToChannelId(pNewToChannelIds[i], _arToChannelIds)) continue;
            return true;
        }
        return false;
    }
}

