/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain.intelligence;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.ChannelImporter;
import com.trs.components.wcm.content.domain.intelligence.IIntellMgr;
import com.trs.components.wcm.content.domain.intelligence.IIntellResLocator;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.Report;
import com.trs.infra.util.Reports;
import java.io.File;
import java.util.List;

public class IntelMgrImpl
implements IIntellMgr {
    IIntellResLocator intellResLocator = (IIntellResLocator)DreamFactory.createObjectById("IIntellResLocator");

    @Override
    public String getSiteIntroduceImgFilePath(String _sKind, String _sStyle) {
        try {
            String sImgFile = this.intellResLocator.getSiteKindStylePath(this.getSiteFromPath(), _sKind, _sStyle) + File.separatorChar + "introduce.gif";
            if (!CMyFile.fileExists(sImgFile)) {
                return null;
            }
            return sImgFile;
        }
        catch (WCMException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public String getSiteIntroduceContent(String _sKind, String _sStyle) throws WCMException {
        String sContentFile = this.intellResLocator.getSiteKindStylePath(this.getSiteFromPath(), _sKind, _sStyle) + File.separatorChar + "introduce.txt";
        if (!CMyFile.fileExists(sContentFile)) {
            return "";
        }
        try {
            return CMyFile.readFile(sContentFile);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(IntelMgrImpl.class, "IntelMgrImpl.label1", "\u8bfb\u53d6\u6587\u4ef6[") + sContentFile + I18NMessage.get(IntelMgrImpl.class, "IntelMgrImpl.label2", "]\u5931\u8d25\uff01"), e);
        }
    }

    @Override
    public Reports createNewSiteFrom(String _sKind, String _sStyle, String _sNewSiteName) throws WCMException {
        return this.createNewSiteFrom(_sKind, _sStyle, _sNewSiteName, null);
    }

    @Override
    public Reports createNewSiteFrom(String _sKind, String _sStyle, String _sNewSiteName, String _sSiteDesc) throws WCMException {
        String sDataFile = this.getSiteDataFile(_sKind, _sStyle);
        String sXMLFile = FilesMan.getFilesMan().copyFile(sDataFile, "UT", true);
        WebSite baseobj = new WebSite();
        baseobj.setName(_sNewSiteName);
        baseobj.setDesc(_sSiteDesc);
        long lStartTime = LogServer.startRecord(this.getLoginUserName(), "SITE_INTELL", I18NMessage.get(IntelMgrImpl.class, "IntelMgrImpl.label4", "\u667a\u80fd\u5efa\u7ad9"), baseobj);
        Reports importReports = new Reports("");
        try {
            ChannelImporter importer = (ChannelImporter)DreamFactory.createObjectById("ChannelImporter");
            importer.setNewSiteName(_sNewSiteName);
            importer.setNewSiteDesc(_sSiteDesc);
            importReports = importer.importFromFile(sXMLFile, null, null);
            importReports.setTitle(I18NMessage.get(IntelMgrImpl.class, "IntelMgrImpl.label5", "\u667a\u80fd\u521b\u5efa\u7ad9\u70b9"));
        }
        catch (WCMException e) {
            LogServer.endRecordFailedOperation(lStartTime, e);
            importReports.addFailedReport(I18NMessage.get(IntelMgrImpl.class, "IntelMgrImpl.label6", "\u667a\u80fd\u5efa\u7ad9\u5931\u8d25"), e);
            throw new WCMException(1100, I18NMessage.get(IntelMgrImpl.class, "IntelMgrImpl.label7", "\u667a\u80fd\u5efa\u7ad9\u5931\u8d25!"), e);
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        List reports = importReports.getSucessedReporter();
        Report report = null;
        if (!reports.isEmpty()) {
            report = (Report)reports.get(0);
            report.setRportTitle(I18NMessage.get(IntelMgrImpl.class, "IntelMgrImpl.label8", "\u6210\u529f\u521b\u5efa\u7ad9\u70b9!"));
        } else {
            report = importReports.getFailedReporterAt(0);
            report.setRportTitle(I18NMessage.get(IntelMgrImpl.class, "IntelMgrImpl.label9", "\u521b\u5efa\u7ad9\u70b9\u5931\u8d25!"));
        }
        return importReports;
    }

    private String getSiteFromPath() {
        return FilesMan.getFilesMan().getPathConfigValue("SF", 0);
    }

    @Override
    public String[] getSiteKinds() throws WCMException {
        return this.intellResLocator.findSiteKinds(this.getSiteFromPath());
    }

    @Override
    public String[] getSiteStyles(String _sKindName) throws WCMException {
        return this.intellResLocator.findSiteStylesOfKind(this.getSiteFromPath(), _sKindName);
    }

    @Override
    public String getSiteDemoLink(String _sKind, String _sStyle) throws WCMException {
        String sDemoLinkFile = this.intellResLocator.getSiteKindStylePath(this.getSiteFromPath(), _sKind, _sStyle) + File.separatorChar + "demo_url.txt";
        if (!CMyFile.fileExists(sDemoLinkFile)) {
            return null;
        }
        try {
            return CMyFile.readFile(sDemoLinkFile);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(IntelMgrImpl.class, "IntelMgrImpl.label1", "\u8bfb\u53d6\u6587\u4ef6[") + sDemoLinkFile + I18NMessage.get(IntelMgrImpl.class, "IntelMgrImpl.label2", "]\u5931\u8d25\uff01"), e);
        }
    }

    @Override
    public String getSiteDataFile(String _sKind, String _sStyle) throws WCMException {
        String sSiteDataFile = this.intellResLocator.getSiteKindStylePath(this.getSiteFromPath(), _sKind, _sStyle) + File.separatorChar + "data.zip";
        if (!CMyFile.fileExists(sSiteDataFile)) {
            throw new WCMException(I18NMessage.get(IntelMgrImpl.class, "IntelMgrImpl.label10", "\u6ca1\u6709\u6570\u636e\u6587\u4ef6\uff1a[") + sSiteDataFile + "]");
        }
        return sSiteDataFile;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private String getLoginUserName() {
        return this.getLoginUser().getName();
    }
}

