/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.logger.IObjLogger;
import com.trs.components.wcm.content.persistent.LoggerSwitch;
import com.trs.components.wcm.content.persistent.LoggerSwitchs;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.WCMDiscoveryFactory;
import com.trs.webframework.ServiceExcuteLogger;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class LoggerSwitchMgr {
    private static Logger logger = Logger.getLogger(LoggerSwitchMgr.class);
    private static LoggerSwitchMgr instance = null;
    private static LoggerSwitchs sysLoggers = null;
    private static HashMap<String, String> loggerMap = new HashMap();

    private LoggerSwitchMgr() {
        try {
            this.initLoggers();
        }
        catch (InstantiationException e) {
            logger.error((Object)"\u521d\u59cb\u5316LoggerSwitchMgr\u5931\u8d25", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"\u521d\u59cb\u5316LoggerSwitchMgr\u5931\u8d25", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"\u521d\u59cb\u5316LoggerSwitchMgr\u5931\u8d25", (Throwable)e);
        }
    }

    public static synchronized LoggerSwitchMgr getInstance() {
        if (instance == null) {
            instance = new LoggerSwitchMgr();
        }
        return instance;
    }

    public void switchState(int loggerId) throws WCMException {
        if (loggerId < 0) {
            return;
        }
        LoggerSwitch log = (LoggerSwitch)sysLoggers.getById(loggerId);
        this.switchState(log);
    }

    public void switchState(LoggerSwitch oLogger) throws WCMException {
        if (oLogger == null) {
            return;
        }
        int newState = oLogger.getLoggerState() ^ 1;
        oLogger.setLoggerState(newState);
        oLogger.save();
    }

    public LoggerSwitchs getSysLoggers() {
        if (sysLoggers == null || sysLoggers.size() < 1) {
            try {
                sysLoggers = LoggerSwitchs.openWCMObjs(ContextHelper.getLoginUser(), null);
            }
            catch (WCMException e) {
                logger.error((Object)"\u6570\u636e\u5e93\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            }
        }
        return sysLoggers;
    }

    public boolean checkLoggerState(String className) {
        if (sysLoggers == null || sysLoggers.size() < 1) {
            return true;
        }
        for (int i = 0; i < sysLoggers.size(); ++i) {
            LoggerSwitch log = (LoggerSwitch)sysLoggers.getAt(i);
            if (log == null || className == null) {
                return true;
            }
            if (!className.equalsIgnoreCase(log.getLoggerClassName())) continue;
            return log.getLoggerState() == 1;
        }
        return true;
    }

    public boolean checkLoggerState(LoggerSwitch oLog) {
        return this.checkLoggerState(oLog.getLoggerClassName());
    }

    private void initLoggers() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String value;
        Object loggerClassInstance;
        String key2;
        try {
            sysLoggers = LoggerSwitchs.openWCMObjs(ContextHelper.getLoginUser(), null);
        }
        catch (WCMException e) {
            logger.error((Object)"\u67e5\u8be2\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
        Iterator serviceIt = WCMDiscoveryFactory.getDiscovery().getImplementors("com.trs.webframework.ServiceExcuteLogger");
        Iterator persistenceIt = WCMDiscoveryFactory.getDiscovery().getImplementors("com.trs.cms.logger.IObjLogger");
        while (serviceIt.hasNext()) {
            try {
                key2 = (String)serviceIt.next();
                if (key2.equalsIgnoreCase("com.trs.webframework.AbstractLogger") || key2.equalsIgnoreCase("com.trs.webframework.DefaultDeleteLogger") || key2.equalsIgnoreCase("com.trs.webframework.DefaultSaveLogger") || (loggerClassInstance = (ServiceExcuteLogger)Class.forName(key2).newInstance()) == null) continue;
                value = loggerClassInstance.getClassDesc();
                loggerMap.put(key2, value);
            }
            catch (Throwable key2) {}
        }
        while (persistenceIt.hasNext()) {
            try {
                key2 = (String)persistenceIt.next();
                if (key2.equalsIgnoreCase("com.trs.cms.logger.IObjLogger") || (loggerClassInstance = (IObjLogger)Class.forName(key2).newInstance()) == null) continue;
                value = loggerClassInstance.getClassDesc();
                loggerMap.put(key2, value);
            }
            catch (Throwable key3) {}
        }
        this.synchronizeDB();
        try {
            sysLoggers = LoggerSwitchs.openWCMObjs(ContextHelper.getLoginUser(), null);
        }
        catch (WCMException e) {
            logger.error((Object)"\u67e5\u8be2\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    private void synchronizeDB() {
        for (String className : loggerMap.keySet()) {
            if (this.checkDuplicated(className)) continue;
            LoggerSwitch loggerSwitch = new LoggerSwitch();
            try {
                loggerSwitch.setLoggerClassName(className);
                loggerSwitch.setLoggerDesc(loggerMap.get(className));
                loggerSwitch.setLoggerState(1);
                loggerSwitch.save();
            }
            catch (WCMException e) {
                logger.error((Object)("\u4fdd\u5b58\u65e5\u5fd7\u7c7b\u3010CLASSNAME=" + className + "\u3011\u5931\u8d25"), (Throwable)e);
            }
        }
    }

    private boolean checkDuplicated(String className) {
        if (sysLoggers == null || sysLoggers.size() < 1) {
            return false;
        }
        for (int i = 0; i < sysLoggers.size(); ++i) {
            LoggerSwitch log = (LoggerSwitch)sysLoggers.getAt(i);
            if (log == null || className == null) {
                return false;
            }
            if (!className.equalsIgnoreCase(log.getLoggerClassName())) continue;
            return true;
        }
        return false;
    }
}

