/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.auth;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.domain.IRightObj;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;

public class WebSiteRightObjImpl
implements IRightObj {
    private WebSite m_oSite = null;

    @Override
    public boolean hasRight(User _currUser, int _nRightIndex) throws WCMException {
        if (_nRightIndex == -1) {
            return true;
        }
        if (_currUser.isAdministrator()) {
            return true;
        }
        String isPermitView = ConfigServer.getServer().getSysConfigValue("CREATER_CAN_SEE_OWN_SITE", "true");
        if (isPermitView.equalsIgnoreCase("true") && _currUser.getName().equalsIgnoreCase(this.m_oSite.getCrUserName())) {
            return true;
        }
        IObjectMemberMgr oObjectMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");
        if (_nRightIndex == 64 || _nRightIndex == 14) {
            return oObjectMemberMgr.isVisible(_currUser, this.m_oSite.getWCMType(), this.m_oSite.getId());
        }
        if (!oObjectMemberMgr.canOperate(_currUser, this.m_oSite.getWCMType(), this.m_oSite.getId())) {
            return false;
        }
        return AuthServer.hasRightOnSelf(_currUser, this.m_oSite, _nRightIndex);
    }

    @Override
    public int getId() {
        return this.m_oSite == null ? 0 : this.m_oSite.getId();
    }

    @Override
    public String getInfo() {
        if (this.m_oSite == null) {
            return null;
        }
        return this.m_oSite.toString();
    }

    @Override
    public CMSObj getSubstance() {
        return this.m_oSite;
    }

    @Override
    public int getType() {
        return 103;
    }

    @Override
    public boolean loadById(int _nId) throws WCMException {
        this.m_oSite = WebSite.findById(_nId);
        return true;
    }

    @Override
    public void makeFrom(CMSObj _oObj) throws WCMException {
        this.m_oSite = (WebSite)_oObj;
    }

    @Override
    public void setSubstance(CMSObj _oObj) {
        this.m_oSite = (WebSite)_oObj;
    }
}

