/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class StatBonusResultForUser {
    private Logger logger = Logger.getLogger(StatBonusResultForUser.class);
    private HashMap[] m_pResult = null;
    private List m_arUserNames = null;
    private List m_arDocIds = null;
    private int m_nBonusType;
    private boolean m_bSortDesc;

    public StatBonusResultForUser(int _nStatCount) {
        this.m_pResult = new HashMap[_nStatCount];
    }

    protected void setResult(HashMap _hResult, int _nIndex) throws WCMException {
        if (_nIndex >= this.m_pResult.length) {
            throw new WCMException("\u6307\u5b9a\u7684\u7ed3\u679c\u6240\u5728\u6570\u7ec4\u4e2d\u7684\u4f4d\u7f6e\u5927\u4e8e\u6570\u7ec4\u7684\u957f\u5ea6\uff01");
        }
        this.m_pResult[_nIndex] = _hResult;
    }

    public float getBonus(String _sUserName, int _nBonusType) throws WCMException {
        HashMap map = this.m_pResult[_nBonusType - 1];
        if (map == null) {
            return 0.0f;
        }
        Object value = map.get(_sUserName);
        if (_nBonusType == 2) {
            return this.getHitBonus(_sUserName, map);
        }
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof String) {
            return Float.parseFloat(value.toString());
        }
        throw new WCMException("\u5956\u91d1\u4e0d\u662fFloat\u7c7b\u578b\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8c03\u7528\u63a5\u53e3\u9519\u8bef\uff01");
    }

    private float getHitBonus(String _sUserName, HashMap _map) throws WCMException {
        if (_map == null) {
            return 0.0f;
        }
        WCMFilter filter = new WCMFilter("", "CrUser = ?", "");
        filter.addSearchValues(_sUserName);
        Documents docs = Documents.openWCMObjs(null, filter);
        if (docs == null || docs.size() == 0) {
            return 0.0f;
        }
        String[] sDocIds = docs.getIdListAsString().split(",");
        float fBonus = 0.0f;
        for (int i = 0; i < sDocIds.length; ++i) {
            Object value = _map.get(sDocIds[i]);
            if (value == null) continue;
            fBonus += Float.parseFloat(value.toString());
        }
        return fBonus;
    }

    public float getTotalBonus(String _sUserName) throws WCMException {
        return this.getBonus(_sUserName, 1) + this.getBonus(_sUserName, 2);
    }

    public float getIssuesAmountBonusOfMonth(String _sUserName, CMyDateTime _dateTime) throws Exception {
        HashMap map = this.m_pResult[0];
        Object value = map.get(_sUserName + "&" + _dateTime.getDateTimeAsString("yyyy\u5e74MM\u6708"));
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof String) {
            return Float.parseFloat(value.toString().split("&")[0]);
        }
        throw new WCMException("\u5956\u91d1\u7684\u7c7b\u578b\u4e0d\u5bf9\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u662f\u8c03\u7528\u63a5\u53e3\u9519\u8bef\uff01");
    }

    public int getIssuedAmountOfMonth(String _sUserName, CMyDateTime _dateTime) throws Exception {
        HashMap map = this.m_pResult[0];
        Object value = map.get(_sUserName + "&" + _dateTime.getDateTimeAsString("yyyy\u5e74MM\u6708"));
        if (value == null) {
            return 0;
        }
        if (value instanceof String) {
            return Integer.parseInt(value.toString().split("&")[1]);
        }
        throw new WCMException("\u83b7\u53d6\u5230\u7684\u6570\u636e\u7684\u7c7b\u578b\u4e0d\u5bf9\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8c03\u7528\u63a5\u53e3\u9519\u8bef\uff01");
    }

    public float getHitsBonusOfMonth(String _sUserName, int _nDocId, CMyDateTime _dateTime) throws Exception {
        Document document = Document.findById(_nDocId);
        if (document == null) {
            return 0.0f;
        }
        if (!_sUserName.equalsIgnoreCase(document.getCrUserName())) {
            return 0.0f;
        }
        HashMap hitsResult = this.m_pResult[0];
        String sDateTime = _dateTime.getDateTimeAsString("yyyy\u5e74MM\u6708");
        Object value = hitsResult.get(_nDocId + "&" + sDateTime);
        if (value == null) {
            return 0.0f;
        }
        return Float.parseFloat(value.toString().split("&")[0]);
    }

    public int getHitsCountOfMonth(String _sUserName, int _nDocId, CMyDateTime _dateTime) throws Exception {
        Document document = Document.findById(_nDocId);
        if (document == null) {
            return 0;
        }
        if (!_sUserName.equalsIgnoreCase(document.getCrUserName())) {
            return 0;
        }
        HashMap hitsResult = this.m_pResult[0];
        String sDateTime = _dateTime.getDateTimeAsString("yyyy\u5e74MM\u6708");
        Object value = hitsResult.get(_nDocId + "&" + sDateTime);
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value.toString().split("&")[1]);
    }

    protected void setUserNames(ArrayList _arUserNames) {
        this.m_arUserNames = _arUserNames;
    }

    public List getUserNames() {
        return this.m_arUserNames;
    }

    protected void setDocIds(ArrayList _arDocIds) {
        this.m_arDocIds = _arDocIds;
    }

    public List getDocIds() {
        return this.m_arDocIds;
    }

    public List sort(int _nBonusType, boolean _bSortDesc) {
        this.m_nBonusType = _nBonusType;
        this.m_bSortDesc = _bSortDesc;
        Comparator comparator = new Comparator(){

            public int compare(Object _sSrcCrUserName, Object _sDstCrUserName) {
                try {
                    float nSrcDataCount = StatBonusResultForUser.this.getBonus((String)_sSrcCrUserName, StatBonusResultForUser.this.m_nBonusType);
                    float nDstDataCount = StatBonusResultForUser.this.getBonus((String)_sDstCrUserName, StatBonusResultForUser.this.m_nBonusType);
                    if (StatBonusResultForUser.this.m_bSortDesc) {
                        return (int)(nDstDataCount - nSrcDataCount);
                    }
                    return (int)(nSrcDataCount - nDstDataCount);
                }
                catch (Exception ignore) {
                    StatBonusResultForUser.this.logger.error((Object)"\u6392\u5e8f\u5931\u8d25", (Throwable)ignore);
                    return 0;
                }
            }
        };
        if (this.m_arUserNames != null && this.m_arUserNames.size() > 0) {
            Collections.sort(this.m_arUserNames, comparator);
        }
        return this.m_arUserNames;
    }
}

