/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.common.job.BaseStatefulScheduleWorker;
import com.trs.components.stat.IHitsCountHandler;
import com.trs.components.stat.IURLParser;
import com.trs.components.stat.URLParser;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.WCMDiscoveryFactory;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class HitsCountParserSchedule
extends BaseStatefulScheduleWorker {
    private static Logger logger = Logger.getLogger(HitsCountParserSchedule.class);
    private Date currentDate;
    private String sCurrentDate;
    private IURLParser urlParser;

    @Override
    protected void execute() throws WCMException {
        int i;
        String sRootPath = this.getArgAsString("rootPath");
        FileService dir = new FileService(sRootPath);
        if (!dir.exists()) {
            logger.error((Object)("\u6307\u5b9a\u7684\u70b9\u51fb\u91cf\u6839\u76ee\u5f55[" + sRootPath + "]\u4e0d\u5b58\u5728"));
            return;
        }
        CMyDateTime date = CMyDateTime.now();
        try {
            date = date.dateAdd(3, -1);
        }
        catch (Exception e) {
            logger.error((Object)("\u8f6c\u6362\u65e5\u671f\u5931\u8d25:" + date), (Throwable)e);
        }
        this.currentDate = date.getDateTime();
        dir = new FileService(dir, this.getCurrentDir());
        if (!dir.exists()) {
            return;
        }
        logger.debug((Object)("\u5f00\u59cb\u5206\u6790\u76ee\u5f55[" + dir.getAbsolutePath() + "]\u4e0b\u7684\u70b9\u51fb\u91cf\u6587\u4ef6"));
        this.sCurrentDate = new SimpleDateFormat("yyyy-MM-dd").format(this.currentDate);
        this.urlParser = new URLParser();
        IHitsCountHandler[] handlers = this.getHitsCountHandler();
        FileStore[] files = dir.listFiles();
        for (i = 0; i < files.length; ++i) {
            try {
                this.parse(files[i], handlers);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("\u5904\u7406\u6587\u4ef6[" + files[i] + "]\u70b9\u51fb\u91cf\u5931\u8d25"));
            }
        }
        for (i = 0; i < handlers.length; ++i) {
            try {
                handlers[i].notifyComplete();
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("\u5904\u7406\u5668notifyComplete[" + handlers[i] + "]\u5931\u8d25"));
            }
        }
    }

    private String getCurrentDir() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(this.currentDate);
    }

    private void parse(FileStore file, IHitsCountHandler[] handlers) throws WCMException {
        if (!file.getName().endsWith(".xml")) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u5f00\u59cb\u89e3\u6790\u70b9\u51fb\u91cf\u6587\u4ef6[" + file + "]\u6210dom\u5bf9\u8c61"));
        }
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(file.getInputStream());
        }
        catch (DocumentException e) {
            logger.error((Object)("\u89e3\u6790\u6587\u4ef6[" + file + "]\u6210document\u5bf9\u8c61\u65f6\u51fa\u73b0\u5f02\u5e38"), (Throwable)e);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u5b8c\u6210\u89e3\u6790\u70b9\u51fb\u91cf\u6587\u4ef6[" + file + "]\u6210dom\u5bf9\u8c61"));
        }
        Iterator itr = document.getRootElement().elementIterator("item");
        while (itr.hasNext()) {
            Element item = (Element)itr.next();
            String sUrl = item.selectSingleNode("url").getText();
            String sHits = item.selectSingleNode("hits").getText();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u5904\u7406\u70b9\u51fb\u91cf[" + sUrl + "][" + sHits + "]"));
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("hitsTime", this.sCurrentDate);
            properties.put("hitsCount", sHits);
            try {
                BaseObj obj = this.urlParser.parse(sUrl);
                this.parse(obj, properties, handlers);
            }
            catch (Exception e) {
                logger.error((Object)("\u5904\u7406\u70b9\u51fb\u91cf[" + sUrl + "][" + sHits + "]\u5931\u8d25"));
            }
        }
    }

    private void parse(BaseObj obj, Map properties, IHitsCountHandler[] handlers) {
        for (int i = 0; i < handlers.length; ++i) {
            try {
                handlers[i].handle(obj, properties);
                continue;
            }
            catch (WCMException e) {
                logger.debug((Object)("\u5904\u7406\u5bf9\u8c61[" + obj + "]\u70b9\u51fb\u91cf\u65f6\u51fa\u73b0\u5f02\u5e38"), (Throwable)e);
            }
        }
    }

    private IHitsCountHandler[] getHitsCountHandler() {
        Iterator itr = WCMDiscoveryFactory.getDiscovery().getImplementors(IHitsCountHandler.class.getName());
        if (itr == null) {
            return new IHitsCountHandler[0];
        }
        ArrayList implClzs = new ArrayList();
        while (itr.hasNext()) {
            String sImplClz = (String)itr.next();
            try {
                implClzs.add(Class.forName(sImplClz).newInstance());
                logger.debug((Object)("\u52a0\u8f7d\u70b9\u51fb\u91cf\u5904\u7406\u5668:" + sImplClz));
            }
            catch (Exception e) {
                logger.error((Object)("\u52a0\u8f7d\u70b9\u51fb\u91cf\u5904\u7406\u5668[" + sImplClz + "]\u51fa\u73b0\u9519\u8bef"), (Throwable)e);
            }
        }
        return implClzs.toArray(new IHitsCountHandler[0]);
    }
}

