/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget.tagparser;

import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.publish.tagparser.WCMTagParserLogoBase;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;

public class WCMTagParserSpecialAppendix
extends BaseTagParser {
    private static TagBeanInfo s_TagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TBI tbi = new TBI();
            tbi.setName("TRS_SpecialAppendix");
            tbi.setDesc("TRS_SpecialAppendix");
            tbai = new TagBeanAttrInfo();
            tbai.setName("FILENAME");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("URLISABS");
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        IPublishFolder folder = _context.getUpperFolder();
        if (folder == null) {
            return null;
        }
        String sFileName = _context.getAttribute("FILENAME");
        String sFileFullName = this.getFileFullName(sFileName);
        this.distributeFile(_context, folder, sFileFullName);
        boolean bUrlIsAbs = "TRUE".equalsIgnoreCase(_context.getAttribute("URLISABS"));
        PublishPathCompass compass = _context.getPathCompass();
        String path = bUrlIsAbs ? (_context.isPreview() ? compass.getPreviewHttpPath(folder) : compass.getAbsoluteHttpPath(folder)) : "./";
        return new String[]{path + sFileName};
    }

    private String getFileFullName(String _sFileName) throws WCMException {
        if (CMyString.isEmpty(_sFileName)) {
            return null;
        }
        String sSrcFilePathName = FilesMan.getFilesMan().mapFilePath(_sFileName, 0) + _sFileName;
        if (!CMyFile.fileExists(sSrcFilePathName)) {
            return null;
        }
        return sSrcFilePathName;
    }

    private boolean distributeFile(PublishTagContext _context, IPublishFolder _hostFolder, String sSrcFilePathName) throws WCMException {
        boolean bPreview;
        if (_hostFolder == null) {
            return false;
        }
        if (!CMyFile.fileExists(sSrcFilePathName)) {
            _context.addWarning(_hostFolder.getInfo() + "-appendix", _hostFolder.getId(), I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label1", "\u5728\u78c1\u76d8\u4e0a\u6ca1\u6709\u627e\u5230(") + _hostFolder.getInfo() + I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label2", ")\u7684Logo[") + sSrcFilePathName + "]");
            return false;
        }
        String _sFileName = CMyFile.extractFileName(sSrcFilePathName);
        PublishPathCompass compass = _context.getPathCompass();
        String sLocalPath = CMyString.setStrEndWith(compass.getLocalPath(_hostFolder, bPreview = _context.isPreview()), File.separatorChar) + File.separatorChar;
        if (CMyFile.fileExists(sLocalPath + _sFileName)) {
            return true;
        }
        PublishSyncGlobalTuner.insureLocalPathExists(sLocalPath);
        try {
            CMyFile.copyFile(sSrcFilePathName, sLocalPath + _sFileName);
        }
        catch (CMyException e) {
            e.printStackTrace();
            _context.addWarning(_hostFolder.getInfo() + "-appendix", _hostFolder.getId(), I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label3", "\u62f7\u8d1d(") + _hostFolder.getInfo() + I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label2", ")\u7684\u9644\u4ef6[") + _sFileName + I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label4", "]\u53d1\u751f\u5f02\u5e38:") + CMyException.getStackTraceText(e));
        }
        if (!bPreview) {
            _context.getFileDistributeShip().distributeFile(sSrcFilePathName, _hostFolder, null, true);
        }
        return true;
    }

    private class TBI
    extends TagBeanInfo {
        @Override
        public void checkSemantic(IPublishFolder _folder, TagItem _tagItem, StringBuffer _sbResult) {
        }
    }
}

