/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.widget.ILayoutGenerator;
import com.trs.components.common.publish.widget.ILayoutMgr;
import com.trs.components.common.publish.widget.Layout;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WCMTagParserLayout
extends BaseTagParser {
    private static Logger logger = Logger.getLogger(WCMTagParserLayout.class);
    ILayoutMgr m_oLayoutMgr = (ILayoutMgr)DreamFactory.createObjectById("ILayoutMgr");
    private ILayoutGenerator m_oLayoutGenerator = (ILayoutGenerator)DreamFactory.createObjectById("ILayoutGenerator");
    private static TagBeanInfo s_TagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TBI tbi = new TBI();
            tbi.setName("TRS_Layout");
            tbi.setDesc("TRS_Layout");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NAME");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("RATIO");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("RATIOTYPE");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue(String.valueOf(Layout.RATIO_TYPE_FIXED));
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("STYLE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public String[] parse(PublishTagContext context) throws WCMException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\u83b7\u53d6\u5230TRS_Layout\u4e0a\u7684\u6240\u6709\u5c5e\u6027\u4e3a\uff1a\n");
            HashMap attributes = context.getAttributes();
            for (Map.Entry entry : attributes.entrySet()) {
                logger.debug((Object)(entry.getKey() + ":" + entry.getValue()));
            }
        }
        String sStyle = context.getAttribute("style");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u83b7\u53d6\u5230\u7684\u5e03\u5c40\u81ea\u5b9a\u4e49\u6837\u5f0f[" + sStyle + "]"));
        }
        Layout layout = this.findLayout(context);
        String[] aCellHtml = new String[layout.getColumns()];
        String[] aRealCellHtml = this.getChildrenHtml(context);
        System.arraycopy(aRealCellHtml, 0, aCellHtml, 0, aRealCellHtml.length);
        for (int i = aRealCellHtml.length; i < aCellHtml.length; ++i) {
            aCellHtml[i] = "<div class='c-empty-column'>\u70b9\u51fb\u6dfb\u52a0\u8d44\u6e90</div>";
        }
        String sLayoutHtml = this.m_oLayoutGenerator.generateHtml(layout, true, true);
        if (!CMyString.isEmpty(sStyle)) {
            sLayoutHtml = sLayoutHtml.replaceFirst("(?is)(<div)", "$1 style=\"" + sStyle + "\"");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u66ff\u6362\u81ea\u5b9a\u4e49\u6837\u5f0f\u540e\u7684\u5e03\u5c40html\u4ee3\u7801[" + sLayoutHtml + "]"));
            }
        }
        return new String[]{CMyString.format(sLayoutHtml, aCellHtml)};
    }

    private String[] getChildrenHtml(PublishTagContext context) throws WCMException {
        ArrayList<String> childrenHtml = new ArrayList<String>();
        List children = context.getTagItem().getChildren();
        if (children == null || children.size() == 0) {
            return new String[0];
        }
        int length = children.size();
        for (int i = 0; i < length; ++i) {
            Object child = children.get(i);
            if (child instanceof String) continue;
            String[] aHtml = TagParseHelper.parseItem((TagItem)child, context);
            childrenHtml.add(aHtml != null ? aHtml[0] : null);
        }
        return childrenHtml.toArray(new String[0]);
    }

    private Layout findLayout(PublishTagContext context) throws WCMException {
        Layout layout;
        int nLayoutId = context.getAttribute("id", 0);
        if (nLayoutId != 0 && (layout = Layout.findById(nLayoutId)) != null) {
            return layout;
        }
        String sLayoutName = context.getAttribute("name");
        if (!CMyString.isEmpty(sLayoutName) && (layout = this.m_oLayoutMgr.findLayoutByName(ContextHelper.getLoginUser(), sLayoutName)) != null) {
            return layout;
        }
        String sRatio = context.getAttribute("Ratio");
        if (CMyString.isEmpty(sRatio)) {
            throw new WCMException("\u6ca1\u6709\u4f20\u5165\u6709\u6548\u7684\u5e03\u5c40id[" + nLayoutId + "]\u6216name[" + CMyString.showNull(sLayoutName) + "]\u6216Ratio[" + CMyString.showEmpty(sRatio) + "]\u5c5e\u6027");
        }
        int nRatioType = context.getAttribute("RatioType", Layout.RATIO_TYPE_FIXED);
        int nColumns = sRatio.split(Layout.RATIO_SEPERATE).length;
        layout = Layout.createNewInstance();
        layout.setColumns(nColumns);
        layout.setRatio(sRatio);
        layout.setRatioType(nRatioType);
        this.m_oLayoutMgr.validate(layout);
        return layout;
    }

    private class TBI
    extends TagBeanInfo {
        @Override
        public void checkSemantic(IPublishFolder _folder, TagItem _tagItem, StringBuffer _sbResult) {
        }
    }
}

