/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.IMasterMgr;
import com.trs.components.common.publish.widget.IMasterServiceProvider;
import com.trs.components.common.publish.widget.Master;
import com.trs.components.common.publish.widget.Masters;
import com.trs.components.common.publish.widget.SpecialAuthServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;

public class MasterServiceProvider
implements IMasterServiceProvider {
    private IMasterMgr m_oMasterMgr = (IMasterMgr)DreamFactory.createObjectById("IMasterMgr");

    @Override
    public String export(MethodContext _oContext) throws Exception {
        User loginUser = this.getLoginUser();
        String sMasterIds = _oContext.getObjectIds();
        if (CMyString.isEmpty(sMasterIds)) {
            throw new WCMException(I18NMessage.get(MasterServiceProvider.class, "MasterServiceProvider.label1", "\u8981\u5bfc\u51fa\u7684\u6bcd\u677f\u7684Id\u4e3a\u7a7a"));
        }
        Masters oMasters = Masters.findByIds(loginUser, sMasterIds);
        int nSize = oMasters.size();
        for (int i = 0; i < nSize; ++i) {
            Master currMaster = (Master)oMasters.getAt(i);
            if (currMaster == null || SpecialAuthServer.hasRight(loginUser, currMaster, 24)) continue;
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u5bfc\u51fa\u6bcd\u677f\u3010" + currMaster.getMName() + "\u3011");
        }
        String sExportFile = this.m_oMasterMgr.export(oMasters);
        return sExportFile;
    }

    @Override
    public int save(MethodContext _oContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nMasterId = _oContext.getObjectId();
        Master currMaster = null;
        if (nMasterId == 0) {
            currMaster = new Master();
        } else {
            currMaster = Master.findById(nMasterId);
            if (currMaster == null) {
                throw new WCMException(CMyString.format(I18NMessage.get(MasterServiceProvider.class, "MasterServiceProvider.label2", "\u6307\u5b9aId\u4e3a[{0}]\u7684\u6bcd\u677f\u4e0d\u5b58\u5728"), new int[]{nMasterId}));
            }
        }
        if (currMaster.isAddMode()) {
            if (!SpecialAuthServer.hasRight(loginUser, currMaster, 21)) {
                throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u65b0\u5efa\u6bcd\u677f");
            }
        } else if (!SpecialAuthServer.hasRight(loginUser, currMaster, 22)) {
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u6bcd\u677f\u3010" + currMaster.getMName() + "\u3011");
        }
        String[] pLogicFields = new String[]{"ObjectId"};
        currMaster = (Master)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _oContext, currMaster, pLogicFields);
        Master oMaster = this.m_oMasterMgr.save(loginUser, currMaster);
        return oMaster.getId();
    }

    @Override
    public Master save(String _sMasterName, String _sFileName) throws WCMException {
        User loginUser = this.getLoginUser();
        String sFileName = CMyFile.extractFileName(_sFileName);
        String sValidResult = this.validateMasterFile(sFileName);
        if (sValidResult != null) {
            throw new WCMException(sValidResult);
        }
        Master oMaster = this.m_oMasterMgr.save(loginUser, _sMasterName, _sFileName);
        return oMaster;
    }

    @Override
    public String validateMasterFile(MethodContext _oContext) throws Exception {
        String sFileName = _oContext.getValue("FileName");
        String sResult = this.validateMasterFile(sFileName);
        return sResult;
    }

    @Override
    public String validateMasterFile(String _sFileName) throws WCMException {
        String sFileName = CMyFile.extractFileName(_sFileName);
        String sValidResult = this.m_oMasterMgr.validateMasterFile(sFileName);
        return sValidResult;
    }

    @Override
    public void delete(MethodContext _oContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sMasterIds = _oContext.getObjectIds();
        Masters oMasters = Masters.findByIds(loginUser, sMasterIds);
        int nSize = oMasters.size();
        for (int i = 0; i < nSize; ++i) {
            Master currMaster = (Master)oMasters.getAt(i);
            if (currMaster == null || SpecialAuthServer.hasRight(loginUser, currMaster, 23)) continue;
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u6bcd\u677f\u3010" + currMaster.getMName() + "\u3011");
        }
        this.m_oMasterMgr.delete(loginUser, oMasters);
    }

    @Override
    public Object query(MethodContext _oContext) throws Throwable {
        User loginUser = this.getLoginUser();
        WCMFilter extraFilter = _oContext.getExtraWCMFilter();
        Masters oMasters = this.m_oMasterMgr.query(loginUser, extraFilter);
        for (int i = oMasters.size() - 1; i >= 0; --i) {
            Master currMaster = (Master)oMasters.getAt(i);
            if (currMaster == null || SpecialAuthServer.hasRight(loginUser, currMaster, 24)) continue;
            oMasters.remove(currMaster, false);
        }
        return oMasters;
    }

    public Object queryMasterByContentType(MethodContext _oContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nMasterFileType = _oContext.getValue("MasterFileType", 0);
        if (nMasterFileType == 0) {
            throw new WCMException("\u60a8\u5fc5\u4f20\u5165\u6bcd\u7248\u7684\u6587\u4ef6\u7c7b\u578b\u53c2\u6570\uff01");
        }
        WCMFilter filter = new WCMFilter();
        filter.mergeWith(_oContext.getExtraWCMFilter());
        Masters oMasters = this.m_oMasterMgr.query(loginUser, filter);
        for (int i = oMasters.size() - 1; i >= 0; --i) {
            String sFileContent;
            Master oMaster = (Master)oMasters.getAt(i);
            if (oMaster == null || !CMyString.isEmpty(sFileContent = this.m_oMasterMgr.getMasterFileContent(oMaster, nMasterFileType))) continue;
            oMasters.removeAt(i, false);
        }
        return oMasters;
    }

    @Override
    public Object findById(MethodContext _oContext) throws Throwable {
        int nObjId = _oContext.getObjectId();
        return Master.findById(nObjId);
    }

    @Override
    public Object findByIds(MethodContext _oContext) throws Throwable {
        String sObjIds = _oContext.getObjectIds();
        return Masters.findByIds(this.getLoginUser(), sObjIds);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public String importMasters(MethodContext _oContext) throws Exception {
        User loginUser = this.getLoginUser();
        if (!SpecialAuthServer.hasRight(loginUser, Master.createNewInstance(), 21)) {
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u65b0\u5efa\u6bcd\u677f\u7684\u6743\u9650\uff0c\u4e0d\u80fd\u5bfc\u5165\u6bcd\u677f");
        }
        String sFileName = _oContext.getValue("FileName");
        int nImportMode = _oContext.getValue("ImportMode", 1);
        Reports reports = this.m_oMasterMgr.importMasters(loginUser, sFileName, nImportMode);
        return reports.toJSONXML();
    }

    @Override
    public boolean existsMName(MethodContext _oContext) throws Throwable {
        int nObjectId = _oContext.getObjectId();
        String sMName = _oContext.getValue("MNAME");
        return this.m_oMasterMgr.existsMName(nObjectId, sMName);
    }
}

