/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class TagParserNewIcon
implements ITagParser {
    private static final Logger s_logger = Logger.getLogger(TagParserNewIcon.class);
    private static final long TIME_UNIT_MINITE = 60000L;
    private static final long TIME_UNIT_HOUR = 3600000L;
    private static final long TIME_UNIT_DAY = 86400000L;
    private static final long TIME_UNIT_WEEK = 604800000L;
    private static TagBeanInfo s_TagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_NEWICON");
            tbi.setDesc("TRS_NEWICON");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("CRTIME");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TIME");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("today");
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) throws WCMException {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        long ltCompareTime;
        long ltCurrentTime;
        CMyDateTime objTime;
        CMSObj host = _context.getUpperHost().getSubstance();
        String sField = _context.getAttribute("FIELD");
        if (sField == null || sField.length() <= 0) {
            sField = "CRTIME";
        }
        if ((objTime = host.getPropertyAsDateTime(sField)) == null) {
            return null;
        }
        long ltOccuredTime = objTime.getTimeInMillis();
        if (ltOccuredTime > (ltCurrentTime = System.currentTimeMillis())) {
            s_logger.error((Object)(I18NMessage.get(TagParserNewIcon.class, "TagParserNewIcon.label1", "\u5bf9\u8c61[") + objTime + I18NMessage.get(TagParserNewIcon.class, "TagParserNewIcon.label2", "]\u7684[") + sField + I18NMessage.get(TagParserNewIcon.class, "TagParserNewIcon.label3", "]\u65f6\u95f4\u53d1\u751f\u5728\u672a\u6765:") + new Timestamp(ltOccuredTime)));
            return null;
        }
        String sTimes = _context.getAttribute("TIME");
        if (sTimes == null || (sTimes = sTimes.trim()).length() <= 0) {
            sTimes = "day";
        }
        if (ltOccuredTime > (ltCompareTime = this.getCompareTime(sTimes))) {
            return TagParseHelper.parseItems(_context.getTagItem().getChildren(), _context);
        }
        return null;
    }

    public void clear() {
    }

    private long getCompareTime(String sTimes) {
        if (Character.isDigit(sTimes.charAt(0))) {
            boolean zTrunc = true;
            long lTimeUnit = 0L;
            int cLastChar = sTimes.charAt(sTimes.length() - 1);
            if (cLastChar <= 57 && cLastChar >= 48) {
                cLastChar = 32;
            }
            switch (cLastChar) {
                case 32: {
                    zTrunc = false;
                    lTimeUnit = 60000L;
                    break;
                }
                case 77: 
                case 109: {
                    lTimeUnit = 60000L;
                    break;
                }
                case 72: 
                case 104: {
                    lTimeUnit = 3600000L;
                    break;
                }
                case 68: 
                case 100: {
                    lTimeUnit = 86400000L;
                    break;
                }
                case 87: 
                case 119: {
                    lTimeUnit = 604800000L;
                    break;
                }
                default: {
                    lTimeUnit = 60000L;
                }
            }
            if (zTrunc) {
                sTimes = sTimes.substring(0, sTimes.length() - 1);
            }
            return System.currentTimeMillis() - lTimeUnit * Long.parseLong(sTimes);
        }
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if ("month".equals(sTimes)) {
            cal.set(5, 1);
            return cal.getTimeInMillis();
        }
        if ("week".equals(sTimes)) {
            cal.set(7, 1);
            return cal.getTimeInMillis();
        }
        if ("week1".equals(sTimes)) {
            cal.set(7, 2);
            return cal.getTimeInMillis();
        }
        return cal.getTimeInMillis();
    }
}

