/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.LoopException;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TagParserNestedTemplate
implements ITagParser {
    private TagItem m_tagItem = null;
    private static TagBeanInfo s_TagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TBI tbi = new TBI();
            tbi.setName("TRS_TEMPLATE");
            tbi.setDesc("TRS_TEMPLATE");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TEMPNAME");
            tbai.setDesc(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label8", "\u88ab\u5d4c\u5957\u6a21\u677f\u7684\u540d\u79f0(TEMPNAME)"));
            tbai.setRequired(true);
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("IDENTITY");
            tbai.setDesc(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label9", "\u88ab\u5d4c\u5957\u7684\u6a21\u677f\u5728\u4e3b\u6a21\u677f\u4e2d\u552f\u4e00\u6807\u8bc6(IDENTITY)"));
            tbai.setRequired(false);
            tbai.setVariable(false);
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
        this.m_tagItem = _item;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        int ix = 8;
        ArrayList<String> parsedTags = (ArrayList<String>)ContextParameters.get(ix, true);
        if (parsedTags == null) {
            parsedTags = new ArrayList<String>(4);
            ContextParameters.set(ix, parsedTags);
        }
        try {
            Template template = TagParseHelper.findNestedTemplate(_context);
            TemplateParseMgr mgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            if (parsedTags.contains(template.getName())) {
                throw new WCMException(220, I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label10", "\u5d4c\u5957\u6a21\u677f\u5b58\u5728\u5d4c\u5957\u73af\u8def\uff01"));
            }
            parsedTags.add(template.getName());
            TagDocument tagDoc = mgr.parse(template);
            if (tagDoc == null || tagDoc.getItemCount() == 0) {
                String[] stringArray = null;
                return stringArray;
            }
            _context.setPrefixOfArgument(_context.getAttribute("IDENTITY"));
            String[] result = TagParseHelper.parseItems(tagDoc.getItems(), _context);
            _context.setPrefixOfArgument(null);
            String[] stringArray = result;
            return stringArray;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label11", "\u89e3\u6790\u5d4c\u5957\u7f6e\u6807\u5931\u8d25\uff01\u5d4c\u5957\u7f6e\u6807\u5185\u5bb9\u4e3a: ") + this.m_tagItem.toString(), ex);
        }
        finally {
            parsedTags.clear();
            parsedTags = null;
            ContextParameters.get(ix);
        }
    }

    private class TBI
    extends TagBeanInfo {
        private TBI() {
        }

        @Override
        public void checkSemantic(IPublishFolder _folder, TagItem _tagItem, StringBuffer _sbResult) {
            this.checkSemantic(_folder, _tagItem, _sbResult, null);
        }

        @Override
        public void checkSemantic(IPublishFolder _folder, TagItem _tagItem, StringBuffer _sbResult, String _currTemplateName) {
            String sTempName = _tagItem.getAttribute("TEMPNAME");
            if (TagItem.isVariableParameter(sTempName)) {
                return;
            }
            try {
                TemplateCacheMgr tcm = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
                Template nestedTemplate = tcm.lookupByName(_folder, sTempName);
                if (nestedTemplate == null) {
                    _sbResult.append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label1", "\u7f6e\u6807"));
                    _sbResult.append(_tagItem.getDescWithPos());
                    _sbResult.append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label2", "\u6307\u5b9a\u7684\u5d4c\u5957\u6a21\u677f["));
                    _sbResult.append(sTempName);
                    _sbResult.append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label3", "]\u4e0d\u5b58\u5728\n"));
                    return;
                }
                ArrayList nestedTemplates = new ArrayList(3);
                try {
                    this.checkNested(nestedTemplate, nestedTemplates, tcm, _folder);
                }
                catch (LoopException e) {
                    _sbResult.append(CMyString.format(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label12", "\u7f6e\u6807{0}\u6307\u5b9a\u7684\u5d4c\u5957\u6a21\u677f[{1}]\u4e0e\u5176\u5b83\u6a21\u677f\u95f4\u5b58\u5728\u5d4c\u5957\u73af\u8def.\n"), new String[]{_tagItem.getDescWithPos(), sTempName}));
                    _sbResult.append(_tagItem).append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label5", "\u73af\u8def\u4e3a\uff1a"));
                    _sbResult.append(nestedTemplates);
                    return;
                }
                catch (Exception e) {
                    _sbResult.append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label1", "\u7f6e\u6807"));
                    _sbResult.append(_tagItem.getDescWithPos());
                    _sbResult.append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label2", "\u6307\u5b9a\u7684\u5d4c\u5957\u6a21\u677f["));
                    _sbResult.append(sTempName);
                    _sbResult.append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label6", "]\u5b58\u5728\u8bed\u6cd5\u9519\u8bef\uff01\n"));
                    _sbResult.append(e.getMessage());
                    _sbResult.append(_tagItem);
                    return;
                }
                nestedTemplates.clear();
            }
            catch (Exception e) {
                _sbResult.append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label1", "\u7f6e\u6807"));
                _sbResult.append(_tagItem.getDescWithPos());
                _sbResult.append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label2", "\u6307\u5b9a\u7684\u5d4c\u5957\u6a21\u677f["));
                _sbResult.append(sTempName);
                _sbResult.append(I18NMessage.get(TagParserNestedTemplate.class, "TagParserNestedTemplate.label7", "]\u67e5\u627e\u51fa\u9519:"));
                _sbResult.append(e.getMessage());
                _sbResult.append("\n");
            }
        }

        private void checkNested(Template nestedTemplate, List nestedTemplates, TemplateCacheMgr tcm, IPublishFolder folder) throws Exception {
            nestedTemplates.add(nestedTemplate.getName());
            TemplateParseMgr mgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            TagDocument nestedTag = mgr.parse(nestedTemplate);
            Iterator it = nestedTag.findItems("TRS_TEMPLATE");
            TagItem nestedTemplateTag = null;
            String templateName = null;
            while (it.hasNext()) {
                nestedTemplateTag = (TagItem)it.next();
                templateName = nestedTemplateTag.getAttribute("TEMPNAME");
                if (nestedTemplates.indexOf(templateName) != -1) {
                    nestedTemplates.add(templateName);
                    throw new LoopException();
                }
                nestedTemplate = tcm.lookupByName(folder, templateName);
                if (nestedTemplate == null) continue;
                this.checkNested(nestedTemplate, nestedTemplates, tcm, folder);
            }
            nestedTemplates.remove(nestedTemplates.size() - 1);
        }
    }
}

