/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MailContentHelper {
    private static final String MAIL_TEMPLATE = "/TRSEmail.htm";
    private static Logger logger = Logger.getLogger(MailContentHelper.class);
    private static String s_sMailTemplate = null;

    public static String makeEmailContent(Map _hParamValues) throws Exception {
        if (s_sMailTemplate == null) {
            MailContentHelper.initEmailContent();
        }
        return MailContentHelper.parsePageVariables(s_sMailTemplate, _hParamValues);
    }

    private static String parsePageVariables(String _sContent, Map _variables) throws WCMException {
        if (_sContent == null) {
            return null;
        }
        StringBuffer buffResult = null;
        try {
            char[] chrArray = _sContent.toCharArray();
            int nLength = chrArray.length;
            int nPos = 0;
            buffResult = new StringBuffer();
            while (nPos < chrArray.length) {
                char aChar;
                if ((aChar = chrArray[nPos++]) == '$' && nPos < nLength && chrArray[nPos] == '{') {
                    StringBuffer buffVarName = new StringBuffer(16);
                    ++nPos;
                    int iCount = 0;
                    boolean zFound = false;
                    while (iCount++ < 20 && nPos < nLength) {
                        if ((aChar = chrArray[nPos++]) == '}') {
                            zFound = true;
                            break;
                        }
                        buffVarName.append(aChar);
                    }
                    if (zFound) {
                        String sKey = buffVarName.toString().toUpperCase();
                        String sVal = (String)_variables.get(sKey);
                        if (sVal != null) {
                            buffResult.append(sVal);
                            continue;
                        }
                        buffResult.append("${").append(buffVarName).append('}');
                        continue;
                    }
                    buffResult.append("${").append(buffVarName);
                    continue;
                }
                buffResult.append(aChar);
            }
            return buffResult.toString();
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(MailContentHelper.class, "MailContentHelper.label1", "\u89e3\u6790\u5185\u5bb9\u4e2d\u7684\u53d8\u91cf\u5931\u8d25!"), ex);
        }
    }

    private static synchronized void initEmailContent() throws Exception {
        if (s_sMailTemplate != null) {
            return;
        }
        MailContentHelper.initEmailTemplate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initEmailTemplate() throws Exception {
        Class<MailContentHelper> clazz = MailContentHelper.class;
        InputStream ins = clazz.getResourceAsStream(MAIL_TEMPLATE);
        if (ins == null) {
            ins = clazz.getResourceAsStream(MAIL_TEMPLATE.substring(1));
        }
        if (ins == null) {
            logger.error((Object)I18NMessage.get(MailContentHelper.class, "MailContentHelper.label2", "\u6307\u5b9a\u7684\u6a21\u677f\u6587\u4ef6[TRSEmail.htm]\u4e0d\u5b58\u5728\uff01"));
            s_sMailTemplate = "System mail Server Error!";
            return;
        }
        BufferedReader reader = null;
        InputStreamReader insr = null;
        try {
            insr = new InputStreamReader(ins, "GBK");
            reader = new BufferedReader(insr);
            StringBuffer buff = new StringBuffer(256);
            String line = reader.readLine();
            while (line != null) {
                buff.append(line).append('\n');
                line = reader.readLine();
            }
            s_sMailTemplate = buff.toString();
        }
        catch (Exception ex) {
            s_sMailTemplate = "System mail Server Error!";
            logger.error((Object)"init template fail", (Throwable)ex);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
            if (insr != null) {
                try {
                    insr.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static String readFile(URL _url) throws CMyException {
        InputStreamReader fileReader = null;
        StringBuffer buffContent = null;
        FileInputStream fis = null;
        BufferedReader buffReader = null;
        try {
            String sLine;
            buffReader = new BufferedReader(new InputStreamReader(_url.openStream(), "GBK"));
            while ((sLine = buffReader.readLine()) != null) {
                if (buffContent == null) {
                    buffContent = new StringBuffer();
                } else {
                    buffContent.append("\n");
                }
                buffContent.append(sLine);
            }
            String string = buffContent == null ? "" : buffContent.toString();
            return string;
        }
        catch (FileNotFoundException ex) {
            throw new CMyException(55, I18NMessage.get(MailContentHelper.class, "MailContentHelper.label3", "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230(CMyFile.readFile)"), ex);
        }
        catch (IOException ex) {
            throw new CMyException(53, I18NMessage.get(MailContentHelper.class, "MailContentHelper.label4", "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef(CMyFile.readFile)"), ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) {
        HashMap<String, String> hValues = new HashMap<String, String>(3);
        hValues.put("to_user".toUpperCase(), I18NMessage.get(MailContentHelper.class, "MailContentHelper.label5", "\u9646\u68da"));
        hValues.put("content".toUpperCase(), I18NMessage.get(MailContentHelper.class, "MailContentHelper.label6", "\u6d4b\u8bd5\u4e00\u4e0b"));
        hValues.put("from_user".toUpperCase(), I18NMessage.get(MailContentHelper.class, "MailContentHelper.label7", "\u66f9\u8f89"));
        try {
            System.out.println(MailContentHelper.makeEmailContent(hValues));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

