/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.JSONHelper;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.ajaxservice.WebSiteServiceProvider;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMSystemObject;
import com.trs.cms.process.FlowContentFactory;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowServer;
import com.trs.cms.process.QueryFlowDocContext;
import com.trs.cms.process.config.FlowConfigServer;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmployMgr;
import com.trs.cms.process.definition.FlowEmploys;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.definition.FlowNodeField;
import com.trs.cms.process.definition.FlowNodeFields;
import com.trs.cms.process.definition.FlowNodes;
import com.trs.cms.process.definition.Flows;
import com.trs.cms.process.engine.ContentProcessInfo;
import com.trs.cms.process.engine.FlowContext;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.cms.process.engine.FlowNextBranchInfo;
import com.trs.cms.process.engine.IInitValueCreator;
import com.trs.cms.process.xml.FlowImporter;
import com.trs.cms.process.xml.FlowXmlConverter;
import com.trs.components.common.message.MessageServer;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.process.element.FlowContentDocumentImpl;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.Report;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import com.trs.webframework.xmlserver.IXMLConvertor;
import com.trs.webframework.xmlserver.XMLConvertorFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class ProcessService
implements IGlueServiceProvider {
    private static Logger logger = Logger.getLogger(ProcessService.class);
    private FlowEmployMgr m_oFlowEmployMgr = (FlowEmployMgr)DreamFactory.createObjectById("FlowEmployMgr");
    private IFlowServer m_oFlowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
    private static final int VIEW_TYPE_DOWITH = 1;
    private static final int VIEW_TYPE_DONE = 2;
    private static final int VIEW_TYPE_START = 3;

    @Override
    public void delete(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Flows flows = Flows.findByIds(loginUser, _methodContext.getObjectIds());
        this.validateRight(loginUser, flows, 43, I18NMessage.get(ProcessService.class, "ProcessService.label1", "\u5220\u9664\u5de5\u4f5c\u6d41"));
        flows.removeAll(true);
    }

    @Override
    public Object query(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nOwnerType = _methodContext.getValue("OwnerType", 0);
        int nOwnerId = _methodContext.getValue("OwnerId", 0);
        CMSObj owner = this.findOwner(nOwnerType, nOwnerId);
        _methodContext.putContextCacheData("Owner", owner);
        switch (nOwnerType) {
            case 1: {
                if (loginUser.isAdministrator()) break;
                throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label2", "\u5f53\u524d\u7528\u6237[") + loginUser.getName() + I18NMessage.get(ProcessService.class, "ProcessService.label3", "]\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u65e0\u6743\u7ba1\u7406\u5de5\u4f5c\u6d41\uff01"));
            }
            default: {
                int[] pWorkFlowRightIndexs = WCMRightTypes.RIGHT_INDEXS_WORKFLOW;
                boolean bHasRight = false;
                for (int i = 0; i < pWorkFlowRightIndexs.length; ++i) {
                    if (!AuthServer.hasRight(loginUser, owner, pWorkFlowRightIndexs[i])) continue;
                    bHasRight = true;
                    break;
                }
                if (bHasRight) break;
                throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label2", "\u5f53\u524d\u7528\u6237[") + loginUser.getName() + I18NMessage.get(ProcessService.class, "ProcessService.label4", "]\u65e0\u6743\u7ba1\u7406[") + owner + I18NMessage.get(ProcessService.class, "ProcessService.label5", "]\u7684\u5de5\u4f5c\u6d41\uff01"));
            }
        }
        WCMFilter filter = this.makeQueryFlowsOfHostFilter(owner, _methodContext.getValue("ContainsChildren", false));
        filter.mergeWith(_methodContext.getExtraWCMFilter());
        return Flows.openWCMObjs(loginUser, filter);
    }

    public Object queryOptionalFlows(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nOwnerType = _methodContext.getValue("OwnerType", 0);
        int nOwnerId = _methodContext.getValue("OwnerId", 0);
        CMSObj owner = this.findOwner(nOwnerType, nOwnerId);
        CMSObj host = null;
        WCMSystemObject root = null;
        Channel channel = null;
        if (nOwnerType == 101) {
            if (nOwnerId > 0) {
                channel = Channel.findById(nOwnerId);
                host = channel.getSite();
            } else {
                host = WebSite.findById(owner.getPropertyAsInt("SiteId", 0));
            }
        } else if (nOwnerType == 103) {
            host = owner;
        }
        Flows flows = new Flows(null);
        if (channel != null) {
            WCMFilter chnlFilter = this.makeQueryFlowsOfHostFilter(channel, false);
            chnlFilter.mergeWith(_methodContext.getExtraWCMFilter());
            flows = Flows.openWCMObjs(loginUser, chnlFilter);
        }
        WCMFilter filter = this.makeQueryFlowsOfHostFilter(host, false);
        filter.mergeWith(_methodContext.getExtraWCMFilter());
        flows.addWith(Flows.openWCMObjs(loginUser, filter));
        root = new WCMSystemObject(host.getPropertyAsInt("SiteType", 0));
        WCMFilter rootFilter = this.makeQueryFlowsOfHostFilter(root, false);
        rootFilter.mergeWith(_methodContext.getExtraWCMFilter());
        flows.addWith(Flows.openWCMObjs(loginUser, rootFilter));
        return flows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int save(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nFlowId = _methodContext.getObjectId();
        Flow flow = null;
        if (nFlowId > 0) {
            flow = this.findById(nFlowId);
        } else {
            flow = Flow.createNewInstance();
            flow.setOwner(_methodContext.getValue("OwnerType", 0), _methodContext.getValue("OwnerId", 0));
        }
        CMSObj owner = this.findOwner(flow.getOwnerType(), flow.getOwnerId());
        int nRightIndex = nFlowId > 0 ? 42 : 41;
        String sOperDesc = nFlowId > 0 ? I18NMessage.get(ProcessService.class, "ProcessService.label6", "\u4fee\u6539\u5de5\u4f5c\u6d41") : I18NMessage.get(ProcessService.class, "ProcessService.label7", "\u65b0\u5efa\u5de5\u4f5c\u6d41");
        this.validateRight(loginUser, owner, flow, nRightIndex, sOperDesc);
        try {
            if (flow != null) {
                flow.validCanEditAndLock(loginUser);
            }
            String[] pLogicFields = new String[]{"ObjectId", "HostType", "HostId"};
            flow = (Flow)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, flow, pLogicFields);
            flow.save(loginUser);
            int n = flow.getId();
            return n;
        }
        finally {
            if (flow != null && flow.isLocked() && loginUser.getName().equals(flow.getLockerUserName())) {
                flow.unlock();
            }
        }
    }

    @Override
    public Object findById(MethodContext _methodContext) throws Throwable {
        Flow flow = this.findById(_methodContext.getObjectId());
        return flow;
    }

    private Flow findById(int _nFlowId) throws WCMException {
        if (_nFlowId <= 0) {
            return null;
        }
        Flow flow = Flow.findById(_nFlowId);
        if (flow == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(_nFlowId), WCMTypes.getLowerObjName(401)}));
        }
        return flow;
    }

    private FlowDoc findFlowDocById(int _nFlowDocId) throws WCMException {
        FlowDoc flowdoc = FlowDoc.findById(_nFlowDocId);
        if (flowdoc == null) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label9", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5de5\u4f5c\u6d41\u8f68\u8ff9\uff01[ID=") + _nFlowDocId + "]");
        }
        return flowdoc;
    }

    @Override
    public Object findByIds(MethodContext _methodContext) throws Throwable {
        return null;
    }

    public Reports importFlows(MethodContext _methodContext) throws WCMException {
        int nOwnerId;
        User loginUser = this.getLoginUser();
        String sImportFile = _methodContext.getValue("ImportFile");
        int nOwnerType = _methodContext.getValue("OwnerType", 0);
        CMSObj owner = this.findOwner(nOwnerType, nOwnerId = _methodContext.getValue("OwnerId", 0));
        if (owner == null) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label10", "\u6ca1\u6709\u627e\u5230\u6307\u5b9aID\u4e3a[") + nOwnerId + I18NMessage.get(ProcessService.class, "ProcessService.label11", "]\u3001\u7c7b\u578b\u4e3a[") + nOwnerType + I18NMessage.get(ProcessService.class, "ProcessService.label12", "]\u7684\u5bfc\u5165\u76ee\u6807\uff01"));
        }
        int nRightIndex = 45;
        this.validateRight(loginUser, owner, null, nRightIndex, I18NMessage.get(ProcessService.class, "ProcessService.label13", "\u5bfc\u5165\u5de5\u4f5c\u6d41"));
        FlowImporter importer = new FlowImporter(loginUser, 1);
        importer.setImportWithInfoviewId(false);
        importer.setOwner(owner);
        Reports reports = null;
        try {
            reports = importer.importFromFile(sImportFile, null);
        }
        catch (Throwable ex) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label14", "\u8981\u5bfc\u5165\u7684XML\u5185\u5bb9\u6216\u8005\u7ed3\u6784\u4e0d\u5408\u6cd5\uff01"), ex);
        }
        return reports;
    }

    public String exportFlows(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sFlowIds = _methodContext.getObjectIds();
        Flows flows = Flows.findByIds(this.getLoginUser(), sFlowIds);
        int nRightIndex = 44;
        this.validateRight(loginUser, flows, nRightIndex, I18NMessage.get(ProcessService.class, "ProcessService.label15", "\u5bfc\u51fa\u5de5\u4f5c\u6d41"));
        FlowXmlConverter converter = new FlowXmlConverter();
        String sXmlFile = FilesMan.getFilesMan().getNextFileName("ST", ".xml", null, true);
        converter.toXMLFile(flows, sXmlFile);
        return CMyFile.extractFileName(sXmlFile);
    }

    public String getConfigContent() throws Throwable {
        FlowConfigServer aFlowConfigServer = (FlowConfigServer)DreamFactory.createObjectById("FlowConfigServer");
        if (aFlowConfigServer == null) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label16", "FlowConfigServer\u5728\u5de5\u5382\u4e2d\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        return aFlowConfigServer.getConfigFileContent();
    }

    public String toXML(MethodContext _methodContext) throws Throwable {
        Flow flow = null;
        if (_methodContext.getObjectId() > 0) {
            flow = this.findById(_methodContext.getObjectId());
        } else {
            int nContentId;
            int nContentType = _methodContext.getValue("ContentType", 0);
            IFlowContent content = FlowContentFactory.makeFlowContent(nContentType, nContentId = _methodContext.getValue("ContentId", 0));
            if (content == null) {
                throw new WCMException(200006, I18NMessage.get(ProcessService.class, "ProcessService.label17", "\u6307\u5b9a\u7684\u5185\u5bb9[Type=") + nContentType + ", Id=" + nContentId + I18NMessage.get(ProcessService.class, "ProcessService.label18", "]\u6ca1\u6709\u627e\u5230\uff01"));
            }
            flow = content.getOwnerFlow();
            if (flow == null) {
                throw new WCMException(200006, I18NMessage.get(ProcessService.class, "ProcessService.label19", "\u7531\u4e8e\u6307\u5b9a\u7684\u5185\u5bb9[Type=") + nContentType + ", Id=" + nContentId + I18NMessage.get(ProcessService.class, "ProcessService.label20", "]\u6ca1\u6709\u914d\u7f6e\u5de5\u4f5c\u6d41\uff0c\u6216\u8005\u5176\u539f\u5148\u4f7f\u7528\u7684\u5de5\u4f5c\u6d41\u5df2\u4e0d\u590d\u5b58\u5728\uff0c\u56e0\u6b64\u65e0\u6cd5\u83b7\u53d6\u5176\u5de5\u4f5c\u6d41\u56fe\u7684\u76f8\u5173\u4fe1\u606f\uff01"));
            }
        }
        FlowXmlConverter xmlConverter = new FlowXmlConverter();
        String result = xmlConverter.toXMLString(flow);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reports fromXML(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nFlowId = _methodContext.getObjectId();
        Flow flow = null;
        if (nFlowId > 0) {
            flow = this.findById(nFlowId);
        }
        CMSObj owner = null;
        owner = flow != null ? this.findOwner(flow.getOwnerType(), flow.getOwnerId()) : this.findOwner(_methodContext.getValue("OwnerType", 0), _methodContext.getValue("OwnerId", 0));
        int nRightIndex = nFlowId > 0 ? 42 : 41;
        String sOperDesc = nFlowId > 0 ? I18NMessage.get(ProcessService.class, "ProcessService.label6", "\u4fee\u6539\u5de5\u4f5c\u6d41") : I18NMessage.get(ProcessService.class, "ProcessService.label7", "\u65b0\u5efa\u5de5\u4f5c\u6d41");
        this.validateRight(loginUser, owner, flow, nRightIndex, sOperDesc);
        try {
            if (flow != null) {
                flow.validCanEditAndLock(loginUser);
            }
            FlowImporter importer = new FlowImporter(loginUser, 2);
            importer.setImportWithFlowNodeFields(true);
            importer.setImportWithInfoviewId(true);
            importer.setOwner(owner);
            boolean bUpdateOptMarkEnum = _methodContext.getValue("UpdateOptMarkEnum", false);
            importer.setImportWithOptMarkEnum(bUpdateOptMarkEnum);
            Reports reports = importer.importFromXMLContent(_methodContext.getValue("FlowXML"));
            List fails = reports.getFailedReporter();
            if (fails != null && fails.size() != 0) {
                for (int i = 0; i < fails.size(); ++i) {
                    Report report = (Report)fails.get(i);
                    report.setRportTitle(sOperDesc + I18NMessage.get(ProcessService.class, "ProcessService.label21", "\u5931\u8d25\uff01"));
                }
                reports.setTitle(sOperDesc + I18NMessage.get(ProcessService.class, "ProcessService.label22", "\u5931\u8d25"));
            } else {
                List succs = reports.getSucessedReporter();
                for (int i = 0; i < succs.size(); ++i) {
                    Report report = (Report)succs.get(i);
                    report.setRportTitle(sOperDesc + I18NMessage.get(ProcessService.class, "ProcessService.label23", "\u6210\u529f\uff01"));
                }
                reports.setTitle(sOperDesc + I18NMessage.get(ProcessService.class, "ProcessService.label24", "\u6210\u529f"));
            }
            Reports reports2 = reports;
            return reports2;
        }
        finally {
            if (flow != null && flow.isLocked() && loginUser.getName().equals(flow.getLockerUserName())) {
                flow.unlock();
            }
        }
    }

    public Flow getFlowUsedByChannel(MethodContext _methodContext) throws WCMException {
        Channel channel = (Channel)this.findOwner(101, _methodContext.getObjectId());
        return this.m_oFlowEmployMgr.getFlow(channel);
    }

    public Channels getChannelsUseingFlow(MethodContext _methodContext) throws WCMException {
        int nObjectId = _methodContext.getObjectId();
        WCMFilter filter = _methodContext.getExtraWCMFilter();
        Flow flow = this.findById(nObjectId);
        if (flow == null) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label25", "\u627e\u4e0d\u5230[ID=") + nObjectId + I18NMessage.get(ProcessService.class, "ProcessService.label5", "]\u7684\u5de5\u4f5c\u6d41\uff01"));
        }
        this.validateSetEmployRight(this.getLoginUser(), flow, I18NMessage.get(ProcessService.class, "ProcessService.label26", "\u67e5\u770b\u5de5\u4f5c\u6d41\u7684\u914d\u7f6e\u60c5\u51b5"));
        return this.getFlowEmployment(flow, filter);
    }

    private void validateSetEmployRight(User _loginUser, Flow _flow, String _sOperDesc) throws WCMException {
        if (_loginUser.isAdministrator()) {
            return;
        }
        boolean bHasRight = false;
        CMSObj owner = this.findOwner(_flow.getOwnerType(), _flow.getOwnerId());
        if (owner instanceof BaseChannel) {
            WebSite site = ((BaseChannel)owner).getSite();
            for (int i = 0; i < WCMRightTypes.SET_FLOW_EMPLOY_RIGHTS.length; ++i) {
                if (!AuthServer.hasRight(_loginUser, (CMSObj)site, WCMRightTypes.SET_FLOW_EMPLOY_RIGHTS[i])) continue;
                bHasRight = true;
                break;
            }
        }
        if (!bHasRight) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label27", "\u60a8\u6ca1\u6709\u6743\u9650") + _sOperDesc);
        }
    }

    public ContentProcessInfo getProcessInfoOfContent(MethodContext _methodContext) throws WCMException {
        int nContentId;
        int nContentType = _methodContext.getValue("ContentType", 0);
        IFlowContent content = FlowContentFactory.makeFlowContent(nContentType, nContentId = _methodContext.getValue("ContentId", 0));
        if (content == null) {
            throw new WCMException(200006, I18NMessage.get(ProcessService.class, "ProcessService.label17", "\u6307\u5b9a\u7684\u5185\u5bb9[Type=") + nContentType + ", Id=" + nContentId + I18NMessage.get(ProcessService.class, "ProcessService.label18", "]\u6ca1\u6709\u627e\u5230\uff01"));
        }
        return this.m_oFlowServer.getProcessInfoOfContent(content);
    }

    private Channels getFlowEmployment(Flow _flow, WCMFilter _filter) throws WCMException {
        User loginUser = this.getLoginUser();
        this.validateRight(loginUser, null, _flow, WCMRightTypes.RIGHT_INDEXS_WORKFLOW, I18NMessage.get(ProcessService.class, "ProcessService.label28", "\u5de5\u4f5c\u6d41\u67e5\u770b"));
        return (Channels)this.m_oFlowEmployMgr.getChannelsUseingFlow(_flow, new Channels(loginUser), 101, "WCMCHANNEL", _filter);
    }

    public void enableFlowToChannel(MethodContext _methodContext) throws WCMException {
        User loginUser = this.getLoginUser();
        Flow flow = this.findById(_methodContext.getValue("FlowId", 0));
        int nEmployerType = 101;
        int nEmployerId = _methodContext.getObjectId();
        Channel channel = (Channel)this.findOwner(nEmployerType, nEmployerId);
        int nRightIndex = 13;
        this.validateRight(loginUser, (CMSObj)channel, flow, nRightIndex, I18NMessage.get(ProcessService.class, "ProcessService.label29", "\u7ed9\u680f\u76ee[") + channel.getDispDesc() + "][ID=" + channel.getId() + I18NMessage.get(ProcessService.class, "ProcessService.label30", "]\u8bbe\u7f6e\u5de5\u4f5c\u6d41"));
        this.m_oFlowEmployMgr.setFlow(channel, flow.getId());
    }

    public void disableFlowToChannel(MethodContext _methodContext) throws WCMException {
        User loginUser = this.getLoginUser();
        Flow flow = Flow.findById(_methodContext.getValue("FlowId", 0));
        int nEmployerType = 101;
        int nEmployerId = _methodContext.getValue("ObjectId", 0);
        Channel channel = (Channel)this.findOwner(nEmployerType, nEmployerId);
        if (flow == null) {
            int nRightIndex = 13;
            this.validateRight(loginUser, (CMSObj)channel, null, nRightIndex, I18NMessage.get(ProcessService.class, "ProcessService.label29", "\u7ed9\u680f\u76ee[") + channel.getDispDesc() + "][ID=" + channel.getId() + I18NMessage.get(ProcessService.class, "ProcessService.label30", "]\u8bbe\u7f6e\u5de5\u4f5c\u6d41"));
        } else {
            this.validateSetEmployRight(this.getLoginUser(), flow, I18NMessage.get(ProcessService.class, "ProcessService.label26", "\u67e5\u770b\u5de5\u4f5c\u6d41\u7684\u914d\u7f6e\u60c5\u51b5"));
        }
        this.m_oFlowEmployMgr.clearEmploysOfEmployer(channel);
    }

    public void setChannelEmployersOfFlow(MethodContext _methodContext) throws WCMException {
        User loginUser = this.getLoginUser();
        Flow flow = this.findById(_methodContext.getValue("FlowId", 0));
        int nEmployerType = 101;
        this.validateSetEmployRight(this.getLoginUser(), flow, I18NMessage.get(ProcessService.class, "ProcessService.label31", "\u7ef4\u62a4\u5de5\u4f5c\u6d41\u7684\u914d\u7f6e\u60c5\u51b5"));
        this.m_oFlowEmployMgr.setEmployersOfFlow(loginUser, flow.getId(), nEmployerType, CMyString.splitToInt(_methodContext.getObjectIds(), ","));
    }

    public void removeChannelEmployersOfFlow(MethodContext _methodContext) throws WCMException {
        User loginUser = this.getLoginUser();
        Flow flow = this.findById(_methodContext.getValue("FlowId", 0));
        int nEmployerType = 101;
        int[] arRightIndexes = WCMRightTypes.RIGHT_INDEXS_WORKFLOW;
        this.validateRight(loginUser, null, flow, arRightIndexes, I18NMessage.get(ProcessService.class, "ProcessService.label32", "\u7ef4\u62a4\u5de5\u4f5c\u6d41[") + flow.getName() + "][ID=" + flow.getId() + I18NMessage.get(ProcessService.class, "ProcessService.label33", "]\u7684\u914d\u7f6e\u5173\u7cfb!"));
        int[] pEmployerIds = CMyString.splitToInt(_methodContext.getObjectIds(), ",");
        WCMFilter filter = new WCMFilter("", null, "");
        String sWhere = "FlowId=? and EmployerType=? and EmployerId in(";
        filter.addSearchValues(flow.getId());
        filter.addSearchValues(nEmployerType);
        for (int i = 0; i < pEmployerIds.length; ++i) {
            sWhere = i == 0 ? sWhere + "?" : sWhere + ",?";
            filter.addSearchValues(pEmployerIds[i]);
        }
        sWhere = sWhere + ")";
        filter.setWhere(sWhere);
        FlowEmploys.openWCMObjs(loginUser, filter).removeAll(true);
    }

    public IFlowContent[] getContentsInFlow(MethodContext _methodContext) throws WCMException {
        User loginUser = this.getLoginUser();
        Flow flow = this.findById(_methodContext.getObjectId());
        this.validateRight(loginUser, null, flow, 46, I18NMessage.get(ProcessService.class, "ProcessService.label34", "\u67e5\u770b\u5728\u6307\u5b9a\u5de5\u4f5c\u6d41\u4e2d\u6d41\u8f6c\u7684\u6587\u6863\uff01"));
        return this.m_oFlowServer.getFlowContentsInFlow(flow);
    }

    public IFlowContent[] getContentsOfUser(MethodContext _MethodContext2) throws WCMException {
        User currUser;
        User loginUser = this.getLoginUser();
        int nViewType = _MethodContext2.getValue("ViewType", 1);
        String sCurrUserName = _MethodContext2.getValue("CurrUser");
        String sSearchValue = _MethodContext2.getValue("SearchValue");
        String sSearchType = _MethodContext2.getValue("searchType");
        String sOrderBy = _MethodContext2.getValue("OrderBy");
        CPager pager = new CPager();
        pager.setPageSize(_MethodContext2.getPageSize());
        pager.setCurrentPageIndex(_MethodContext2.getPageIndex());
        QueryFlowDocContext queryFlowDocContext = new QueryFlowDocContext();
        String sSearchFileds = _MethodContext2.getValue("searchFields");
        if (!CMyString.isEmpty(sSearchFileds)) {
            String[] searchFileds = sSearchFileds.split(",");
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < searchFileds.length; ++i) {
                map.put(searchFileds[i], _MethodContext2.getValue(searchFileds[i]));
            }
            queryFlowDocContext.setParameterValue("ValueMap", map);
        }
        if ((currUser = User.findByName(sCurrUserName)) == null) {
            currUser = loginUser;
        }
        queryFlowDocContext.setCurrUser(currUser);
        queryFlowDocContext.setPager(pager);
        queryFlowDocContext.setContentType(_MethodContext2.getValue("ObjType", -1));
        _MethodContext2.getServiceContext().getRequest().setAttribute("PAGER", (Object)pager);
        if (sSearchValue != null) {
            queryFlowDocContext.setParameter("SearchValue", sSearchValue);
        }
        if (sOrderBy != null) {
            queryFlowDocContext.setParameter("OrderBy", sOrderBy);
        }
        if (sSearchType != null) {
            queryFlowDocContext.setParameter("SearchType", sSearchType);
        }
        if (sSearchFileds != null) {
            queryFlowDocContext.setParameter("SearchFileds", sSearchFileds);
        }
        switch (nViewType) {
            case 1: {
                return this.m_oFlowServer.getFlowContentsOfUser(queryFlowDocContext);
            }
            case 2: {
                return this.m_oFlowServer.getFlowContentsDoneByUser(queryFlowDocContext);
            }
            case 3: {
                return this.m_oFlowServer.getFlowContentsStartByUser(queryFlowDocContext);
            }
        }
        throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label35", "\u4e0d\u652f\u6301\u7684\u89c6\u56fe\u7c7b\u578b[") + nViewType + I18NMessage.get(ProcessService.class, "ProcessService.label65", "]\uff01"));
    }

    public FlowDocs getFlowDocsOfContent(MethodContext _methodContext) throws Throwable {
        int nContentId;
        int nContentType = _methodContext.getValue("ContentType", 0);
        IFlowContent content = FlowContentFactory.makeFlowContent(nContentType, nContentId = _methodContext.getValue("ContentId", 0));
        if (content == null) {
            throw new WCMException(200006, I18NMessage.get(ProcessService.class, "ProcessService.label17", "\u6307\u5b9a\u7684\u5185\u5bb9[Type=") + nContentType + ", Id=" + nContentId + I18NMessage.get(ProcessService.class, "ProcessService.label18", "]\u6ca1\u6709\u627e\u5230\uff01"));
        }
        return this.m_oFlowServer.getFlowDocs(content, _methodContext.getExtraWCMFilter());
    }

    public boolean doReceive(MethodContext _MethodContext2) throws WCMException {
        return this.sendReceipt(_MethodContext2, false);
    }

    public boolean backTo(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        FlowDocs flowDocs = FlowDocs.findByIdsOfDealer(loginUser, _methodContext.getObjectIds(), loginUser);
        FlowContext context = new FlowContext();
        context.setCurrUser(loginUser);
        context.setPostUser(loginUser);
        context.setPostDesc(_methodContext.getValue("PostDesc"));
        context.setNotifyTypes(_methodContext.getValue("NotifyTypes"));
        String sApplyExtension = _methodContext.getValue("ApplyExtension");
        if (!CMyString.isEmpty(sApplyExtension) && "1".equals(sApplyExtension)) {
            context.setProperty("ApplyExtension", "1");
        }
        int nSize = flowDocs.size();
        for (int i = 0; i < nSize; ++i) {
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null) continue;
            context.setCurrFlowDoc(flowDoc);
            this.m_oFlowServer.backTo(context);
        }
        return true;
    }

    public boolean refuse(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        FlowDocs flowDocs = FlowDocs.findByIdsOfDealer(loginUser, _methodContext.getObjectIds(), loginUser);
        FlowContext context = new FlowContext();
        context.setCurrUser(loginUser);
        context.setPostUser(loginUser);
        context.setPostDesc(_methodContext.getValue("PostDesc"));
        int nSize = flowDocs.size();
        for (int i = 0; i < nSize; ++i) {
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null) continue;
            context.setCurrFlowDoc(flowDoc);
            this.m_oFlowServer.refuse(context);
        }
        return true;
    }

    public boolean forceEnd(MethodContext _methodContext) throws Throwable {
        int nContentId;
        User loginUser = this.getLoginUser();
        int nContentType = _methodContext.getValue("ContentType", 0);
        IFlowContent content = FlowContentFactory.makeFlowContent(nContentType, nContentId = _methodContext.getValue("ContentId", 0));
        if (content == null) {
            throw new WCMException(200006, I18NMessage.get(ProcessService.class, "ProcessService.label17", "\u6307\u5b9a\u7684\u5185\u5bb9[Type=") + nContentType + ", Id=" + nContentId + I18NMessage.get(ProcessService.class, "ProcessService.label18", "]\u6ca1\u6709\u627e\u5230\uff01"));
        }
        FlowContext context = new FlowContext(loginUser, content);
        context.setCurrUser(loginUser);
        context.setPostUser(loginUser);
        context.setPostDesc(_methodContext.getValue("PostDesc"));
        context.setFlowContent(content);
        this.m_oFlowServer.forceEnd(context);
        return true;
    }

    public void submitTo(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        FlowContext context = this.createFlowContextFrom(_methodContext, loginUser);
        FlowDocs flowDocs = FlowDocs.findByIdsOfDealer(loginUser, _methodContext.getObjectIds(), loginUser);
        if (flowDocs.isEmpty()) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label36", "\u60a8\u8981\u5904\u7406\u7684\u5185\u5bb9\u53ef\u80fd\u662f\u7ed9\u5176\u5b83\u4eba\u7684\u6216\u8005\u88ab\u5220\u9664\u4e86\uff01ObjectIds=") + _methodContext.getObjectIds());
        }
        int nSize = flowDocs.size();
        for (int i = 0; i < nSize; ++i) {
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null) continue;
            context.setCurrFlowDoc(flowDoc);
            this.m_oFlowServer.submitTo(context);
        }
    }

    public void reSubmitTo(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        FlowContext context = this.createFlowContextFrom(_methodContext, loginUser);
        FlowDocs flowDocs = FlowDocs.findByIdsOfPoster(loginUser, _methodContext.getObjectIds(), loginUser);
        int nSize = flowDocs.size();
        for (int i = 0; i < nSize; ++i) {
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null) continue;
            context.setCurrFlowDoc(flowDoc);
            this.m_oFlowServer.resubmitTo(context);
        }
    }

    private FlowContext createFlowContextFrom(MethodContext _methodContext, User _loginUser) throws WCMException {
        FlowNode nextNode = FlowNode.findById(_methodContext.getValue("NextNodeId", 0));
        Users toUsers = null;
        String sToUserIds = _methodContext.getValue("ToUserIds");
        if (sToUserIds != null && sToUserIds.length() > 0) {
            toUsers = Users.findByIds(null, sToUserIds);
        }
        FlowContext context = new FlowContext();
        context.setCurrUser(_loginUser);
        context.setPostUser(_loginUser);
        context.setPostDesc(_methodContext.getValue("PostDesc"));
        context.setNextNode(nextNode);
        context.setToUsers(toUsers);
        context.setNotifyTypes(_methodContext.getValue("NotifyTypes"));
        String sReffererTo = "false";
        if (!CMyString.isEmpty(_methodContext.getValue("ReffererTo"))) {
            sReffererTo = _methodContext.getValue("ReffererTo");
        }
        context.setProperty("ReffererTo", sReffererTo);
        return context;
    }

    public FlowNodes getNextNodes(MethodContext _methodContext) throws Throwable {
        FlowDoc flowDoc = FlowDoc.findById(_methodContext.getObjectId());
        boolean bResubmit = _methodContext.getValue("Resubmit", false);
        FlowNodes nodes = this.m_oFlowServer.getNextFlowNodes(flowDoc, bResubmit);
        if (bResubmit && nodes.size() > 1) {
            FlowNode node = flowDoc.getNode();
            nodes.remove(node.getId(), false);
            nodes.addElement(node, 0);
        }
        return nodes;
    }

    public FlowNodes getProcessedNodes(MethodContext _methodContext) throws WCMException {
        int nCurrFlowDocId = _methodContext.getObjectId();
        if (nCurrFlowDocId == 0) {
            throw new WCMException("\u4f20\u5165\u7684\u5f53\u524d\u8f68\u8ff9Id\u5fc5\u987b\u5927\u4e8e0\uff01");
        }
        FlowDoc flowdoc = FlowDoc.findById(nCurrFlowDocId);
        if (flowdoc == null) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230Id\u4e3a\u3010\uff01" + nCurrFlowDocId + "\u3011\u7684\u6d41\u8f6c\u8f68\u8ff9\uff01");
        }
        FlowNodes nodes = this.m_oFlowServer.getProcessedFlowNodes(flowdoc);
        return nodes;
    }

    public FlowNodes getWorkModalSepretorEndNodes(MethodContext _methodContext) throws WCMException {
        int nCurrFlowDocId = _methodContext.getObjectId();
        if (nCurrFlowDocId == 0) {
            throw new WCMException("\u4f20\u5165\u7684\u5f53\u524d\u8f68\u8ff9Id\u5fc5\u987b\u5927\u4e8e0\uff01");
        }
        FlowDoc flowdoc = FlowDoc.findById(nCurrFlowDocId);
        if (flowdoc == null) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230Id\u4e3a\u3010\uff01" + nCurrFlowDocId + "\u3011\u7684\u6d41\u8f6c\u8f68\u8ff9\uff01");
        }
        FlowNodes nodes = this.m_oFlowServer.getWorkModalSepretorEndNodes(flowdoc);
        return nodes;
    }

    public void autoToNextNode(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        FlowContext context = this.createFlowContextFrom(_methodContext, loginUser);
        FlowDocs flowDocs = FlowDocs.findByIdsOfDealer(loginUser, _methodContext.getObjectIds(), loginUser);
        if (flowDocs.isEmpty()) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label36", "\u60a8\u8981\u5904\u7406\u7684\u5185\u5bb9\u53ef\u80fd\u662f\u7ed9\u5176\u5b83\u4eba\u7684\u6216\u8005\u88ab\u5220\u9664\u4e86\uff01ObjectIds=") + _methodContext.getObjectIds());
        }
        int nSize = flowDocs.size();
        for (int i = 0; i < nSize; ++i) {
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null) continue;
            context.setCurrFlowDoc(flowDoc);
            this.m_oFlowServer.autoToNextNode(context, context.getNextNode());
        }
    }

    private boolean sendReceipt(MethodContext _methodContext, boolean _bIsAccept) throws WCMException {
        User loginUser = this.getLoginUser();
        FlowDocs flowDocs = FlowDocs.findByIdsOfDealer(loginUser, _methodContext.getObjectIds(), loginUser);
        FlowContext context = new FlowContext();
        context.setPostUser(loginUser);
        context.setCurrUser(loginUser);
        int nSize = flowDocs.size();
        for (int i = 0; i < nSize; ++i) {
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null) continue;
            context.setCurrFlowDoc(flowDoc);
            if (_bIsAccept) {
                this.m_oFlowServer.doAccept(context);
                continue;
            }
            this.m_oFlowServer.doReceive(context);
        }
        return true;
    }

    public boolean doAccept(MethodContext _MethodContext2) throws WCMException {
        return this.sendReceipt(_MethodContext2, true);
    }

    public String getBranchInfo(MethodContext _methodContext) throws Throwable {
        Group groupRange;
        User loginUser = this.getLoginUser();
        FlowDoc flowDoc = this.findFlowDocById(_methodContext.getValue("FlowDocId", 0));
        int nNextNodeId = _methodContext.getValue("NextNodeId", 0);
        boolean bResubmit = _methodContext.getValue("ReSubmit", false);
        if (bResubmit) {
            if (!loginUser.getName().equalsIgnoreCase(flowDoc.getPostUserName())) {
                logger.error((Object)(I18NMessage.get(ProcessService.class, "ProcessService.label37", "\u5bf9\u4e0d\u8d77\uff0c\u8fd9\u4e2a\u4e8b\u52a1\u4e0d\u9700\u8981\u60a8\u9012\u4ea4\u7684\uff01\u9012\u4ea4\u4eba\u4e3a[") + flowDoc.getToUser() + "]"));
                throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label38", "\u5bf9\u4e0d\u8d77\uff0c\u8fd9\u4e2a\u4e8b\u52a1\u4e0d\u662f\u7531\u60a8\u9012\u4ea4\u7684\uff0c\u4e0d\u80fd\u83b7\u53d6\u5206\u652f\u4fe1\u606f\uff01"));
            }
        } else if (flowDoc.getToUserId() != loginUser.getId()) {
            logger.error((Object)(I18NMessage.get(ProcessService.class, "ProcessService.label39", "\u5bf9\u4e0d\u8d77\uff0c\u8fd9\u4e2a\u4e8b\u52a1\u4e0d\u9700\u8981\u60a8\u6765\u5904\u7406\uff01\u5904\u7406\u4eba\u4e3a[") + flowDoc.getToUser() + "]"));
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label40", "\u5bf9\u4e0d\u8d77\uff0c\u8fd9\u4e2a\u4e8b\u52a1\u4e0d\u9700\u8981\u60a8\u6765\u5904\u7406\uff01"));
        }
        FlowNextBranchInfo branchInfo = new FlowNextBranchInfo(loginUser, flowDoc, nNextNodeId, bResubmit);
        Users toUsers = branchInfo.getToUsers();
        Status status = branchInfo.getChangeStatus();
        StringBuffer sbResult = null;
        String sUsersInfo = "";
        IXMLConvertor convertorOfUser = XMLConvertorFactory.createConvertor(Users.class);
        if (convertorOfUser != null && toUsers != null && toUsers.size() != 0) {
            _methodContext.setValue("SelectFields", "UserId,TrueName,UserName,Address,test");
            sUsersInfo = convertorOfUser.toXmlString(_methodContext, toUsers);
        }
        sbResult = new StringBuffer(sUsersInfo.length() + 300);
        sbResult.append("<BranchInfo>\n");
        sbResult.append(sUsersInfo);
        Users postUsers = Users.createNewInstance(loginUser);
        User oPostUser = flowDoc.getPostUser();
        if (oPostUser != null) {
            postUsers.addElement(oPostUser);
        }
        String sPostUsersInfo = "";
        if (convertorOfUser != null && oPostUser != null && postUsers.size() != 0) {
            _methodContext.setValue("SelectFields", "UserId,TrueName,UserName");
            sPostUsersInfo = convertorOfUser.toXmlString(_methodContext, postUsers);
            sbResult.append(sPostUsersInfo.replaceAll("(?ism)Users", "PostUsers"));
        }
        if ((groupRange = branchInfo.getGroupRange()) != null) {
            sbResult.append("<GroupRange>\n");
            sbResult.append("<GroupId>").append(groupRange.getId()).append("</GroupId>\n");
            sbResult.append("<GroupName>").append(groupRange.getName()).append("</GroupName>\n");
            sbResult.append("</GroupRange>\n");
        }
        if (status != null) {
            sbResult.append("\n");
            sbResult.append("<DOCSTATUS Id=\"" + status.getId() + "\" Name=\"" + status.getDisp() + "\"/>");
            sbResult.append("\n");
        }
        sbResult.append("<NOTIFYSTYLES>");
        sbResult.append(CMyString.showNull(branchInfo.getNotifyTypes()));
        sbResult.append("</NOTIFYSTYLES>\n");
        if (convertorOfUser != null && branchInfo.getUsersPassed() != null) {
            _methodContext.setValue("SelectFields", "UserId,TrueName,UserName");
            String sUsersPassed = convertorOfUser.toXmlString(_methodContext, branchInfo.getUsersPassed());
            sbResult.append(sUsersPassed.replaceAll("(?ism)Users", "UsersPassed"));
        }
        if (flowDoc.getFlag() == 2) {
            FlowNode oNextNode = flowDoc.getPreNode();
            sbResult.append("<NEXTWORKMODAL>");
            sbResult.append(oNextNode.getWorkModal());
            sbResult.append("</NEXTWORKMODAL>\n");
        }
        sbResult.append("</BranchInfo>");
        return sbResult.toString();
    }

    public FlowNodeFields getFieldsInfoOfFlowDoc(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
        FlowDoc flowDoc = this.findFlowDocById(_methodContext.getValue("FlowDocId", 0));
        if (!loginUser.isAdministrator() && !flowDoc.getPostUserName().equalsIgnoreCase(loginUser.getName()) && flowDoc.getToUserId() != loginUser.getId()) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label41", "\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u6b64\u8f68\u8ff9\uff01[FlowDocId=") + nFlowDocId + "]");
        }
        int nNodeId = 0;
        nNodeId = flowDoc.isWorked() && flowDoc.getPostUserName().equalsIgnoreCase(loginUser.getName()) ? flowDoc.getPreNodeId() : flowDoc.getNodeId();
        WCMFilter filter = new WCMFilter("", "NodeId=?", "");
        filter.addSearchValues(nNodeId);
        FlowNodeFields fields = FlowNodeFields.openWCMObjs(loginUser, filter);
        int nSize = fields.size();
        FlowContext flowContext = new FlowContext();
        flowContext.setCurrUser(loginUser);
        flowContext.setPostUser(loginUser);
        flowContext.setCurrFlowDoc(flowDoc);
        for (int i = 0; i < nSize; ++i) {
            String sInitValueCreator;
            FlowNodeField field = (FlowNodeField)fields.getAt(i);
            if (field == null || CMyString.isEmpty(sInitValueCreator = field.getPropertyAsString("InitValueCreator"))) continue;
            IInitValueCreator creator = (IInitValueCreator)Class.forName(sInitValueCreator).newInstance();
            field.getProperties().put("INITVALUE", creator.createInitValue(flowContext));
        }
        return fields;
    }

    private WCMFilter makeQueryFlowsOfHostFilter(CMSObj _host, boolean _bContainsChildren) throws WCMException {
        StringBuffer sbWhere;
        String sHostIdFieldName = "OwnerId";
        String sHostTypeFieldName = "OwnerType";
        String sFromTableName = "WCMFLOW";
        WCMFilter filter = new WCMFilter();
        switch (_host.getWCMType()) {
            case 1: {
                int nMaxLength = _bContainsChildren ? 400 : 50;
                sbWhere = new StringBuffer(nMaxLength);
                int nSearchIndex = 0;
                sbWhere.append("(" + sHostIdFieldName + "=? and " + sHostTypeFieldName + "=?)");
                filter.addSearchValues(nSearchIndex++, _host.getId());
                filter.addSearchValues(nSearchIndex++, _host.getWCMType());
                if (!_bContainsChildren) break;
                sbWhere.append(" or ");
                sbWhere.append("exists(select WCMWebSite.SiteId from WCMWebSite where WCMWebSite.SiteType=? and " + sFromTableName + "." + sHostTypeFieldName + "=103 and " + sFromTableName + "." + sHostIdFieldName + "=WCMWebSite.SiteId)");
                filter.addSearchValues(nSearchIndex++, _host.getId());
                sbWhere.append(" or ");
                sbWhere.append("exists(select WCMChannel.ChannelId from WCMChannel where " + sFromTableName + "." + sHostTypeFieldName + "=101 and " + sFromTableName + "." + sHostIdFieldName + "=WCMChannel.ChannelId and exists(select WCMWebSite.SiteId from WCMWebSite where WCMWebSite.SiteType=? and " + "WCMCHANNEL" + ".SiteId=WCMWebSite.SiteId))");
                filter.addSearchValues(nSearchIndex++, _host.getId());
                break;
            }
            case 103: {
                int nMaxLength = _bContainsChildren ? 300 : 50;
                sbWhere = new StringBuffer(nMaxLength);
                int nSearchIndex = 0;
                sbWhere.append("(" + sHostIdFieldName + "=? and " + sHostTypeFieldName + "=?)");
                filter.addSearchValues(nSearchIndex++, _host.getId());
                filter.addSearchValues(nSearchIndex++, _host.getWCMType());
                if (!_bContainsChildren) break;
                sbWhere.append(" or ");
                sbWhere.append("exists(select WCMChannel.ChannelId from WCMChannel where " + sFromTableName + "." + sHostTypeFieldName + "=101 and " + sFromTableName + "." + sHostIdFieldName + "=WCMChannel.ChannelId and exists(select WCMWebSite.SiteId from WCMWebSite where WCMWebSite.SiteId=? and " + "WCMCHANNEL" + ".SiteId=WCMWebSite.SiteId))");
                filter.addSearchValues(nSearchIndex++, _host.getId());
                break;
            }
            case 101: {
                int nMaxLength = _bContainsChildren ? 200 : 50;
                sbWhere = new StringBuffer(nMaxLength);
                if (_bContainsChildren) {
                    sbWhere.append("" + sHostTypeFieldName + "=? and " + sHostIdFieldName + " in(?");
                    filter.addSearchValues(0, _host.getWCMType());
                    filter.addSearchValues(1, _host.getId());
                    this.makeChildrenWhere(filter, sbWhere, (Channel)_host);
                    sbWhere.append(")");
                    break;
                }
                sbWhere.append("(" + sHostIdFieldName + "=? and " + sHostTypeFieldName + "=?)");
                filter.addSearchValues(0, _host.getId());
                filter.addSearchValues(1, _host.getWCMType());
                break;
            }
            default: {
                throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label42", "\u672a\u77e5\u7c7b\u578b[HostType=") + _host.getWCMType() + ",HostId=" + _host.getId() + "]\uff01");
            }
        }
        filter.setWhere(sbWhere.toString());
        return filter;
    }

    private void makeChildrenWhere(WCMFilter _filter, StringBuffer _sbWhere, Channel _parent) throws WCMException {
        List<Channel> lChildren = _parent.getChildren(null);
        if (lChildren == null || lChildren.isEmpty()) {
            return;
        }
        int nSize = lChildren.size();
        for (int i = 0; i < nSize; ++i) {
            Channel child = lChildren.get(i);
            if (child == null) continue;
            _sbWhere.append(",?");
            _filter.addSearchValues(_filter.getSearchValues().size(), child.getId());
            this.makeChildrenWhere(_filter, _sbWhere, child);
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private CMSObj findOwner(int _nOwnerType, int _nOwnerId) throws WCMException {
        int nOwnerType = _nOwnerType;
        int nOwnerId = _nOwnerId;
        switch (nOwnerType) {
            case 103: {
                WebSite currSite = WebSite.findById(nOwnerId);
                if (currSite == null) {
                    throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label43", "\u6307\u5b9a\u7684\u7ad9\u70b9[ID=") + nOwnerId + I18NMessage.get(ProcessService.class, "ProcessService.label44", "]\u4e0d\u5b58\u5728\uff01"));
                }
                return currSite;
            }
            case 101: {
                Channel currChannel = Channel.findById(nOwnerId);
                if (currChannel == null) {
                    throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label45", "\u6307\u5b9a\u7684\u680f\u76ee[ID=") + nOwnerId + I18NMessage.get(ProcessService.class, "ProcessService.label44", "]\u4e0d\u5b58\u5728\uff01"));
                }
                return currChannel;
            }
            case 605: {
                String SQL_QUERY_CHANNEL_ID = "select DocChannel from WCMDocument where DocId=?";
                int nChannelId = DBManager.getDBManager().sqlExecuteIntQuery("select DocChannel from WCMDocument where DocId=?", new int[]{nOwnerId});
                Channel docChannel = Channel.findById(nChannelId);
                if (docChannel == null) {
                    throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label46", "\u6307\u5b9a\u7684\u6587\u6863[ID=") + nOwnerId + I18NMessage.get(ProcessService.class, "ProcessService.label47", "]\u7684\u6240\u5c5e\u680f\u76ee\u4e0d\u5b58\u5728\uff01"));
                }
                return docChannel;
            }
            case 0: 
            case 1: {
                return new WCMSystemObject(nOwnerId);
            }
        }
        throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label42", "\u672a\u77e5\u7c7b\u578b[HostType=") + nOwnerType + "]");
    }

    private void validateRight(User loginUser, CMSObj _owner, Flow _flow, int _nRightIndex, String _sOprDesc) throws WCMException {
        if (_owner == null && _flow == null) {
            return;
        }
        if (_flow != null && _flow.getCrUserName().equalsIgnoreCase(loginUser.getName())) {
            return;
        }
        CMSObj owner = _owner;
        if (_owner == null && _flow != null) {
            owner = this.findOwner(_flow.getOwnerType(), _flow.getOwnerId());
        }
        if (!AuthServer.hasRight(loginUser, owner, _nRightIndex)) {
            throw new WCMException(CMyString.format(I18NMessage.get(ProcessService.class, "ProcessService.label66", "\u60a8[{0}]\u6ca1\u6709\u6743\u9650\u5728{1}\u4e0a{2}!"), new String[]{loginUser.getName(), owner.toString(), _sOprDesc}));
        }
    }

    private void validateRight(User loginUser, CMSObj _owner, Flow _flow, int[] _arRightIndexes, String _sOprDesc) throws WCMException {
        if (_owner == null && _flow == null) {
            return;
        }
        if (_flow != null && _flow.getCrUserName().equalsIgnoreCase(loginUser.getName())) {
            return;
        }
        CMSObj owner = _owner;
        if (_owner == null && _flow != null) {
            owner = this.findOwner(_flow.getOwnerType(), _flow.getOwnerId());
        }
        for (int i = 0; i < _arRightIndexes.length; ++i) {
            if (!AuthServer.hasRight(loginUser, owner, _arRightIndexes[i])) continue;
            return;
        }
        throw new WCMException(CMyString.format(I18NMessage.get(ProcessService.class, "ProcessService.label66", "\u60a8[{0}]\u6ca1\u6709\u6743\u9650\u5728{1}\u4e0a{2}!"), new String[]{loginUser.getName(), _owner.toString(), _sOprDesc}));
    }

    private void validateRight(User loginUser, Flows _flows, int _nRightIndex, String _sOprDesc) throws Throwable {
        int nSize = _flows.size();
        for (int i = 0; i < nSize; ++i) {
            Flow flow = (Flow)_flows.getAt(i);
            if (flow == null) continue;
            this.validateRight(loginUser, null, flow, _nRightIndex, _sOprDesc);
        }
    }

    public String getEmploymentInfo(MethodContext _methContext) throws Throwable {
        String sFlowIds = _methContext.getObjectIds();
        _methContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(this.getEmploymentInfoByIds(sFlowIds), 0);
    }

    private HashMap getEmploymentInfoByIds(String _sFlowIds) throws Throwable {
        User loginUser = this.getLoginUser();
        Flows flows = Flows.findByIds(loginUser, _sFlowIds);
        HashMap<String, Object[]> hResult = new HashMap<String, Object[]>(1);
        Object[] pResult = new Object[flows.size()];
        for (int i = 0; i < pResult.length; ++i) {
            Flow flow = (Flow)flows.getAt(i);
            if (flow == null) continue;
            Channels channels = this.getFlowEmployment(flow, null);
            HashMap<String, Object> hValue = new HashMap<String, Object>(5);
            if (channels != null && !channels.isEmpty()) {
                String[] chnlDescs = new String[channels.size()];
                for (int j = 0; j < channels.size(); ++j) {
                    Channel refChnl = (Channel)channels.getAt(j);
                    if (refChnl == null) continue;
                    chnlDescs[j] = CMyString.filterForHTMLValue(refChnl.getDesc()) + I18NMessage.get(ProcessService.class, "ProcessService.label51", "(\u680f\u76ee-") + refChnl.getId() + ")";
                }
                hValue.put("refchannels", chnlDescs);
            }
            hValue.put("flowid", String.valueOf(flow.getId()));
            hValue.put("flowname", CMyString.filterForHTMLValue(flow.getName()));
            hValue.put("owner", this.getFlowOwnerInfo(flow));
            pResult[i] = hValue;
        }
        hResult.put("employmentInfo", pResult);
        return hResult;
    }

    private Object getFlowOwnerInfo(Flow _flow) throws Throwable {
        if (_flow.getOwnerType() != 103) {
            return WebSiteServiceProvider.findSiteTypeDesc(_flow.getOwnerId());
        }
        BaseObj owner = _flow.getOwner();
        if (owner == null) {
            return "";
        }
        WebSite site = (WebSite)owner;
        return CMyString.filterForHTMLValue(site.getDesc()) + I18NMessage.get(ProcessService.class, "ProcessService.label52", "(\u7ad9\u70b9-") + site.getId() + ")";
    }

    public String getFlowOptionAuth(MethodContext _context) throws WCMException {
        String result = "";
        boolean bCanAddFlow = false;
        String sRights = "0";
        User loginUser = this.getLoginUser();
        if (loginUser.isAdministrator()) {
            bCanAddFlow = true;
            sRights = "1111111111111111111111111111111111111111111111111111111111111111";
        } else {
            int nChannelId = _context.getValue("ChannelId", 0);
            int nSiteId = _context.getValue("SiteId", 0);
            try {
                WebSite site = null;
                if (nChannelId > 0) {
                    Channel chnl = Channel.findById(nChannelId);
                    site = chnl.getSite();
                } else if (nSiteId > 0) {
                    site = WebSite.findById(nSiteId);
                }
                sRights = AuthServer.getRightValue((CMSObj)site, loginUser).toString();
                bCanAddFlow = AuthServer.hasRight(loginUser, (CMSObj)site, 41);
            }
            catch (Throwable ex) {
                logger.warn((Object)(I18NMessage.get(ProcessService.class, "ProcessService.label53", "\u83b7\u53d6\u5de5\u4f5c\u6d41\u6743\u9650\u65f6\u5931\u8d25\uff0c\u53ef\u80fd\u5bfc\u81f4\u5de5\u4f5c\u6d41\u64cd\u4f5c\u6743\u9650\u8ba1\u7b97\u6709\u8bef\uff01\uff08\u6307\u5b9a[SiteId=") + nSiteId + ", ChannelId=" + nChannelId + "])"), ex);
            }
        }
        result = result + "<FlowOptionAuth canAddFlow=\"" + bCanAddFlow + "\" rights=\"" + sRights + "\"></FlowOptionAuth>";
        return result;
    }

    public void startDocumentInFlow(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Document document = Document.findById(_methodContext.getObjectId());
        if (document == null) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label54", "\u6307\u5b9a\u7684\u6587\u6863\u4e0d\u5b58\u5728![ObjectId=") + _methodContext.getObjectId() + "]");
        }
        if (!DocumentAuthServer.hasRight(loginUser, null, document, 32)) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label55", "\u60a8\u6ca1\u6709\u6743\u9650\u8ba9\u6587\u6863[Title=") + document.getTitle() + "][DocId=" + _methodContext.getObjectId() + I18NMessage.get(ProcessService.class, "ProcessService.label56", "]\u6d41\u8f6c\uff01"));
        }
        WCMProcessServiceHelper.startDocumentInFlow(loginUser, document, true);
    }

    public String createFrom(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        CMSObj owner = this.findOwner(0, 1);
        String sSrcFlowIds = _methodContext.getObjectIds();
        Flows srcFlows = Flows.findByIds(this.getLoginUser(), sSrcFlowIds);
        if (srcFlows.size() == 0) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label57", "\u8981\u7c7b\u4f3c\u521b\u5efa\u7684\u5de5\u4f5c\u6d41[") + sSrcFlowIds + I18NMessage.get(ProcessService.class, "ProcessService.label58", "]\u5df2\u4e0d\u5b58\u5728\uff01"));
        }
        String sAllFlows = "";
        ArrayList<String> arAllFlows = new ArrayList<String>(srcFlows.size());
        for (int i = 0; i < srcFlows.size(); ++i) {
            Flow flow = (Flow)srcFlows.getAt(i);
            if (flow == null) continue;
            arAllFlows.add(flow.getId() + "-" + flow.getName());
        }
        sAllFlows = CMyString.join(arAllFlows, ",");
        if (!AuthServer.hasRight(loginUser, owner, 41)) {
            throw new WCMException(I18NMessage.get(ProcessService.class, "ProcessService.label59", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + loginUser.getName() + I18NMessage.get(ProcessService.class, "ProcessService.label60", "]\u6ca1\u6709\u6743\u9650\u5728\u7cfb\u7edf\u5185\u7c7b\u4f3c\u521b\u5efa\u5de5\u4f5c\u6d41\uff01"));
        }
        FlowXmlConverter exporter = new FlowXmlConverter();
        FlowImporter importer = new FlowImporter(loginUser, 1);
        boolean bCreateWithFlowNodeFields = _methodContext.getValue("CreateWithFlowNodeFields", false);
        importer.setImportWithFlowNodeFields(bCreateWithFlowNodeFields);
        importer.setImportWithInfoviewId(false);
        try {
            String sXmlFile = FilesMan.getFilesMan().getNextFileName("ST", ".xml", null, true);
            exporter.toXMLFile(srcFlows, sXmlFile);
            Reports reports = importer.importFromFile(sXmlFile, null);
            List fails = reports.getFailedReporter();
            List succs = reports.getSucessedReporter();
            if (fails != null && fails.size() > 0) {
                String sTitle = I18NMessage.get(ProcessService.class, "ProcessService.label61", "\u4ece\u5de5\u4f5c\u6d41[") + sAllFlows + I18NMessage.get(ProcessService.class, "ProcessService.label62", "]\u7c7b\u4f3c\u521b\u5efa\u5230\u7cfb\u7edf\u5931\u8d25\uff01");
                reports.setTitle(sTitle);
                ((Report)fails.get(0)).setRportTitle(sTitle);
            } else if (succs != null && succs.size() > 0) {
                String sTitle = I18NMessage.get(ProcessService.class, "ProcessService.label61", "\u4ece\u5de5\u4f5c\u6d41[") + sAllFlows + I18NMessage.get(ProcessService.class, "ProcessService.label63", "]\u7c7b\u4f3c\u521b\u5efa\u5230\u7cfb\u7edf\u6210\u529f\uff01");
                reports.setTitle(sTitle);
                ((Report)succs.get(0)).setRportTitle(sTitle);
            }
            return reports.toJSONXML();
        }
        catch (WCMException e) {
            throw new WCMException(1100, I18NMessage.get(ProcessService.class, "ProcessService.label64", "\u7c7b\u4f3c\u521b\u5efa\u5de5\u4f5c\u6d41\u5931\u8d25!"), e);
        }
    }

    public static boolean canDocumentIntoFlow(MethodContext _methodContext) throws Throwable {
        int nDocumentId = _methodContext.getObjectId();
        if (nDocumentId <= 0) {
            return false;
        }
        Document _document = Document.findById(nDocumentId);
        if (_document == null) {
            return false;
        }
        IFlowContent content = FlowContentFactory.makeFlowContent(605, _document.getId());
        boolean bCanIntoFlow = false;
        if (content != null) {
            IFlowServer m_oFlowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
            ContentProcessInfo oProcessInfo = m_oFlowServer.getProcessInfoOfContent(content);
            bCanIntoFlow = (oProcessInfo.canInFlow() || oProcessInfo.canReInFlow()) && _document.getStatusId() != 1028;
        }
        return bCanIntoFlow;
    }

    public boolean canTakeBack(MethodContext _methodContext) throws Throwable {
        int nFlowDocId = _methodContext.getValue("flowdocid", 0);
        if (nFlowDocId == 0) {
            return false;
        }
        FlowDoc currFlowDoc = FlowDoc.findById(nFlowDocId);
        return this.canTakeBack(currFlowDoc);
    }

    private boolean canTakeBack(FlowDoc _oFlowDoc) throws WCMException {
        if (_oFlowDoc == null) {
            return false;
        }
        if (_oFlowDoc.getFlag() == 18) {
            return false;
        }
        if (!this.getLoginUser().getName().equals(_oFlowDoc.getPostUserName())) {
            return false;
        }
        if (_oFlowDoc.getFlag() == 2 || _oFlowDoc.getFlag() == 8 || _oFlowDoc.getFlag() == 14) {
            return false;
        }
        if (_oFlowDoc.getParentId() > 0) {
            return false;
        }
        if (_oFlowDoc.isObjDeleted()) {
            return false;
        }
        FlowDoc preFlowDoc = _oFlowDoc.getPreFlowDoc();
        boolean bResubmit = false;
        while (preFlowDoc.getFlag() == 4) {
            if ((preFlowDoc = preFlowDoc.getPreFlowDoc()) == null) {
                return false;
            }
            if (bResubmit) continue;
            bResubmit = true;
        }
        if (bResubmit && (preFlowDoc = preFlowDoc.getPreFlowDoc()) == null) {
            return false;
        }
        if (preFlowDoc.getWorkModal() != 0) {
            return false;
        }
        String receivedCantakeback = ConfigServer.getServer().getSysConfigValue("RECEIVED_CANTAKEBACK", "false");
        if ("false".equalsIgnoreCase(receivedCantakeback) && !_oFlowDoc.getReceiveTime().isNull()) {
            return false;
        }
        FlowDocs oChildren = _oFlowDoc.getChildren(this.getLoginUser(), null);
        return oChildren.size() == 0 && !_oFlowDoc.isWorked() && !_oFlowDoc.isAccepted();
    }

    public void takeBack(MethodContext _methodContext) throws Throwable {
        if (!this.canTakeBack(_methodContext)) {
            return;
        }
        int nFlowDocId = _methodContext.getValue("flowdocid", 0);
        FlowDoc currFlowDoc = FlowDoc.findById(nFlowDocId);
        User loginUser = this.getLoginUser();
        currFlowDoc.validCanEditAndLock(loginUser);
        currFlowDoc.setWorked(true);
        currFlowDoc.update(loginUser);
        FlowDoc realCurrFlowDoc = currFlowDoc;
        while (realCurrFlowDoc.getFlag() == 4) {
            if ((realCurrFlowDoc = realCurrFlowDoc.getPreFlowDoc()) != null) continue;
            throw new WCMException("\u6570\u636e\u6709\u8bef\uff01[FlowDocId=" + currFlowDoc.getId() + "]");
        }
        int nNodeId = realCurrFlowDoc.getPreNodeId();
        int nPreNodeId = realCurrFlowDoc.getNodeId();
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        IFlowContent iFlowContent = realCurrFlowDoc.getFlowContent();
        Document nDocument = (Document)iFlowContent.getSubinstance();
        FlowDoc preFlowDoc = realCurrFlowDoc.getPreFlowDoc();
        FlowNodeBranch preBranchComeFrom = preFlowDoc.getBranchComeFrom(ContextHelper.getLoginUser());
        documentMgr.changeStatus(nDocument, nDocument.getChannel(), preBranchComeFrom.getStatus());
        FlowDoc transmitFlowDoc = new FlowDoc();
        transmitFlowDoc.setContentType(realCurrFlowDoc.getContentType());
        transmitFlowDoc.setContentId(realCurrFlowDoc.getContentId());
        transmitFlowDoc.setPostUser(loginUser);
        transmitFlowDoc.setPostTime(CMyDateTime.now());
        transmitFlowDoc.setPostDesc("\u6536\u56de");
        transmitFlowDoc.setToUser(loginUser.getId());
        transmitFlowDoc.setFlag(14);
        transmitFlowDoc.setPreNode(nPreNodeId);
        transmitFlowDoc.setNode(nNodeId);
        transmitFlowDoc.setPreFlowDoc(nFlowDocId);
        transmitFlowDoc.setWorkModal(realCurrFlowDoc.getPreNode().getWorkModal());
        transmitFlowDoc.setNextId();
        transmitFlowDoc.setSerialNum(realCurrFlowDoc.getSerialNum());
        transmitFlowDoc.setBranchSerialNum(realCurrFlowDoc.getBranchSerialNum());
        transmitFlowDoc.insert(loginUser);
        this.autodeleteMessage(currFlowDoc, currFlowDoc.getToUser());
    }

    private void autodeleteMessage(FlowDoc _oFlowDoc, User _oUser) throws WCMException {
        String sDeleteMessage = ConfigServer.getServer().getSysConfigValue("DELETE_MESSAGE_AFTER_PROCESS", "false");
        if ("true".equalsIgnoreCase(sDeleteMessage)) {
            if (_oFlowDoc == null) {
                return;
            }
            if (_oUser == null) {
                return;
            }
            MessageServer.deleteMessage(_oFlowDoc.getId(), _oUser);
        }
    }

    public void clearPublishFlowDoc(MethodContext _methodContext) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        _methodContext.setValue("PAGESIZE", Integer.MAX_VALUE);
        _methodContext.setValue("CURRPAGE", 1);
        IFlowContent[] flowcontentArr = this.getContentsOfUser(_methodContext);
        for (int i = 0; i < flowcontentArr.length; ++i) {
            if (!(flowcontentArr[i] instanceof FlowContentDocumentImpl) || ((FlowContentDocumentImpl)flowcontentArr[i]).getStatusId() != 10) continue;
            FlowContext context = new FlowContext(loginUser, flowcontentArr[i]);
            context.setCurrUser(loginUser);
            context.setPostUser(loginUser);
            context.setPostDesc("\u5df2\u53d1\u6587\u6863\uff0c\u5f3a\u5236\u7ec8\u6b62\u5de5\u4f5c\u6d41\u6d41\u8f6c");
            context.setFlowContent(flowcontentArr[i]);
            this.m_oFlowServer.forceEnd(context);
        }
    }
}

