/*
 * Decompiled with CFR 0.152.
 */
package com.trs;

import com.trs.ajaxservice.jsonconvertors.WCMJsonUtil;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.ServerControl;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.TRSConfigServer;
import com.trs.infra.config.domain.ConfigHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.WCMDiscoveryFactory;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.webframework.controler.JSPRequestProcessor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import junit.framework.TestCase;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class TRSWCMBaseTest
extends TestCase {
    private static Logger logger = Logger.getLogger(TRSWCMBaseTest.class);
    private Logger s_logger = Logger.getLogger(TRSWCMBaseTest.class);
    protected User m_oLoginUser = null;
    protected String m_sCurrUserName = "admin";
    public boolean SIGNLE_TEST = true;
    private static ArrayList<String> s_arClassPaths = new ArrayList();
    boolean DEBUG = false;

    public TRSWCMBaseTest(String _sName) {
        super(_sName);
        try {
            this.mySetUp();
        }
        catch (Exception e) {
            logger.error((Object)"\u521d\u59cb\u5316\u6d4b\u8bd5\u7528\u4f8b\u73af\u5883\u51fa\u9519", (Throwable)e);
        }
    }

    public TRSWCMBaseTest() {
        try {
            this.mySetUp();
        }
        catch (Throwable e) {
            logger.error((Object)"\u521d\u59cb\u5316\u6d4b\u8bd5\u7528\u4f8b\u73af\u5883\u51fa\u9519", e);
        }
    }

    protected String createUploadFile(String _sSrcFileName) {
        try {
            File file = new File(_sSrcFileName);
            if (!file.exists() || !file.isFile()) {
                TRSWCMBaseTest.fail((String)("File[" + _sSrcFileName + "] not exists!"));
            }
            return FilesMan.getFilesMan().copyFile(file.getAbsolutePath(), "U0", false);
        }
        catch (Exception e) {
            TRSWCMBaseTest.fail((String)("Copy File[" + _sSrcFileName + "] fail!\n" + CMyException.getStackTraceText(e)));
            return null;
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.SIGNLE_TEST) {
            this.myTearDown();
        }
    }

    public Object doTestMethod(String _sServiceId, String _sMethodName, HashMap<String, Object> _hParameters, boolean _bDBDebug) {
        try {
            this.setDBDebug(_bDBDebug);
            DebugTimer timer = new DebugTimer();
            timer.start();
            JSPRequestProcessor processor = new JSPRequestProcessor();
            Object oResult = processor.excute(_sServiceId, _sMethodName, _hParameters);
            String sJSON = WCMJsonUtil.toJSON(oResult);
            timer.stop();
            System.err.println("use [" + timer.getTime() + "]ms");
            System.err.println("====serviceId=" + _sServiceId + "__sMethodName=" + _sMethodName + "_time:" + timer.getTime() + " ms,result:\n" + sJSON);
            return oResult;
        }
        catch (Exception e) {
            logger.error((Object)("\u6d4b\u8bd5[" + _sServiceId + "_" + _sMethodName + "]\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)e);
            TRSWCMBaseTest.fail((String)("\u6d4b\u8bd5[" + _sServiceId + "_" + _sMethodName + "]\u51fa\u73b0\u5f02\u5e38\uff01\n" + CMyException.getStackTraceText(e)));
            return null;
        }
    }

    protected void setDBDebug(boolean _bDebug) {
        if (!_bDebug) {
            return;
        }
        this.setDebugOfLog4j("com.trs.util.dbcp.impl.ConnectionWrapper");
        this.setDebugOfLog4j("com.trs.util.dbcp.impl.Tracer");
    }

    protected void setDebugOfLog4j(String _sClassName) {
        Logger logger = Logger.getLogger((String)_sClassName);
        if (logger != null) {
            logger.setLevel(Level.toLevel((String)"DEBUG"));
        } else {
            System.err.println("???");
        }
    }

    @Deprecated
    public static String getWCMLibs() {
        Properties sysProperties = System.getProperties();
        String[] pClassPaths = TRSWCMBaseTest.makeClassPath();
        for (int i = 0; i < pClassPaths.length; ++i) {
            String sClassPath = pClassPaths[i];
            File file = new File(sClassPath);
            if (!file.isFile() || sClassPath.indexOf("trswcmv6.jar") < 0) continue;
            return CMyFile.extractFilePath(file.getAbsolutePath());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getClassPaths() {
        Properties sysProperties = System.getProperties();
        if (s_arClassPaths.isEmpty()) {
            ArrayList<String> arrayList = s_arClassPaths;
            synchronized (arrayList) {
                if (!s_arClassPaths.isEmpty()) {
                    return s_arClassPaths;
                }
                ArrayList<String> arTemp = new ArrayList<String>();
                boolean bRunInEclipse = true;
                String[] pClassPaths = null;
                String sClassPathOfProperties = sysProperties.getProperty("java.class.path");
                pClassPaths = sClassPathOfProperties.indexOf(";") >= 0 ? sClassPathOfProperties.split(";") : (sClassPathOfProperties.indexOf(":") >= 0 ? sClassPathOfProperties.split(":") : new String[]{sClassPathOfProperties});
                for (int i = 0; i < pClassPaths.length; ++i) {
                    String sClassPath = pClassPaths[i];
                    File file = new File(sClassPath);
                    if (!file.isDirectory()) continue;
                    sClassPath = file.getAbsolutePath();
                    if (!bRunInEclipse && sClassPath.endsWith(".cp")) {
                        bRunInEclipse = true;
                        continue;
                    }
                    if (!sClassPath.endsWith(File.separator)) {
                        sClassPath = sClassPath + File.separator;
                    }
                    arTemp.add(sClassPath);
                }
                if (!bRunInEclipse) {
                    arTemp = new ArrayList();
                    arTemp.add(TRSConfigServer.getAppRootPath());
                }
                s_arClassPaths = arTemp;
            }
        }
        return s_arClassPaths;
    }

    protected void mySetUp() throws Exception {
        ConfigHelper.RUN_IN_ECLISPE = true;
        String rootPath = System.getProperty("user.dir");
        ArrayList arClassPaths = ConfigHelper.getClassPaths();
        FileStore[] pClassesDirs = new FileService[arClassPaths.size()];
        for (int i = 0; i < pClassesDirs.length; ++i) {
            pClassesDirs[i] = new FileService((String)arClassPaths.get(i));
        }
        String libPath = rootPath + "/target/eshop/WEB-INF/lib";
        FileService fileWCMLib = new FileService(libPath);
        System.out.println("the lib path exists:" + fileWCMLib.exists());
        if (this.DEBUG) {
            logger.error((Object)"Look", (Throwable)new Exception("Who call me!" + Thread.currentThread().getName()));
        }
        FileStore[] pLibDirs = new FileStore[]{fileWCMLib};
        WCMDiscoveryFactory.initDiscovery(pLibDirs, pClassesDirs);
        DebugTimer timer = new DebugTimer();
        timer.start();
        ServerControl control = ServerControl.createInstance();
        control.startup();
        timer.stop();
        System.err.println("\u7cfb\u7edf\u6240\u4f9d\u8d56\u73af\u5883\u8017\u65f6[" + timer.getTime() + "]ms!");
        if (this.DEBUG) {
            logger.error((Object)"Look", (Throwable)new Exception("Who call me!" + Thread.currentThread().getName()));
        }
        this.m_oLoginUser = User.findByName(this.m_sCurrUserName);
        ContextHelper.initContext(this.m_oLoginUser);
    }

    protected void myTearDown() throws Exception {
        ServerControl control = ServerControl.createInstance();
        control.shutdown();
    }

    protected void descTest(String _sTestDesc) {
        this.setName(_sTestDesc);
        this.s_logger.info((Object)_sTestDesc);
    }

    protected Channel getChannelById(int _nChannelId) {
        Channel aChannel = null;
        try {
            aChannel = Channel.findById(_nChannelId);
        }
        catch (Exception ex) {
            this.s_logger.error((Object)"\u6d4b\u8bd5[getChannelById]\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)ex);
            TRSWCMBaseTest.fail((String)"\u6d4b\u8bd5[getChannelById]\u51fa\u73b0\u5f02\u5e38\uff01");
        }
        if (aChannel == null) {
            this.s_logger.error((Object)("[getChannelById]\u6240\u9700\u7684\u6d4b\u8bd5\u6570\u636e\u4e0d\u6b63\u786e\uff01ChannelId:[" + _nChannelId + "]"));
            TRSWCMBaseTest.fail((String)("[getChannelById]\u6240\u9700\u7684\u6d4b\u8bd5\u6570\u636e\u4e0d\u6b63\u786e\uff01ChannelId:[" + _nChannelId + "]"));
        }
        return aChannel;
    }

    protected WebSite findSiteById(int _nSiteId) throws WCMException {
        WebSite currSite = WebSite.findById(_nSiteId);
        if (currSite == null) {
            TRSWCMBaseTest.fail((String)("\u6307\u5b9a\u7684Site[" + currSite + "]\u4e0d\u5b58\u5728\uff01"));
        }
        return currSite;
    }

    protected User findUserById(int _nUserId) throws WCMException {
        User currUser = User.findById(_nUserId);
        if (currUser == null) {
            TRSWCMBaseTest.fail((String)("\u6307\u5b9a\u7684User[" + _nUserId + "]\u4e0d\u5b58\u5728\uff01"));
        }
        return currUser;
    }

    protected Group findGroup(User _user) throws WCMException {
        Groups groups = _user.getGroups();
        Group group = null;
        int nSize = groups.size();
        for (int i = 0; i < nSize && (group = (Group)groups.getAt(i)) == null; ++i) {
        }
        if (group == null) {
            TRSWCMBaseTest.fail((String)("\u7528\u6237[" + _user.getId() + "]\u6ca1\u6709\u6240\u5c5e\u7ec4\u7ec7\uff01"));
        }
        return group;
    }

    @Deprecated
    public static String[] makeClassPath() {
        Properties sysProperties = System.getProperties();
        String[] pClassPaths = null;
        String sClassPathOfProperties = sysProperties.getProperty("java.class.path");
        pClassPaths = sClassPathOfProperties.indexOf(";") >= 0 ? sClassPathOfProperties.split(";") : (sClassPathOfProperties.indexOf(":") >= 0 ? sClassPathOfProperties.split(":") : new String[]{sClassPathOfProperties});
        return pClassPaths;
    }

    protected String uploadFile(String _FileName, String _sFileFalg) throws CMyException {
        String filePathName = TRSWCMBaseTest.getDataFilePath(_FileName);
        FilesMan aFilesMan = FilesMan.getFilesMan();
        String sSaveFile = aFilesMan.getNextFilePathName(_sFileFalg, CMyFile.extractFileExt(filePathName));
        CMyFile.copyFile(filePathName, sSaveFile);
        String sUploadName = CMyFile.extractFileName(sSaveFile);
        return sUploadName;
    }

    private static String getDataFilePath(String _FileName) {
        return System.getProperty("user.dir") + File.separator + "Data4Tester" + File.separator + _FileName;
    }

    public String buildJsonByUploadFiles(String ... _FileNames) {
        try {
            return this.buildJsonByUploadFiles("U0", _FileNames);
        }
        catch (Exception e) {
            logger.error((Object)"Fail to upload file", (Throwable)e);
            TRSWCMBaseTest.fail((String)"Fail to upload file");
            return null;
        }
    }

    public String buildJsonByUploadFilesUseST(String ... _FileNames) throws CMyException {
        return this.buildJsonByUploadFiles("ST", _FileNames);
    }

    private String buildJsonByUploadFiles(String _FileFlag, String ... _FileNames) throws CMyException {
        JSONArray imgArray = new JSONArray();
        for (int i = 0; i < _FileNames.length; ++i) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"APPFILE", (Object)this.uploadFile(_FileNames[i], _FileFlag));
            obj.put((Object)"APPDESC", (Object)("\u6d4b\u8bd5\u6587\u4ef6(" + i + ")"));
            obj.put((Object)"AppendixId", (Object)"0");
            imgArray.add((Object)obj);
        }
        return imgArray.toString();
    }
}

