/*
 * Decompiled with CFR 0.152.
 */
package com.trs.jdbc.broker.access;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;

public class BrokerProcess {
    private Process m_objSubProcess;
    private int m_iExitCode;
    private BufferedReader m_oStdoutReader;
    private BufferedReader m_oStderrReader;
    private PrintWriter m_oStdinWriter;
    private String m_sVersionInfo;
    private String m_sQuerySummary;
    private String m_sErrorMessage;
    private boolean[] m_zSetParameter;
    private String[] m_sAllParameter = new String[14];
    private boolean m_zInteractMode;
    private boolean m_zCursorMode;
    private boolean m_zISO_8859_1;

    public BrokerProcess() {
        this.m_zSetParameter = new boolean[14];
        String encoding = System.getProperty("file.encoding");
        this.m_zISO_8859_1 = encoding.indexOf("ISO-8859-1") >= 0 || encoding.indexOf("ISO8859-1") >= 0;
    }

    public void startup() throws IOException {
        if (!this.isClosed()) {
            return;
        }
        ArrayList<String> al = new ArrayList<String>(16);
        int i = 1;
        while (i < this.m_sAllParameter.length) {
            if (this.m_sAllParameter[i] != null) {
                al.add(this.commandLine2Local(this.m_sAllParameter[i]));
            }
            ++i;
        }
        String[] ca = new String[al.size()];
        al.toArray(ca);
        this.m_objSubProcess = Runtime.getRuntime().exec(ca, null, null);
        InputStreamReader reader = null;
        OutputStreamWriter writer = null;
        try {
            reader = new InputStreamReader(this.m_objSubProcess.getErrorStream(), "GBK");
            this.m_oStderrReader = new BufferedReader(reader);
            reader = new InputStreamReader(this.m_objSubProcess.getInputStream(), "GBK");
            this.m_oStdoutReader = new BufferedReader(reader);
            writer = new OutputStreamWriter(this.m_objSubProcess.getOutputStream(), "GBK");
            this.m_oStdinWriter = new PrintWriter(writer);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.m_sVersionInfo = this.getNextElement();
    }

    public void cleanup() {
        if (this.m_zInteractMode) {
            if (this.isClosed()) {
                return;
            }
            this.sendCloseProcessCommand();
        }
        this.m_objSubProcess = null;
    }

    public boolean isClosed() {
        if (this.m_objSubProcess == null) {
            return true;
        }
        try {
            this.m_iExitCode = this.m_objSubProcess.exitValue();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void newQuery() throws SQLException {
        if (!this.m_zInteractMode) {
            try {
                this.startup();
                this.m_sQuerySummary = this.getNextElement();
                if (this.m_sQuerySummary == null) {
                    throw new SQLException(this.getErrorMessage());
                }
            }
            catch (IOException e) {
                throw new SQLException(e.toString());
            }
        }
    }

    public void moveCursor() {
        if (!this.m_zInteractMode) {
            try {
                this.startup();
                this.m_sQuerySummary = this.getNextElement();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void closeCursor() {
    }

    public int getExitCode() {
        return this.m_iExitCode;
    }

    public String getErrorMessage() {
        return this.m_sErrorMessage;
    }

    private void getErrorMessage0() {
        this.isClosed();
        CharArrayWriter buffer = new CharArrayWriter(4096);
        try {
            String sLine;
            PrintWriter writer = new PrintWriter(buffer);
            while ((sLine = this.m_oStderrReader.readLine()) != null && !sLine.equals("`")) {
                writer.println(sLine);
            }
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_sErrorMessage = buffer.toString();
    }

    public String getVersionInfo() {
        return this.m_sVersionInfo;
    }

    public String getQuerySummary() {
        return this.m_sQuerySummary;
    }

    public String getNextElement() throws IOException {
        CharArrayWriter buffer = new CharArrayWriter(4096);
        PrintWriter writer = new PrintWriter(buffer);
        while (true) {
            String sLine;
            if ((sLine = this.m_oStdoutReader.readLine()) == null) {
                this.getErrorMessage0();
                return null;
            }
            if (sLine.equals("`")) break;
            if (buffer.size() > 0) {
                writer.println();
            }
            writer.print(sLine);
        }
        writer.close();
        return buffer.toString();
    }

    public boolean getInteractMode() {
        return this.m_zInteractMode;
    }

    public void setInteractMode(boolean interactMode) {
        this.m_zInteractMode = interactMode;
    }

    public String getParameter(int i) {
        return this.m_sAllParameter[i];
    }

    public void setParameter(int i, Object obj) {
        switch (i) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.m_sAllParameter[i] = obj.toString();
                break;
            }
            case 6: {
                this.m_zInteractMode = Boolean.valueOf(obj.toString());
                if (this.m_zInteractMode) {
                    this.m_sAllParameter[i] = "-i";
                    break;
                }
                this.m_sAllParameter[i] = null;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.m_sAllParameter[i] = obj.toString();
                break;
            }
            case 11: {
                this.m_zCursorMode = Boolean.valueOf(obj.toString());
                if (this.m_zCursorMode) {
                    this.m_sAllParameter[i] = "-1";
                    break;
                }
                this.m_sAllParameter[i] = null;
                break;
            }
            case 12: 
            case 13: {
                this.m_sAllParameter[i] = obj.toString();
                break;
            }
            default: {
                StringBuffer sb = new StringBuffer(64);
                sb.append("Index: ");
                sb.append(i);
                sb.append(" out of range: ");
                sb.append(6);
                sb.append('-');
                sb.append(13);
                throw new IndexOutOfBoundsException(sb.toString());
            }
        }
        this.m_zSetParameter[i] = true;
    }

    public void clearParameters() {
        int i = this.m_sAllParameter.length - 1;
        while (i >= 0) {
            this.m_sAllParameter[i] = null;
            --i;
        }
    }

    private String commandLine2Local(String s) {
        if (this.m_zISO_8859_1) {
            try {
                return new String(s.getBytes("GBK"), "ISO8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s;
    }

    private void sendCloseProcessCommand() {
        if (!this.m_zInteractMode) {
            return;
        }
        this.m_oStdinWriter.println("close");
    }
}

