/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server.http;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.ConfigurableService;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.ServerUtils;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.util.IOUtils;
import org.apache.soap.util.MethodUtils;

public class ServerHTTPUtils {
    private static final String SERVICE_MANAGER_ID = "serviceManager";
    private static final String SCRIPT_CLASS = "com.ibm.bsf.BSFManager";
    private static final String SCRIPT_INVOKER = "org.apache.soap.server.InvokeBSF";
    private static final String SERVLET_CLASSLOADER = "servletClassLoader";
    static /* synthetic */ Class class$org$apache$soap$server$DeploymentDescriptor;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceManager getServiceManagerFromContext(ServletContext context, String configFilename) {
        Object o;
        if (context != null) {
            ServletContext servletContext = context;
            synchronized (servletContext) {
                o = context.getAttribute(SERVICE_MANAGER_ID);
                if (o == null) {
                    o = new ServiceManager(context, configFilename);
                    context.setAttribute(SERVICE_MANAGER_ID, o);
                }
            }
        } else {
            o = new ServiceManager(null, configFilename);
        }
        return o;
    }

    public static ServiceManager getServiceManagerFromContext(ServletContext context) {
        return ServerHTTPUtils.getServiceManagerFromContext(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getServletClassLoaderFromContext(ServletContext context) {
        if (context != null) {
            Object o;
            ServletContext servletContext = context;
            synchronized (servletContext) {
                o = context.getAttribute(SERVLET_CLASSLOADER);
            }
            return (ClassLoader)o;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setServletClassLoaderIntoContext(ServletContext context, ClassLoader cl) {
        ServletContext servletContext = context;
        synchronized (servletContext) {
            context.setAttribute(SERVLET_CLASSLOADER, (Object)cl);
        }
    }

    public static File getFileFromNameAndContext(String fileName, ServletContext context) {
        String realFileName;
        File file = new File(fileName);
        if (!file.isAbsolute() && context != null && (realFileName = context.getRealPath(fileName)) != null) {
            file = new File(realFileName);
        }
        return file;
    }

    public static Envelope readEnvelopeFromRequest(DocumentBuilder xdb, String contentType, int contentLength, InputStream requestStream, EnvelopeEditor editor, HttpServletResponse res, SOAPContext ctx) throws SOAPException, IOException {
        return ServerHTTPUtils.readEnvelopeFromRequest(xdb, contentType, contentLength, requestStream, editor, res, ctx, null);
    }

    public static Envelope readEnvelopeFromRequest(DocumentBuilder xdb, String contentType, int contentLength, InputStream requestStream, EnvelopeEditor editor, HttpServletResponse res, SOAPContext ctx, Hashtable headers) throws SOAPException, IOException {
        try {
            return ServerUtils.readEnvelopeFromInputStream(xdb, requestStream, contentLength, contentType, editor, ctx, headers);
        }
        catch (IllegalArgumentException e) {
            String msg = e.getMessage();
            res.sendError(400, "Error unmarshalling envelope: " + msg);
            return null;
        }
        catch (MessagingException me) {
            res.sendError(400, "Error unmarshalling envelope: " + (Object)((Object)me));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getTargetObject(ServiceManager serviceManager, DeploymentDescriptor dd, String targetID, HttpServlet thisServlet, HttpSession session, SOAPContext ctxt, ServletContext context) throws SOAPException {
        int scope = dd.getScope();
        byte providerType = dd.getProviderType();
        Object targetObject = null;
        String className = providerType == 0 || providerType == 3 ? dd.getProviderClass() : SCRIPT_CLASS;
        Object scopeLock = null;
        if (scope == 0) {
            scopeLock = thisServlet;
        } else if (scope == 1) {
            scopeLock = session;
        } else if (scope == 2) {
            try {
                scopeLock = ctxt.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                String msg = providerType == 0 || providerType == 3 ? "Unable to resolve target object at application scope: " + e.getMessage() : "Unable to load BSF at application scope: script services not available without BSF: " + e.getMessage();
                throw new SOAPException(Constants.FAULT_CODE_SERVER_BAD_TARGET_OBJECT_URI, msg, e);
            }
        } else {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Service uses deprecated object scope 'page': inform provider of error");
        }
        boolean freshObject = false;
        if (targetID.equals("urn:xml-soap-service-management-service")) {
            targetObject = serviceManager;
        } else {
            if (scopeLock == null) {
                scopeLock = className;
            }
            Object msg = scopeLock;
            synchronized (msg) {
                targetObject = scope == 1 ? session.getValue(targetID) : (scope == 2 ? context.getAttribute(targetID) : null);
                if (targetObject == null) {
                    try {
                        Class c = ctxt.loadClass(className);
                        if (dd.getIsStatic()) {
                            targetObject = c;
                        } else {
                            targetObject = c.newInstance();
                            if (targetObject instanceof ConfigurableService) {
                                ConfigurableService configurableTarget = (ConfigurableService)targetObject;
                                try {
                                    configurableTarget.configure(ServerHTTPUtils.getServiceParameters(dd), ServerHTTPUtils.getServletParameters(thisServlet), ServerHTTPUtils.getContextParameters(context));
                                }
                                catch (Exception e) {
                                    throw new SOAPException(Constants.FAULT_CODE_SERVER, "Unable to initialize target object: " + e.getMessage(), e);
                                }
                            }
                        }
                        freshObject = true;
                        if (scope == 1) {
                            session.putValue(targetID, targetObject);
                        } else if (scope == 2) {
                            context.setAttribute(targetID, targetObject);
                        }
                    }
                    catch (Exception e) {
                        String msg2 = providerType == 0 || providerType == 3 ? "Unable to resolve target object: " + e.getMessage() : "Unable to load BSF: script services not available without BSF: " + e.getMessage();
                        throw new SOAPException(Constants.FAULT_CODE_SERVER_BAD_TARGET_OBJECT_URI, msg2, e);
                    }
                }
            }
        }
        if (providerType != 0 && providerType != 3 && freshObject) {
            Class bc = null;
            try {
                bc = ctxt.loadClass(SCRIPT_INVOKER);
            }
            catch (Exception e) {
                String msg = "Unable to load BSF invoker (org.apache.soap.server.InvokeBSF): script services not available without BSF: " + e.getMessage();
                throw new SOAPException(Constants.FAULT_CODE_SERVER, msg, e);
            }
            String script = dd.getScriptFilenameOrString();
            if (providerType == 1) {
                String fileName = context.getRealPath(script);
                try {
                    script = IOUtils.getStringFromReader(new FileReader(fileName));
                }
                catch (Exception e) {
                    String msg = "Unable to load script file (" + fileName + ")" + ": " + e.getMessage();
                    throw new SOAPException(Constants.FAULT_CODE_SERVER, msg, e);
                }
            }
            Class[] sig = new Class[]{class$org$apache$soap$server$DeploymentDescriptor == null ? (class$org$apache$soap$server$DeploymentDescriptor = ServerHTTPUtils.class$("org.apache.soap.server.DeploymentDescriptor")) : class$org$apache$soap$server$DeploymentDescriptor, class$java$lang$Object == null ? (class$java$lang$Object = ServerHTTPUtils.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$String == null ? (class$java$lang$String = ServerHTTPUtils.class$("java.lang.String")) : class$java$lang$String};
            try {
                Method m = MethodUtils.getMethod(bc, "init", sig, true);
                m.invoke(null, dd, targetObject, script);
            }
            catch (InvocationTargetException ite) {
                Throwable te = ite.getTargetException();
                if (te instanceof SOAPException) {
                    throw (SOAPException)te;
                }
                String msg = "Unable to invoke init method of script invoker: " + te;
                throw new SOAPException(Constants.FAULT_CODE_SERVER, msg, te);
            }
            catch (Exception e) {
                String msg = "Unable to invoke init method of script invoker: " + e;
                throw new SOAPException(Constants.FAULT_CODE_SERVER, msg, e);
            }
        }
        return targetObject;
    }

    private static Hashtable getContextParameters(ServletContext context) {
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        Enumeration names = context.getInitParameterNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                String value = context.getInitParameter(key);
                parameters.put(key, value);
            }
        }
        return parameters;
    }

    private static Hashtable getServletParameters(HttpServlet servlet) {
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        ServletConfig config = servlet.getServletConfig();
        Enumeration names = config.getInitParameterNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                String value = config.getInitParameter(key);
                parameters.put(key, value);
            }
        }
        return parameters;
    }

    private static Hashtable getServiceParameters(DeploymentDescriptor dd) {
        Hashtable props = dd.getProps();
        return props != null ? (Hashtable)props.clone() : null;
    }

    public static boolean isUserAuthorized(DeploymentDescriptor dd, HttpServletRequest req, HttpServletResponse res) throws IOException, SOAPException {
        String roles;
        Hashtable props = dd.getProps();
        String string = roles = props != null ? (String)props.get("roles") : null;
        if (roles == null) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(roles, ",");
        while (st.hasMoreTokens()) {
            if (!req.isUserInRole(st.nextToken())) continue;
            return true;
        }
        if (req.getRemoteUser() == null && req.getUserPrincipal() == null) {
            res.setHeader("WWW-Authenticate", "Basic realm=\"Apache SOAP\"");
            res.setContentType("text/html");
            res.sendError(401, "Unauthorized");
            return false;
        }
        throw new SOAPException(Constants.FAULT_CODE_SERVER, "Not authorized for this SOAP service.");
    }

    public static Hashtable getHeaders(HttpServletRequest req) {
        Enumeration e = req.getHeaderNames();
        Hashtable<String, String> headers = new Hashtable<String, String>(20);
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = req.getHeader(name);
            headers.put(name, value);
        }
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SOAPMappingRegistry getSMRFromContext(ServletContext context) {
        SOAPMappingRegistry smr = null;
        ServletContext servletContext = context;
        synchronized (servletContext) {
            smr = (SOAPMappingRegistry)context.getAttribute("__cached_servlet_SMR__");
            if (smr == null) {
                smr = new SOAPMappingRegistry();
                context.setAttribute("__cached_servlet_SMR__", (Object)smr);
            }
        }
        return smr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

