/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.ScopableResolver;
import org.exolab.castor.xml.schema.Wildcard;

class ContentModelGroupImpl
implements ContentModelGroup,
Serializable {
    private Vector _contentModel = new Vector();
    private transient ScopableResolver _resolver = new ScopableResolver();

    public void addWildcard(Wildcard wildcard) throws SchemaException {
        if (wildcard.isAttributeWildcard()) {
            throw new SchemaException("only <any> should be add in a group.");
        }
        this._contentModel.addElement(wildcard);
    }

    public void addElementDecl(ElementDecl elementDecl) throws SchemaException {
        if (elementDecl == null) {
            return;
        }
        String name = elementDecl.getName();
        if (!elementDecl.isReference()) {
            String key = "element:" + name;
            if (this._resolver.resolve(key) != null) {
                String err = "An element declaration with the given name, ";
                err = err + name + ", already exists in this scope.";
                throw new SchemaException(err);
            }
            this._resolver.addResolvable(key, elementDecl);
        }
        this._contentModel.addElement(elementDecl);
    }

    public boolean removeElementDecl(ElementDecl elementDecl) {
        if (elementDecl == null) {
            return false;
        }
        int position = this._contentModel.indexOf(elementDecl);
        if (position >= 0) {
            this._contentModel.removeElementAt(position);
            if (!elementDecl.isReference()) {
                String key = "element:" + elementDecl.getName();
                this._resolver.removeResolvable(key);
            }
            return true;
        }
        return false;
    }

    public void addGroup(Group group) throws SchemaException {
        if (group == null) {
            return;
        }
        String name = group.getName();
        if (name != null) {
            String key = "group:" + name;
            if (this._resolver.resolve(key) != null) {
                String err = "A group definition with the given name, ";
                err = err + name + ", already exists in this scope.";
                throw new SchemaException(err);
            }
            this._resolver.addResolvable(key, group);
        }
        this._contentModel.addElement(group);
    }

    public boolean removeGroup(Group group) {
        if (group == null) {
            return false;
        }
        int position = this._contentModel.indexOf(group);
        if (position >= 0) {
            String name = group.getName();
            if (name != null) {
                String key = "group:" + name;
                this._resolver.removeResolvable(key);
            }
            this._contentModel.removeElementAt(position);
            return true;
        }
        return false;
    }

    public void addGroup(ModelGroup group) throws SchemaException {
        if (group == null) {
            return;
        }
        String name = group.getName();
        if (name != null && !group.isReference()) {
            String key = "group:" + name;
            if (this._resolver.resolve(key) != null) {
                String err = "An element declaration with the given name, ";
                err = err + name + ", already exists in this scope.";
                throw new SchemaException(err);
            }
            this._resolver.addResolvable(key, group);
        }
        this._contentModel.addElement(group);
    }

    public boolean removeGroup(ModelGroup group) {
        if (group == null) {
            return false;
        }
        int position = this._contentModel.indexOf(group);
        if (position >= 0) {
            String name = group.getName();
            if (name != null && !group.isReference()) {
                String key = "group:" + name;
                this._resolver.removeResolvable(key);
            }
            this._contentModel.removeElementAt(position);
            return true;
        }
        return false;
    }

    public boolean removeWildcard(Wildcard wildcard) {
        if (wildcard == null) {
            return false;
        }
        int position = this._contentModel.indexOf(wildcard);
        if (position >= 0) {
            this._contentModel.removeElementAt(position);
            return true;
        }
        return false;
    }

    public Enumeration enumerate() {
        return this._contentModel.elements();
    }

    public ElementDecl getElementDecl(String name) {
        String key;
        if (name == null) {
            return null;
        }
        ElementDecl result = null;
        if (this._resolver != null && (result = (ElementDecl)this._resolver.resolve(key = "element:" + name)) != null) {
            return result;
        }
        for (int i = 0; i < this._contentModel.size(); ++i) {
            Particle p = (Particle)this._contentModel.elementAt(i);
            switch (p.getStructureType()) {
                case 8: {
                    ElementDecl e = (ElementDecl)p;
                    if (!name.equals(e.getName())) break;
                    result = e;
                    break;
                }
                case 10: 
                case 16: {
                    result = ((ContentModelGroup)((Object)p)).getElementDecl(name);
                    break;
                }
            }
            if (result != null) break;
        }
        return result;
    }

    public int getMaxOccurs() {
        return 1;
    }

    public int getMinOccurs() {
        return 1;
    }

    public Particle getParticle(int index) {
        return (Particle)this._contentModel.elementAt(index);
    }

    public int getParticleCount() {
        return this._contentModel.size();
    }
}

