/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.util.Vector;
import org.exolab.castor.builder.FieldInfo;
import org.exolab.castor.builder.GroupInfo;
import org.exolab.castor.builder.XMLInfo;
import org.exolab.javasource.JClass;

public class ClassInfo
extends XMLInfo {
    private Vector _atts = null;
    private Vector _elements = null;
    private FieldInfo _textField = null;
    private ClassInfo _baseClass = null;
    private JClass _class = null;
    private GroupInfo _groupInfo = null;
    private boolean _isContainer = false;
    private boolean _abstract = false;

    public ClassInfo(JClass jClass) {
        super((short)1);
        if (jClass == null) {
            String err = "JClass passed to constructor of ClassInfo must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._class = jClass;
        this._groupInfo = new GroupInfo();
    }

    public void addFieldInfo(FieldInfo fieldInfo) {
        if (fieldInfo == null) {
            return;
        }
        switch (fieldInfo.getNodeType()) {
            case 0: {
                if (this._atts == null) {
                    this._atts = new Vector(3);
                }
                if (this._atts.contains(fieldInfo)) break;
                this._atts.addElement(fieldInfo);
                break;
            }
            case 2: {
                this._textField = fieldInfo;
                break;
            }
            default: {
                if (this._elements == null) {
                    this._elements = new Vector(5);
                }
                if (this._elements.contains(fieldInfo)) break;
                this._elements.addElement(fieldInfo);
            }
        }
    }

    public void addFieldInfo(FieldInfo[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            this.addFieldInfo(fields[i]);
        }
    }

    public boolean allowContent() {
        return this._textField != null;
    }

    public boolean contains(FieldInfo fieldInfo) {
        boolean val = false;
        if (fieldInfo == null) {
            return false;
        }
        switch (fieldInfo.getNodeType()) {
            case 0: {
                if (this._atts == null) break;
                return this._atts.contains(fieldInfo);
            }
            case 2: {
                return fieldInfo == this._textField;
            }
            default: {
                if (this._elements == null) break;
                return this._elements.contains(fieldInfo);
            }
        }
        return false;
    }

    public FieldInfo[] getAttributeFields() {
        Object[] fields = null;
        if (this._atts != null) {
            fields = new FieldInfo[this._atts.size()];
            this._atts.copyInto(fields);
        } else {
            fields = new FieldInfo[]{};
        }
        return fields;
    }

    public FieldInfo getAttributeField(String nodeName) {
        if (this._atts != null) {
            for (int i = 0; i < this._atts.size(); ++i) {
                FieldInfo temp = (FieldInfo)this._atts.get(i);
                if (!temp.getNodeName().equals(nodeName)) continue;
                return temp;
            }
        }
        return null;
    }

    public ClassInfo getBaseClass() {
        return this._baseClass;
    }

    public FieldInfo[] getElementFields() {
        Object[] members = null;
        if (this._elements != null) {
            members = new FieldInfo[this._elements.size()];
            this._elements.copyInto(members);
        } else {
            members = new FieldInfo[]{};
        }
        return members;
    }

    public FieldInfo getElementField(String nodeName) {
        if (this._elements != null) {
            for (int i = 0; i < this._elements.size(); ++i) {
                FieldInfo temp = (FieldInfo)this._elements.get(i);
                String elementNodeName = temp.getNodeName();
                if (elementNodeName == null || !elementNodeName.equals(nodeName)) continue;
                return temp;
            }
        }
        return null;
    }

    public int getFieldCount() {
        int count = 0;
        if (this._atts != null) {
            count += this._atts.size();
        }
        if (this._elements != null) {
            count += this._elements.size();
        }
        if (this._textField != null) {
            ++count;
        }
        return count;
    }

    public GroupInfo getGroupInfo() {
        return this._groupInfo;
    }

    public JClass getJClass() {
        return this._class;
    }

    public FieldInfo getTextField() {
        return this._textField;
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public boolean isChoice() {
        return this._groupInfo.isChoice();
    }

    public boolean isContainer() {
        return this._isContainer;
    }

    public boolean isSequence() {
        return this._groupInfo.isSequence();
    }

    public void setAbstract(boolean abstractClass) {
        this._abstract = abstractClass;
    }

    public void setBaseClass(ClassInfo base) {
        this._baseClass = base;
    }

    public void setContainer(boolean isContainer) {
        this._isContainer = isContainer;
    }
}

