/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.tools.JSLocaleProperties;
import java.io.File;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class JSLocaleCollector {
    private static Logger logger = Logger.getLogger(JSLocaleCollector.class);
    private Pattern m_scriptRegExp = Pattern.compile("(?is)<script[^>]*>(.*?)</script>");
    private Pattern m_chineseJSRegExp = Pattern.compile("(?im)('|\")((?:[^'\"\\n\\\\]|\\\\'|\\\\\"|\\\\)*[\\u4e00-\\u9fbb]+(?:[^'\"\\n\\\\]|\\\\'|\\\\\"|\\\\)*)\\1");
    private Pattern m_tagInChineseRegExp = Pattern.compile("(?im)[\\u4e00-\\u9fbb]+.*[<>].*[\\u4e00-\\u9fbb]+");
    private Pattern m_noTagInChineseRegExp = Pattern.compile("[^<>]*[\\u4e00-\\u9fbb]+[^<>]*");
    private String m_sRootPath;
    private String[] m_aAcceptFileExt = new String[]{".jsp", ".html", ".htm", ".js"};
    private Map m_mapResult = new TreeMap(new Comparator(){

        public int compare(Object o1, Object o2) {
            String pair1 = (String)o1;
            String pair2 = (String)o2;
            return pair1.compareTo(pair2);
        }
    });
    private String m_sOutputFile;

    public JSLocaleCollector(String sRootPath, String sOutputFile) {
        this.m_sRootPath = CMyString.setStrEndWith(sRootPath, File.separatorChar);
        this.m_sOutputFile = sOutputFile;
    }

    public static void main(String[] args) throws CMyException {
        if (args.length < 2) {
            StringBuffer sbInfo = new StringBuffer(200);
            sbInfo.append("\u6307\u5b9a\u7684\u53c2\u6570\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u9700\u8981\u4e24\u4e2a\u53c2\u6570\n");
            sbInfo.append("\u7b2c\u4e00\u4e2a\u53c2\u6570\u6307\u5b9a\u9700\u8981\u5904\u7406\u7684\u76ee\u5f55\uff1a\n");
            sbInfo.append("\t\t\u5982\uff1a\n");
            sbInfo.append("E:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/WebApp/app");
            sbInfo.append("\n\u7b2c\u4e8c\u4e2a\u53c2\u6570\u6307\u5b9a\u751f\u6210\u7684\u8d44\u6e90\u6587\u4ef6\u5168\u8def\u5f84\uff1a\n");
            sbInfo.append("\t\t\u5982\uff1a\n");
            sbInfo.append("E:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/Java/configfiles/wcm6-locale/js_en_tmp.properties");
            logger.error((Object)sbInfo);
            return;
        }
        JSLocaleCollector instance = new JSLocaleCollector(args[0], args[1]);
        instance.analyze();
    }

    public Map analyze() throws CMyException {
        FileService root = new FileService(this.m_sRootPath);
        this.analyzeDir(root);
        JSLocaleProperties.store(this.m_sOutputFile, this.m_mapResult);
        return this.m_mapResult;
    }

    private void analyzeDir(FileStore oFile) throws CMyException {
        if (!this.isAccept(oFile)) {
            return;
        }
        if (oFile.isFile()) {
            this.analyzeFile(oFile);
            return;
        }
        FileStore[] aFiles = oFile.listFiles();
        for (int i = 0; i < aFiles.length; ++i) {
            this.analyzeDir(aFiles[i]);
        }
    }

    private boolean isAccept(FileStore oFile) {
        int i;
        String sFileName = oFile.getName();
        if (oFile.isDirectory()) {
            String[] excludeFolders = new String[]{".svn", "CVS", "editor", "runtime"};
            for (int i2 = 0; i2 < excludeFolders.length; ++i2) {
                if (!sFileName.endsWith(excludeFolders[i2])) continue;
                return false;
            }
            return true;
        }
        String[] excludeFiles = new String[]{"_cn.js", "_en.js", "jquery"};
        for (i = 0; i < excludeFiles.length; ++i) {
            if (sFileName.indexOf(excludeFiles[i]) < 0) continue;
            return false;
        }
        for (i = 0; i < this.m_aAcceptFileExt.length; ++i) {
            if (!sFileName.endsWith(this.m_aAcceptFileExt[i])) continue;
            return true;
        }
        return false;
    }

    private void analyzeFile(FileStore oFile) throws CMyException {
        String sFullFileName = oFile.getAbsolutePath();
        String sEncoding = CharsetDetector.detect(sFullFileName);
        String sContent = CMyFile.readFile(sFullFileName, sEncoding);
        logger.info((Object)("\u5f00\u59cb\u5206\u6790\u6587\u4ef6\uff1a" + sFullFileName));
        if (sFullFileName.endsWith(".js")) {
            this.analyzeContent(sContent);
        } else {
            Matcher matcher = this.m_scriptRegExp.matcher(sContent);
            while (matcher.find()) {
                String sJSCode = matcher.group(1);
                if (sJSCode.length() <= 0) continue;
                this.analyzeContent(sJSCode);
            }
        }
    }

    private void analyzeContent(String sContent) {
        Matcher matcher = this.m_chineseJSRegExp.matcher(sContent);
        while (matcher.find()) {
            String sChinese = matcher.group(2);
            if (this.m_mapResult.get(sChinese = this.getOptimizeKey(sChinese)) != null || this.isInComment(sContent, matcher.start(), matcher.end())) continue;
            this.m_mapResult.put(sChinese, "");
        }
    }

    private String getOptimizeKey(String sChineseKey) {
        Matcher matcher = this.m_tagInChineseRegExp.matcher(sChineseKey);
        if (matcher.find()) {
            return sChineseKey;
        }
        matcher = this.m_noTagInChineseRegExp.matcher(sChineseKey);
        if (matcher.find()) {
            String sNewKey = matcher.group();
            if (!matcher.find()) {
                return sNewKey;
            }
        }
        return sChineseKey;
    }

    private boolean isInComment(String sContent, int nStartIndex, int nEndIndex) {
        int nSP2;
        int nEnterStartPos;
        int nCommentStartPos = sContent.lastIndexOf("//", nStartIndex);
        if (nCommentStartPos > (nEnterStartPos = sContent.lastIndexOf(10, nStartIndex))) {
            return true;
        }
        int nSP1 = sContent.lastIndexOf("/*", nStartIndex);
        if (nSP1 < 0) {
            return false;
        }
        if (nSP1 != 0) {
            while (sContent.charAt(nSP1 - 1) == '/') {
                if ((nSP1 = sContent.lastIndexOf("/*", nSP1 - 1)) != -1) continue;
                return false;
            }
        }
        return nSP1 > (nSP2 = sContent.lastIndexOf("*/", nStartIndex));
    }
}

