/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.infoview.db.InfoviewXMLDataUpdator;
import com.trs.components.wcm.content.WCMDocumentHelper;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class AppendixMgr {
    private static Logger s_oLogger = Logger.getLogger((String)AppendixMgr.class.getName());

    public void saveAppendixes(Document _currDocument, List<CMSObj> _currAppendixList) throws WCMException {
        this.saveAppendixes(_currDocument, _currAppendixList, -1);
    }

    public void saveAppendixes(Document _currDocument, List<CMSObj> _currAppendixList, int _nAppendixFlag) throws WCMException {
        int i;
        if (_currAppendixList == null) {
            return;
        }
        if (_currDocument == null) {
            throw new WCMException(10, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label1", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5904\u7406\u9644\u4ef6\uff01"));
        }
        Appendixes delAppendixes = this.getUnusedAppendixes(_currDocument, _currAppendixList, _nAppendixFlag);
        for (i = 0; i < delAppendixes.size(); ++i) {
            this.deleteAppendixFromDocument(_currDocument, (Appendix)delAppendixes.getAt(i));
        }
        for (i = 0; i < _currAppendixList.size(); ++i) {
            this.saveAppendix(_currDocument, (Appendix)_currAppendixList.get(i), _nAppendixFlag);
        }
    }

    public void removeAppendices(Document document, String oldAppendixIds) throws WCMException {
        Appendixes delAppendixes = this.getAppendixesByIds(oldAppendixIds);
        for (int i = 0; i < delAppendixes.size(); ++i) {
            this.deleteAppendixFromDocument(document, (Appendix)delAppendixes.getAt(i));
        }
    }

    public Appendixes getAppendixesByIds(String oldAppendixIds) throws WCMException {
        if (CMyString.isEmpty(oldAppendixIds)) {
            return Appendixes.createNewInstance(ContextHelper.getLoginUser());
        }
        User loginUser = ContextHelper.getLoginUser();
        WCMFilter filter = new WCMFilter();
        String[] tempIds = oldAppendixIds.split(",");
        if (tempIds.length > 0) {
            StringBuilder whereSQL = new StringBuilder();
            for (int i = 0; i < tempIds.length; ++i) {
                whereSQL.append("?,");
                filter.addSearchValues(tempIds[i]);
            }
            filter.setWhere("APPENDIXID in (" + whereSQL.substring(0, whereSQL.length() - 1) + ")");
            filter.setOrder("APPSERN asc");
        }
        return Appendixes.openWCMObjs(loginUser, filter);
    }

    public void saveAppendix(Document _currDocument, Appendix currAppendix, int _nAppendixFlag) throws WCMException {
        if (currAppendix == null) {
            throw new WCMException(20, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label2", "\u9644\u4ef6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        if (currAppendix.isAddMode()) {
            currAppendix.setFlag(_nAppendixFlag);
            this.addAppendix(_currDocument, currAppendix);
        } else {
            this.editAppendix(_currDocument, currAppendix);
        }
    }

    void saveAppendix(Document _currDocument, Appendix _currAppendix) throws WCMException {
        if (_currAppendix == null) {
            throw new WCMException(20, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label2", "\u9644\u4ef6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        if (_currAppendix.isAddMode()) {
            this.addAppendix(_currDocument, _currAppendix);
        } else {
            this.editAppendix(_currDocument, _currAppendix);
        }
    }

    public void addAppendix(Document _currDocument, Appendix _currAppendix) throws WCMException {
        if (_currDocument.getId() == 0) {
            throw new WCMException(10, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label3", "\u6587\u6863ID\u4e3a0\uff0c\u65e0\u6cd5\u6dfb\u52a0\u9644\u4ef6\uff01"));
        }
        _currAppendix.setDocId(_currDocument.getId());
        String sNewFileName = _currAppendix.getFile();
        if (sNewFileName == null) {
            s_oLogger.debug((Object)I18NMessage.get(AppendixMgr.class, "AppendixMgr.label4", "\u4fdd\u5b58\u9644\u4ef6\u65f6\uff0c\u9047\u5230\u65e0\u6548\u7684\u9644\u4ef6\u6587\u4ef6\uff0c\u8df3\u8fc7\u8be5\u9644\u4ef6"));
            return;
        }
        int nApdFlag = _currAppendix.getFlag();
        s_oLogger.debug((Object)sNewFileName);
        if (nApdFlag != 40 && sNewFileName.indexOf(47) < 0) {
            sNewFileName = this.moveAppendixFile(sNewFileName, 10 == nApdFlag);
            _currAppendix.setFileExt(CMyFile.extractFileExt(sNewFileName));
            _currAppendix.setFile(CMyFile.extractFileName(sNewFileName));
        }
        _currAppendix.setUsedByVersion(_currDocument.getVersion(), true);
        _currAppendix.insert(ContextHelper.getLoginUser());
    }

    public void editAppendix(Document _currDocument, Appendix _currAppendix) throws WCMException {
        if (!_currAppendix.canEdit(ContextHelper.getLoginUser())) {
            throw new WCMException(1013, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label5", "\u9644\u4ef6\u5bf9\u8c61\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        if (_currAppendix.getDocId() == _currDocument.getDocId()) {
            int nNewDocVersion = _currDocument.isChangeProperty("DOCVERSION") ? _currDocument.getNewPropertyAsInt("DOCVERSION", 0) : _currDocument.getVersion();
            _currAppendix.setUsedByVersion(nNewDocVersion, true);
            _currAppendix.update(ContextHelper.getLoginUser());
        } else {
            Appendix appendix = new Appendix();
            appendix.setProperties(_currAppendix.getAllProperty());
            appendix.setDocId(_currDocument.getDocId());
            FilesMan filesman = FilesMan.getFilesMan();
            String appfile = appendix.getFile();
            if (filesman.fileExists(appfile)) {
                String path = filesman.mapFilePath(appfile, 0);
                CMyString.setStrEndWith(path, File.separatorChar);
                String name = filesman.copyFile(path + appfile, filesman.getFileFlag(appfile), false);
                appendix.setFile(name);
                appendix.setUsedByVersion(_currDocument.getVersion(), true);
            }
            appendix.insert();
        }
    }

    private String moveAppendixFile(String _sApdFileName, boolean _bDocApd) {
        boolean bNotProcessed;
        FilesMan aFilesMan = FilesMan.getFilesMan();
        if (aFilesMan.getFileFlag(_sApdFileName) == "") {
            s_oLogger.error((Object)(I18NMessage.get(AppendixMgr.class, "AppendixMgr.label6", "\u627e\u4e0d\u5230\u6587\u4ef6\u5bf9\u5e94\u7684FileFlag\uff0c\u672a\u77e5\u6587\u4ef6\uff0c\u65e0\u6cd5\u79fb\u52a8\uff01") + _sApdFileName));
            return null;
        }
        String sNewFileName = _sApdFileName;
        String sFileFlag = aFilesMan.getFileFlag(_sApdFileName);
        boolean bl = bNotProcessed = sFileFlag != "W0" && sFileFlag != "P0";
        if (bNotProcessed) {
            try {
                sNewFileName = _bDocApd ? aFilesMan.moveWCMFile(_sApdFileName, "P0", false) : aFilesMan.moveWCMFile(_sApdFileName, "W0", false);
            }
            catch (Exception ex) {
                s_oLogger.error((Object)(I18NMessage.get(AppendixMgr.class, "AppendixMgr.label7", "\u79fb\u52a8\u6587\u4ef6\u5931\u8d25\uff01") + _sApdFileName), (Throwable)ex);
            }
        }
        return sNewFileName;
    }

    public Appendixes getAppendixes(WCMFilter _aWCMFilter) throws WCMException {
        if (_aWCMFilter == null) {
            throw new WCMException(20, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label8", "\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        return Appendixes.openWCMObjs(ContextHelper.getLoginUser(), _aWCMFilter);
    }

    public Appendix getAppendixById(int _nId) throws WCMException {
        WCMFilter appendixFilter = new WCMFilter("WCMAPPENDIX", "WCMAPPENDIX.APPENDIXID=" + _nId, "", "");
        Appendixes aAppendixes = new Appendixes(ContextHelper.getLoginUser());
        aAppendixes.open(appendixFilter);
        if (aAppendixes == null || aAppendixes.size() == 0) {
            return null;
        }
        return (Appendix)aAppendixes.getAt(0);
    }

    public void deleteAppendixFromDocument(Document _currDocument, Appendix _currAppendix) throws WCMException {
        if (_currDocument == null || _currAppendix == null) {
            throw new WCMException(20, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label9", "\u6587\u6863\u6216\u9644\u4ef6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\u9644\u4ef6\uff01"));
        }
        CMyBitsValue bitAppendixVersions = _currAppendix.getUsedVersions();
        bitAppendixVersions.setBit(_currDocument.getVersion(), false);
        if (bitAppendixVersions.getValue() == 0L) {
            _currAppendix.delete(ContextHelper.getLoginUser());
            return;
        }
        if (!_currAppendix.canEdit(ContextHelper.getLoginUser())) {
            return;
        }
        _currAppendix.setUsedVersions(bitAppendixVersions.getValue());
        _currAppendix.update(ContextHelper.getLoginUser());
    }

    public void copyAppendixes(Document _fromDocument, Document _newDocument) throws WCMException {
        if (_fromDocument == null) {
            throw new WCMException(10, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label10", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u590d\u5236\u5176\u9644\u4ef6\uff01"));
        }
        if (_newDocument == null) {
            throw new WCMException(10, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label11", "\u76ee\u6807\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u590d\u5236\u9644\u4ef6\uff01"));
        }
        Appendixes currAppendixes = Appendixes.findAppendixesByObj(_fromDocument);
        if (_fromDocument.getAttachPic() > 0) {
            WCMDocumentHelper.setAttachPicOfDocument(_newDocument.getId(), _fromDocument.getAttachPic());
        }
        int nCurrentVesion = _fromDocument.getVersion();
        int nDocFlag = _newDocument.getPropertyAsInt("DocFlag", 0);
        InfoviewXMLDataUpdator updator = null;
        HashMap<String, String> hAppendixField = new HashMap<String, String>();
        if (nDocFlag > 0) {
            updator = new InfoviewXMLDataUpdator(_newDocument.getContent());
        }
        for (int i = 0; i < currAppendixes.size(); ++i) {
            Appendix appendix = (Appendix)currAppendixes.getAt(i);
            if (appendix == null || !appendix.isUsedByVersion(nCurrentVesion)) continue;
            Appendix newAppendix = (Appendix)appendix.cloneToNewWCMObj();
            newAppendix.setDocId(_newDocument.getId());
            newAppendix.setUsedVersions(1L);
            newAppendix.insert(ContextHelper.getLoginUser());
            if (updator == null) continue;
            String sFieldName = newAppendix.getRelatedColumn();
            if (!hAppendixField.containsKey(sFieldName)) {
                hAppendixField.put(sFieldName, "0");
            } else {
                hAppendixField.put(sFieldName, String.valueOf(Integer.parseInt((String)hAppendixField.get(sFieldName)) + 1));
            }
            int nCurrAppendixFieldSize = Integer.parseInt((String)hAppendixField.get(sFieldName));
            if (updator.getAppenDixFieldSize(sFieldName) < nCurrAppendixFieldSize) continue;
            updator.setAppendixField(sFieldName, newAppendix.getFile(), nCurrAppendixFieldSize);
        }
        if (nDocFlag > 0 && updator != null) {
            String sNewContent = updator.update(null);
            _newDocument.canEdit(ContextHelper.getLoginUser());
            _newDocument.setContent(sNewContent);
            _newDocument.save(ContextHelper.getLoginUser());
        }
    }

    public Appendixes getAppendixes(Document _currDocument, int _nAppendixType) throws WCMException {
        return this.getAppendixes(_currDocument, _nAppendixType, null);
    }

    public Appendixes getAppendixes(Document _document, int _nAppendixType, WCMFilter _filter) throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "", "");
        String sWhere = "";
        if (_nAppendixType == 60) {
            sWhere = sWhere + "AppFlag<>?";
            aFilter.addSearchValues(0, 30);
        } else if (_nAppendixType != -1) {
            sWhere = sWhere + "AppFlag=?";
            aFilter.addSearchValues(0, _nAppendixType);
        }
        aFilter.setWhere(sWhere);
        aFilter.mergeWith(_filter);
        return this.getAppendixes(_document, aFilter);
    }

    public Appendixes getAppendixes(Document _currDocument, WCMFilter _filter) throws WCMException {
        if (_currDocument == null) {
            throw new WCMException(10, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label12", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61,\u65e0\u6cd5\u53d6\u5f97\u9644\u4ef6"));
        }
        String sWhere = "AppDocId=?";
        WCMFilter aFilter = new WCMFilter("", sWhere, "APPSERN");
        int docId = _currDocument.getDocId();
        if (docId == 0) {
            return null;
        }
        aFilter.addSearchValues(0, _currDocument.getDocId());
        aFilter.mergeWith(_filter);
        Appendixes docAppendixes = Appendixes.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        try {
            int currVersion = _currDocument.getVersion();
            for (int i = docAppendixes.size() - 1; i >= 0; --i) {
                Appendix anAppendix = (Appendix)docAppendixes.getAt(i);
                if (anAppendix != null && anAppendix.isUsedByVersion(currVersion)) continue;
                docAppendixes.removeAt(i, false);
            }
        }
        catch (WCMException ex) {
            s_oLogger.error((Object)"Fail to remove unused appendix!", (Throwable)ex);
            docAppendixes.clear();
            throw new WCMException(1100, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label13", "\u83b7\u53d6\u5f53\u524d\u6587\u6863\u4f7f\u7528\u7684\u9644\u4ef6\u96c6\u5408\u5931\u8d25!"), ex);
        }
        return docAppendixes;
    }

    private Appendixes getUnusedAppendixes(Document _currDocument, List _newAppendixList, int _nAppendixFlag) throws WCMException {
        if (_newAppendixList == null) {
            return null;
        }
        if (_currDocument == null) {
            throw new WCMException(20, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label14", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d6\u51fa\u9644\u4ef6\uff01"));
        }
        if (_newAppendixList.size() == 0) {
            return this.getAppendixes(_currDocument, _nAppendixFlag);
        }
        String sIds = "0";
        Appendix aAppendix = new Appendix();
        for (int i = 0; i < _newAppendixList.size(); ++i) {
            aAppendix = (Appendix)_newAppendixList.get(i);
            if (aAppendix == null) continue;
            sIds = sIds + "," + aAppendix.getId();
        }
        StringBuffer sbDelWhere = new StringBuffer();
        if (_nAppendixFlag == -1) {
            sbDelWhere.append("AppFlag <> 30");
        } else {
            sbDelWhere.append("AppFlag = " + _nAppendixFlag);
        }
        sbDelWhere.append(" and  APPENDIXID not in (" + sIds + ") AND APPDOCID=" + _currDocument.getId());
        WCMFilter apdsFilter = new WCMFilter("", sbDelWhere.toString(), "", "");
        return this.getAppendixes(apdsFilter);
    }

    public void deleteUnuseAppendixes(Document _currDocument, String _sUseingIds, int _nAppendixType) throws WCMException {
        if (_sUseingIds == null || _sUseingIds.length() == 0) {
            return;
        }
        if (_currDocument == null) {
            throw new WCMException(20, I18NMessage.get(AppendixMgr.class, "AppendixMgr.label14", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d6\u51fa\u9644\u4ef6\uff01"));
        }
        String sDelWhere = "APPDOCID=? and APPFLAG =?";
        if (!"0".equals(_sUseingIds)) {
            sDelWhere = sDelWhere + " and APPENDIXID not in (" + _sUseingIds + ")";
        }
        WCMFilter apdsFilter = new WCMFilter("", sDelWhere, "", "");
        apdsFilter.addSearchValues(_currDocument.getDocId());
        apdsFilter.addSearchValues(_nAppendixType);
        Appendixes delAppendixes = new Appendixes(ContextHelper.getLoginUser());
        delAppendixes.open(apdsFilter);
        int size = delAppendixes.size();
        for (int i = 0; i < size; ++i) {
            this.deleteAppendixFromDocument(_currDocument, (Appendix)delAppendixes.getAt(i));
        }
    }
}

