/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.content.HTMLContent;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseResults;
import com.trs.components.common.publish.domain.tagparser.TagParserFactory;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;
import com.trs.infra.util.html.HtmlUtil;
import com.trs.tools.HtmlCleaner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class TagParseHelper {
    private static final Logger LOG = Logger.getLogger(TagParseHelper.class);
    private static final String SEP_PATTERN = "(?is)<TRS_PAGE_SEPARATOR.*?>.*?</TRS_PAGE_SEPARATOR>";
    public static final int AUTOFORMATTYPE_HTML = 1;
    public static final int AUTOFORMATTYPE_HTMLVALUE = 2;
    public static final int AUTOFORMATTYPE_JAVASCRIPT = 3;
    public static final int AUTOFORMATTYPE_XML = 4;
    public static final int AUTOFORMATTYPE_INNERTEXT = 5;
    public static final int AUTOFORMATTYPE_BLANKLINE = 6;
    public static final int AUTOFORMATTYPE_JSON = 7;
    private static NamesRegister s_oNamesRegister = new NamesRegister();
    private static final String FLAG_START_STYLE = "<style id=_Custom_V6_Style";
    private static final String FLAG_END_STYLE = "</style>";
    private static final String FLAG_PASTE_STYLE = "cas_content";
    private static final Set SPECIAL_TAG_SET;

    private TagParseHelper() {
    }

    public static TagItem strToTagItem(String _sText) throws Exception {
        Object firstItem;
        if (_sText == null || _sText.length() == 0) {
            return null;
        }
        TagDocument doc = TagDocumentReader.read(_sText.trim());
        if (doc != null && doc.getItemCount() > 0 && (firstItem = doc.getItemAt(0)) instanceof TagItem) {
            return (TagItem)firstItem;
        }
        return null;
    }

    public static String[] parseItem(TagItem _item, PublishTagContext _context) throws WCMException {
        if (_item == null) {
            return null;
        }
        try {
            String sDefaultValue;
            ITagParser parser = TagParserFactory.createParserByName(_item.getName());
            _context.setTagItem(_item);
            parser.setTagItem(_item);
            String[] pResult = parser.parse(_context);
            if (!TagParseHelper.isSpecialTag(_item.getName()) && TagParseHelper.isNull(pResult) && !CMyString.isEmpty(sDefaultValue = _item.getAttribute("Default"))) {
                pResult = new String[]{sDefaultValue};
            }
            return pResult;
        }
        catch (Exception ex) {
            if (ex instanceof WCMException && ((WCMException)ex).getErrNo() > 200000) {
                throw (WCMException)ex;
            }
            throw new WCMException(234, I18NMessage.get(TagParseHelper.class, "TagParseHelper.label1", "\u89e3\u6790\u7f6e\u6807\u53d1\u751f\u5f02\u5e38\uff01\u7f6e\u6807\u5185\u5bb9\u4e3a: \n") + _item.toString(), ex);
        }
    }

    private static boolean isSpecialTag(String _sTagName) {
        return SPECIAL_TAG_SET.contains(_sTagName.toUpperCase());
    }

    private static boolean isNull(String[] _pResult) {
        if (_pResult == null) {
            return true;
        }
        boolean zIsNull = true;
        int len = _pResult.length;
        for (int i = 0; zIsNull && i < len; ++i) {
            zIsNull = CMyString.isEmpty(_pResult[i]);
        }
        return zIsNull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] parseItems(List _items, PublishTagContext _context) throws WCMException {
        if (_items == null || _items.isEmpty()) {
            return null;
        }
        TagParseResults parseResults = new TagParseResults();
        try {
            for (int nItemIndex = 0; nItemIndex < _items.size(); ++nItemIndex) {
                Object item = _items.get(nItemIndex);
                if (item instanceof String) {
                    parseResults.append((String)item);
                    continue;
                }
                TagItem tagItem = (TagItem)item;
                String[] results = TagParseHelper.parseItem(tagItem, _context);
                if (results == null) continue;
                parseResults.append(results);
            }
            String[] stringArray = parseResults.toStrArray();
            return stringArray;
        }
        finally {
            parseResults.clear();
        }
    }

    public static String parseDateFormat(String _sFormat) {
        if (_sFormat == null || (_sFormat = _sFormat.trim()).length() <= 0) {
            return "yyyy-MM-dd";
        }
        char[] arrChar = _sFormat.toCharArray();
        StringBuffer buff = new StringBuffer(arrChar.length + 4);
        int nPos = 0;
        int nLength = arrChar.length;
        block10: while (nPos < nLength) {
            char aChar;
            if ((aChar = arrChar[nPos++]) != '%') {
                buff.append(aChar);
                continue;
            }
            if (nPos == nLength) {
                buff.append('%');
                break;
            }
            aChar = arrChar[nPos++];
            switch (aChar) {
                case 'Y': {
                    buff.append("yyyy");
                    continue block10;
                }
                case 'M': {
                    if (nPos + 1 < nLength && arrChar[nPos] == 'O' && arrChar[nPos + 1] == 'N') {
                        buff.append("MM");
                        nPos += 2;
                        continue block10;
                    }
                    buff.append("mm");
                    continue block10;
                }
                case 'm': {
                    buff.append("MM");
                    continue block10;
                }
                case 'D': {
                    if (nPos + 1 < nLength && arrChar[nPos] == 'A' && arrChar[nPos + 1] == 'Y') {
                        buff.append("dd");
                        nPos += 2;
                        continue block10;
                    }
                    buff.append("%D");
                    continue block10;
                }
                case 'd': {
                    buff.append("dd");
                    continue block10;
                }
                case 'H': {
                    buff.append("HH");
                    continue block10;
                }
                case 'S': {
                    buff.append("ss");
                    continue block10;
                }
                case '%': {
                    buff.append('%');
                    --nPos;
                    continue block10;
                }
            }
            buff.append('%').append(aChar);
        }
        return buff.toString();
    }

    public static String[] separatePagesOld(String _sText) {
        int i;
        String[] temp;
        Pattern pattern = Pattern.compile(SEP_PATTERN);
        Matcher matcher = pattern.matcher(_sText);
        String[] results = new String[1];
        int nPages = 0;
        int nLength = _sText.length();
        int nNextStart = 0;
        while (matcher.find()) {
            if (++nPages > results.length) {
                temp = new String[nPages];
                System.arraycopy(results, 0, temp, 0, nPages - 1);
                results = temp;
            }
            results[nPages - 1] = _sText.substring(nNextStart, matcher.start());
            nNextStart = matcher.end();
            if (nNextStart + 1 < nLength) continue;
        }
        if (nNextStart > 0 && nNextStart < nLength) {
            temp = new String[++nPages];
            System.arraycopy(results, 0, temp, 0, nPages - 1);
            results = temp;
            results[nPages - 1] = _sText.substring(nNextStart);
        }
        if (nPages <= 0) {
            return new String[]{_sText};
        }
        if (nPages == 1) {
            return results;
        }
        for (int i2 = 0; i2 < results.length; ++i2) {
            String sAppendTemp = HtmlCleaner.parse(results[i2]);
            if (sAppendTemp == null || sAppendTemp.trim().length() <= 0) continue;
            if (sAppendTemp.endsWith("-")) {
                sAppendTemp = sAppendTemp.substring(0, sAppendTemp.length() - 2);
                results[i2] = TagParseHelper.reverseAppendTag(results[i2], sAppendTemp, false);
                continue;
            }
            results[i2] = TagParseHelper.appendTag(results[i2], sAppendTemp, true);
        }
        String sStyle = TagParseHelper.extractStyleHTML(results[0]);
        String sDivStartHTML = null;
        if (sStyle != null) {
            int i3;
            int nStartPos;
            sDivStartHTML = TagParseHelper.extractDivStartHTML(results[0]);
            if (sDivStartHTML != null) {
                results[results.length - 1] = sDivStartHTML + sStyle + results[results.length - 1] + "</DIV>";
                for (i = 1; i < results.length - 1; ++i) {
                    results[i] = sDivStartHTML + sStyle + results[i] + "</DIV>";
                }
            }
            if ((nStartPos = results[0].indexOf(FLAG_PASTE_STYLE)) > 0) {
                for (i3 = 1; i3 < results.length - 1; ++i3) {
                    results[i3] = "<DIV class='cas_content'>" + results[i3] + "</DIV>";
                }
                results[results.length - 1] = "<DIV class='cas_content'>" + results[results.length - 1];
            }
            for (i3 = 1; i3 < results.length - 1; ++i3) {
                results[i3] = "<DIV class='TRS_Editor'>" + results[i3] + "</DIV>";
            }
            if (nStartPos > 0) {
                results[results.length - 1] = results[results.length - 1].substring(6);
            }
            results[results.length - 1] = "<DIV class='TRS_Editor'>" + results[results.length - 1] + "</div>";
        }
        try {
            if (PublishServerConfigMapper.isDetailPageSeperateTo51Style()) {
                for (i = 0; i < results.length; ++i) {
                    results[i] = results[i] + TagParseHelper.getPageNavigator(i, results.length);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public static String[] separatePages(String _sText) {
        int i;
        int len;
        String regStyle = "<style[^>]*>([\\d\\D]*?)</style>";
        Pattern pStylePattern = Pattern.compile(regStyle);
        Matcher mStyleTag = pStylePattern.matcher(_sText);
        String sStyle = "";
        while (mStyleTag.find()) {
            sStyle = sStyle + mStyleTag.group();
        }
        LOG.debug((Object)("\u7ec6\u7f06\u9875\u9762\u4e2d\u5206\u9875\u6837\u5f0f\u4e3a\uff1a " + sStyle));
        boolean bAdd_TRS_Editor = false;
        String regTRSEditor = "<div class=[\"']*?TRS_Editor[\"']*?>";
        Pattern pTRSEditorPattern = Pattern.compile(regTRSEditor);
        Matcher mTRSEditor = pTRSEditorPattern.matcher(_sText);
        if (mTRSEditor.find()) {
            bAdd_TRS_Editor = true;
        }
        Pattern pattern = Pattern.compile(SEP_PATTERN);
        Matcher matcher = pattern.matcher(_sText);
        ArrayList<String> parts = new ArrayList<String>(5);
        int nLength = _sText.length();
        int nNextStart = 0;
        String s_TRS_Editor = "<div class=\"TRS_Editor\">";
        while (matcher.find()) {
            if (bAdd_TRS_Editor && nNextStart != 0) {
                parts.add(sStyle + s_TRS_Editor + _sText.substring(nNextStart, matcher.start()));
            } else {
                parts.add(sStyle + _sText.substring(nNextStart, matcher.start()));
            }
            nNextStart = matcher.end();
        }
        if (nNextStart > 0 && nNextStart < nLength) {
            if (bAdd_TRS_Editor) {
                parts.add(sStyle + s_TRS_Editor + _sText.substring(nNextStart));
            } else {
                parts.add(sStyle + _sText.substring(nNextStart));
            }
        }
        if (parts.size() <= 1) {
            parts.clear();
            return new String[]{_sText};
        }
        String[] results = new String[parts.size()];
        parts.toArray(results);
        parts.clear();
        String head = results[0];
        int ix = head.indexOf(FLAG_PASTE_STYLE);
        if (ix == -1) {
            ix = head.indexOf(FLAG_START_STYLE);
            if (ix != -1) {
                ix = head.indexOf(FLAG_END_STYLE, ix);
                head = head.substring(0, ix + FLAG_END_STYLE.length());
            } else {
                head = null;
            }
        } else {
            ix = '>' != head.charAt(ix += FLAG_PASTE_STYLE.length()) ? (ix += 2) : ++ix;
            head = head.substring(0, ix);
        }
        if (head != null) {
            len = results.length;
            for (i = 1; i < len; ++i) {
                results[i] = head + results[i];
            }
        }
        len = results.length;
        for (i = 0; i < len; ++i) {
            String part = results[i];
            String sAppendTemp = HtmlCleaner.parse(part);
            if (sAppendTemp == null || sAppendTemp.trim().length() <= 0) continue;
            if (sAppendTemp.endsWith("-")) {
                sAppendTemp = sAppendTemp.substring(0, sAppendTemp.length() - 2);
                results[i] = TagParseHelper.reverseAppendTag(part, sAppendTemp, false);
                continue;
            }
            results[i] = TagParseHelper.appendTag(part, sAppendTemp, true);
        }
        try {
            if (PublishServerConfigMapper.isDetailPageSeperateTo51Style()) {
                len = results.length;
                for (i = 0; i < len; ++i) {
                    results[i] = results[i] + TagParseHelper.getPageNavigator(i, len);
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"failed to generate nav of wcm51 style.", (Throwable)e);
        }
        return results;
    }

    private static String appendTag(String _sSource, String _sAppendTemp, boolean _bAppendBack) {
        String sResult = _sSource;
        for (int i = 0; i < _sAppendTemp.split(",").length; ++i) {
            sResult = _bAppendBack ? sResult + " </" + _sAppendTemp.split(",")[i] + ">" : "<" + _sAppendTemp.split(",")[i] + "> " + sResult;
        }
        return sResult;
    }

    private static String reverseAppendTag(String _sSource, String _sAppendTemp, boolean _bAppendBack) {
        String sResult = _sSource;
        for (int i = _sAppendTemp.split(",").length - 1; i >= 0; --i) {
            sResult = _bAppendBack ? sResult + " </" + _sAppendTemp.split(",")[i] + ">" : "<" + _sAppendTemp.split(",")[i] + "> " + sResult;
        }
        return sResult;
    }

    private static String extractDivStartHTML(String _sContent) {
        int nDivStartPos = _sContent.indexOf("<DIV id='TRS_AUTOADD");
        if (nDivStartPos < 0) {
            nDivStartPos = _sContent.indexOf("<DIV id=\"TRS_AUTOADD");
        }
        if (nDivStartPos < 0) {
            return null;
        }
        int nDivEndPos = _sContent.indexOf(">", nDivStartPos + 6);
        if (nDivEndPos < 0) {
            return null;
        }
        return _sContent.substring(nDivStartPos, nDivEndPos + 1);
    }

    private static String extractStyleHTML(String _sContent) {
        int nStartPos = _sContent.indexOf(FLAG_START_STYLE);
        if (nStartPos <= 0) {
            return null;
        }
        int nEndPos = _sContent.indexOf(FLAG_END_STYLE, nStartPos + 10);
        if (nEndPos <= 0) {
            return null;
        }
        return _sContent.substring(nStartPos, nEndPos + FLAG_END_STYLE.length());
    }

    public static String truncateTextIfNeeded(TagItem _currItem, String _sText) throws WCMException {
        int nMaxLength = _currItem.getIntAttribute("NUM", 0);
        if (nMaxLength <= 0) {
            return _sText;
        }
        String sTruncatedFlag = _currItem.getAttribute("TRUNCATEDFLAG");
        if (sTruncatedFlag == null) {
            sTruncatedFlag = "...";
        }
        return CMyString.truncateStr(_sText, nMaxLength, sTruncatedFlag);
    }

    public static String truncateTextIfNeeded(PublishTagContext _context, String _sText) throws WCMException {
        int nMaxLength = _context.getAttribute("NUM", 0);
        if (nMaxLength <= 0) {
            return _sText;
        }
        _sText = CMyString.innerText(_sText);
        String sTruncatedFlag = _context.getAttribute("TRUNCATEDFLAG");
        if (sTruncatedFlag == null) {
            sTruncatedFlag = "...";
        }
        return CMyString.truncateStr(_sText, nMaxLength, sTruncatedFlag);
    }

    public static String formatTextIfNeeded(TagItem _currItem, String _sText) {
        if (!_currItem.getBooleanAttribute("AUTOFORMAT", false)) {
            return _sText;
        }
        String sAutoFormatType = _currItem.getAttribute("AUTOFORMATTYPE");
        sAutoFormatType = sAutoFormatType == null || (sAutoFormatType = sAutoFormatType.trim()).length() == 0 ? "HTML" : sAutoFormatType.toUpperCase();
        int nAutoFormatType = s_oNamesRegister.lookup(sAutoFormatType, 1);
        String sResult = null;
        switch (nAutoFormatType) {
            case 2: {
                sResult = CMyString.filterForHTMLValue(_sText);
                break;
            }
            case 3: {
                sResult = CMyString.filterForJs(_sText);
                break;
            }
            case 4: {
                sResult = CMyString.filterForXML(_sText);
                break;
            }
            case 5: {
                sResult = CMyString.innerText(_sText);
                break;
            }
            default: {
                sResult = CMyString.transDisplay(_sText);
            }
        }
        return sResult;
    }

    public static String formatTextIfNeeded(PublishTagContext _context, String _sText) throws WCMException {
        if (!_context.getAttribute("AUTOFORMAT", false)) {
            return _sText;
        }
        String sAutoFormatType = _context.getAttribute("AUTOFORMATTYPE");
        sAutoFormatType = sAutoFormatType == null || (sAutoFormatType = sAutoFormatType.trim()).length() == 0 ? "HTML" : sAutoFormatType.toUpperCase();
        String sResult = _sText;
        String[] aFormatType = CMyString.split(sAutoFormatType, ",");
        for (int i = 0; i < aFormatType.length; ++i) {
            sResult = TagParseHelper.formatTextIfNeeded(_context, sResult, aFormatType[i]);
        }
        return sResult;
    }

    private static String formatTextIfNeeded(PublishTagContext _context, String _sText, String sFormatType) throws WCMException {
        int nAutoFormatType = s_oNamesRegister.lookup(sFormatType, 1);
        String sResult = null;
        switch (nAutoFormatType) {
            case 2: {
                sResult = CMyString.filterForHTMLValue(_sText);
                break;
            }
            case 3: {
                sResult = CMyString.filterForJs(_sText);
                break;
            }
            case 4: {
                sResult = CMyString.filterForXML(_sText);
                break;
            }
            case 5: {
                int nEnterNum = _context.getAttribute("ENTERNUM", 1);
                sResult = CMyString.innerText(_sText, nEnterNum);
                break;
            }
            case 6: {
                boolean bTrimLine = _context.getAttribute("TRIMLINE", true);
                sResult = CMyString.filterBlankLine(_sText, bTrimLine);
                break;
            }
            case 7: {
                sResult = CMyString.filterForJson(_sText);
                break;
            }
            default: {
                sResult = CMyString.transDisplay(_sText, false);
            }
        }
        return sResult;
    }

    public static Template findNestedTemplate(PublishTagContext _context) throws WCMException {
        String sValue = _context.getAttribute("TEMPNAME");
        IPublishFolder root = _context.getPageElement().getFolder().getRoot();
        return TagParseHelper.findNestedTemplate(sValue, root);
    }

    public static Template findNestedTemplate(TagItem _tagItem, IPublishFolder _root) throws WCMException {
        String sValue = _tagItem.getAttribute("TEMPNAME");
        return TagParseHelper.findNestedTemplate(sValue, _root);
    }

    public static Template findNestedTemplate(String sTempName, IPublishFolder _root) throws WCMException {
        if (sTempName == null || (sTempName = sTempName.trim()).length() == 0) {
            throw new WCMException(232, "Template name requried in tag <TRS_TEMPLATE>");
        }
        TemplateCacheMgr mgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        Template nestedTemplate = mgr.lookupByName(_root, sTempName);
        if (nestedTemplate == null) {
            throw new WCMException(232, "Template [" + sTempName + "] not found in " + _root.getInfo() + "!");
        }
        return nestedTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] parse4List(PublishTagContext _tagContext, ITagParser4List _parser4List) throws WCMException {
        int nLoopLimit;
        int nStartPos = _tagContext.getAttribute("STARTPOS", 0);
        if (nStartPos < 0) {
            nStartPos = 0;
        }
        int nTotal = _parser4List.getRecordSize();
        int nNum = _tagContext.getAttribute("NUM", 0);
        if (nNum <= 0 || nNum > nTotal) {
            nNum = nTotal;
        }
        if ((nLoopLimit = _tagContext.getAttribute("LOOP", 0)) < 0 || nLoopLimit > nNum) {
            nLoopLimit = nNum;
        }
        int nPageSize = _tagContext.getAttribute("PAGESIZE", 0);
        List tagChildren = _tagContext.getTagItem().getChildren();
        ArrayList<String> pages = new ArrayList<String>();
        TagParseResults parseResults = new TagParseResults();
        String[] results = null;
        try {
            PublishTagContext tagContext;
            _parser4List.setStartPos(nStartPos);
            for (int nLoopCount = 0; nLoopCount < nLoopLimit && (tagContext = _parser4List.getDelegatedContext()) != null; ++nLoopCount) {
                if (nPageSize > 0 && nLoopCount / nPageSize > pages.size()) {
                    pages.add(parseResults.get(0));
                    parseResults.clear();
                }
                if ((results = TagParseHelper.parseItems(tagChildren, tagContext)) == null) continue;
                parseResults.append(results);
            }
            pages.add(parseResults.get(0));
            _tagContext.getPageContext().setExtraAttribute("RECORD_COUNT", String.valueOf(nTotal));
            results = new String[pages.size()];
            pages.toArray(results);
            String[] stringArray = results;
            return stringArray;
        }
        finally {
            if (parseResults != null) {
                parseResults.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] parse4List(TagItem _tagItem, PublishTagContext _tagContext, ITagParser4List _parser4List) throws WCMException {
        PublishTagContext oNewTagContext;
        String sPreContent = null;
        if (_tagItem.containsChild("TRS_EXISTSDATA") && _parser4List.getRecordSize() > 0) {
            oNewTagContext = null;
            oNewTagContext = _tagContext.getParent() == null ? new PublishTagContext(_tagContext.getPageContext()) : new PublishTagContext(_tagContext.getParent(), _tagItem, _tagContext.getUpperHost());
            sPreContent = TagParseHelper.preparseChildTagItem(_tagItem, oNewTagContext, "TRS_EXISTSDATA");
        }
        if (_tagItem.containsChild("TRS_NOTEXISTSDATA") && _parser4List.getRecordSize() <= 0) {
            oNewTagContext = null;
            oNewTagContext = _tagContext.getParent() == null ? new PublishTagContext(_tagContext.getPageContext()) : new PublishTagContext(_tagContext.getParent(), _tagItem, _tagContext.getUpperHost());
            sPreContent = TagParseHelper.preparseChildTagItem(_tagItem, oNewTagContext, "TRS_NOTEXISTSDATA");
            return new String[]{sPreContent};
        }
        int nStartPos = _tagContext.getAttribute("STARTPOS", 0);
        if (nStartPos < 0) {
            nStartPos = 0;
        }
        int nTotal = _parser4List.getRecordSize();
        int nNum = _tagContext.getAttribute("NUM", 0);
        if (nNum <= 0) {
            nNum = nTotal;
        }
        int nPageSize = _tagContext.getAttribute("PAGESIZE", 0);
        List tagChildren = _tagItem.getChildren();
        boolean bContainsRecordTag = _tagItem.containsChild("TRS_RECORD");
        ArrayList<String> pages = new ArrayList<String>();
        TagParseResults parseResults = new TagParseResults();
        String[] results = null;
        int nParsedCount = 0;
        try {
            boolean bIsWML;
            String sParseResult;
            PublishTagContext tagContext;
            boolean bOnlyFirstOnPreview;
            _parser4List.setStartPos(nStartPos);
            if (_tagContext.isPreview() && nPageSize > 0 && nNum > nPageSize && (bOnlyFirstOnPreview = ConfigServer.getServer().getSysConfigValue("ONLY_FIRST_ON_PREVIEW", "false").trim().equalsIgnoreCase("true"))) {
                nNum = nPageSize;
            }
            while (nParsedCount < nNum && (tagContext = _parser4List.getNextRecordContext()) != null) {
                if (nPageSize > 0 && nParsedCount / nPageSize > pages.size()) {
                    String sParseResult2;
                    String string = sParseResult2 = parseResults.size() > 0 ? parseResults.get(0) : "";
                    if (sPreContent != null) {
                        pages.add(sPreContent + sParseResult2);
                    } else {
                        pages.add(sParseResult2);
                    }
                    parseResults.clear();
                }
                if (!bContainsRecordTag) {
                    results = TagParseHelper.parseItems(tagChildren, tagContext);
                    if (results != null) {
                        parseResults.append(results);
                    }
                    ++nParsedCount;
                    continue;
                }
                for (int nTagIndex = 0; nTagIndex < tagChildren.size(); ++nTagIndex) {
                    Object tagChild = tagChildren.get(nTagIndex);
                    if (tagChild instanceof String) {
                        parseResults.append((String)tagChild);
                        continue;
                    }
                    if ("TRS_RECORD".equalsIgnoreCase(((TagItem)tagChild).getName())) {
                        PublishTagContext aTempContext = new PublishTagContext(_tagContext, (TagItem)tagChild);
                        int nLoopNum = aTempContext.getAttribute("NUM", 1);
                        String[] supplement = new String[]{CMyString.showNull(aTempContext.getAttribute("SUPPLEMENT"), "")};
                        if (nLoopNum <= 0) {
                            nLoopNum = 1;
                        }
                        int nLoopIndex = 0;
                        for (nLoopIndex = 0; nLoopIndex < nLoopNum && nParsedCount < nNum; ++nLoopIndex) {
                            if (tagContext == null) {
                                tagContext = _parser4List.getNextRecordContext();
                            }
                            if (tagContext == null) {
                                parseResults.append(supplement);
                                continue;
                            }
                            results = TagParseHelper.parseItems(((TagItem)tagChild).getChildren(), tagContext);
                            if (results != null) {
                                parseResults.append(results);
                            }
                            ++nParsedCount;
                            tagContext = null;
                        }
                        while (nLoopIndex++ < nLoopNum) {
                            parseResults.append(supplement);
                        }
                        continue;
                    }
                    results = TagParseHelper.parseItem((TagItem)tagChild, tagContext);
                    if (results == null) continue;
                    parseResults.append(results);
                }
            }
            String string = sParseResult = parseResults.size() > 0 ? parseResults.get(0) : "";
            if (sPreContent != null) {
                pages.add(sPreContent + sParseResult);
            } else {
                pages.add(sParseResult);
            }
            _tagContext.getPageContext().setExtraAttribute("RECORD_COUNT", String.valueOf(nTotal));
            if (pages.size() > 1 && (bIsWML = _tagContext.getAttribute("WML", false))) {
                Template pageTemplate = _tagContext.getPageContext().getTemplate();
                String sFileName = pageTemplate.getOutputFileName();
                String sFileExt = pageTemplate.getOutputFileExt();
                results = new String[pages.size()];
                int nPageCount = results.length;
                for (int i = 0; i < nPageCount; ++i) {
                    results[i] = pages.get(i) + "<br/>" + TagParseHelper.makeCurrNavContent(sFileName, sFileExt, i, nPageCount);
                }
                String[] stringArray = results;
                return stringArray;
            }
            results = new String[pages.size()];
            pages.toArray(results);
            String[] stringArray = results;
            return stringArray;
        }
        finally {
            if (parseResults != null) {
                parseResults.clear();
            }
        }
    }

    private static String preparseChildTagItem(TagItem _tagItem, PublishTagContext _tagContext, String _sChildTagName) throws WCMException {
        List m_children = _tagItem.getChildren();
        int nSize = m_children.size();
        for (int i = 0; i < nSize; ++i) {
            Object child = m_children.get(i);
            if (child == null || !(child instanceof TagItem) || !((TagItem)child).getName().equalsIgnoreCase(_sChildTagName)) continue;
            List childrenOfExistsData = ((TagItem)child).getChildren();
            String[] pResult = TagParseHelper.parseItems(childrenOfExistsData, _tagContext);
            if (pResult == null || pResult.length <= 0) break;
            return pResult[0];
        }
        return null;
    }

    private static String makeCurrNavContent(String _sFileName, String _sFileExt, int _nIndex, int _nPageCount) {
        String sURL;
        StringBuffer sbNavContent = new StringBuffer();
        if (_nIndex > 0) {
            sURL = null;
            sURL = _nIndex == 1 ? _sFileName + "." + _sFileExt : _sFileName + "_" + (_nIndex - 1) + "." + _sFileExt;
            sbNavContent.append("<a href=\"" + sURL + I18NMessage.get(TagParseHelper.class, "TagParseHelper.label2", "\">&lt;&lt;\u4e0a\u4e00\u9875</a>"));
            sbNavContent.append("&nbsp;&nbsp;");
        }
        if (_nIndex == 0 || _nIndex != _nPageCount - 1) {
            sURL = _sFileName + "_" + (_nIndex + 1) + "." + _sFileExt;
            sbNavContent.append("<a href=\"" + sURL + I18NMessage.get(TagParseHelper.class, "TagParseHelper.label3", "\">\u4e0b\u4e00\u9875&gt;&gt;</a>"));
        }
        return sbNavContent.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] parse4Children(TagItem _tagItem, PublishTagContext _tagContext) throws WCMException {
        List tagChildren = _tagItem.getChildren();
        ArrayList<String> pages = new ArrayList<String>();
        TagParseResults parseResults = new TagParseResults();
        String[] results = null;
        try {
            for (int nTagIndex = 0; nTagIndex < tagChildren.size(); ++nTagIndex) {
                Object tagChild = tagChildren.get(nTagIndex);
                if (tagChild instanceof String) {
                    parseResults.append((String)tagChild);
                    continue;
                }
                results = TagParseHelper.parseItem((TagItem)tagChild, _tagContext);
                if (results == null) continue;
                parseResults.append(results);
            }
            pages.add(parseResults.get(0));
            results = new String[pages.size()];
            pages.toArray(results);
            String[] stringArray = results;
            return stringArray;
        }
        finally {
            if (parseResults != null) {
                parseResults.clear();
            }
        }
    }

    public static ArrayList makeSelectFields(TagItem _item, String _sContentTagName) {
        List lChildren = _item.getChildren();
        if (lChildren == null || lChildren.isEmpty()) {
            return null;
        }
        ArrayList result = new ArrayList(lChildren.size());
        String sContentTagName = _sContentTagName.toUpperCase();
        return TagParseHelper.makeSelectFields(_item, sContentTagName, result);
    }

    private static ArrayList makeSelectFields(TagItem _itemParent, String _sContentTagName, ArrayList _result) {
        List lChildren = _itemParent.getChildren();
        if (lChildren == null || lChildren.isEmpty()) {
            return _result;
        }
        int nSize = lChildren.size();
        for (int i = 0; i < nSize; ++i) {
            Object child = lChildren.get(i);
            if (child == null || !(child instanceof TagItem)) continue;
            TagItem item = (TagItem)child;
            if (item.getName().equals(_sContentTagName)) {
                String sField = item.getAttribute("FIELD");
                if (CMyString.isEmpty(sField)) {
                    sField = item.getAttribute("ID");
                }
                TagParseHelper.addField(_result, sField);
            }
            TagParseHelper.makeSelectFields(item, _sContentTagName, _result);
        }
        return _result;
    }

    private static void addField(ArrayList _list, String _sField) {
        if (_sField == null || (_sField = _sField.trim()).length() <= 0) {
            return;
        }
        String sField = null;
        sField = _sField.charAt(0) == '#' ? "ATTRIBUTE" : _sField.toUpperCase();
        if (_list.indexOf(sField) < 0) {
            _list.add(sField);
        }
    }

    public static String addAutoLink(String _sUrl, String _sValue, String _sDefaultAltText, PublishTagContext _context) {
        String sTarget = _context.getAttribute("TARGET");
        String sExtra = _context.getAttribute("EXTRA");
        String sLinkText = _context.getAttribute("LINKTEXT");
        String sAltText = null;
        if (_context.getAttribute("LINKALT", false) && ((sAltText = _context.getAttribute("LINKALTTEXT")) == null || (sAltText = sAltText.trim()).length() == 0)) {
            sAltText = _sDefaultAltText;
        }
        return HtmlUtil.renderLink(_sUrl, sTarget, sAltText, sExtra, _sValue, sLinkText);
    }

    public static String addSpanStyleIfNeeded(PublishTagContext _context, String _sText) {
        if (_sText == null) {
            return null;
        }
        String sStyleClass = _context.getAttribute("CLASSNAME");
        if (sStyleClass == null || sStyleClass.length() <= 0) {
            return _sText;
        }
        StringBuffer sb = new StringBuffer(_sText.length() + sStyleClass.length() + 16);
        sb.append("<SPAN class=\"").append(sStyleClass).append("\">");
        sb.append(_sText).append("</SPAN>");
        return sb.toString();
    }

    public static String[] addSpanStyleIfNeeded(PublishTagContext _context, String[] results) {
        if (results == null || results.length == 0) {
            return results;
        }
        String sStyleClass = _context.getAttribute("CLASSNAME");
        if (CMyString.isEmpty(sStyleClass)) {
            return results;
        }
        String temp = results[0];
        StringBuffer buff = new StringBuffer(temp.length() + 128);
        buff.append("<span class='");
        buff.append(sStyleClass);
        buff.append("'>");
        buff.append(temp);
        buff.append("</span>");
        results[0] = buff.toString();
        int len = results.length;
        for (int i = 1; i < len; ++i) {
            buff.setLength(0);
            buff.append("<span class='");
            buff.append(sStyleClass);
            buff.append("'>");
            buff.append(results[i]);
            buff.append("</span>");
            results[i] = buff.toString();
        }
        return results;
    }

    public static String[] parseHtmlContent(String _sHtmlContent, IPublishContent _content, PublishTagContext _context) throws WCMException {
        if (_content == null || _content.getSubstance() == null) {
            return null;
        }
        if (_sHtmlContent == null || _sHtmlContent.length() <= 0) {
            return null;
        }
        String sResult = null;
        try {
            String sImagePath1 = _context.getPathCompass().getAbsoluteHttpPath(_content.getRealHome());
            String sImagePath2 = PublishPathCompass.calSubDirectory(_content, false);
            String sImagePath = sImagePath1 + sImagePath2;
            if (!_context.getAttribute("UrlIsABS", false)) {
                sImagePath = HtmlUtil.calRelativePath(sImagePath, _context.getPageHttpPath());
            }
            HTMLContent oHTMLContent = new HTMLContent(_sHtmlContent);
            sResult = oHTMLContent.parseHTMLContent(sImagePath);
            TagParseHelper.distributionHTMLContentFiles(_content, _context, oHTMLContent.getWCMFiles());
            if (_context.getPageElement() instanceof IPublishContent) {
                return TagParseHelper.separatePages(sResult);
            }
            return new String[]{sResult};
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(TagParseHelper.class, "TagParseHelper.label4", "\u89e3\u6790 ") + _content.getInfo() + I18NMessage.get(TagParseHelper.class, "TagParseHelper.label5", " \u7684\u6b63\u6587\u5931\u8d25!"), ex);
        }
    }

    public static void distributionHTMLContentFiles(IPublishContent _content, PublishTagContext _context, List _listFiles) throws WCMException {
        try {
            int nSize = _listFiles.size();
            if (nSize <= 0) {
                return;
            }
            boolean bPreview = _context.isPreview();
            PublishPathCompass compass = _context.getPathCompass();
            for (int i = 0; i < nSize; ++i) {
                String sSrcFilePathName;
                String sFileName = (String)_listFiles.get(i);
                if (sFileName == null || !CMyFile.fileExists(sSrcFilePathName = FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName)) continue;
                String sLocalPath = compass.getLocalPath(_content, bPreview);
                PublishSyncGlobalTuner.insureLocalPathExists(sLocalPath);
                CMyFile.copyFile(sSrcFilePathName, sLocalPath + sFileName);
                if (bPreview) continue;
                _context.getFileDistributeShip().distributeFile(sSrcFilePathName, _content, null, true);
            }
        }
        catch (Exception ex) {
            _context.addWarning(I18NMessage.get(TagParseHelper.class, "TagParseHelper.label6", "\u53d1\u5e03") + _content.getInfo() + I18NMessage.get(TagParseHelper.class, "TagParseHelper.label7", "\u7684HTML\u6b63\u6587\u56fe\u7247\u5931\u8d25\uff01\n") + CMyException.getStackTraceText(ex));
        }
    }

    private static String getPageNavigator(int nIndex, int nSize) {
        if (nSize <= 1) {
            return "";
        }
        StringBuffer strPageNavigator = new StringBuffer(2048);
        strPageNavigator.append(TagParseHelper.getGotoPageScript(nIndex));
        strPageNavigator.append("<DIV id='idTRSNavigator' class='clsTRSNavigatorDIV'>");
        strPageNavigator.append(TagParseHelper.getListNavigator(nIndex, nSize));
        strPageNavigator.append("</DIV>");
        return strPageNavigator.toString();
    }

    private static String getListNavigator(int _nIndex, int _nSize) {
        StringBuffer bufListNavigator = new StringBuffer(255);
        if (_nIndex != 0) {
            bufListNavigator.append("<A id='idTRSListLink' class='clsTRSListLink' href='javascript:gotoPage(0);'>1</A>");
        } else {
            bufListNavigator.append("1");
        }
        for (int nIndex = 1; nIndex < _nSize; ++nIndex) {
            if (_nIndex != nIndex) {
                bufListNavigator.append(",<A id='idTRSListLink' class='idTRSListLink' href='javascript:gotoPage(" + nIndex + ");'>");
                bufListNavigator.append(nIndex + 1);
                bufListNavigator.append("</A>");
                continue;
            }
            bufListNavigator.append(",");
            bufListNavigator.append(nIndex + 1);
        }
        return bufListNavigator.toString();
    }

    private static String getGotoPageScript(int nIndex) {
        String sScript = "\n<SCRIPT language=\"javascript\">\n<!--\n  var nPageIndex = " + nIndex + "\n;\n  var sValue = window.location.href;\n  var nFileStartPos = sValue.lastIndexOf('/t');\n  var sFile = sValue.substring(nFileNameStartPos);\n  var nFileEndPos = sFile.indexOf('?');\n  if(nFileEndPos < 0){\n      nFileEndPos = sFile.indexOf('#');\n  }\n  if(nFileEndPos > 0){\n      sFile = sFile.substring(0, nFileEndPos);\n  }\n\n\n  var nFileNameEndPos = sFile.lastIndexOf('.');   \n  var sFileExt = sFile.substring(nFileNameEndPos+1);\n  \n  var sFileName = sFile.substring(0, nFileNameEndPos);\n  if(nPageIndex>0){\n      var nFileNameStartPos = sFileName.lastIndexOf('_'+nPageIndex);  \n      sFileName = sFileName.substring(0, nFileNameStartPos);  \n  }\n  \n  function gotoPage(_nPageIndex){\n      var sURL = \"\";\n      if(_nPageIndex>0){\n          sURL = sFileName + \"_\" + _nPageIndex + \".\" + sFileExt;\n      }else{\n          sURL = sFileName +  \".\" + sFileExt;\n      }\n\n      window.location.href = sURL;\n      return false;\n  }\n  \n//-->\n</SCRIPT>";
        return sScript;
    }

    public static void main(String[] args) {
        try {
            String sTestData = CMyFile.readFile("c:\\test.html");
            System.out.println("==============Src==================");
            System.out.println(sTestData);
            String[] pResults = TagParseHelper.separatePages(sTestData);
            for (int i = 0; i < pResults.length; ++i) {
                System.out.println("==============Sep" + i + "==================");
                System.out.println(pResults[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String[] parseContent(IPublishElement _pageElement, String _sTemplateContent) throws Exception {
        return TagParseHelper.parseContent(_pageElement, _sTemplateContent, "NORM");
    }

    public static boolean isVisualParseMode(PublishTagContext context) {
        String sParseMode = context.getPageContext().getExtraAttribute("_ParseMode_");
        return "EDIT".equals(sParseMode);
    }

    public static String[] parseContent(IPublishElement _pageElement, String _sTemplateContent, String _sParseType) throws Exception {
        TagDocument tagDocument = TagDocumentReader.read(_sTemplateContent);
        IPublishFolder startFolder = null;
        if (_pageElement instanceof IPublishFolder) {
            startFolder = (IPublishFolder)_pageElement;
        } else {
            startFolder = ((IPublishContent)_pageElement).getRealHome();
            if (_pageElement.getFolder() == null) {
                ((IPublishContent)_pageElement).setFolder(startFolder);
            }
        }
        PublishTaskContext taskContext = new PublishTaskContext(null, startFolder);
        PublishPageContext pageContext = new PublishPageContext(_pageElement, taskContext);
        if (_sParseType != null) {
            pageContext.setExtraAttribute("_ParseMode_", _sParseType);
        }
        PublishTagContext tagContext = new PublishTagContext(pageContext);
        return TagParseHelper.parseItems(tagDocument.getItems(), tagContext);
    }

    static {
        s_oNamesRegister.register("HTML", 1);
        s_oNamesRegister.register("HTMLVALUE", 2);
        s_oNamesRegister.register("JAVASCRIPT", 3);
        s_oNamesRegister.register("JS", 3);
        s_oNamesRegister.register("XML", 4);
        s_oNamesRegister.register("INNERTEXT", 5);
        s_oNamesRegister.register("BLANKLINE", 6);
        s_oNamesRegister.register("JSON", 7);
        SPECIAL_TAG_SET = new HashSet(2);
        SPECIAL_TAG_SET.add("TRS_VARIABLE");
        SPECIAL_TAG_SET.add("TRS_ENUM");
    }
}

