/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.EnvUtil;
import com.trs.idm.util.JDK13URLCoder;
import com.trs.idm.util.JDK14URLCoder;
import com.trs.idm.util.StringHelper;
import com.trs.idm.util.StringValidator;
import com.trs.idm.util.URLCoder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlUtil {
    private static URLCoder urlCoder = EnvUtil.isJDK14OrHigher() ? new JDK14URLCoder() : new JDK13URLCoder();

    public static String getDomainByLevel(String serverName, int tldLevel) {
        if (StringHelper.isEmpty(serverName) || serverName.indexOf(".") < 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(20);
        String[] arr = serverName.split("\\.");
        int length = arr.length;
        if (length > 0 && arr[length - 1].matches("\\b\\d+\\b")) {
            return "";
        }
        if (tldLevel >= length) {
            sb.append(serverName);
        } else {
            int j = 0;
            while (j < tldLevel) {
                sb.append(".");
                sb.append(arr[j + length - tldLevel]);
                ++j;
            }
        }
        return sb.toString();
    }

    public static boolean isValidHttpUrl(String sUrl) {
        if (sUrl == null) {
            return false;
        }
        Pattern p = Pattern.compile("^(http(s?)://){1}(\\S*)$");
        Matcher m = p.matcher(sUrl);
        if (!m.matches()) {
            return false;
        }
        try {
            new URL(sUrl);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static String urlEncode(String str) {
        return UrlUtil.encode(str, "GBK");
    }

    public static String encode(String str) {
        return UrlUtil.encode(str, "UTF-8");
    }

    public static String decode(String str) {
        return UrlUtil.decode(str, "UTF-8");
    }

    public static String encode(String str, String encoding) {
        return urlCoder.encode(str, encoding);
    }

    public static String decode(String str, String encoding) {
        return urlCoder.decode(str, encoding);
    }

    public static boolean isUrlWithParam(String url) {
        if (StringHelper.isEmpty(url)) {
            return false;
        }
        int i = url.indexOf(63);
        int j = url.indexOf(61, i);
        return i > -1 && j > i + 1;
    }

    public static String getIPAddr(String urlStr) {
        if (!StringHelper.isEmpty(urlStr)) {
            String urlWithIPStr = urlStr.substring(urlStr.indexOf("://") + 3);
            return urlWithIPStr.substring(0, urlWithIPStr.indexOf(":"));
        }
        return "";
    }

    public static boolean isUrlEncoded(String urlStr) {
        return -1 != urlStr.indexOf("+") || -1 != urlStr.indexOf("%");
    }

    public static boolean validateDynamicUrl(String url) {
        if (url.endsWith(".html")) {
            return false;
        }
        if (url.endsWith(".htm")) {
            return false;
        }
        return !url.endsWith(".shtml");
    }

    public static String getDomainByLevelFromUrl(String url, int level) {
        String result = "";
        StringBuffer sb = new StringBuffer(20);
        String regex = "^(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])";
        if (level < 0 || level == 0) {
            return result;
        }
        String removerSlashUrl = StringHelper.substringByFirstOccurance(url, "//", "/");
        if (removerSlashUrl == null && (removerSlashUrl = StringHelper.substringByFirstOccurance(url, "//", "")) == null) {
            return result;
        }
        String[] colonSplitedUrl = StringHelper.split(removerSlashUrl, ":");
        String clearColonUrl = colonSplitedUrl[0];
        String[] pointSplitedUrl = StringHelper.splitAndTrim(clearColonUrl, ".");
        if (pointSplitedUrl.length < 0) {
            result = pointSplitedUrl[0];
            return result;
        }
        if (pointSplitedUrl.length > 0) {
            if (level >= pointSplitedUrl.length) {
                result = clearColonUrl;
                return result;
            }
            if (StringValidator.isMatch(clearColonUrl, regex)) {
                result = clearColonUrl;
                return result;
            }
            int j = 0;
            while (j < level) {
                sb.append(".");
                sb.append(pointSplitedUrl[j + pointSplitedUrl.length - level]);
                ++j;
            }
            if (sb.toString().indexOf(".") == 0) {
                StringBuffer sb1 = new StringBuffer();
                String temp = sb1.append(sb.toString(), 1, sb.length()).toString();
                if (StringValidator.isNumeric(StringHelper.split(temp, ".")[0])) {
                    return result;
                }
                result = temp;
                return result;
            }
            result = sb.toString();
            return result;
        }
        return result;
    }
}

