/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class OAuthAppInfoUtil {
    private static final String path = "/oauth_app.properties";
    private static Map<String, String> oAuthAppInfo = new HashMap<String, String>();
    public static final String KAIXIN_APP_API_KEY = "kaixin_app_key";
    public static final String KAIXIN_APP_API_SECRET = "kaixin_app_secret";
    public static final String KAIXIN_APP_BACK_URI = "kaixin_app_back_url";
    public static final String KAIXIN_USER_IDS_PWD = "kaixin_user_ids_pwd";
    public static OAuthAppInfoUtil instance = new OAuthAppInfoUtil();

    private OAuthAppInfoUtil() {
        try {
            InputStream in = this.getClass().getResourceAsStream(path);
            Properties props = new Properties();
            props.load(in);
            in.close();
            oAuthAppInfo.put(KAIXIN_APP_API_KEY, props.getProperty(KAIXIN_APP_API_KEY));
            oAuthAppInfo.put(KAIXIN_APP_API_SECRET, props.getProperty(KAIXIN_APP_API_SECRET));
            oAuthAppInfo.put(KAIXIN_APP_BACK_URI, props.getProperty(KAIXIN_APP_BACK_URI));
            oAuthAppInfo.put(KAIXIN_USER_IDS_PWD, props.getProperty(KAIXIN_USER_IDS_PWD));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static OAuthAppInfoUtil getInstance() {
        if (instance == null) {
            instance = new OAuthAppInfoUtil();
            return instance;
        }
        return instance;
    }

    public Map getAppBasicInfo() {
        return oAuthAppInfo;
    }

    public String getKaiXinAppKey() {
        return oAuthAppInfo.get(KAIXIN_APP_API_KEY);
    }

    public String getKaiXinAppSecret() {
        return oAuthAppInfo.get(KAIXIN_APP_API_SECRET);
    }

    public String getKaiXinAppCallBackUrl() {
        return oAuthAppInfo.get(KAIXIN_APP_BACK_URI);
    }

    public String getKaiXinUserIdsPwd() {
        return oAuthAppInfo.get(KAIXIN_USER_IDS_PWD);
    }
}

