/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.JceEncryptUtil;
import com.trs.idm.util.StringHelper;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.crypto.spec.DESKeySpec;

public class DesEncryptUtil {
    private static final String DES_ALGORITHM_NAME = "DES";
    private static final String DES_ALGORITHM_TRANSFORMATION_DEFAULT = "DES/ECB/PKCS5Padding";
    private static final String DES_KEY_DATA_PROPERTY_NAME = "desKeyData";
    private static final String SEC_CFG_FILE = "/security.ini";

    public static byte[] encrypt(byte[] toEncryptData) {
        return DesEncryptUtil.doEncrypt(DesEncryptUtil.getKey(), toEncryptData);
    }

    public static String encryptToHex(byte[] toEncryptData) {
        byte[] encryptedData = DesEncryptUtil.doEncrypt(DesEncryptUtil.getKey(), toEncryptData);
        if (encryptedData == null) {
            return "";
        }
        return StringHelper.bytesToHex(encryptedData, 0, encryptedData.length);
    }

    public static byte[] encrypt(byte[] toEncryptData, String keyResourceName, String propertyName) {
        return DesEncryptUtil.doEncrypt(DesEncryptUtil.getKeyFromResource(keyResourceName, propertyName), toEncryptData);
    }

    public static byte[] encrypt(byte[] toEncryptData, String keyData) {
        return DesEncryptUtil.doEncrypt(DesEncryptUtil.getKeyByData(keyData), toEncryptData);
    }

    public static String encryptToHex(byte[] toEncryptData, String keyResourceName, String propertyName) {
        byte[] encryptedData = DesEncryptUtil.doEncrypt(DesEncryptUtil.getKeyFromResource(keyResourceName, propertyName), toEncryptData);
        if (encryptedData == null) {
            return "";
        }
        return StringHelper.bytesToHex(encryptedData, 0, encryptedData.length);
    }

    public static String encryptToHex(byte[] toEncryptData, String keyData) {
        byte[] encryptedData = DesEncryptUtil.doEncrypt(DesEncryptUtil.getKeyByData(keyData), toEncryptData);
        if (encryptedData == null) {
            return "";
        }
        return StringHelper.bytesToHex(encryptedData, 0, encryptedData.length);
    }

    public static byte[] doEncrypt(Key key, byte[] toEncryptData, String transformation) {
        if (key == null) {
            return null;
        }
        return JceEncryptUtil.doEncrypt(key, toEncryptData, transformation);
    }

    public static byte[] doEncrypt(Key key, byte[] toEncryptData) {
        if (key == null) {
            return null;
        }
        return JceEncryptUtil.doEncrypt(key, toEncryptData, DES_ALGORITHM_TRANSFORMATION_DEFAULT);
    }

    public static byte[] decrypt(byte[] toDecryptData) {
        return JceEncryptUtil.doDecrypt(DesEncryptUtil.getKey(), toDecryptData, DES_ALGORITHM_TRANSFORMATION_DEFAULT);
    }

    public static String decryptToHex(byte[] toDecryptData) {
        byte[] decryptedData = JceEncryptUtil.doDecrypt(DesEncryptUtil.getKey(), toDecryptData, DES_ALGORITHM_TRANSFORMATION_DEFAULT);
        if (decryptedData == null) {
            return "";
        }
        return StringHelper.bytesToHex(decryptedData, 0, decryptedData.length);
    }

    public static byte[] decrypt(byte[] toDecryptData, String keyResourceName, String propertyName) {
        return JceEncryptUtil.doDecrypt(DesEncryptUtil.getKeyFromResource(keyResourceName, propertyName), toDecryptData, DES_ALGORITHM_TRANSFORMATION_DEFAULT);
    }

    public static byte[] decrypt(byte[] toDecryptData, String keyData) {
        return JceEncryptUtil.doDecrypt(DesEncryptUtil.getKeyByData(keyData), toDecryptData, DES_ALGORITHM_TRANSFORMATION_DEFAULT);
    }

    public static String decryptToHex(byte[] toDecryptData, String keyData) {
        byte[] decryptedData = JceEncryptUtil.doDecrypt(DesEncryptUtil.getKeyByData(keyData), toDecryptData, DES_ALGORITHM_TRANSFORMATION_DEFAULT);
        if (decryptedData == null) {
            return "";
        }
        return StringHelper.bytesToHex(decryptedData, 0, decryptedData.length);
    }

    public static String decryptToHex(byte[] toDecryptData, String keyResourceName, String propertyName) {
        byte[] decryptedData = JceEncryptUtil.doDecrypt(DesEncryptUtil.getKeyFromResource(keyResourceName, propertyName), toDecryptData, DES_ALGORITHM_TRANSFORMATION_DEFAULT);
        if (decryptedData == null) {
            return "";
        }
        return StringHelper.bytesToHex(decryptedData, 0, decryptedData.length);
    }

    public static byte[] doDecrypt(Key key, byte[] toDecryptData, String transformation) {
        if (key == null) {
            return null;
        }
        return JceEncryptUtil.doDecrypt(key, toDecryptData, transformation);
    }

    public static byte[] doDecrypt(Key key, byte[] toDecryptData) {
        if (key == null) {
            return null;
        }
        return JceEncryptUtil.doDecrypt(key, toDecryptData, DES_ALGORITHM_TRANSFORMATION_DEFAULT);
    }

    public static SecretKey getKey() {
        String keyData = DesEncryptUtil.getKeyDataFromResource(SEC_CFG_FILE, DES_KEY_DATA_PROPERTY_NAME);
        if (StringHelper.isEmpty(keyData)) {
            return null;
        }
        return DesEncryptUtil.getKeyByData(keyData);
    }

    public static SecretKey getKeyFromResource(String resName, String propertyName) {
        String keyData = DesEncryptUtil.getKeyDataFromResource(resName, propertyName);
        return DesEncryptUtil.getKeyByData(keyData);
    }

    public static SecretKey getKeyByData(String keyData) {
        DESKeySpec desKeySpec = null;
        try {
            desKeySpec = new DESKeySpec(keyData.getBytes());
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return JceEncryptUtil.getKey(DES_ALGORITHM_NAME, desKeySpec);
    }

    public static String getKeyDataFromResource(String resName, String propertyName) {
        return JceEncryptUtil.getKeyDataFromResource(resName, propertyName);
    }
}

