/*
 * Decompiled with CFR 0.152.
 */
package com.trs.net.ftp.impl;

import com.trs.net.ftp.FtpClient;
import com.trs.net.ftp.FtpException;
import com.trs.net.ftp.FtpFile;
import com.trs.net.ftp.FtpFileFilter;
import com.trs.net.ftp.FtpFileListParser;
import com.trs.net.ftp.FtpFilenameFilter;
import com.trs.net.ftp.FtpProgressMonitor;
import com.trs.net.ftp.FtpURL;
import com.trs.net.ftp.parser.ParserFactory;
import com.trs.net.ftp.protocol.FtpClientPI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;

public class FtpClientImpl
implements FtpClient {
    private static final String DEFAULT_ENCODING = "GBK";
    private boolean m_zSuppressException = false;
    private FtpURL m_oFtpURL;
    private FtpClientPI m_oFtpPI;
    private FtpFileListParser m_oParser;
    private String m_sEncoding;
    private String m_sGreetInfo;
    private String m_sSystemInfo;
    private String m_sErrorInfo;
    private String m_sWarningInfo;

    public FtpClientImpl(FtpURL url) {
        this.m_oFtpURL = url;
        this.m_oFtpPI = null;
    }

    public boolean getSuppressException() {
        return this.m_zSuppressException;
    }

    public void setSuppressException(boolean zSuppress) {
        this.m_zSuppressException = zSuppress;
    }

    public String getEncoding() {
        if (this.m_sEncoding == null) {
            this.m_sEncoding = DEFAULT_ENCODING;
        }
        return this.m_sEncoding;
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        "s".getBytes(encoding);
        this.m_sEncoding = encoding;
    }

    public Object getProtocolInterpreter() {
        return this.m_oFtpPI;
    }

    public FtpURL getFtpURL() {
        return this.m_oFtpURL;
    }

    public String getLastError() {
        return this.m_sErrorInfo;
    }

    public String getLastWarning() {
        return this.m_sWarningInfo;
    }

    public void open() throws IOException {
        String host = this.m_oFtpURL.getHost();
        String user = this.m_oFtpURL.getUserName();
        String pass = this.m_oFtpURL.getPassWord();
        int port = this.m_oFtpURL.getPort();
        FtpClientPI pi = new FtpClientPI();
        pi.connect(host, port, null);
        this.m_sGreetInfo = pi.getReplyString();
        pi.user(user);
        if (pi.getReplyCode1st() != 3) {
            FtpException fe = pi.newFtpException();
            FtpClientImpl.innerCloseProtocolInterpreter(pi);
            throw fe;
        }
        pi.pass(pass);
        if (pi.getReplyCode1st() != 2) {
            FtpException fe = pi.newFtpException();
            FtpClientImpl.innerCloseProtocolInterpreter(pi);
            throw fe;
        }
        if (!pi.setDataType(73)) {
            FtpException fe = pi.newFtpException();
            FtpClientImpl.innerCloseProtocolInterpreter(pi);
            throw fe;
        }
        pi.syst();
        if (pi.getReplyCode1st() == 2) {
            this.m_sSystemInfo = pi.getReplyContent();
        } else {
            this.m_sWarningInfo = pi.getReplyString();
        }
        this.m_oFtpPI = pi;
    }

    private static final void innerCloseProtocolInterpreter(FtpClientPI pi) {
        if (pi != null) {
            try {
                pi.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void close() throws IOException {
        if (this.m_oFtpPI != null) {
            this.m_oFtpPI.close();
        }
        this.m_oFtpPI = null;
        this.m_oParser = null;
        this.m_sGreetInfo = null;
        this.m_sSystemInfo = null;
        this.m_sErrorInfo = null;
        this.m_sWarningInfo = null;
    }

    public boolean isClosed() throws IOException {
        if (this.m_oFtpPI != null) {
            return !this.m_oFtpPI.isConnected();
        }
        return false;
    }

    private final void assertOpen() throws FtpException {
        if (this.m_oFtpPI == null) {
            throw new FtpException("no connection");
        }
    }

    public String getGreekInfo() throws IOException {
        if (!this.m_zSuppressException) {
            this.assertOpen();
        }
        return this.m_sGreetInfo;
    }

    public String getSystemInfo() throws IOException {
        this.assertOpen();
        if (this.m_sSystemInfo == null) {
            this.m_oFtpPI.syst();
            if (this.m_oFtpPI.getReplyCode1st() == 2) {
                this.m_sSystemInfo = this.m_oFtpPI.getReplyContent();
            } else {
                throw this.m_oFtpPI.newFtpException();
            }
        }
        return this.m_sSystemInfo;
    }

    public String getRemoteHelp() throws IOException {
        return this.getRemoteHelp(null);
    }

    public String getRemoteHelp(String cmd) throws IOException {
        this.assertOpen();
        if (cmd != null && (cmd = cmd.trim()).length() <= 0) {
            cmd = null;
        }
        this.m_oFtpPI.help(cmd);
        if (this.m_oFtpPI.getReplyCode1st() != 2) {
            throw this.m_oFtpPI.newFtpException();
        }
        return this.m_oFtpPI.getReplyContent();
    }

    public String getStatus() throws IOException {
        return this.getStatus(null);
    }

    public String getStatus(String path) throws IOException {
        this.assertOpen();
        if (path != null && (path = path.trim()).length() <= 0) {
            path = null;
        }
        this.m_oFtpPI.stat(path);
        if (this.m_oFtpPI.getReplyCode1st() != 2) {
            throw this.m_oFtpPI.newFtpException();
        }
        return this.m_oFtpPI.getReplyContent();
    }

    public Date getFileDate(String filename) throws IOException {
        throw new RuntimeException("Not implement");
    }

    public long getFileSize(String filename) throws IOException {
        throw new RuntimeException("Not implement");
    }

    public String[] listNames() throws IOException {
        return this.listNames(null, null);
    }

    public String[] listNames(String path) throws IOException {
        return this.listNames(path, null);
    }

    public String[] listNames(FtpFilenameFilter filter) throws IOException {
        return this.listNames(null, filter);
    }

    private String[] listNames(String path, FtpFilenameFilter filter) throws IOException {
        if (path != null && (path = path.trim()).length() <= 0) {
            path = null;
        }
        this.assertOpen();
        InputStream is = this.m_oFtpPI.listNames(path);
        ArrayList<String> list = new ArrayList<String>();
        try {
            InputStreamReader isr = new InputStreamReader(is, this.getEncoding());
            BufferedReader reader = new BufferedReader(isr);
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (filter != null && !filter.accept(line)) continue;
                list.add(line);
            }
            reader.close();
            reader = null;
            isr = null;
            is = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        this.m_oFtpPI.readReplyPending();
        String[] names = new String[list.size()];
        list.toArray(names);
        return names;
    }

    public FtpFileListParser getFileListParser() {
        if (this.m_oParser == null) {
            this.m_oParser = this.innerMakeFtpFileListParser();
        }
        return this.m_oParser;
    }

    private final FtpFileListParser innerMakeFtpFileListParser() {
        FtpFileListParser parser = null;
        parser = ParserFactory.newParser(this.m_sGreetInfo, this.m_sSystemInfo);
        return parser;
    }

    public FtpFileListParser setFileListParser(FtpFileListParser parser) {
        if (parser == null) {
            throw new IllegalArgumentException("parser must not null");
        }
        FtpFileListParser oldParser = this.m_oParser;
        this.m_oParser = parser;
        return oldParser;
    }

    public FtpFile[] listFiles() throws IOException {
        return this.listFiles(null, null);
    }

    public FtpFile[] listFiles(String path) throws IOException {
        return this.listFiles(path, null);
    }

    public FtpFile[] listFiles(FtpFileFilter filter) throws IOException {
        return this.listFiles(null, filter);
    }

    private FtpFile[] listFiles(String path, FtpFileFilter filter) throws IOException {
        if (path != null && (path = path.trim()).length() <= 0) {
            path = null;
        }
        this.assertOpen();
        FtpFileListParser parser = this.getFileListParser();
        InputStream is = this.m_oFtpPI.listFiles(path);
        ArrayList<FtpFile> list = new ArrayList<FtpFile>();
        try {
            InputStreamReader isr = new InputStreamReader(is, this.getEncoding());
            BufferedReader reader = new BufferedReader(isr);
            String line = null;
            while ((line = reader.readLine()) != null) {
                FtpFile file = parser.parse(line);
                if (file == null || filter != null && !filter.accept(file)) continue;
                list.add(file);
            }
            reader.close();
            reader = null;
            isr = null;
            is = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        this.m_oFtpPI.readReplyPending();
        FtpFile[] files = new FtpFile[list.size()];
        list.toArray(files);
        return files;
    }

    public String getDirectory() throws IOException {
        this.assertOpen();
        this.m_oFtpPI.pwd();
        if (this.m_oFtpPI.getReplyCode1st() == 2) {
            String sReply = this.m_oFtpPI.getReplyLine();
            int index1 = sReply.indexOf(34);
            int index2 = sReply.lastIndexOf(34);
            if (index2 > index1 && index1 > 0) {
                return sReply.substring(index1 + 1, index2);
            }
        }
        throw this.m_oFtpPI.newFtpException();
    }

    public boolean setDirectory(String sDirectory) throws IOException {
        if (sDirectory == null) {
            throw new IllegalArgumentException("directory must not null");
        }
        this.assertOpen();
        int iReplyCode = this.m_oFtpPI.cwd(sDirectory);
        if (iReplyCode == 250) {
            return true;
        }
        throw this.m_oFtpPI.newFtpException();
    }

    public boolean insureDirectory(String sDirectory) throws IOException {
        if (sDirectory == null || sDirectory.length() == 0) {
            return true;
        }
        int iReplyCode = this.m_oFtpPI.cwd(sDirectory);
        if (iReplyCode == 250) {
            return true;
        }
        if (iReplyCode == 550) {
            int iIndex1 = sDirectory.lastIndexOf(47, sDirectory.length() - 2);
            if (iIndex1 != -1) {
                String sToChange = sDirectory.substring(0, iIndex1 + 1);
                this.insureDirectory(sToChange);
            }
            String sToCreate = sDirectory.substring(iIndex1 + 1);
            this.createDirectory(sToCreate);
            if (this.m_oFtpPI.cwd(sToCreate) == 250) {
                return true;
            }
        }
        throw this.m_oFtpPI.newFtpException();
    }

    public boolean createDirectory(String sDirectory) throws IOException {
        if (sDirectory == null || sDirectory.length() <= 0) {
            throw new IllegalArgumentException("directory must not null");
        }
        if (sDirectory.charAt(sDirectory.length() - 1) == '/') {
            sDirectory = sDirectory.substring(0, sDirectory.length() - 1);
        }
        if (sDirectory.length() <= 0) {
            throw new IllegalArgumentException("directory must not null");
        }
        this.assertOpen();
        this.m_oFtpPI.mkd(sDirectory);
        if (this.m_oFtpPI.getReplyCode1st() == 2) {
            return true;
        }
        throw this.m_oFtpPI.newFtpException();
    }

    public boolean deleteDirectory(String sDirectory) throws IOException {
        if (sDirectory == null) {
            throw new IllegalArgumentException("directory must not null");
        }
        this.assertOpen();
        this.m_oFtpPI.rmd(sDirectory);
        if (this.m_oFtpPI.getReplyCode1st() == 2) {
            return true;
        }
        throw this.m_oFtpPI.newFtpException();
    }

    public boolean deleteDirectory(String sDirectory, boolean zRecursive) throws IOException {
        throw new RuntimeException("Not implement");
    }

    public boolean renameDirectory(String _old, String _new) throws IOException {
        return this.renameFile(_old, _new);
    }

    public boolean createFile(String path) throws IOException {
        throw new RuntimeException("Not implement");
    }

    public boolean deleteFile(String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path must not null");
        }
        this.assertOpen();
        this.m_oFtpPI.dele(path);
        if (this.m_oFtpPI.getReplyCode1st() == 2) {
            return true;
        }
        throw this.m_oFtpPI.newFtpException();
    }

    public boolean renameFile(String _old, String _new) throws IOException {
        if (_old == null) {
            throw new IllegalArgumentException("path must not null");
        }
        if (_new == null) {
            throw new IllegalArgumentException("path must not null");
        }
        this.assertOpen();
        this.m_oFtpPI.rnfr(_old);
        if (this.m_oFtpPI.getReplyCode1st() != 3) {
            if (this.m_zSuppressException) {
                this.m_sErrorInfo = this.m_oFtpPI.getReplyLine();
                return false;
            }
            throw this.m_oFtpPI.newFtpException();
        }
        this.m_oFtpPI.rnto(_new);
        if (this.m_oFtpPI.getReplyCode1st() != 2) {
            if (this.m_zSuppressException) {
                this.m_sErrorInfo = this.m_oFtpPI.getReplyLine();
                return false;
            }
            throw this.m_oFtpPI.newFtpException();
        }
        return true;
    }

    public boolean download(String src, File dst) throws IOException {
        return this.download(src, dst, null, 0);
    }

    public boolean download(String src, File dst, FtpProgressMonitor fpm) throws IOException {
        return this.download(src, dst, fpm, 0);
    }

    public boolean download(String src, File dst, FtpProgressMonitor fpm, int mode) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException("remote file must not null");
        }
        long skip = 0L;
        boolean result = false;
        OutputStream fos = null;
        try {
            switch (mode) {
                case 0: {
                    skip = 0L;
                    fos = new FileOutputStream(dst);
                    break;
                }
                case 1: {
                    skip = 0L;
                    fos = new FileOutputStream(dst.getAbsolutePath(), true);
                    break;
                }
                case 2: {
                    if (dst.exists()) {
                        skip = dst.length();
                    }
                    fos = new FileOutputStream(dst.getAbsolutePath(), true);
                    break;
                }
                default: {
                    throw new FtpException("not support mode");
                }
            }
            result = this.download(src, fos, fpm, skip);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public boolean download(String src, OutputStream fos, FtpProgressMonitor fpm, long skip) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException("remote file must not null");
        }
        this.assertOpen();
        InputStream is = this.m_oFtpPI.retrieveFile(src, skip);
        if (is != null) {
            try {
                int len = 0;
                byte[] buff = new byte[this.m_oFtpPI.getBufferSize()];
                while ((len = is.read(buff)) != -1) {
                    fos.write(buff, 0, len);
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        this.m_oFtpPI.readReplyPending();
        return true;
    }

    public boolean upload(File src, String dst) throws IOException {
        return this.upload(src, dst, null, 0);
    }

    public boolean upload(File src, String dst, FtpProgressMonitor fpm) throws IOException {
        return this.upload(src, dst, fpm, 0);
    }

    public boolean upload(File src, String dst, FtpProgressMonitor fpm, int mode) throws IOException {
        boolean result = false;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(src);
            result = this.upload(fis, dst, fpm, mode);
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public boolean upload(InputStream fis, String dst, FtpProgressMonitor fpm, int mode) throws IOException {
        if (fis == null) {
            throw new IllegalArgumentException("source stream must not null");
        }
        if (dst == null) {
            throw new IllegalArgumentException("remote file must not null");
        }
        this.assertOpen();
        OutputStream os = null;
        try {
            switch (mode) {
                case 0: {
                    os = this.m_oFtpPI.storeFile(dst, 0);
                    break;
                }
                case 1: {
                    os = this.m_oFtpPI.appendFile(dst);
                    break;
                }
                case 2: {
                    long skip = this.getFileSize(dst);
                    fis.skip(skip);
                    os = this.m_oFtpPI.appendFile(dst);
                    break;
                }
                default: {
                    throw new FtpException("not support mode");
                }
            }
            if (os != null) {
                try {
                    int len = 0;
                    byte[] buff = new byte[this.m_oFtpPI.getBufferSize()];
                    while ((len = fis.read(buff)) != -1) {
                        os.write(buff, 0, len);
                    }
                }
                finally {
                    try {
                        os.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.m_oFtpPI.readReplyPending();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }
}

