/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class FileSystemResource
extends AbstractResource {
    private final File file;

    public FileSystemResource(File file) {
        this.file = file;
    }

    public FileSystemResource(String path) {
        this.file = new File(path);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public URL getURL() throws IOException {
        return new URL("file:" + this.file.getAbsolutePath());
    }

    public File getFile() {
        return this.file;
    }

    public Resource createRelative(String relativePath) {
        File parent = this.file.getParentFile();
        if (parent != null) {
            return new FileSystemResource(new File(parent, relativePath));
        }
        return new FileSystemResource(relativePath);
    }

    public String getFilename() {
        return this.file.getName();
    }

    public String getDescription() {
        return "file [" + this.file.getAbsolutePath() + "]";
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof FileSystemResource && this.file.equals(((FileSystemResource)obj).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

