/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.providers;

import java.io.StringWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.RPCRouter;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.util.Provider;

public class RPCJavaProvider
implements Provider {
    protected DeploymentDescriptor dd;
    protected Envelope envelope;
    protected Call call;
    protected String methodName;
    protected String targetObjectURI;
    protected HttpServlet servlet;
    protected HttpSession session;
    protected Object targetObject;

    public void locate(DeploymentDescriptor dd, Envelope env, Call call, String methodName, String targetObjectURI, SOAPContext reqContext) throws SOAPException {
        HttpServlet servlet = (HttpServlet)reqContext.getProperty(Constants.BAG_HTTPSERVLET);
        HttpSession session = (HttpSession)reqContext.getProperty(Constants.BAG_HTTPSESSION);
        this.dd = dd;
        this.envelope = env;
        this.call = call;
        this.methodName = methodName;
        this.targetObjectURI = targetObjectURI;
        this.servlet = servlet;
        this.session = session;
        ServletConfig config = null;
        ServletContext context = null;
        if (servlet != null) {
            config = servlet.getServletConfig();
        }
        if (config != null) {
            context = config.getServletContext();
        }
        ServiceManager serviceManager = ServerHTTPUtils.getServiceManagerFromContext(context);
        if (!RPCRouter.validCall(dd, call)) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Method '" + call.getMethodName() + "' is not supported.");
        }
        this.targetObject = ServerHTTPUtils.getTargetObject(serviceManager, dd, targetObjectURI, servlet, session, reqContext, context);
    }

    public void invoke(SOAPContext reqContext, SOAPContext resContext) throws SOAPException {
        try {
            Response resp = RPCRouter.invoke(this.dd, this.call, this.targetObject, reqContext, resContext);
            Envelope env = resp.buildEnvelope();
            StringWriter sw = new StringWriter(1024);
            env.marshall(sw, this.call.getSOAPMappingRegistry(), resContext);
            resContext.setRootPart(sw.toString(), "text/xml;charset=utf-8");
        }
        catch (Exception e) {
            if (e instanceof SOAPException) {
                throw (SOAPException)e;
            }
            throw new SOAPException(Constants.FAULT_CODE_SERVER, e.toString(), e);
        }
    }
}

