/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.comm.Protocol;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.integrationtests.TestConfig;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.PartETag;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import junit.framework.Assert;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class TestUtils {
    private static final byte[] ALPHABETS = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final int MAX_RANDOM_LENGTH = 0x40000000;
    private static Random rand = new Random();
    private static HttpClient httpClient = null;

    static {
        httpClient = new DefaultHttpClient();
        Scheme sch = new Scheme(Protocol.HTTPS.toString(), 443, (SchemeSocketFactory)TestUtils.getSSLSocketFactory());
        httpClient.getConnectionManager().getSchemeRegistry().register(sch);
    }

    private static SSLSocketFactory getSSLSocketFactory() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(null, trustAllCerts, null);
            SSLSocketFactory ssf = new SSLSocketFactory(sslcontext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return ssf;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte pickupAlphabet() {
        int idx = new Random().nextInt(ALPHABETS.length);
        return ALPHABETS[idx];
    }

    public static String genRandomString(int length) {
        byte[] data = new byte[length];
        int i = 0;
        while (i < data.length) {
            data[i] = TestUtils.pickupAlphabet();
            ++i;
        }
        return new String(data);
    }

    public static OSSClient createClientByLocation(String location) {
        OSSClient client = null;
        if ("oss-cn-beijing".equals(location)) {
            client = new OSSClient("http://oss-cn-beijing.aliyuncs.com", "<valid access id>", "<valid access key>");
        } else if ("oss-cn-hangzhou".equals(location)) {
            client = new OSSClient("https://oss-cn-hangzhou.aliyuncs.com", "k6v3sL0ZTaIaVvMs", "aIEyqeEnFhBi9LqsODzFaHP9lPodTQ");
        } else if ("oss-cn-hongkong".equals(location)) {
            client = new OSSClient("http://oss-cn-hongkong.aliyuncs.com", "<valid access id>", "<valid access key>");
        } else if ("oss-cn-qingdao".equals(location)) {
            client = new OSSClient("http://oss-cn-qingdao.aliyuncs.com", "<valid access id>", "<valid access key>");
        } else if ("oss-cn-shenzhen".equals(location)) {
            client = new OSSClient("http://oss-cn-shenzhen.aliyuncs.com", "<valid access id>", "<valid access key>");
        } else {
            throw new IllegalArgumentException("Unsupported location " + location);
        }
        return client;
    }

    public static String buildObjectKey(String keyPrefix, int seqNum) {
        return String.valueOf(keyPrefix) + seqNum;
    }

    public static void waitAll(Thread[] targets) {
        int i = 0;
        while (i < targets.length) {
            targets[i].start();
            ++i;
        }
        i = 0;
        while (i < targets.length) {
            try {
                targets[i].join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
    }

    public static String genFixedLengthFile(long fixedLength) throws IOException {
        TestUtils.ensureDirExist(TestConfig.UPLOAD_DIRECOTRY);
        String filePath = String.valueOf(TestConfig.UPLOAD_DIRECOTRY) + System.currentTimeMillis();
        RandomAccessFile raf = new RandomAccessFile(filePath, "rw");
        FileChannel fc = raf.getChannel();
        MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_WRITE, 0L, fixedLength);
        try {
            int i = 0;
            while ((long)i < fixedLength) {
                mbb.put(TestUtils.pickupAlphabet());
                ++i;
            }
            String string = filePath;
            return string;
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (raf != null) {
                raf.close();
            }
        }
    }

    public static String buildFilePath() {
        TestUtils.ensureDirExist(TestConfig.DOWNLOAD_DIRECOTRY);
        return String.valueOf(TestConfig.DOWNLOAD_DIRECOTRY) + System.currentTimeMillis();
    }

    public static String genRandomLengthFile() throws IOException {
        TestUtils.ensureDirExist(TestConfig.UPLOAD_DIRECOTRY);
        String filePath = String.valueOf(TestConfig.UPLOAD_DIRECOTRY) + System.currentTimeMillis();
        RandomAccessFile raf = new RandomAccessFile(filePath, "rw");
        FileChannel fc = raf.getChannel();
        long fileLength = rand.nextInt(0x40000000);
        MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_WRITE, 0L, fileLength);
        try {
            int i = 0;
            while ((long)i < fileLength) {
                mbb.put(TestUtils.pickupAlphabet());
                ++i;
            }
            String string = filePath;
            return string;
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (raf != null) {
                raf.close();
            }
        }
    }

    public static boolean batchPutObject(OSSClient client, String bucketName, List<String> objects) {
        byte[] buf = new byte[1024];
        int i = 0;
        while (i < buf.length) {
            buf[i] = 97;
            ++i;
        }
        for (String o : objects) {
            try {
                client.putObject(bucketName, o, new ByteArrayInputStream(buf), null);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static InputStream genFixedLengthInputStream(long fixedLength) {
        byte[] buf = new byte[(int)fixedLength];
        int i = 0;
        while (i < buf.length) {
            buf[i] = 97;
            ++i;
        }
        return new ByteArrayInputStream(buf);
    }

    public static void ensureDirExist(String dir) {
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public static void removeFiles(List<File> files) {
        for (File f : files) {
            if (f == null || !f.exists()) continue;
            f.delete();
        }
    }

    public static void removeFile(String filePath) {
        File toRemove = new File(filePath);
        if (toRemove != null && toRemove.exists()) {
            toRemove.delete();
        }
    }

    public static String claimUploadId(OSSClient client, String bucketName, String key) {
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(bucketName, key);
        InitiateMultipartUploadResult result = client.initiateMultipartUpload(request);
        Assert.assertEquals((String)bucketName, (String)result.getBucketName());
        Assert.assertEquals((String)key, (String)result.getKey());
        return result.getUploadId();
    }

    public static String calcMultipartsETag(List<PartETag> eTags) {
        StringBuffer concatedEtags = new StringBuffer();
        for (PartETag e : eTags) {
            concatedEtags.append(e.getETag());
        }
        String md5Digest = BinaryUtil.encodeMD5(concatedEtags.toString().getBytes());
        int partNumber = eTags.size();
        String finalETag = String.format("%s-%d", md5Digest, partNumber);
        return finalETag;
    }

    public static String composeLocation(String endpoint, String bucketName, String key) {
        try {
            URI baseUri = URI.create(endpoint);
            URI resultUri = new URI(baseUri.getScheme(), null, String.valueOf(bucketName) + "." + baseUri.getHost(), baseUri.getPort(), String.format("/%s", HttpUtil.urlEncode(key, "utf-8")), null, null);
            return URLDecoder.decode(resultUri.toString(), "utf-8");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static String composeLocation(OSSClient client, String endpoint, String bucketName, String key) {
        try {
            URI baseUri = URI.create(endpoint);
            URI resultUri = null;
            resultUri = client.getClientConfiguration().isSLDEnabled() ? new URI(baseUri.getScheme(), null, baseUri.getHost(), baseUri.getPort(), String.format("/%s/%s", bucketName, HttpUtil.urlEncode(key, "utf-8")), null, null) : new URI(baseUri.getScheme(), null, String.valueOf(bucketName) + "." + baseUri.getHost(), baseUri.getPort(), String.format("/%s", HttpUtil.urlEncode(key, "utf-8")), null, null);
            return URLDecoder.decode(resultUri.toString(), "utf-8");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static void waitForCacheExpiration(int durationSeconds) {
        try {
            Thread.sleep(durationSeconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static OSSClient createSessionClient(List<String> actions, List<String> resources) {
        String tokenPolicy = TestUtils.jsonizeTokenPolicy(actions, resources, true);
        StsToken token = TestUtils.getStsToken("1287905056319499", "testuser1", 3600L, tokenPolicy);
        return new OSSClient("http://oss-test.aliyun-inc.com", token.accessKeyId, token.secretAccessKey, token.securityToken, new ClientConfiguration().setSupportCname(false).setSLDEnabled(true));
    }

    public static String jsonizeTokenPolicy(List<String> actions, List<String> resources, boolean allow) {
        JSONObject stmtJsonObject = new JSONObject();
        stmtJsonObject.put((Object)"Action", actions);
        stmtJsonObject.put((Object)"Resource", resources);
        stmtJsonObject.put((Object)"Effect", (Object)(allow ? "Allow" : "Deny"));
        JSONArray stmtJsonArray = new JSONArray();
        stmtJsonArray.add(0, (Object)stmtJsonObject);
        JSONObject policyJsonObject = new JSONObject();
        policyJsonObject.put((Object)"Version", (Object)"1");
        policyJsonObject.put((Object)"Statement", (Object)stmtJsonArray);
        return policyJsonObject.toString();
    }

    public static StsToken getStsToken(String grantor, String grantee, long durationSeconds, String policy) {
        try {
            URI apiUri = new URI(Protocol.HTTPS.toString(), null, "10.101.88.247", 8200, "/api/GetFederationToken", null, null);
            HttpPost httpPost = new HttpPost(apiUri);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("STSVERSION", "1"));
            nvps.add(new BasicNameValuePair("CALLERUID", grantor));
            nvps.add(new BasicNameValuePair("GRANTEE", grantee));
            nvps.add(new BasicNameValuePair("DURATIONSECONDS", String.valueOf(durationSeconds)));
            nvps.add(new BasicNameValuePair("POLICY", policy));
            nvps.add(new BasicNameValuePair("APIUSERNAME", "pop"));
            nvps.add(new BasicNameValuePair("APIPASSWORD", "poppassword"));
            nvps.add(new BasicNameValuePair("MFAPresent", "false"));
            nvps.add(new BasicNameValuePair("OwnerId", grantor));
            nvps.add(new BasicNameValuePair("CallerType", "customer"));
            nvps.add(new BasicNameValuePair("ProxyTrustTransportInfo", "false"));
            nvps.add(new BasicNameValuePair("CallerIp", "127.0.0.1"));
            nvps.add(new BasicNameValuePair("ProxyCallerIp", "127.0.0.1"));
            nvps.add(new BasicNameValuePair("ProxyCallerSecurityTransport", "false"));
            nvps.add(new BasicNameValuePair("callerSecurityTransport", "true"));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            InputStream responseBody = httpResponse.getEntity().getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader(responseBody));
            String line = null;
            StringBuilder tokenString = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                tokenString.append(line);
                System.out.println(line);
            }
            JSONObject tokenJsonObject = JSONObject.fromObject((Object)tokenString.toString());
            JSONObject credsJsonObjson = tokenJsonObject.getJSONObject("Credentials");
            String accessKeyId = credsJsonObjson.getString("AccessKeyId");
            String secretAccessKey = credsJsonObjson.getString("AccessKeySecret");
            String securityToken = credsJsonObjson.getString("SecurityToken");
            return new StsToken(accessKeyId, secretAccessKey, securityToken);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void __main(String[] args) {
        ArrayList<String> actions = new ArrayList<String>();
        actions.add("oss:GetObject");
        actions.add("oss:PutObject");
        ArrayList<String> resources = new ArrayList<String>();
        resources.add("acs:oss:*:1287905056319499:test-sts/*");
        resources.add("acs:oss:*:1287905056319499:test-sts/abc*");
        String tokenPolicy = TestUtils.jsonizeTokenPolicy(actions, resources, true);
        TestUtils.getStsToken("1287905056319499", "testuser1", 3600L, tokenPolicy);
    }

    static class StsToken {
        private String accessKeyId;
        private String secretAccessKey;
        private String securityToken;

        public StsToken(String accessKeyId, String secretAccessKey, String securityToken) {
            this.accessKeyId = accessKeyId;
            this.secretAccessKey = secretAccessKey;
            this.securityToken = securityToken;
        }

        public String getAccessKeyId() {
            return this.accessKeyId;
        }

        public void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public String getSecretAccessKey() {
            return this.secretAccessKey;
        }

        public void setSecretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
        }

        public String getSecurityToken() {
            return this.securityToken;
        }

        public void setSecurityToken(String securityToken) {
            this.securityToken = securityToken;
        }
    }
}

