/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.maps;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.maps.Column;
import org.xmlmiddleware.xmldbms.maps.ColumnMap;
import org.xmlmiddleware.xmldbms.maps.LinkInfo;
import org.xmlmiddleware.xmldbms.maps.MapBase;
import org.xmlmiddleware.xmldbms.maps.PropertyTableMap;
import org.xmlmiddleware.xmldbms.maps.RelatedClassTableMap;
import org.xmlmiddleware.xmldbms.maps.Table;
import org.xmlmiddleware.xmlutils.XMLName;

public class ClassTableMap
extends MapBase {
    private Table table;
    private Table baseTable;
    private LinkInfo baseLinkInfo;
    private XMLName elementTypeName;
    private Hashtable columnMaps = new Hashtable();
    private Vector relatedClassTableMaps = new Vector();
    private Hashtable propTableMaps = new Hashtable();

    private ClassTableMap(Table table) {
        this.table = table;
    }

    public static ClassTableMap create(Table table) {
        MapBase.checkArgNull(table, "table");
        return new ClassTableMap(table);
    }

    public final Table getTable() {
        return this.table;
    }

    public final Table getBaseTable() {
        return this.baseTable;
    }

    public void setBaseTable(Table table) {
        this.baseTable = table;
        if (table == null) {
            this.baseLinkInfo = null;
        }
    }

    public final LinkInfo getBaseLinkInfo() {
        return this.baseLinkInfo;
    }

    public void setBaseLinkInfo(LinkInfo linkInfo) {
        if (this.baseTable == null) {
            throw new IllegalStateException("Cannot call ClassTableMap.setUseBaseTable() if the base table is null.");
        }
        this.baseLinkInfo = linkInfo;
    }

    public final XMLName getElementTypeName() {
        return this.elementTypeName;
    }

    public void setElementTypeName(String string, String string2) throws XMLMiddlewareException {
        this.setElementTypeName(XMLName.create(string, string2));
    }

    public void setElementTypeName(XMLName xMLName) throws XMLMiddlewareException {
        MapBase.checkArgNull(xMLName, "elementTypeName");
        this.elementTypeName = xMLName;
    }

    public final ColumnMap getColumnMap(String string) {
        MapBase.checkArgNull(string, "columnName");
        return (ColumnMap)this.columnMaps.get(string);
    }

    public final Enumeration getColumnMaps() {
        return this.columnMaps.elements();
    }

    public ColumnMap createColumnMap(Column column) {
        MapBase.checkArgNull(column, "column");
        String string = column.getName();
        ColumnMap columnMap = (ColumnMap)this.columnMaps.get(string);
        if (columnMap == null) {
            columnMap = ColumnMap.create(column);
            this.columnMaps.put(string, columnMap);
        }
        return columnMap;
    }

    public void addColumnMap(ColumnMap columnMap) throws XMLMiddlewareException {
        MapBase.checkArgNull(columnMap, "columnMap");
        String string = columnMap.getColumn().getName();
        Object v = this.columnMaps.get(string);
        if (v != null) {
            throw new XMLMiddlewareException("Column " + string + " already mapped.");
        }
        this.columnMaps.put(string, columnMap);
    }

    public void removeColumnMap(String string) throws XMLMiddlewareException {
        MapBase.checkArgNull(string, "columnName");
        Object v = this.columnMaps.remove(string);
        if (v == null) {
            throw new XMLMiddlewareException("Column " + string + " not mapped.");
        }
    }

    public void removeAllColumnMaps() {
        this.columnMaps.clear();
    }

    public final Enumeration getRelatedClassTableMap(String string, String string2, String string3, String string4) {
        Vector<RelatedClassTableMap> vector = new Vector<RelatedClassTableMap>();
        String string5 = Table.getHashName(string, string2, string3, string4);
        int n = 0;
        while (n < this.relatedClassTableMaps.size()) {
            RelatedClassTableMap relatedClassTableMap = (RelatedClassTableMap)this.relatedClassTableMaps.elementAt(n);
            if (relatedClassTableMap.getClassTableMap().getTable().getHashName().equals(string5)) {
                vector.addElement(relatedClassTableMap);
            }
            ++n;
        }
        return vector.elements();
    }

    public final Enumeration getRelatedClassTableMaps() {
        return this.relatedClassTableMaps.elements();
    }

    public void addRelatedClassTableMap(RelatedClassTableMap relatedClassTableMap) {
        MapBase.checkArgNull(relatedClassTableMap, "relatedClassTableMap");
        this.relatedClassTableMaps.addElement(relatedClassTableMap);
    }

    public void removeRelatedClassTableMaps(String string, String string2, String string3, String string4) throws XMLMiddlewareException {
        String string5 = Table.getHashName(string, string2, string3, string4);
        int n = 0;
        while (n < this.relatedClassTableMaps.size()) {
            RelatedClassTableMap relatedClassTableMap = (RelatedClassTableMap)this.relatedClassTableMaps.elementAt(n);
            if (relatedClassTableMap.getClassTableMap().getTable().getHashName().equals(string5)) {
                this.relatedClassTableMaps.removeElementAt(n);
            }
            ++n;
        }
    }

    public void removeAllRelatedClassTableMaps() {
        this.relatedClassTableMaps.removeAllElements();
    }

    public final PropertyTableMap getPropertyTableMap(String string, String string2, String string3, String string4) {
        return (PropertyTableMap)this.propTableMaps.get(Table.getHashName(string, string2, string3, string4));
    }

    public final Enumeration getPropertyTableMaps() {
        return this.propTableMaps.elements();
    }

    public PropertyTableMap createPropertyTableMap(Table table) {
        MapBase.checkArgNull(table, "table");
        String string = table.getHashName();
        PropertyTableMap propertyTableMap = (PropertyTableMap)this.propTableMaps.get(string);
        if (propertyTableMap == null) {
            propertyTableMap = PropertyTableMap.create(table);
            this.propTableMaps.put(string, propertyTableMap);
        }
        return propertyTableMap;
    }

    public void addPropertyTableMap(PropertyTableMap propertyTableMap) throws XMLMiddlewareException {
        MapBase.checkArgNull(propertyTableMap, "propTableMap");
        String string = propertyTableMap.getTable().getHashName();
        Object v = this.propTableMaps.get(string);
        if (v != null) {
            throw new XMLMiddlewareException("Property table " + propertyTableMap.getTable().getUniversalName() + " already mapped.");
        }
        this.propTableMaps.put(string, propertyTableMap);
    }

    public void removePropertyTableMap(String string, String string2, String string3, String string4) throws XMLMiddlewareException {
        Object v = this.propTableMaps.remove(Table.getHashName(string, string2, string3, string4));
        if (v == null) {
            throw new XMLMiddlewareException("Property table " + Table.getUniversalName(string, string2, string3, string4) + " not mapped.");
        }
    }

    public void removeAllPropertyTableMaps() {
        this.propTableMaps.clear();
    }
}

