/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.filters;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlmiddleware.xmldbms.filters.FilterBase;
import org.xmlmiddleware.xmldbms.filters.FilterConditions;
import org.xmlmiddleware.xmldbms.filters.FilterConst;
import org.xmlmiddleware.xmldbms.filters.FilterSet;
import org.xmlmiddleware.xmldbms.filters.RelatedTableFilter;
import org.xmlmiddleware.xmldbms.filters.ResultSetFilter;
import org.xmlmiddleware.xmldbms.filters.RootFilter;
import org.xmlmiddleware.xmldbms.filters.TableFilter;
import org.xmlmiddleware.xmldbms.maps.Table;
import org.xmlmiddleware.xmlutils.XMLName;
import org.xmlmiddleware.xmlutils.XMLWriter;

public class FilterSerializer
extends XMLWriter {
    private static String FILTERSDTD = "filters.dtd";
    private FilterSet filterSet;
    private Hashtable uris;
    private Hashtable prefixes;

    public FilterSerializer() {
        this.allocateAttrs(5);
    }

    public FilterSerializer(Writer writer) {
        super(writer);
        this.allocateAttrs(5);
    }

    public void setWriter(Writer writer) {
        this.setWriter(writer);
    }

    public void serialize(FilterSet filterSet) throws IOException {
        this.filterSet = filterSet;
        this.serialize(null, null);
    }

    public void serialize(FilterSet filterSet, String string, String string2) throws IOException {
        if (filterSet == null) {
            return;
        }
        this.filterSet = filterSet;
        if (string == null) {
            string = FILTERSDTD;
        }
        this.serialize(string, string2);
    }

    private void serialize(String string, String string2) throws IOException {
        this.writeFilterSetStart(string, string2);
        this.writeOptions();
        this.writeFilters();
        this.writeFilterSetEnd();
    }

    private void writeFilter(FilterBase filterBase) throws IOException {
        this.writeElementStart(FilterConst.ELEM_FILTER, 0, false);
        if (filterBase instanceof RootFilter) {
            this.writeRootFilter((RootFilter)filterBase);
        } else {
            this.writeResultSetFilter((ResultSetFilter)filterBase);
        }
        this.writeTableFilters(filterBase);
        this.writeElementEnd(FilterConst.ELEM_FILTER);
    }

    private void writeFilterConditions(FilterConditions filterConditions) throws IOException {
        this.writeTable(filterConditions.getTable());
        Vector vector = filterConditions.getConditions();
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            this.writeWhere(string);
            ++n;
        }
    }

    private void writeFilters() throws IOException {
        this.writeElementStart(FilterConst.ELEM_FILTERS, 0, false);
        Vector vector = this.filterSet.getFilters();
        int n = 0;
        while (n < vector.size()) {
            FilterBase filterBase = (FilterBase)vector.elementAt(n);
            this.writeFilter(filterBase);
            ++n;
        }
        this.writeElementEnd(FilterConst.ELEM_FILTERS);
    }

    private void writeFilterSetEnd() throws IOException {
        this.writeElementEnd(FilterConst.ELEM_FILTERSET);
    }

    private void writeFilterSetStart(String string, String string2) throws IOException {
        this.attrs[0] = FilterConst.ATTR_VERSION;
        this.values[0] = FilterConst.DEF_VERSION;
        this.attrs[1] = "xmlns";
        this.values[1] = FilterConst.URI_FILTERSV2;
        this.writeXMLDecl();
        this.writeDOCTYPE(FilterConst.ELEM_FILTERSET, string, string2);
        this.writeElementStart(FilterConst.ELEM_FILTERSET, 2, false);
    }

    private void writeNamespaces() throws IOException {
        Hashtable hashtable = this.filterSet.getNamespaceURIs();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.attrs[0] = FilterConst.ATTR_PREFIX;
            this.values[0] = string;
            this.attrs[1] = FilterConst.ATTR_URI;
            this.values[1] = (String)hashtable.get(string);
            this.writeElementStart(FilterConst.ELEM_NAMESPACE, 2, true);
        }
    }

    private void writeOptions() throws IOException {
        this.writeElementStart(FilterConst.ELEM_OPTIONS, 0, false);
        this.writeNamespaces();
        this.writeWrappers();
        this.writeElementEnd(FilterConst.ELEM_OPTIONS);
    }

    private void writeRelatedTableFilter(RelatedTableFilter relatedTableFilter) throws IOException {
        this.attrs[0] = FilterConst.ATTR_PARENTKEY;
        this.values[0] = relatedTableFilter.getParentKeyName();
        this.attrs[1] = FilterConst.ATTR_CHILDKEY;
        this.values[1] = relatedTableFilter.getChildKeyName();
        this.writeElementStart(FilterConst.ELEM_RELATEDTABLEFILTER, 2, false);
        this.writeFilterConditions(relatedTableFilter);
        this.writeElementEnd(FilterConst.ELEM_RELATEDTABLEFILTER);
    }

    private void writeResultSetFilter(ResultSetFilter resultSetFilter) throws IOException {
        int n = 0;
        String string = resultSetFilter.getResultSetName();
        if (string != null && !string.equals(FilterConst.DEF_NAME)) {
            this.attrs[n] = FilterConst.ATTR_NAME;
            this.values[n++] = string;
        }
        if ((string = resultSetFilter.getDatabaseName()) != null && !string.equals(FilterConst.DEF_DATABASE)) {
            this.attrs[n] = FilterConst.ATTR_DATABASE;
            this.values[n++] = string;
        }
        if ((string = resultSetFilter.getCatalogName()) != null) {
            this.attrs[n] = FilterConst.ATTR_CATALOG;
            this.values[n++] = string;
        }
        if ((string = resultSetFilter.getSchemaName()) != null) {
            this.attrs[n] = FilterConst.ATTR_SCHEMA;
            this.values[n++] = string;
        }
        this.attrs[n] = FilterConst.ATTR_TABLE;
        this.values[n++] = resultSetFilter.getTableName();
        this.writeElementStart(FilterConst.ELEM_RESULTSETINFO, n, true);
    }

    private void writeRootFilter(RootFilter rootFilter) throws IOException {
        this.writeElementStart(FilterConst.ELEM_ROOTFILTER, 0, false);
        this.writeFilterConditions(rootFilter.getRootFilterConditions());
        this.writeElementEnd(FilterConst.ELEM_ROOTFILTER);
    }

    private void writeTable(Table table) throws IOException {
        int n = 0;
        String string = table.getDatabaseName();
        if (string != null && !string.equals(FilterConst.DEF_DATABASE)) {
            this.attrs[n] = FilterConst.ATTR_DATABASE;
            this.values[n++] = string;
        }
        if ((string = table.getCatalogName()) != null) {
            this.attrs[n] = FilterConst.ATTR_CATALOG;
            this.values[n++] = string;
        }
        if ((string = table.getSchemaName()) != null) {
            this.attrs[n] = FilterConst.ATTR_SCHEMA;
            this.values[n++] = string;
        }
        this.attrs[n] = FilterConst.ATTR_NAME;
        this.values[n++] = table.getTableName();
        this.writeElementStart(FilterConst.ELEM_TABLE, n, true);
    }

    private void writeTableFilter(TableFilter tableFilter) throws IOException {
        this.writeElementStart(FilterConst.ELEM_TABLEFILTER, 0, false);
        this.writeTable(tableFilter.getTable());
        Enumeration enumeration = tableFilter.getRelatedTableFilters();
        while (enumeration.hasMoreElements()) {
            this.writeRelatedTableFilter((RelatedTableFilter)enumeration.nextElement());
        }
        this.writeElementEnd(FilterConst.ELEM_TABLEFILTER);
    }

    private void writeTableFilters(FilterBase filterBase) throws IOException {
        Enumeration enumeration = filterBase.getTableFilters();
        while (enumeration.hasMoreElements()) {
            this.writeTableFilter((TableFilter)enumeration.nextElement());
        }
    }

    private void writeWhere(String string) throws IOException {
        this.attrs[0] = FilterConst.ATTR_CONDITION;
        this.values[0] = string;
        this.writeElementStart(FilterConst.ELEM_WHERE, 1, true);
    }

    private void writeWrappers() throws IOException {
        Vector vector = this.filterSet.getWrapperNames();
        int n = 0;
        while (n < vector.size()) {
            XMLName xMLName = (XMLName)vector.elementAt(n);
            this.attrs[0] = FilterConst.ATTR_NAME;
            this.values[0] = xMLName.getQualifiedName();
            this.writeElementStart(FilterConst.ELEM_WRAPPER, 1, true);
            ++n;
        }
    }
}

