/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.schemas.dtds;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.InputSource;
import org.xmlmiddleware.schemas.dtds.Attribute;
import org.xmlmiddleware.schemas.dtds.DTD;
import org.xmlmiddleware.schemas.dtds.DTDConst;
import org.xmlmiddleware.schemas.dtds.ElementType;
import org.xmlmiddleware.schemas.dtds.Group;
import org.xmlmiddleware.schemas.dtds.Notation;
import org.xmlmiddleware.schemas.dtds.ParameterEntity;
import org.xmlmiddleware.schemas.dtds.ParsedGeneralEntity;
import org.xmlmiddleware.schemas.dtds.Particle;
import org.xmlmiddleware.schemas.dtds.Reference;
import org.xmlmiddleware.schemas.dtds.UnparsedEntity;
import org.xmlmiddleware.utils.TokenList;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmlutils.XMLName;

public class DTDParser {
    static final int READER_READER = 0;
    static final int READER_STRING = 1;
    static final int READER_URL = 2;
    static final int STATE_OUTSIDEDTD = 0;
    static final int STATE_DTD = 1;
    static final int STATE_ATTVALUE = 2;
    static final int STATE_ENTITYVALUE = 3;
    static final int STATE_COMMENT = 4;
    static final int STATE_IGNORE = 5;
    static final int BUFSIZE = 8096;
    static final int LITBUFSIZE = 1024;
    static final int NAMEBUFSIZE = 1024;
    DTD dtd;
    Hashtable namespaceURIs;
    Hashtable predefinedEntities = new Hashtable();
    Hashtable declaredElementTypes = new Hashtable();
    TokenList dtdTokens;
    Reader reader;
    int readerType;
    int bufferPos;
    int bufferLen;
    int literalPos;
    int namePos;
    int entityState;
    int line;
    int column;
    Stack readerStack;
    StringBuffer literalStr;
    StringBuffer nameStr;
    char[] buffer;
    char[] literalBuffer = new char[1024];
    char[] nameBuffer = new char[1024];
    boolean ignoreQuote;
    boolean ignoreMarkup;
    URL readerURL;

    public DTDParser() {
        this.dtdTokens = new TokenList(DTDConst.KEYWDS, DTDConst.KEYWD_TOKENS, 0);
        this.initPredefinedEntities();
    }

    public DTD parseXMLDocument(InputSource inputSource, Hashtable hashtable) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.initGlobals();
        this.namespaceURIs = hashtable;
        this.openInputSource(inputSource);
        this.parseDocument();
        this.postProcessDTD();
        return this.dtd;
    }

    public DTD parseExternalSubset(InputSource inputSource, Hashtable hashtable) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.initGlobals();
        this.namespaceURIs = hashtable;
        this.openInputSource(inputSource);
        this.parseExternalSubset(true);
        this.postProcessDTD();
        return this.dtd;
    }

    void parseAttlistDecl() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.requireWhitespace();
        ElementType elementType = this.createElementType();
        while (!this.isChar('>')) {
            this.requireWhitespace();
            if (this.isChar('>')) break;
            this.getAttDef(elementType);
        }
    }

    void parseComment() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        int n = this.entityState;
        this.entityState = 4;
        this.discardUntil("--");
        this.requireChar('>');
        this.entityState = n;
    }

    boolean parseConditional() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        boolean bl = true;
        if (this.isString("<![")) {
            this.discardWhitespace();
            if (this.isString("INCLUDE")) {
                this.parseInclude();
            } else if (this.isString("IGNORE")) {
                this.entityState = 5;
                this.parseIgnoreSect();
                this.entityState = 1;
            } else {
                this.throwXMLMiddlewareException("Invalid conditional section.");
            }
        } else {
            bl = false;
        }
        return bl;
    }

    void parseDocTypeDecl() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        String string = null;
        if (!this.isString("<!DOCTYPE")) {
            return;
        }
        this.requireWhitespace();
        String string2 = this.getName();
        if (string2 == null) {
            this.throwXMLMiddlewareException("Invalid root element type name.");
        }
        if (this.isWhitespace()) {
            this.discardWhitespace();
            if (this.isString("SYSTEM")) {
                string = this.parseSystemLiteral();
                this.discardWhitespace();
            } else if (this.isString("PUBLIC")) {
                this.parsePublicID();
                string = this.parseSystemLiteral();
                this.discardWhitespace();
            }
        }
        if (this.isChar('[')) {
            this.parseInternalSubset();
            this.requireChar(']');
        }
        if (string != null) {
            this.pushCurrentReader();
            this.createURLReader(new URL(this.readerURL, string));
            this.parseExternalSubset(false);
        }
        this.discardWhitespace();
        this.requireChar('>');
    }

    void parseDocument() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        if (this.isString("<?xml")) {
            this.parseXMLDecl();
        }
        this.parseMisc();
        this.parseDocTypeDecl();
    }

    void parseElementDecl() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.requireWhitespace();
        ElementType elementType = this.addElementType();
        this.requireWhitespace();
        this.getContentModel(elementType);
        this.discardWhitespace();
        this.requireChar('>');
    }

    void parseEncodingDecl() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.parseEquals();
        this.getEncName();
    }

    void parseEntityDecl() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        boolean bl = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        this.requireWhitespace();
        if (this.isChar('%')) {
            bl = true;
            this.requireWhitespace();
        }
        String string4 = this.getName();
        this.requireWhitespace();
        if (this.isString("PUBLIC")) {
            string3 = this.parsePublicID();
            string2 = this.parseSystemLiteral();
        } else if (this.isString("SYSTEM")) {
            string2 = this.parseSystemLiteral();
        } else {
            string = this.getEntityValue();
        }
        if (bl) {
            ParameterEntity parameterEntity = new ParameterEntity(string4);
            parameterEntity.systemID = string2;
            parameterEntity.publicID = string3;
            parameterEntity.value = string;
            if (!this.dtd.parameterEntities.containsKey(string4)) {
                this.dtd.parameterEntities.put(string4, parameterEntity);
            }
        } else if (this.isString("NDATA")) {
            this.requireWhitespace();
            String string5 = this.getName();
            UnparsedEntity unparsedEntity = new UnparsedEntity(string4);
            unparsedEntity.systemID = string2;
            unparsedEntity.publicID = string3;
            unparsedEntity.notation = string5;
            if (!this.dtd.unparsedEntities.containsKey(string4) && !this.dtd.parsedGeneralEntities.containsKey(string4)) {
                this.dtd.unparsedEntities.put(string4, unparsedEntity);
            }
        } else {
            ParsedGeneralEntity parsedGeneralEntity = new ParsedGeneralEntity(string4);
            parsedGeneralEntity.systemID = string2;
            parsedGeneralEntity.publicID = string3;
            parsedGeneralEntity.value = string;
            if (!this.dtd.unparsedEntities.containsKey(string4) && !this.dtd.parsedGeneralEntities.containsKey(string4)) {
                this.dtd.parsedGeneralEntities.put(string4, parsedGeneralEntity);
            }
        }
        this.discardWhitespace();
        this.requireChar('>');
    }

    void parseEquals() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.discardWhitespace();
        this.requireChar('=');
        this.discardWhitespace();
    }

    void parseExternalSubset(boolean bl) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.entityState = 1;
        if (this.isString("<?xml")) {
            this.parseTextDecl();
        }
        this.parseExternalSubsetDecl(bl);
        this.entityState = 0;
    }

    void parseExternalSubsetDecl(boolean bl) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        boolean bl2 = true;
        while (bl2) {
            try {
                this.discardWhitespace();
            }
            catch (EOFException eOFException) {
                if (bl) {
                    return;
                }
                throw eOFException;
            }
            bl2 = this.parseMarkupDecl();
            if (bl2) continue;
            bl2 = this.parseConditional();
        }
    }

    boolean parseIgnore() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        int n = 0;
        block7: while (true) {
            char c = this.nextChar();
            switch (n) {
                default: {
                    continue block7;
                }
                case 0: {
                    if (c == '<') {
                        n = 1;
                        continue block7;
                    }
                    if (c != ']') continue block7;
                    n = 3;
                    continue block7;
                }
                case 1: {
                    n = c == '!' ? 2 : 0;
                    continue block7;
                }
                case 2: {
                    if (c == '[') {
                        return false;
                    }
                    n = 0;
                    continue block7;
                }
                case 3: {
                    n = c == ']' ? 4 : 0;
                    continue block7;
                }
                case 4: 
            }
            if (c == ']') {
                return true;
            }
            n = 0;
        }
    }

    void parseIgnoreSect() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.discardWhitespace();
        this.requireChar('[');
        this.parseIgnoreSectContents();
    }

    void parseIgnoreSectContents() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        int n = 1;
        while (n > 0) {
            int n2 = n = this.parseIgnore() ? n - 1 : n + 1;
        }
    }

    void parseInclude() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.discardWhitespace();
        this.requireChar('[');
        this.parseExternalSubsetDecl(false);
        this.requireString("]]>");
    }

    void parseInternalSubset() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        boolean bl = true;
        this.entityState = 1;
        while (bl) {
            this.discardWhitespace();
            bl = this.parseMarkupDecl();
        }
        this.entityState = 0;
    }

    boolean parseMarkupDecl() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        if (!this.isChar('<')) {
            return false;
        }
        if (this.isString("!--")) {
            this.parseComment();
        } else if (this.isChar('!')) {
            String string = this.getName();
            switch (this.dtdTokens.getToken(string)) {
                case 4: {
                    this.parseElementDecl();
                    break;
                }
                case 2: {
                    this.parseAttlistDecl();
                    break;
                }
                case 6: {
                    this.parseEntityDecl();
                    break;
                }
                case 16: {
                    this.parseNotationDecl();
                    break;
                }
                default: {
                    this.throwXMLMiddlewareException("Invalid markup declaration: <!" + string);
                    break;
                }
            }
        } else if (this.isChar('?')) {
            this.parsePI();
        } else {
            return false;
        }
        return true;
    }

    void parseMisc() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        boolean bl = true;
        while (bl) {
            this.discardWhitespace();
            if (this.isString("<!--")) {
                this.parseComment();
                continue;
            }
            if (this.isString("<?")) {
                this.parsePI();
                continue;
            }
            bl = false;
        }
    }

    void parseNotationDecl() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        Notation notation = new Notation();
        this.requireWhitespace();
        notation.name = this.getName();
        this.requireWhitespace();
        String string = this.getName();
        switch (this.dtdTokens.getToken(string)) {
            case 20: {
                notation.systemID = this.parseSystemLiteral();
                this.discardWhitespace();
                this.requireChar('>');
                break;
            }
            case 18: {
                notation.publicID = this.parsePublicID();
                if (this.isChar('>')) break;
                this.requireWhitespace();
                if (this.isChar('>')) break;
                notation.systemID = this.getSystemLiteral();
                this.discardWhitespace();
                this.requireChar('>');
                break;
            }
            default: {
                this.throwXMLMiddlewareException("Invalid keyword in notation declaration: " + string);
            }
        }
        if (this.dtd.notations.containsKey(notation.name)) {
            this.throwXMLMiddlewareException("Duplicate notation declaration: " + notation.name);
        }
        this.dtd.notations.put(notation.name, notation);
    }

    void parsePI() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.discardUntil("?>");
    }

    String parsePublicID() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.requireWhitespace();
        return this.getPubidLiteral();
    }

    void parseStandalone() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.parseEquals();
        this.getYesNo();
    }

    String parseSystemLiteral() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.requireWhitespace();
        return this.getSystemLiteral();
    }

    void parseTextDecl() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.requireWhitespace();
        if (this.isString("version")) {
            this.parseVersion();
            this.requireWhitespace();
        }
        this.requireString("encoding");
        this.parseEncodingDecl();
        this.discardWhitespace();
        this.requireString("?>");
    }

    void parseVersion() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.parseEquals();
        char c = this.getQuote();
        this.requireString("1.0");
        this.requireChar(c);
    }

    void parseXMLDecl() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        if (!this.isWhitespace()) {
            this.parsePI();
            return;
        }
        this.discardWhitespace();
        this.requireString("version");
        this.parseVersion();
        if (this.isWhitespace()) {
            this.discardWhitespace();
            if (this.isString("encoding")) {
                this.parseEncodingDecl();
                if (!this.isWhitespace()) {
                    return;
                }
                this.discardWhitespace();
            }
            if (this.isString("standalone")) {
                this.parseStandalone();
                this.discardWhitespace();
            }
        }
        this.requireString("?>");
    }

    ElementType addElementType() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        XMLName xMLName = this.getXMLName();
        if (this.declaredElementTypes.containsKey(xMLName)) {
            this.throwXMLMiddlewareException("Duplicate element type declaration: " + xMLName.getUniversalName());
        }
        this.declaredElementTypes.put(xMLName, xMLName);
        return this.dtd.createElementType(xMLName);
    }

    void getAttDef(ElementType elementType) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        Attribute attribute = this.getAttribute(elementType);
        this.requireWhitespace();
        this.getAttributeType(attribute);
        this.requireWhitespace();
        this.getAttributeRequired(attribute);
    }

    Attribute getAttribute(ElementType elementType) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        XMLName xMLName = this.getXMLName();
        Attribute attribute = new Attribute(xMLName);
        if (!elementType.attributes.containsKey(xMLName)) {
            elementType.attributes.put(xMLName, attribute);
        }
        return attribute;
    }

    void getAttributeDefault(Attribute attribute) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        attribute.defaultValue = this.getAttValue();
    }

    void getAttributeRequired(Attribute attribute) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        if (this.isChar('#')) {
            String string = this.getName();
            switch (this.dtdTokens.getToken(string)) {
                case 19: {
                    attribute.required = 1;
                    return;
                }
                case 12: {
                    attribute.required = 2;
                    return;
                }
                case 8: {
                    attribute.required = 3;
                    this.requireWhitespace();
                    this.getAttributeDefault(attribute);
                    return;
                }
            }
            this.throwXMLMiddlewareException("Invalid attribute default: " + string);
            return;
        }
        attribute.required = 4;
        this.getAttributeDefault(attribute);
    }

    void getAttributeType(Attribute attribute) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        if (this.isChar('(')) {
            attribute.type = 9;
            this.getEnumeration(attribute, false);
            return;
        }
        String string = this.getName();
        switch (this.dtdTokens.getToken(string)) {
            case 3: {
                attribute.type = 1;
                return;
            }
            case 9: {
                attribute.type = 2;
                return;
            }
            case 10: {
                attribute.type = 3;
                return;
            }
            case 11: {
                attribute.type = 4;
                return;
            }
            case 6: {
                attribute.type = 5;
                return;
            }
            case 7: {
                attribute.type = 6;
                return;
            }
            case 14: {
                attribute.type = 7;
                return;
            }
            case 15: {
                attribute.type = 8;
                return;
            }
            case 16: {
                attribute.type = 10;
                this.requireWhitespace();
                this.requireChar('(');
                this.getEnumeration(attribute, true);
                return;
            }
        }
        this.throwXMLMiddlewareException("Invalid attribute type: " + string);
    }

    void getContentModel(ElementType elementType) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        if (this.isChar('(')) {
            this.discardWhitespace();
            if (this.isChar('#')) {
                this.getMixedContent(elementType);
                return;
            }
            this.getElementContent(elementType);
            return;
        }
        if (this.isString("EMPTY")) {
            elementType.contentType = 1;
            return;
        }
        if (this.isString("ANY")) {
            elementType.contentType = 2;
            return;
        }
        this.throwXMLMiddlewareException("Invalid element type declaration.");
    }

    void getContentParticle(Group group, ElementType elementType) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        if (this.isChar('(')) {
            Group group2 = new Group();
            group.members.addElement(group2);
            this.getGroup(group2, elementType);
            return;
        }
        Reference reference = this.getReference(group, elementType, false);
        this.getFrequency(reference);
    }

    void getElementContent(ElementType elementType) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        elementType.content = new Group();
        elementType.contentType = 5;
        this.getGroup(elementType.content, elementType);
    }

    ElementType createElementType() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        XMLName xMLName = this.getXMLName();
        return this.dtd.createElementType(xMLName);
    }

    void getEnumeratedValue(Attribute attribute, boolean bl, Hashtable hashtable) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        String string;
        this.discardWhitespace();
        String string2 = string = bl ? this.getName() : this.getNmtoken();
        if (hashtable.containsKey(string)) {
            this.throwXMLMiddlewareException("Enumerated values must be unique: " + string);
        }
        attribute.enums.addElement(string);
        this.discardWhitespace();
    }

    void getEnumeration(Attribute attribute, boolean bl) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        Hashtable hashtable = new Hashtable();
        attribute.enums = new Vector();
        this.getEnumeratedValue(attribute, bl, hashtable);
        while (!this.isChar(')')) {
            this.requireChar('|');
            this.getEnumeratedValue(attribute, bl, hashtable);
        }
    }

    void getFrequency(Particle particle) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        if (this.isChar('?')) {
            particle.isRequired = false;
            particle.isRepeatable = false;
            return;
        }
        if (this.isChar('+')) {
            particle.isRequired = true;
            particle.isRepeatable = true;
            return;
        }
        if (this.isChar('*')) {
            particle.isRequired = false;
            particle.isRepeatable = true;
            return;
        }
        particle.isRequired = true;
        particle.isRepeatable = false;
    }

    void getGroup(Group group, ElementType elementType) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        boolean bl = true;
        while (bl) {
            this.discardWhitespace();
            this.getContentParticle(group, elementType);
            this.discardWhitespace();
            if (this.isChar('|')) {
                if (group.type == 0) {
                    group.type = 2;
                    continue;
                }
                if (group.type != 3) continue;
                this.throwXMLMiddlewareException("Invalid mixture of ',' and '|' in content model.");
                continue;
            }
            if (this.isChar(',')) {
                if (group.type == 0) {
                    group.type = 3;
                    continue;
                }
                if (group.type != 2) continue;
                this.throwXMLMiddlewareException("Invalid mixture of ',' and '|' in content model.");
                continue;
            }
            if (!this.isChar(')')) continue;
            bl = false;
            this.getFrequency(group);
            if (group.type != 0) continue;
            group.type = 3;
        }
    }

    void getMixedContent(ElementType elementType) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        boolean bl = true;
        this.discardWhitespace();
        this.requireString("PCDATA");
        this.discardWhitespace();
        if (this.isChar('|')) {
            elementType.contentType = 4;
            elementType.content = new Group();
            elementType.content.type = 2;
            elementType.content.isRequired = false;
            elementType.content.isRepeatable = true;
            while (bl) {
                this.discardWhitespace();
                this.getReference(elementType.content, elementType, true);
                this.discardWhitespace();
                bl = this.isChar('|');
            }
            this.requireString(")*");
            return;
        }
        elementType.contentType = 3;
        this.requireChar(')');
        this.isChar('*');
    }

    XMLName getXMLName() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        String string = this.getName();
        return XMLName.create(string, this.namespaceURIs);
    }

    Reference getReference(Group group, ElementType elementType, boolean bl) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        ElementType elementType2 = this.createElementType();
        if (bl && elementType.children.containsKey(elementType2.name)) {
            this.throwXMLMiddlewareException("The element type " + elementType2.name.getUniversalName() + " appeared more than once in the declaration of mixed content for the element type " + elementType2.name.getUniversalName() + ".");
        }
        elementType.children.put(elementType2.name, elementType2);
        elementType2.parents.put(elementType.name, elementType);
        Reference reference = new Reference(elementType2);
        group.members.addElement(reference);
        return reference;
    }

    void initGlobals() throws MalformedURLException {
        this.dtd = new DTD();
        this.entityState = 0;
        this.readerStack = new Stack();
        this.initReaderGlobals();
        this.declaredElementTypes.clear();
    }

    void initPredefinedEntities() {
        ParsedGeneralEntity parsedGeneralEntity = new ParsedGeneralEntity("lt");
        parsedGeneralEntity.value = "<";
        this.predefinedEntities.put(parsedGeneralEntity.name, parsedGeneralEntity);
        parsedGeneralEntity = new ParsedGeneralEntity("gt");
        parsedGeneralEntity.value = ">";
        this.predefinedEntities.put(parsedGeneralEntity.name, parsedGeneralEntity);
        parsedGeneralEntity = new ParsedGeneralEntity("amp");
        parsedGeneralEntity.value = "&";
        this.predefinedEntities.put(parsedGeneralEntity.name, parsedGeneralEntity);
        parsedGeneralEntity = new ParsedGeneralEntity("apos");
        parsedGeneralEntity.value = "'";
        this.predefinedEntities.put(parsedGeneralEntity.name, parsedGeneralEntity);
        parsedGeneralEntity = new ParsedGeneralEntity("quot");
        parsedGeneralEntity.value = "\"";
        this.predefinedEntities.put(parsedGeneralEntity.name, parsedGeneralEntity);
    }

    void postProcessDTD() throws XMLMiddlewareException {
        if (this.dtd != null) {
            this.updateANYParents();
            this.checkElementTypeReferences();
            this.checkNotationReferences();
        }
    }

    private void updateANYParents() {
        Enumeration enumeration = this.dtd.elementTypes.elements();
        while (enumeration.hasMoreElements()) {
            ElementType elementType = (ElementType)enumeration.nextElement();
            if (elementType.contentType != 2) continue;
            Enumeration enumeration2 = this.dtd.elementTypes.elements();
            while (enumeration2.hasMoreElements()) {
                ElementType elementType2 = (ElementType)enumeration2.nextElement();
                elementType.children.put(elementType2.name, elementType2);
                elementType2.parents.put(elementType.name, elementType);
            }
        }
    }

    private void checkElementTypeReferences() throws XMLMiddlewareException {
        Enumeration enumeration = this.dtd.elementTypes.elements();
        while (enumeration.hasMoreElements()) {
            ElementType elementType = (ElementType)enumeration.nextElement();
            if (elementType.children.isEmpty()) continue;
            Enumeration enumeration2 = elementType.children.elements();
            while (enumeration2.hasMoreElements()) {
                ElementType elementType2 = (ElementType)enumeration2.nextElement();
                if (this.declaredElementTypes.containsKey(elementType2.name)) continue;
                throw new XMLMiddlewareException("Element type " + elementType2.name.getUniversalName() + " is referenced in element type " + elementType.name.getUniversalName() + " but is never defined.");
            }
        }
    }

    private void checkNotationReferences() throws XMLMiddlewareException {
        Enumeration enumeration = this.dtd.elementTypes.elements();
        while (enumeration.hasMoreElements()) {
            ElementType elementType = (ElementType)enumeration.nextElement();
            Enumeration enumeration2 = elementType.attributes.elements();
            while (enumeration2.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration2.nextElement();
                if (attribute.type != 10) continue;
                int n = 0;
                while (n < attribute.enums.size()) {
                    String string = (String)attribute.enums.elementAt(n);
                    if (!this.dtd.notations.containsKey(string)) {
                        throw new XMLMiddlewareException("Notation " + string + " not defined. Used by the " + attribute.name.getUniversalName() + " attribute of the " + elementType.name.getUniversalName() + " element type.");
                    }
                    ++n;
                }
            }
        }
        enumeration = this.dtd.unparsedEntities.elements();
        while (enumeration.hasMoreElements()) {
            UnparsedEntity unparsedEntity = (UnparsedEntity)enumeration.nextElement();
            if (this.dtd.notations.containsKey(unparsedEntity.notation)) continue;
            throw new XMLMiddlewareException("Notation " + unparsedEntity.notation + " not defined. Used by the " + unparsedEntity.name + " unparsed entity.");
        }
    }

    void throwXMLMiddlewareException(String string) throws XMLMiddlewareException {
        throw new XMLMiddlewareException(String.valueOf(string) + "\nLine: " + this.line + " Column: " + this.column);
    }

    boolean isWhitespace() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        if (this.isWhitespace(this.nextChar())) {
            return true;
        }
        this.restore();
        return false;
    }

    void requireWhitespace() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        if (!this.isWhitespace()) {
            this.throwXMLMiddlewareException("Whitespace required.");
        }
        this.discardWhitespace();
    }

    void discardWhitespace() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        while (this.isWhitespace()) {
        }
    }

    void discardUntil(String string) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            char c = this.nextChar();
            int n2 = n = c == cArray[n] ? n + 1 : 0;
        }
    }

    boolean isString(String string) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            char c = this.nextChar();
            if (c != cArray[n]) {
                cArray[n] = c;
                this.restore(new String(cArray, 0, n + 1));
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean isChar(char c) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        if (this.nextChar() == c) {
            return true;
        }
        this.restore();
        return false;
    }

    void requireString(String string) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        if (!this.isString(string)) {
            this.throwXMLMiddlewareException("String required: " + string);
        }
    }

    void requireChar(char c) throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        if (!this.isChar(c)) {
            this.throwXMLMiddlewareException("Character required: " + c);
        }
    }

    String getAttValue() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.entityState = 2;
        char c = this.getQuote();
        this.resetLiteralBuffer();
        char c2 = this.nextChar();
        while (c2 != c || this.ignoreQuote) {
            if (!(c2 != '<' && c2 != '&' || this.ignoreMarkup)) {
                this.throwXMLMiddlewareException("Markup character '" + c2 + "' not allowed in default attribute value.");
            }
            this.appendLiteralBuffer(c2);
            c2 = this.nextChar();
        }
        this.entityState = 1;
        return this.getLiteralBuffer();
    }

    String getEncName() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        char c = this.getQuote();
        this.resetLiteralBuffer();
        char c2 = this.nextChar();
        if (!this.isLatinLetter(c2)) {
            this.throwXMLMiddlewareException("Invalid starting character in encoding name: " + c2);
        }
        while ((c2 = this.nextChar()) != c) {
            if (!this.isLatinLetter(c2) && !this.isLatinDigit(c2) && c2 != '.' && c2 != '_' && c2 != '-') {
                this.throwXMLMiddlewareException("Invalid character in encoding name: " + c2);
            }
            this.appendLiteralBuffer(c2);
        }
        return this.getLiteralBuffer();
    }

    String getEntityValue() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.entityState = 3;
        char c = this.getQuote();
        this.resetLiteralBuffer();
        char c2 = this.nextChar();
        while (c2 != c || this.ignoreQuote) {
            if (!(c2 != '<' && c2 != '%' || this.ignoreMarkup)) {
                this.throwXMLMiddlewareException("Markup character '" + c2 + "' not allowed in entity value.");
            }
            this.appendLiteralBuffer(c2);
            c2 = this.nextChar();
        }
        this.entityState = 1;
        return this.getLiteralBuffer();
    }

    String getName() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.resetLiteralBuffer();
        char c = this.nextChar();
        if (!this.isLetter(c) && c != '_' && c != ':') {
            this.throwXMLMiddlewareException("Invalid name start character: " + c);
        }
        while (this.isNameChar(c)) {
            this.appendLiteralBuffer(c);
            c = this.nextChar();
        }
        this.restore();
        return this.getLiteralBuffer();
    }

    String getNmtoken() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        this.resetLiteralBuffer();
        char c = this.nextChar();
        if (!this.isNameChar(c)) {
            this.throwXMLMiddlewareException("Invalid Nmtoken start character: " + c);
        }
        while (this.isNameChar(c)) {
            this.appendLiteralBuffer(c);
            c = this.nextChar();
        }
        this.restore();
        return this.getLiteralBuffer();
    }

    String getPubidLiteral() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        char c;
        char c2 = this.getQuote();
        this.resetLiteralBuffer();
        while ((c = this.nextChar()) != c2) {
            if (!this.isPubidChar(c)) {
                this.throwXMLMiddlewareException("Invalid character in public identifier: " + c);
            }
            this.appendLiteralBuffer(c);
        }
        return this.getLiteralBuffer();
    }

    char getQuote() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        char c = this.nextChar();
        if (c != '\'' && c != '\"') {
            this.throwXMLMiddlewareException("Quote character required.");
        }
        return c;
    }

    String getSystemLiteral() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        char c;
        char c2 = this.getQuote();
        this.resetLiteralBuffer();
        while ((c = this.nextChar()) != c2) {
            this.appendLiteralBuffer(c);
        }
        return this.getLiteralBuffer();
    }

    String getYesNo() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        boolean bl = true;
        char c = this.getQuote();
        if (!this.isString("no")) {
            this.requireString("yes");
            bl = false;
        }
        this.requireChar(c);
        if (bl) {
            return "no";
        }
        return "yes";
    }

    void resetLiteralBuffer() {
        this.literalPos = -1;
        this.literalStr = null;
    }

    void appendLiteralBuffer(char c) {
        ++this.literalPos;
        if (this.literalPos >= 1024) {
            if (this.literalStr == null) {
                this.literalStr = new StringBuffer();
            }
            this.literalStr.append(this.literalBuffer);
            this.literalPos = 0;
        }
        this.literalBuffer[this.literalPos] = c;
    }

    String getLiteralBuffer() {
        if (this.literalStr == null) {
            return new String(this.literalBuffer, 0, this.literalPos + 1);
        }
        this.literalStr.append(this.literalBuffer, 0, this.literalPos + 1);
        return this.literalStr.toString();
    }

    boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    boolean isLatinLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    boolean isLatinDigit(char c) {
        return c >= '0' && c <= '9';
    }

    boolean isPubidChar(char c) {
        switch (c) {
            case '\n': 
            case '\r': 
            case ' ': 
            case '!': 
            case '#': 
            case '$': 
            case '%': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '=': 
            case '?': 
            case '@': 
            case '_': {
                return true;
            }
        }
        return this.isLatinLetter(c) || this.isLatinDigit(c);
    }

    boolean isNameChar(char c) {
        if (this.isLatinLetter(c)) {
            return true;
        }
        if (this.isLatinDigit(c)) {
            return true;
        }
        if (c == '.' || c == '-' || c == '_' || c == ':') {
            return true;
        }
        if (this.isLetter(c)) {
            return true;
        }
        if (this.isDigit(c)) {
            return true;
        }
        if (this.isCombiningChar(c)) {
            return true;
        }
        return this.isExtender(c);
    }

    boolean isLetter(char c) {
        switch (c >> 8) {
            case 0: {
                if (c >= 'A' && c <= 'Z') {
                    return true;
                }
                if (c >= 'a' && c <= 'z') {
                    return true;
                }
                if (c >= '\u00c0' && c <= '\u00d6') {
                    return true;
                }
                if (c >= '\u00d8' && c <= '\u00f6') {
                    return true;
                }
                return c >= '\u00f8' && c <= '\u00ff';
            }
            case 1: {
                if (c >= '\u0100' && c <= '\u0131') {
                    return true;
                }
                if (c >= '\u0134' && c <= '\u013e') {
                    return true;
                }
                if (c >= '\u0141' && c <= '\u0148') {
                    return true;
                }
                if (c >= '\u014a' && c <= '\u017e') {
                    return true;
                }
                if (c >= '\u0180' && c <= '\u01c3') {
                    return true;
                }
                if (c >= '\u01cd' && c <= '\u01f0') {
                    return true;
                }
                if (c >= '\u01f4' && c <= '\u01f5') {
                    return true;
                }
                return c >= '\u01fa' && c <= '\u01ff';
            }
            case 2: {
                if (c >= '\u0200' && c <= '\u0217') {
                    return true;
                }
                if (c >= '\u0250' && c <= '\u02a8') {
                    return true;
                }
                return c >= '\u02bb' && c <= '\u02c1';
            }
            case 3: {
                if (c >= '\u0388' && c <= '\u038a') {
                    return true;
                }
                if (c >= '\u038e' && c <= '\u03a1') {
                    return true;
                }
                if (c >= '\u03a3' && c <= '\u03ce') {
                    return true;
                }
                if (c >= '\u03d0' && c <= '\u03d6') {
                    return true;
                }
                if (c >= '\u03e2' && c <= '\u03f3') {
                    return true;
                }
                return c == '\u0386' || c == '\u038c' || c == '\u03da' || c == '\u03dc' || c == '\u03de' || c == '\u03e0';
            }
            case 4: {
                if (c >= '\u0401' && c <= '\u040c') {
                    return true;
                }
                if (c >= '\u040e' && c <= '\u044f') {
                    return true;
                }
                if (c >= '\u0451' && c <= '\u045c') {
                    return true;
                }
                if (c >= '\u045e' && c <= '\u0481') {
                    return true;
                }
                if (c >= '\u0490' && c <= '\u04c4') {
                    return true;
                }
                if (c >= '\u04c7' && c <= '\u04c8') {
                    return true;
                }
                if (c >= '\u04cb' && c <= '\u04cc') {
                    return true;
                }
                if (c >= '\u04d0' && c <= '\u04eb') {
                    return true;
                }
                if (c >= '\u04ee' && c <= '\u04f5') {
                    return true;
                }
                return c >= '\u04f8' && c <= '\u04f9';
            }
            case 5: {
                if (c >= '\u0531' && c <= '\u0556') {
                    return true;
                }
                if (c >= '\u0561' && c <= '\u0586') {
                    return true;
                }
                if (c >= '\u05d0' && c <= '\u05ea') {
                    return true;
                }
                if (c >= '\u05f0' && c <= '\u05f2') {
                    return true;
                }
                return c == '\u0559';
            }
            case 6: {
                if (c >= '\u0621' && c <= '\u063a') {
                    return true;
                }
                if (c >= '\u0641' && c <= '\u064a') {
                    return true;
                }
                if (c >= '\u0671' && c <= '\u06b7') {
                    return true;
                }
                if (c >= '\u06ba' && c <= '\u06be') {
                    return true;
                }
                if (c >= '\u06c0' && c <= '\u06ce') {
                    return true;
                }
                if (c >= '\u06d0' && c <= '\u06d3') {
                    return true;
                }
                if (c >= '\u06e5' && c <= '\u06e6') {
                    return true;
                }
                return c == '\u06d5';
            }
            case 9: {
                if (c >= '\u0905' && c <= '\u0939') {
                    return true;
                }
                if (c >= '\u0958' && c <= '\u0961') {
                    return true;
                }
                if (c >= '\u0985' && c <= '\u098c') {
                    return true;
                }
                if (c >= '\u098f' && c <= '\u0990') {
                    return true;
                }
                if (c >= '\u0993' && c <= '\u09a8') {
                    return true;
                }
                if (c >= '\u09aa' && c <= '\u09b0') {
                    return true;
                }
                if (c >= '\u09b6' && c <= '\u09b9') {
                    return true;
                }
                if (c >= '\u09dc' && c <= '\u09dd') {
                    return true;
                }
                if (c >= '\u09df' && c <= '\u09e1') {
                    return true;
                }
                if (c >= '\u09f0' && c <= '\u09f1') {
                    return true;
                }
                return c == '\u093d' || c == '\u09b2';
            }
            case 10: {
                if (c >= '\u0a05' && c <= '\u0a0a') {
                    return true;
                }
                if (c >= '\u0a0f' && c <= '\u0a10') {
                    return true;
                }
                if (c >= '\u0a13' && c <= '\u0a28') {
                    return true;
                }
                if (c >= '\u0a2a' && c <= '\u0a30') {
                    return true;
                }
                if (c >= '\u0a32' && c <= '\u0a33') {
                    return true;
                }
                if (c >= '\u0a35' && c <= '\u0a36') {
                    return true;
                }
                if (c >= '\u0a38' && c <= '\u0a39') {
                    return true;
                }
                if (c >= '\u0a59' && c <= '\u0a5c') {
                    return true;
                }
                if (c >= '\u0a72' && c <= '\u0a74') {
                    return true;
                }
                if (c >= '\u0a85' && c <= '\u0a8b') {
                    return true;
                }
                if (c >= '\u0a8f' && c <= '\u0a91') {
                    return true;
                }
                if (c >= '\u0a93' && c <= '\u0aa8') {
                    return true;
                }
                if (c >= '\u0aaa' && c <= '\u0ab0') {
                    return true;
                }
                if (c >= '\u0ab2' && c <= '\u0ab3') {
                    return true;
                }
                if (c >= '\u0ab5' && c <= '\u0ab9') {
                    return true;
                }
                return c == '\u0a5e' || c == '\u0a8d' || c == '\u0abd' || c == '\u0ae0';
            }
            case 11: {
                if (c >= '\u0b05' && c <= '\u0b0c') {
                    return true;
                }
                if (c >= '\u0b0f' && c <= '\u0b10') {
                    return true;
                }
                if (c >= '\u0b13' && c <= '\u0b28') {
                    return true;
                }
                if (c >= '\u0b2a' && c <= '\u0b30') {
                    return true;
                }
                if (c >= '\u0b32' && c <= '\u0b33') {
                    return true;
                }
                if (c >= '\u0b36' && c <= '\u0b39') {
                    return true;
                }
                if (c >= '\u0b5c' && c <= '\u0b5d') {
                    return true;
                }
                if (c >= '\u0b5f' && c <= '\u0b61') {
                    return true;
                }
                if (c >= '\u0b85' && c <= '\u0b8a') {
                    return true;
                }
                if (c >= '\u0b8e' && c <= '\u0b90') {
                    return true;
                }
                if (c >= '\u0b92' && c <= '\u0b95') {
                    return true;
                }
                if (c >= '\u0b99' && c <= '\u0b9a') {
                    return true;
                }
                if (c >= '\u0b9e' && c <= '\u0b9f') {
                    return true;
                }
                if (c >= '\u0ba3' && c <= '\u0ba4') {
                    return true;
                }
                if (c >= '\u0ba8' && c <= '\u0baa') {
                    return true;
                }
                if (c >= '\u0bae' && c <= '\u0bb5') {
                    return true;
                }
                if (c >= '\u0bb7' && c <= '\u0bb9') {
                    return true;
                }
                return c == '\u0b3d' || c == '\u0b9c';
            }
            case 12: {
                if (c >= '\u0c05' && c <= '\u0c0c') {
                    return true;
                }
                if (c >= '\u0c0e' && c <= '\u0c10') {
                    return true;
                }
                if (c >= '\u0c12' && c <= '\u0c28') {
                    return true;
                }
                if (c >= '\u0c2a' && c <= '\u0c33') {
                    return true;
                }
                if (c >= '\u0c35' && c <= '\u0c39') {
                    return true;
                }
                if (c >= '\u0c60' && c <= '\u0c61') {
                    return true;
                }
                if (c >= '\u0c85' && c <= '\u0c8c') {
                    return true;
                }
                if (c >= '\u0c8e' && c <= '\u0c90') {
                    return true;
                }
                if (c >= '\u0c92' && c <= '\u0ca8') {
                    return true;
                }
                if (c >= '\u0caa' && c <= '\u0cb3') {
                    return true;
                }
                if (c >= '\u0cb5' && c <= '\u0cb9') {
                    return true;
                }
                if (c >= '\u0ce0' && c <= '\u0ce1') {
                    return true;
                }
                return c == '\u0cde';
            }
            case 13: {
                if (c >= '\u0d05' && c <= '\u0d0c') {
                    return true;
                }
                if (c >= '\u0d0e' && c <= '\u0d10') {
                    return true;
                }
                if (c >= '\u0d12' && c <= '\u0d28') {
                    return true;
                }
                if (c >= '\u0d2a' && c <= '\u0d39') {
                    return true;
                }
                return c >= '\u0d60' && c <= '\u0d61';
            }
            case 14: {
                if (c >= '\u0e01' && c <= '\u0e2e') {
                    return true;
                }
                if (c >= '\u0e32' && c <= '\u0e33') {
                    return true;
                }
                if (c >= '\u0e40' && c <= '\u0e45') {
                    return true;
                }
                if (c >= '\u0e81' && c <= '\u0e82') {
                    return true;
                }
                if (c >= '\u0e87' && c <= '\u0e88') {
                    return true;
                }
                if (c >= '\u0e94' && c <= '\u0e97') {
                    return true;
                }
                if (c >= '\u0e99' && c <= '\u0e9f') {
                    return true;
                }
                if (c >= '\u0ea1' && c <= '\u0ea3') {
                    return true;
                }
                if (c >= '\u0eaa' && c <= '\u0eab') {
                    return true;
                }
                if (c >= '\u0ead' && c <= '\u0eae') {
                    return true;
                }
                if (c >= '\u0eb2' && c <= '\u0eb3') {
                    return true;
                }
                if (c >= '\u0ec0' && c <= '\u0ec4') {
                    return true;
                }
                return c == '\u0e30' || c == '\u0e84' || c == '\u0e8a' || c == '\u0e8d' || c == '\u0ea5' || c == '\u0ea7' || c == '\u0eb0' || c == '\u0ebd';
            }
            case 15: {
                if (c >= '\u0f40' && c <= '\u0f47') {
                    return true;
                }
                return c >= '\u0f49' && c <= '\u0f69';
            }
            case 16: {
                if (c >= '\u10a0' && c <= '\u10c5') {
                    return true;
                }
                return c >= '\u10d0' && c <= '\u10f6';
            }
            case 17: {
                if (c >= '\u1102' && c <= '\u1103') {
                    return true;
                }
                if (c >= '\u1105' && c <= '\u1107') {
                    return true;
                }
                if (c >= '\u110b' && c <= '\u110c') {
                    return true;
                }
                if (c >= '\u110e' && c <= '\u1112') {
                    return true;
                }
                if (c >= '\u1154' && c <= '\u1155') {
                    return true;
                }
                if (c >= '\u115f' && c <= '\u1161') {
                    return true;
                }
                if (c >= '\u116d' && c <= '\u116e') {
                    return true;
                }
                if (c >= '\u1172' && c <= '\u1173') {
                    return true;
                }
                if (c >= '\u11ae' && c <= '\u11af') {
                    return true;
                }
                if (c >= '\u11b7' && c <= '\u11b8') {
                    return true;
                }
                if (c >= '\u11bc' && c <= '\u11c2') {
                    return true;
                }
                return c == '\u1100' || c == '\u1109' || c == '\u113c' || c == '\u113e' || c == '\u1140' || c == '\u114c' || c == '\u114e' || c == '\u1150' || c == '\u1159' || c == '\u1163' || c == '\u1165' || c == '\u1167' || c == '\u1169' || c == '\u1175' || c == '\u119e' || c == '\u11a8' || c == '\u11ab' || c == '\u11ba' || c == '\u11eb' || c == '\u11f0' || c == '\u11f9';
            }
            case 30: {
                if (c >= '\u1e00' && c <= '\u1e9b') {
                    return true;
                }
                return c >= '\u1ea0' && c <= '\u1ef9';
            }
            case 31: {
                if (c >= '\u1f00' && c <= '\u1f15') {
                    return true;
                }
                if (c >= '\u1f18' && c <= '\u1f1d') {
                    return true;
                }
                if (c >= '\u1f20' && c <= '\u1f45') {
                    return true;
                }
                if (c >= '\u1f48' && c <= '\u1f4d') {
                    return true;
                }
                if (c >= '\u1f50' && c <= '\u1f57') {
                    return true;
                }
                if (c >= '\u1f5f' && c <= '\u1f7d') {
                    return true;
                }
                if (c >= '\u1f80' && c <= '\u1fb4') {
                    return true;
                }
                if (c >= '\u1fb6' && c <= '\u1fbc') {
                    return true;
                }
                if (c >= '\u1fc2' && c <= '\u1fc4') {
                    return true;
                }
                if (c >= '\u1fc6' && c <= '\u1fcc') {
                    return true;
                }
                if (c >= '\u1fd0' && c <= '\u1fd3') {
                    return true;
                }
                if (c >= '\u1fd6' && c <= '\u1fdb') {
                    return true;
                }
                if (c >= '\u1fe0' && c <= '\u1fec') {
                    return true;
                }
                if (c >= '\u1ff2' && c <= '\u1ff4') {
                    return true;
                }
                if (c >= '\u1ff6' && c <= '\u1ffc') {
                    return true;
                }
                return c == '\u1f59' || c == '\u1f5b' || c == '\u1f5d' || c == '\u1fbe';
            }
            case 33: {
                if (c >= '\u212a' && c <= '\u212b') {
                    return true;
                }
                if (c >= '\u2180' && c <= '\u2182') {
                    return true;
                }
                return c == '\u2126' || c == '\u212e';
            }
            case 32: {
                if (c >= '\u3041' && c <= '\u3094') {
                    return true;
                }
                if (c >= '\u30a1' && c <= '\u30fa') {
                    return true;
                }
                if (c >= '\u3021' && c <= '\u3029') {
                    return true;
                }
                return c == '\u3007';
            }
            case 49: {
                return c >= '\u3105' && c <= '\u312c';
            }
        }
        if (c >= '\uac00' && c <= '\ud7a3') {
            return true;
        }
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    boolean isDigit(char c) {
        if (!Character.isDigit(c)) {
            return false;
        }
        return c > '\u0f29';
    }

    boolean isCombiningChar(char c) {
        switch (c >> 8) {
            case 3: {
                if (c >= '\u0300' && c <= '\u0345') {
                    return true;
                }
                return c >= '\u0360' && c <= '\u0361';
            }
            case 4: {
                return c >= '\u0483' && c <= '\u0486';
            }
            case 5: {
                if (c >= '\u0591' && c <= '\u05a1') {
                    return true;
                }
                if (c >= '\u05a3' && c <= '\u05b9') {
                    return true;
                }
                if (c >= '\u05bb' && c <= '\u05bd') {
                    return true;
                }
                if (c >= '\u05c1' && c <= '\u05c2') {
                    return true;
                }
                return c == '\u05bf' || c == '\u05c4';
            }
            case 6: {
                if (c >= '\u064b' && c <= '\u0652') {
                    return true;
                }
                if (c >= '\u06d6' && c <= '\u06dc') {
                    return true;
                }
                if (c >= '\u06dd' && c <= '\u06df') {
                    return true;
                }
                if (c >= '\u06e0' && c <= '\u06e4') {
                    return true;
                }
                if (c >= '\u06e7' && c <= '\u06e8') {
                    return true;
                }
                if (c >= '\u06ea' && c <= '\u06ed') {
                    return true;
                }
                return c == '\u0670';
            }
            case 9: {
                if (c >= '\u0901' && c <= '\u0903') {
                    return true;
                }
                if (c >= '\u093e' && c <= '\u094c') {
                    return true;
                }
                if (c >= '\u0951' && c <= '\u0954') {
                    return true;
                }
                if (c >= '\u0962' && c <= '\u0963') {
                    return true;
                }
                if (c >= '\u0981' && c <= '\u0983') {
                    return true;
                }
                if (c >= '\u09c0' && c <= '\u09c4') {
                    return true;
                }
                if (c >= '\u09c7' && c <= '\u09c8') {
                    return true;
                }
                if (c >= '\u09cb' && c <= '\u09cd') {
                    return true;
                }
                if (c >= '\u09e2' && c <= '\u09e3') {
                    return true;
                }
                return c == '\u093c' || c == '\u094d' || c == '\u09bc' || c == '\u09be' || c == '\u09bf' || c == '\u09d7';
            }
            case 10: {
                if (c >= '\u0a40' && c <= '\u0a42') {
                    return true;
                }
                if (c >= '\u0a47' && c <= '\u0a48') {
                    return true;
                }
                if (c >= '\u0a4b' && c <= '\u0a4d') {
                    return true;
                }
                if (c >= '\u0a70' && c <= '\u0a71') {
                    return true;
                }
                if (c >= '\u0a81' && c <= '\u0a83') {
                    return true;
                }
                if (c >= '\u0abe' && c <= '\u0ac5') {
                    return true;
                }
                if (c >= '\u0ac7' && c <= '\u0ac9') {
                    return true;
                }
                if (c >= '\u0acb' && c <= '\u0acd') {
                    return true;
                }
                return c == '\u0a02' || c == '\u0a3c' || c == '\u0a3e' || c == '\u0a3f' || c == '\u0abc';
            }
            case 11: {
                if (c >= '\u0b01' && c <= '\u0b03') {
                    return true;
                }
                if (c >= '\u0b3e' && c <= '\u0b43') {
                    return true;
                }
                if (c >= '\u0b47' && c <= '\u0b48') {
                    return true;
                }
                if (c >= '\u0b4b' && c <= '\u0b4d') {
                    return true;
                }
                if (c >= '\u0b56' && c <= '\u0b57') {
                    return true;
                }
                if (c >= '\u0b82' && c <= '\u0b83') {
                    return true;
                }
                if (c >= '\u0bbe' && c <= '\u0bc2') {
                    return true;
                }
                if (c >= '\u0bc6' && c <= '\u0bc8') {
                    return true;
                }
                if (c >= '\u0bca' && c <= '\u0bcd') {
                    return true;
                }
                return c == '\u0b3c' || c == '\u0bd7';
            }
            case 12: {
                if (c >= '\u0c01' && c <= '\u0c03') {
                    return true;
                }
                if (c >= '\u0c3e' && c <= '\u0c44') {
                    return true;
                }
                if (c >= '\u0c46' && c <= '\u0c48') {
                    return true;
                }
                if (c >= '\u0c4a' && c <= '\u0c4d') {
                    return true;
                }
                if (c >= '\u0c55' && c <= '\u0c56') {
                    return true;
                }
                if (c >= '\u0c82' && c <= '\u0c83') {
                    return true;
                }
                if (c >= '\u0cbe' && c <= '\u0cc4') {
                    return true;
                }
                if (c >= '\u0cc6' && c <= '\u0cc8') {
                    return true;
                }
                if (c >= '\u0cca' && c <= '\u0ccd') {
                    return true;
                }
                return c >= '\u0cd5' && c <= '\u0cd6';
            }
            case 13: {
                if (c >= '\u0d02' && c <= '\u0d03') {
                    return true;
                }
                if (c >= '\u0d3e' && c <= '\u0d43') {
                    return true;
                }
                if (c >= '\u0d46' && c <= '\u0d48') {
                    return true;
                }
                if (c >= '\u0d4a' && c <= '\u0d4d') {
                    return true;
                }
                return c == '\u0d57';
            }
            case 14: {
                if (c >= '\u0e34' && c <= '\u0e3a') {
                    return true;
                }
                if (c >= '\u0e47' && c <= '\u0e4e') {
                    return true;
                }
                if (c >= '\u0eb4' && c <= '\u0eb9') {
                    return true;
                }
                if (c == '\u0ebb' && c <= '\u0ebc') {
                    return true;
                }
                if (c >= '\u0ec8' && c <= '\u0ecd') {
                    return true;
                }
                return c == '\u0e31' || c == '\u0eb1';
            }
            case 15: {
                if (c >= '\u0f18' && c <= '\u0f19') {
                    return true;
                }
                if (c >= '\u0f71' && c <= '\u0f84') {
                    return true;
                }
                if (c >= '\u0f86' && c <= '\u0f8b') {
                    return true;
                }
                if (c >= '\u0f90' && c <= '\u0f95') {
                    return true;
                }
                if (c >= '\u0f99' && c <= '\u0fad') {
                    return true;
                }
                if (c >= '\u0fb1' && c <= '\u0fb7') {
                    return true;
                }
                return c == '\u0f35' || c == '\u0f37' || c == '\u0f39' || c == '\u0f3e' || c == '\u0f3f' || c == '\u0f97' || c == '\u0fb9';
            }
            case 32: {
                if (c >= '\u20d0' && c <= '\u20dc') {
                    return true;
                }
                return c == '\u20e1';
            }
            case 48: {
                if (c >= '\u302a' && c <= '\u302f') {
                    return true;
                }
                return c == '\u3099' || c == '\u309a';
            }
        }
        return false;
    }

    boolean isExtender(char c) {
        switch (c) {
            case '\u00b7': 
            case '\u02d0': 
            case '\u02d1': 
            case '\u0387': 
            case '\u0640': 
            case '\u0e46': 
            case '\u0ec6': 
            case '\u3005': {
                return true;
            }
        }
        if (c >= '\u3031' && c <= '\u3035') {
            return true;
        }
        if (c >= '\u309d' && c <= '\u309e') {
            return true;
        }
        return c >= '\u30fc' && c <= '\u30fe';
    }

    char nextChar() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        char c = this.getChar();
        switch (c) {
            case '&': {
                c = this.processAmpersand();
                break;
            }
            case '%': {
                c = this.processPercent();
                break;
            }
        }
        if (c == '\n') {
            ++this.line;
            this.column = 1;
        } else {
            ++this.column;
        }
        return c;
    }

    char processAmpersand() throws XMLMiddlewareException, IOException, EOFException {
        switch (this.entityState) {
            case 1: {
                this.throwXMLMiddlewareException("Invalid general entity reference or character reference.");
            }
            case 2: {
                if (this.getChar() == '#') {
                    this.getCharRef();
                } else {
                    this.restore();
                    this.getGeneralEntityRef();
                }
                return this.nextChar();
            }
            case 3: {
                if (this.getChar() == '#') {
                    this.getCharRef();
                    return this.nextChar();
                }
                this.restore();
                return '&';
            }
            case 0: 
            case 4: 
            case 5: {
                return '&';
            }
        }
        throw new IllegalStateException("Internal error: invalid entity state: " + this.entityState);
    }

    char processPercent() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        switch (this.entityState) {
            case 1: {
                char c = this.getChar();
                this.restore();
                if (this.isWhitespace(c)) {
                    return '%';
                }
                this.getParameterEntityRef();
                return this.nextChar();
            }
            case 2: {
                return '%';
            }
            case 3: {
                this.getParameterEntityRef();
                return this.nextChar();
            }
            case 0: 
            case 4: 
            case 5: {
                return '%';
            }
        }
        throw new IllegalStateException("Internal error: invalid entity state: " + this.entityState);
    }

    void getCharRef() throws XMLMiddlewareException, IOException, EOFException {
        boolean bl = false;
        char[] cArray = new char[1];
        int n = 0;
        char c = this.getChar();
        if (c == 'x') {
            bl = true;
            c = this.getChar();
        }
        while (c != ';') {
            if (bl) {
                if ((c = Character.toUpperCase(c)) < '0' || c > 'F' || c > '9' && c < 'A') {
                    this.throwXMLMiddlewareException("Invalid character in character reference: " + c);
                }
                n *= 16;
                n += c < 'A' ? c - 48 : c - 65 + 10;
            } else {
                if (c < '0' || c > '9') {
                    this.throwXMLMiddlewareException("Invalid character in character reference: " + c);
                }
                n *= 10;
                n += c - 48;
            }
            c = this.getChar();
        }
        if (n > 65535) {
            this.throwXMLMiddlewareException("Invalid character reference: " + n);
        }
        this.pushCurrentReader();
        cArray[0] = (char)n;
        this.createStringReader(new String(cArray));
        this.ignoreQuote = true;
        this.ignoreMarkup = true;
    }

    void getGeneralEntityRef() throws XMLMiddlewareException, IOException, EOFException {
        char c;
        this.resetNameBuffer();
        while ((c = this.getChar()) != ';') {
            this.appendNameBuffer(c);
        }
        String string = this.getNameBuffer();
        this.pushCurrentReader();
        ParsedGeneralEntity parsedGeneralEntity = (ParsedGeneralEntity)this.dtd.parsedGeneralEntities.get(string);
        if (parsedGeneralEntity == null && (parsedGeneralEntity = (ParsedGeneralEntity)this.predefinedEntities.get(string)) == null) {
            this.throwXMLMiddlewareException("Reference to undefined parsed general entity: " + string);
        }
        if (parsedGeneralEntity.value == null) {
            this.throwXMLMiddlewareException("Reference to external parsed general entity in attribute value: " + string);
        }
        this.createStringReader(parsedGeneralEntity.value);
        this.ignoreQuote = true;
        this.ignoreMarkup = false;
    }

    void getParameterEntityRef() throws XMLMiddlewareException, MalformedURLException, IOException, EOFException {
        char c;
        this.resetNameBuffer();
        while ((c = this.getChar()) != ';') {
            this.appendNameBuffer(c);
        }
        String string = this.getNameBuffer();
        this.pushCurrentReader();
        ParameterEntity parameterEntity = (ParameterEntity)this.dtd.parameterEntities.get(string);
        if (parameterEntity == null) {
            this.throwXMLMiddlewareException("Reference to undefined parameter entity: " + string);
        }
        this.pushStringReader(" ", false, false);
        if (parameterEntity.value != null) {
            this.pushStringReader(parameterEntity.value, this.entityState == 3, false);
        } else {
            this.pushURLReader(parameterEntity.systemID, this.entityState == 3, false);
        }
        this.createStringReader(" ");
        this.ignoreQuote = false;
        this.ignoreMarkup = false;
    }

    void createStringReader(String string) {
        this.reader = new StringReader(string);
        this.readerType = 0;
        int n = string.length() > 8096 ? 8096 : string.length();
        this.buffer = new char[n];
        this.bufferPos = 8097;
        this.bufferLen = -1;
        this.line = 1;
        this.column = 1;
    }

    void createURLReader(URL uRL) throws IOException {
        this.reader = new InputStreamReader(uRL.openStream());
        this.readerType = 0;
        this.readerURL = uRL;
        this.buffer = new char[8096];
        this.bufferPos = 8097;
        this.bufferLen = 0;
        this.line = 1;
        this.column = 1;
    }

    void pushCurrentReader() {
        this.readerStack.push(new ReaderInfo(this.reader, this.buffer, this.readerURL, null, this.readerType, this.bufferPos, this.bufferLen, this.line, this.column, this.ignoreQuote, this.ignoreMarkup));
    }

    void pushStringReader(String string, boolean bl, boolean bl2) {
        this.readerStack.push(new ReaderInfo(null, null, null, string, 1, 0, 0, 1, 1, bl, bl2));
    }

    void pushURLReader(String string, boolean bl, boolean bl2) throws MalformedURLException {
        URL uRL = new URL(this.readerURL, string);
        this.readerStack.push(new ReaderInfo(null, null, uRL, null, 2, 0, 0, 1, 1, bl, bl2));
    }

    void popReader() throws XMLMiddlewareException, IOException, EOFException {
        if (this.readerStack.empty()) {
            throw new EOFException("End of file reached while parsing.");
        }
        ReaderInfo readerInfo = (ReaderInfo)this.readerStack.pop();
        switch (readerInfo.type) {
            case 0: {
                this.reader = readerInfo.reader;
                this.readerType = readerInfo.type;
                this.readerURL = readerInfo.url;
                this.buffer = readerInfo.buffer;
                this.bufferPos = readerInfo.bufferPos;
                this.bufferLen = readerInfo.bufferLen;
                this.line = readerInfo.line;
                this.column = readerInfo.column;
                break;
            }
            case 1: {
                this.createStringReader(readerInfo.str);
                break;
            }
            case 2: {
                this.createURLReader(readerInfo.url);
                break;
            }
        }
        this.ignoreQuote = readerInfo.ignoreQuote;
        this.ignoreMarkup = readerInfo.ignoreMarkup;
    }

    void resetNameBuffer() {
        this.namePos = -1;
        this.nameStr = null;
    }

    void appendNameBuffer(char c) {
        ++this.namePos;
        if (this.namePos >= 1024) {
            if (this.nameStr == null) {
                this.nameStr = new StringBuffer();
            }
            this.nameStr.append(this.nameBuffer);
            this.namePos = 0;
        }
        this.nameBuffer[this.namePos] = c;
    }

    String getNameBuffer() {
        if (this.nameStr == null) {
            return new String(this.nameBuffer, 0, this.namePos + 1);
        }
        this.nameStr.append(this.nameBuffer, 0, this.namePos + 1);
        return this.nameStr.toString();
    }

    void initReaderGlobals() {
        this.reader = null;
        this.readerURL = null;
        this.line = 1;
        this.column = 1;
        this.ignoreQuote = false;
        this.ignoreMarkup = false;
    }

    char getChar() throws XMLMiddlewareException, IOException, EOFException {
        if (this.bufferPos >= this.bufferLen) {
            this.bufferLen = this.reader.read(this.buffer, 0, this.buffer.length);
            if (this.bufferLen == -1) {
                this.popReader();
                return this.getChar();
            }
            this.bufferPos = 0;
        }
        return this.buffer[this.bufferPos++];
    }

    void restore() {
        --this.bufferPos;
    }

    void restore(String string) {
        this.pushCurrentReader();
        this.createStringReader(string);
    }

    void openInputSource(InputSource inputSource) throws XMLMiddlewareException, IOException {
        String string = inputSource.getSystemId();
        try {
            this.readerURL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.readerURL = null;
        }
        Reader reader = inputSource.getCharacterStream();
        if (reader != null) {
            this.reader = reader;
            this.readerType = 0;
            this.buffer = new char[8096];
            this.bufferPos = 8097;
            this.bufferLen = 0;
            return;
        }
        InputStream inputStream = inputSource.getByteStream();
        if (inputStream != null) {
            this.reader = new InputStreamReader(inputStream);
            this.readerType = 0;
            this.buffer = new char[8096];
            this.bufferPos = 8097;
            this.bufferLen = 0;
            return;
        }
        if (this.readerURL != null) {
            this.createURLReader(this.readerURL);
            return;
        }
        this.throwXMLMiddlewareException("InputSource does not have a character stream, byte stream, or system ID.");
    }

    class ReaderInfo {
        Reader reader;
        char[] buffer;
        URL url;
        String str;
        int type;
        int bufferPos;
        int bufferLen;
        int line;
        int column;
        boolean ignoreQuote;
        boolean ignoreMarkup;

        ReaderInfo(Reader reader, char[] cArray, URL uRL, String string, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
            DTDParser.this = DTDParser.this;
            this.reader = reader;
            this.buffer = cArray;
            this.url = uRL;
            this.str = string;
            this.type = n;
            this.bufferPos = n2;
            this.bufferLen = n3;
            this.line = n4;
            this.column = n5;
            this.ignoreQuote = bl;
            this.ignoreMarkup = bl2;
        }
    }
}

