/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xmlmiddleware.db.CPConnectionEvent;
import org.xmlmiddleware.db.CPConnectionEventListener;
import org.xmlmiddleware.db.CPConnectionEventSource;
import org.xmlmiddleware.db.StatementPool;
import org.xmlmiddleware.utils.XMLMiddlewareException;

public class CPConnection
implements Connection,
CPConnectionEventSource {
    protected Connection m_connection;
    protected StatementPool m_statements;
    protected boolean m_statementsAcrossCommit;
    protected boolean m_statementsAcrossRollback;
    protected Hashtable m_listeners;
    private static final Object obj = new Object();

    protected CPConnection(Connection connection, StatementPool statementPool) throws SQLException {
        this.m_connection = connection;
        this.m_statements = statementPool == null ? new StatementPool(connection) : statementPool;
        this.m_listeners = new Hashtable();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        this.m_statementsAcrossCommit = databaseMetaData.supportsOpenStatementsAcrossCommit();
        this.m_statementsAcrossRollback = databaseMetaData.supportsOpenCursorsAcrossRollback();
    }

    protected void finalize() {
        try {
            this.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public Statement createStatement() throws SQLException {
        this.checkState();
        try {
            return this.m_connection.createStatement();
        }
        catch (SQLException sQLException) {
            this.fireErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkState();
        try {
            return (PreparedStatement)this.m_statements.checkOut(string);
        }
        catch (XMLMiddlewareException xMLMiddlewareException) {
            if (xMLMiddlewareException.getException() instanceof SQLException) {
                throw (SQLException)xMLMiddlewareException.getException();
            }
            throw new SQLException(xMLMiddlewareException.getMessage());
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.checkState();
        try {
            return this.m_connection.prepareCall(string);
        }
        catch (SQLException sQLException) {
            this.fireErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public String nativeSQL(String string) throws SQLException {
        this.checkState();
        try {
            return this.m_connection.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.fireErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkState();
        try {
            this.m_connection.setAutoCommit(bl);
            return;
        }
        catch (SQLException sQLException) {
            this.fireErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkState();
        try {
            return this.m_connection.getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.fireErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public void commit() throws SQLException {
        this.checkState();
        try {
            if (!this.m_statementsAcrossCommit) {
                this.m_statements.clear();
            }
            this.m_connection.commit();
            return;
        }
        catch (SQLException sQLException) {
            this.fireErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public void rollback() throws SQLException {
        this.checkState();
        try {
            if (!this.m_statementsAcrossRollback) {
                this.m_statements.clear();
            }
            this.m_connection.rollback();
            return;
        }
        catch (SQLException sQLException) {
            this.fireErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public void close() throws SQLException {
        this.checkState();
        this.fireCloseEvent();
    }

    public boolean isClosed() throws SQLException {
        try {
            if (this.m_connection == null) {
                return true;
            }
            return this.m_connection.isClosed();
        }
        catch (SQLException sQLException) {
            this.fireErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkState();
        try {
            return this.m_connection.getMetaData();
        }
        catch (SQLException sQLException) {
            this.fireErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.checkState();
        try {
            this.m_connection.setReadOnly(bl);
            return;
        }
        catch (SQLException sQLException) {
            this.fireErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public boolean isReadOnly() throws SQLException {
        this.checkState();
        try {
            return this.m_connection.isReadOnly();
        }
        catch (SQLException sQLException) {
            this.fireErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public void setCatalog(String string) throws SQLException {
        this.checkState();
        try {
            this.m_connection.setCatalog(string);
            return;
        }
        catch (SQLException sQLException) {
            this.fireErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public String getCatalog() throws SQLException {
        this.checkState();
        try {
            return this.m_connection.getCatalog();
        }
        catch (SQLException sQLException) {
            this.fireErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.checkState();
        try {
            this.m_connection.setTransactionIsolation(n);
            return;
        }
        catch (SQLException sQLException) {
            this.fireErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkState();
        try {
            return this.m_connection.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.fireErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkState();
        try {
            return this.m_connection.getWarnings();
        }
        catch (SQLException sQLException) {
            this.fireErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public void clearWarnings() throws SQLException {
        this.checkState();
        try {
            this.m_connection.clearWarnings();
            return;
        }
        catch (SQLException sQLException) {
            this.fireErrorEvent(sQLException);
            throw sQLException;
        }
    }

    public void addConnectionEventListener(CPConnectionEventListener cPConnectionEventListener) {
        this.m_listeners.put(cPConnectionEventListener, obj);
    }

    public void removeConnectionEventListener(CPConnectionEventListener cPConnectionEventListener) {
        this.m_listeners.remove(cPConnectionEventListener);
    }

    protected Connection getConnection() {
        return this.m_connection;
    }

    protected StatementPool getStatementPool() {
        return this.m_statements;
    }

    protected void invalidate() {
        this.m_connection = null;
        this.m_statements = null;
    }

    private void fireCloseEvent() {
        CPConnectionEvent cPConnectionEvent = new CPConnectionEvent(this);
        Enumeration enumeration = this.m_listeners.keys();
        while (enumeration.hasMoreElements()) {
            CPConnectionEventListener cPConnectionEventListener = (CPConnectionEventListener)enumeration.nextElement();
            cPConnectionEventListener.connectionClosed(cPConnectionEvent);
        }
    }

    private void fireErrorEvent(SQLException sQLException) {
        CPConnectionEvent cPConnectionEvent = new CPConnectionEvent(this, sQLException);
        Enumeration enumeration = this.m_listeners.keys();
        while (enumeration.hasMoreElements()) {
            CPConnectionEventListener cPConnectionEventListener = (CPConnectionEventListener)enumeration.nextElement();
            cPConnectionEventListener.connectionErrorOccurred(cPConnectionEvent);
        }
    }

    private void checkState() throws SQLException {
        if (this.m_connection == null) {
            throw new SQLException("[XML-DBMS][CPConnection] Connection closed.", "08003");
        }
    }
}

