/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.Base64Util;
import com.trs.idm.util.StringHelper;

public class HttpBase64Util {
    private static final String PLUS_BEFORE = "+";
    private static final String PLUS_AFTER = "*";
    private static final String EQUAL_BEFORE = "=";
    private static final String EQUAL_AFTER = "_";
    private static final String SLASH_BEFORE = "/";
    private static final String SLASH_AFTER = "-";

    public static String encode(String origin) {
        return HttpBase64Util.encode(origin, "UTF-8");
    }

    public static String encode(String origin, String charsetName) {
        String simpleBase64Str = Base64Util.encode(origin, charsetName);
        if (StringHelper.isEmpty(simpleBase64Str)) {
            return "";
        }
        String httpBase64Str = StringHelper.replaceStr(simpleBase64Str, PLUS_BEFORE, PLUS_AFTER);
        httpBase64Str = StringHelper.replaceStr(httpBase64Str, EQUAL_BEFORE, EQUAL_AFTER);
        httpBase64Str = StringHelper.replaceStr(httpBase64Str, SLASH_BEFORE, SLASH_AFTER);
        return httpBase64Str;
    }

    public static String decode(String httpBase64Str) {
        return HttpBase64Util.decode(httpBase64Str, "UTF-8");
    }

    public static String decode(String httpBase64Str, String charsetName) {
        if (StringHelper.isEmpty(httpBase64Str)) {
            return "";
        }
        String simpleBase64Str = StringHelper.replaceStr(httpBase64Str, PLUS_AFTER, PLUS_BEFORE);
        simpleBase64Str = StringHelper.replaceStr(simpleBase64Str, EQUAL_AFTER, EQUAL_BEFORE);
        simpleBase64Str = StringHelper.replaceStr(simpleBase64Str, SLASH_AFTER, SLASH_BEFORE);
        return Base64Util.decode(simpleBase64Str, charsetName);
    }
}

