/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.EyouMailHelper;
import java.util.Hashtable;
import junit.framework.TestCase;

public class EyouMailHelperTest
extends TestCase {
    public EyouMailHelperTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBuildCreateUserMessage() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("EYOU_DOMAIN", "www.trs.com.cn");
        EyouMailHelper helper = new EyouMailHelper(properties);
        String message = helper.buildMessage("add{", "user001", "user001", "user001", 0);
        EyouMailHelperTest.assertEquals((String)message, (String)"add{\r\ndomain=www.trs.com.cn\r\nuid=user001\r\nusername=user001\r\nuserPassword=user001\r\nlockstatus=0\r\n}\r\n.\r\n");
    }

    public void testCreateUserActually() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("EYOU_DOMAIN", "songpeng.com");
        properties.put("EYOU_IP", "192.9.200.209");
        properties.put("EYOU_PORT", "80");
        EyouMailHelper helper = new EyouMailHelper(properties);
        boolean result = false;
        try {
            result = helper.createUser("user002", "\ufffd\u00fb\ufffd002", "111111");
        }
        catch (Exception e) {
            e.printStackTrace();
            EyouMailHelperTest.fail();
        }
        EyouMailHelperTest.assertTrue((boolean)result);
    }

    public void testDeleteUser() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("EYOU_DOMAIN", "www.trs.com.cn");
        EyouMailHelper helper = new EyouMailHelper(properties);
        EyouMailHelperTest.assertEquals((String)helper.buildMessage("del{", "user001", null, null, -1), (String)"del{\r\ndomain=www.trs.com.cn\r\nuid=user001\r\n}\r\n.\r\n");
    }

    public void testFindUser() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("EYOU_DOMAIN", "www.trs.com.cn");
        EyouMailHelper helper = new EyouMailHelper(properties);
        EyouMailHelperTest.assertEquals((String)helper.buildMessage("search{", "user001", null, null, -1), (String)"search{\r\ndomain=www.trs.com.cn\r\nuid=user001\r\n}\r\n.\r\n");
    }

    public void testUpdateUser() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("EYOU_DOMAIN", "www.trs.com.cn");
        EyouMailHelper helper = new EyouMailHelper(properties);
        EyouMailHelperTest.assertEquals((String)helper.buildMessage("upd{", "user001", "user001", "user001", 0), (String)"upd{\r\ndomain=www.trs.com.cn\r\nuid=user001\r\nusername=user001\r\nuserPassword=user001\r\nlockstatus=0\r\n}\r\n.\r\n");
    }

    public static void main(String[] args) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        if (args.length < 3) {
            System.out.println("EyouMailHelperTest IP Port Domain");
            return;
        }
        properties.put("EYOU_IP", args[0]);
        properties.put("EYOU_PORT", args[1]);
        properties.put("EYOU_DOMAIN", args[2]);
        EyouMailHelper helper = new EyouMailHelper(properties);
        try {
            helper.createUser("user001", "user001", "user001");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

