/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.common.IConfig;
import com.trs.idm.common.PropertyConfig;
import com.trs.idm.data.access.IDBAccessor;
import com.trs.idm.exception.IdMException;
import com.trs.idm.util.ClassUtil;
import org.apache.log4j.Logger;

public class DBAccessorUtil {
    private static final String DEFAULT_DB_ACCESSOR = "com.trs.idm.data.access.rdb.Hb3DataAccessor";
    private static final Logger LOG = Logger.getLogger(DBAccessorUtil.class);

    public static IDBAccessor getDBAccessor() throws IdMException {
        PropertyConfig idsCfg = new PropertyConfig();
        String dbAccessorClassName = idsCfg.getConfig("IDBAccessor.class");
        if (dbAccessorClassName == null) {
            dbAccessorClassName = DEFAULT_DB_ACCESSOR;
        }
        IDBAccessor dbAccessor = (IDBAccessor)ClassUtil.getInstanceByClassName(dbAccessorClassName);
        try {
            dbAccessor.start((IConfig)idsCfg);
            LOG.info((Object)"dbAccessor start successfully");
        }
        catch (IdMException e) {
            LOG.error((Object)"dbAccessor start failed!", (Throwable)e);
        }
        return dbAccessor;
    }

    public static IDBAccessor getDBAccessor(String driver, String jdbcurl, String userName, String password, String hbm2ddl, String dialect) throws IdMException {
        PropertyConfig idsCfg = null;
        try {
            idsCfg = new PropertyConfig(false);
        }
        catch (IdMException idMException) {
            // empty catch block
        }
        idsCfg.setConfig("hibernate.connection.driver_class", driver);
        idsCfg.setConfig("hibernate.connection.url", jdbcurl);
        idsCfg.setConfig("hibernate.connection.username", userName);
        idsCfg.setConfig("hibernate.connection.password", password);
        idsCfg.setConfig("hibernate.hbm2ddl.auto", hbm2ddl);
        idsCfg.setConfig("hibernate.dialect", dialect);
        String dbAccessorClassName = idsCfg.getConfig("IDBAccessor.class");
        if (dbAccessorClassName == null) {
            dbAccessorClassName = DEFAULT_DB_ACCESSOR;
        }
        IDBAccessor dbAccessor = (IDBAccessor)ClassUtil.getInstanceByClassName(dbAccessorClassName);
        try {
            dbAccessor.start((IConfig)idsCfg);
            LOG.info((Object)"dbAccessor start successfully");
        }
        catch (IdMException e) {
            LOG.error((Object)"dbAccessor start failed!", (Throwable)e);
        }
        return dbAccessor;
    }

    public static String getIPAddr(String jdbcUrl) {
        String jdbcDBURLWithIPStr = jdbcUrl.substring(jdbcUrl.indexOf("://") + 3);
        return jdbcDBURLWithIPStr.substring(0, jdbcDBURLWithIPStr.indexOf(":"));
    }
}

