/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.saml.sp.transporter.impl;

import com.trs.idm.exception.ServiceProviderException;
import com.trs.idm.saml.interact.IRequest;
import com.trs.idm.saml.sp.transporter.TransporterBase;
import com.trs.idm.util.CookieHelper;
import com.trs.idm.util.RequestUtil;
import com.trs.idm.util.StringHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.log4j.Logger;

public class HttpClientTransporter
extends TransporterBase {
    private static final Logger LOG = Logger.getLogger(HttpClientTransporter.class);
    private static final int CONN_TIMEOUT = 20000;
    private static HttpClient httpClient = null;
    private String idpURL;
    protected Map nameValuePairs = new HashMap();

    public HttpClientTransporter(String idpURL) {
        this.idpURL = idpURL;
        LOG.info((Object)("HttpClientTransporter inited, IDP URL: " + idpURL));
    }

    private HttpClient buildHttpClient() {
        HttpClient httpClient = new HttpClient();
        HttpConnectionManager httpConnManager = httpClient.getHttpConnectionManager();
        if (httpConnManager != null) {
            HttpConnectionManagerParams mgrParams = new HttpConnectionManagerParams();
            mgrParams.setSoTimeout(20000);
            mgrParams.setTcpNoDelay(true);
            mgrParams.setConnectionTimeout(20000);
            mgrParams.setLinger(0);
            mgrParams.setStaleCheckingEnabled(false);
            httpConnManager.setParams(mgrParams);
        }
        return httpClient;
    }

    @Override
    public String doTransport(IRequest tokenRequest, HttpServletRequest request, HttpServletResponse response) throws ServiceProviderException {
        if (tokenRequest == null) {
            LOG.warn((Object)"request is null, so return null");
            return null;
        }
        httpClient = this.buildHttpClient();
        String destination = null;
        destination = this.idpURL;
        LOG.debug((Object)("destination: " + destination));
        PostMethod methodPost = new PostMethod(destination);
        CookieHelper cookieHelper = new CookieHelper(request, response);
        methodPost.addParameter("request_type", tokenRequest.getRequestType());
        methodPost.addParameter("SAMLRequest", tokenRequest.getBase64RequestBody());
        methodPost.addParameter("clientIP", request.getRemoteAddr().toString());
        methodPost.addParameter("coAppName", tokenRequest.getServiceProvider().getCoAppName());
        methodPost.addParameter("issuer", RequestUtil.getAppBaseURL(request));
        methodPost.addParameter("coSessionId", request.getSession().getId());
        String ssoSessionIdInCookie = cookieHelper.getValue("com.trs.idm.gSessionId");
        if (!StringHelper.isEmpty(ssoSessionIdInCookie)) {
            methodPost.addParameter("com.trs.idm.gSessionId", ssoSessionIdInCookie);
        }
        if ("SimpleSelfPageLoginHttpPostRequest".equals(tokenRequest.getRequestType())) {
            String userNameField = tokenRequest.getServiceProvider().getConfig().getConfig("sso.selfLoginPage.userName.field", "userName");
            String passwordField = tokenRequest.getServiceProvider().getConfig().getConfig("sso.selfLoginPage.password.field", "password");
            String selfLoginPageUserName = "";
            selfLoginPageUserName = request.getParameter(userNameField);
            String selfLoginPagePassword = "";
            selfLoginPagePassword = request.getParameter(passwordField);
            LOG.debug((Object)("this is a http post login request, userNameField: " + userNameField + "; passwordField: " + passwordField + "; selfLoginPageUserName: " + selfLoginPageUserName));
            if (selfLoginPageUserName == null) {
                selfLoginPageUserName = "";
            }
            if (selfLoginPagePassword == null) {
                selfLoginPagePassword = "";
            }
            methodPost.addParameter("sp.simple.selfLoginPage.userName.vale", selfLoginPageUserName);
            methodPost.addParameter("sp.simple.selfLoginPage.password.value", selfLoginPagePassword);
        }
        String responseBody = null;
        try {
            try {
                methodPost.setRequestHeader("Connection", "close");
                httpClient.executeMethod((HttpMethod)methodPost);
                InputStream responseStream = methodPost.getResponseBodyAsStream();
                responseBody = StringHelper.convertStreamToString(responseStream, "UTF-8");
            }
            catch (HttpException e) {
                LOG.error((Object)"error while doPostRequest ", (Throwable)e);
                methodPost.releaseConnection();
            }
            catch (IOException e) {
                LOG.error((Object)"error while doPostRequest ", (Throwable)e);
                methodPost.releaseConnection();
            }
        }
        finally {
            methodPost.releaseConnection();
        }
        return responseBody;
    }

    @Override
    public String getName() {
        return "httpClient";
    }
}

