/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent;

import com.trs.idm.exception.IdMException;
import com.trs.idm.http.PureClient;
import com.trs.idm.interact.agent.AgentVersion;
import com.trs.idm.interact.agent.IClientTransfer;
import com.trs.idm.interact.protocol.PacketUtil;
import com.trs.idm.interact.protocol.ProtocolPacket;
import com.trs.idm.interact.protocol.RequestPacket;
import com.trs.idm.interact.protocol.ResponsePacket;
import com.trs.idm.util.Base64Util;
import com.trs.idm.util.EnvUtil;
import com.trs.idm.util.StringHelper;
import com.trs.idm.util.UrlUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.log4j.Logger;

public class HTTPClientTransfer
implements IClientTransfer {
    private static final Logger LOG = Logger.getLogger(HTTPClientTransfer.class);
    private String agentName;
    private String host;
    private int port;
    private Properties props;
    private String serverInfo;
    private String nodeKeyOfIDSServer = "";
    private String url;

    public HTTPClientTransfer(String host, int port, String agentName, String serverInfo, Properties props) {
        this.host = host;
        this.port = port;
        this.agentName = agentName;
        this.serverInfo = serverInfo;
        this.props = props;
        this.url = props.getProperty("protocol.http.url");
    }

    @Override
    public void close() {
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getNodeKeyOfIDSServer() {
        return this.nodeKeyOfIDSServer;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public byte[] getResponse(byte[] req) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("user-agent", "TRS Identity Server");
        headers.put("coAppName", Base64Util.encode(this.agentName.getBytes()));
        NameValuePair[] pairs = new NameValuePair[]{new NameValuePair()};
        pairs[0].setName("idsRequest");
        pairs[0].setValue(UrlUtil.encode(Base64Util.encode(req)));
        String responseBody = PureClient.postHttpRequest(this.url, headers, null, pairs).getResponseBodyAsTrimStr();
        byte[] decodeBytes = Base64Util.decodeBytes(UrlUtil.decode(responseBody));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("send idsRequest: " + pairs[0].getValue() + " to " + this.url + ", responseBodyAsTrimStr: " + responseBody + "; decodeBytes: [" + StringHelper.toString(decodeBytes) + "]"));
        }
        return decodeBytes;
    }

    @Override
    public void init() throws IOException {
        LOG.info((Object)"init http client transfer successfully!");
    }

    @Override
    public boolean isSocketAlive() {
        return true;
    }

    @Override
    public void initCoAppConfig() throws IOException {
        String logoutUri = this.props.getProperty("logout.uri", "/logout.jsp");
        String allowGuest = this.props.getProperty("allow.anonymous", "n");
        RequestPacket req = null;
        try {
            req = new RequestPacket(99, new String[]{this.agentName, logoutUri, allowGuest, this.serverInfo, EnvUtil.getJavaEnvInfo(), AgentVersion.getReleaseInfo(), AgentVersion.getSourceLocation(), System.getProperty("os.name"), System.getProperty("user.name"), System.getProperty("user.dir")}, null);
        }
        catch (IdMException e) {
            LOG.error((Object)"this exception should NOT happen!", (Throwable)e);
            throw new RuntimeException(e);
        }
        byte[] bytesResp = this.getResponse(req.toBytes());
        ProtocolPacket packet = PacketUtil.parseFromBytes(bytesResp);
        if (!(packet instanceof ResponsePacket)) {
            LOG.error((Object)("received: [" + packet + "] not a ResponsePacket! IDS Server: [" + this.host + ":" + this.port + "]"));
            throw new IOException("Received is not a IDS ResponsePacket!");
        }
        ResponsePacket resp = (ResponsePacket)packet;
        if (resp.getErrCode() != 1) {
            throw new IOException("the coAppName:[" + this.agentName + "] not exist on IDS Server: [" + this.host + ":" + this.port + "]");
        }
        this.nodeKeyOfIDSServer = resp.getData(0);
    }
}

