/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.http;

import com.trs.idm.util.StringHelper;
import java.io.UnsupportedEncodingException;
import java.nio.charset.IllegalCharsetNameException;
import java.util.HashMap;
import java.util.Map;

public class Response {
    public static final String DEF_ENCODING = "ISO8859-1";
    private String requestURL;
    private String actualPath;
    private int statusCode;
    private String statusText;
    private byte[] responseBody;
    private Map responseHeaders = new HashMap();
    private String encoding = "ISO8859-1";
    private boolean fail;
    private Throwable error;
    private String exceptionInfo;

    public Response(String url) {
        this.requestURL = url;
    }

    public Response(String url, Throwable t) {
        this(url);
        if (t != null) {
            this.fail = true;
            this.error = t;
            this.exceptionInfo = t.toString();
        }
    }

    public String getStatusLine() {
        return String.valueOf(this.statusCode) + " " + this.statusText;
    }

    public String getResponseBodyAsTrimStr() {
        if (this.responseBody == null) {
            return null;
        }
        try {
            return new String(this.responseBody, this.encoding).trim();
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.responseBody).trim();
        }
        catch (IllegalCharsetNameException e) {
            return new String(this.responseBody).trim();
        }
    }

    public int getResponseBodyLength() {
        if (this.responseBody == null) {
            return 0;
        }
        return this.responseBody.length;
    }

    public boolean statusCodeIsFine() {
        if (this.statusCode == 0) {
            return false;
        }
        return this.statusCode / 100 < 4;
    }

    public boolean statusCodeIs2XX() {
        return this.statusCode / 100 == 2;
    }

    public String getMainInfo() {
        if (this.statusCodeIs2XX()) {
            return this.getResponseBodyAsTrimStr();
        }
        if (this.isFail()) {
            return this.getExceptionInfo();
        }
        return this.getStatusLine();
    }

    public void addResponseHeader(String name, String value) {
        Object originValue = this.responseHeaders.get(name);
        if (originValue instanceof String) {
            this.responseHeaders.put(name, originValue + "; " + value);
        } else {
            this.responseHeaders.put(name, value);
        }
        if ("Content-Type".equalsIgnoreCase(name) && value != null && value.indexOf(61) > 0) {
            this.encoding = StringHelper.truncateAndTrim(value, "=");
            if (this.encoding != null) {
                this.encoding = this.encoding.toUpperCase();
            }
        }
    }

    Throwable getError() {
        return this.error;
    }

    void setError(Throwable error) {
        this.error = error;
        if (error != null) {
            this.exceptionInfo = error.toString();
        }
    }

    public Map getResponseHeaders() {
        return this.responseHeaders;
    }

    void setResponseHeaders(Map headers) {
        this.responseHeaders = headers;
    }

    public byte[] getResponseBody() {
        return this.responseBody;
    }

    void setResponseBody(byte[] responseBody) {
        this.responseBody = responseBody;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public boolean isFail() {
        return this.fail;
    }

    void setFail(boolean success) {
        this.fail = success;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    void setRequestURL(String requestURL) {
        this.requestURL = requestURL;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getActualPath() {
        return this.actualPath;
    }

    void setActualPath(String actualURL) {
        this.actualPath = actualURL;
    }

    public String getExceptionInfo() {
        return this.exceptionInfo;
    }
}

