/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.authorization.processor;

import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.client.authorization.IAuthorizationActor;
import com.trs.idm.client.authorization.bo.Group;
import com.trs.idm.client.authorization.processor.IAuthorizationProcessor;
import com.trs.idm.util.StringHelper;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class UpdUGAProcessor
implements IAuthorizationProcessor {
    private static final Logger logger = Logger.getLogger(UpdUGAProcessor.class);
    private IAuthorizationActor actor;

    public UpdUGAProcessor(IAuthorizationActor actor) {
        this.actor = actor;
    }

    @Override
    public String process(String data) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("request data is " + data));
        }
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)data);
        }
        catch (DocumentException e) {
            logger.error((Object)("parse user's group assignments failed,data is " + data), (Throwable)e);
        }
        if (doc == null) {
            return null;
        }
        Element assignments = doc.getRootElement();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("update user's group assignments to :" + assignments.asXML()));
        }
        if (assignments != null) {
            String userName = assignments.attributeValue("userName");
            String sourceName = assignments.attributeValue("sourceName");
            if (StringHelper.isEmpty(userName)) {
                logger.error((Object)"can not get userName from new uga.");
                return null;
            }
            if (StringHelper.isEmpty(sourceName)) {
                sourceName = "ids_internal";
            }
            Properties userProps = new Properties();
            try {
                userProps.put("userName", userName);
                userProps.put("sourceName", sourceName);
            }
            catch (Exception e) {
                logger.error((Object)("Put userName[" + userName + "] and sourceName[" + sourceName + "] to properties fail! "), (Throwable)e);
            }
            SSOUser user = new SSOUser(userProps);
            Iterator iter = assignments.elementIterator("group");
            if (iter != null) {
                while (iter.hasNext()) {
                    Group group;
                    Element eleGroup = (Element)iter.next();
                    String id = eleGroup.attributeValue("id");
                    String name = eleGroup.attributeValue("name");
                    boolean isAssigned = "true".equalsIgnoreCase(eleGroup.attributeValue("assigned"));
                    if (isAssigned == this.actor.isGroupAssigned(group = new Group(id, name), user)) continue;
                    if (isAssigned) {
                        this.actor.assignToGroup(group, user);
                        continue;
                    }
                    this.actor.removeFromGroup(group, user);
                }
            }
        }
        return null;
    }
}

