/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.actor.v2;

import com.trs.idm.client.actor.ActorException;
import com.trs.idm.client.actor.FormValues;
import com.trs.idm.client.actor.SSOGroup;
import com.trs.idm.client.actor.SSOUser;
import com.trs.idm.client.actor.v2.IServletAppActorV2;
import com.trs.idm.interact.agent.AgentBase;
import com.trs.idm.interact.agent.IAgent;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ServletAppActorV2Wrapper
implements IServletAppActorV2 {
    private static final Logger logger = Logger.getLogger(AgentBase.class);
    private IServletAppActorV2 servletAppActorv2;

    public ServletAppActorV2Wrapper(IServletAppActorV2 servletAppActorv2, IAgent agent) {
        this.servletAppActorv2 = servletAppActorv2;
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
        }
        logger.info((Object)("Create ServletAppActorV2Wrapper by Actor[" + servletAppActorv2 + "] and Agent[" + agent + "]"));
    }

    @Override
    public boolean addGroup(HttpServletRequest request, HttpServletResponse response, SSOGroup group) {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return false;
        }
        logger.info((Object)("Excute addGroup method in Actor[" + this.servletAppActorv2 + "] Ready"));
        logger.info((Object)("SSOGroup: " + group));
        boolean result = false;
        try {
            result = this.servletAppActorv2.addGroup(request, response, group);
        }
        catch (Exception e) {
            logger.error((Object)("Excute addGroup method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.info((Object)("Excute addGroup method in Actor[" + this.servletAppActorv2 + "] Finished, Result: " + (result ? "Success" : "Fail")));
        return result;
    }

    @Override
    public boolean addUser(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return false;
        }
        long beginTime = System.currentTimeMillis();
        logger.info((Object)("Excute addUser method in Actor[" + this.servletAppActorv2 + "] Ready, begin time[" + beginTime + "]"));
        logger.info((Object)("SSOUser: " + user));
        boolean result = false;
        try {
            result = this.servletAppActorv2.addUser(request, response, user);
        }
        catch (Exception e) {
            logger.error((Object)("Excute addUser method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        logger.info((Object)("Excute addUser method in Actor[" + this.servletAppActorv2 + "] Finished, Result: " + (result ? "Success" : "Fail") + ", synchronize to add user cost time[" + (endTime - beginTime) + "] millisecond!"));
        return result;
    }

    @Override
    public boolean checkLocalLogin(HttpServletRequest request, HttpServletResponse response) throws ActorException {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return false;
        }
        logger.debug((Object)("Excute checkLocalLogin method in Actor[" + this.servletAppActorv2 + "] Ready"));
        boolean result = false;
        try {
            result = this.servletAppActorv2.checkLocalLogin(request, response);
        }
        catch (Exception e) {
            logger.error((Object)("Excute checkLocalLogin method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.debug((Object)("Excute checkLocalLogin method in Actor[" + this.servletAppActorv2 + "] Finished, Result: " + (result ? "Success" : "Fail")));
        return result;
    }

    @Override
    public boolean delGroup(HttpServletRequest request, HttpServletResponse response, SSOGroup group) {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return false;
        }
        logger.info((Object)("Excute delGroup method in Actor[" + this.servletAppActorv2 + "] Ready"));
        logger.info((Object)("SSOGroup: " + group));
        boolean result = false;
        try {
            result = this.servletAppActorv2.delGroup(request, response, group);
        }
        catch (Exception e) {
            logger.error((Object)("Excute delGroup method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.info((Object)("Excute delGroup method in Actor[" + this.servletAppActorv2 + "] Finished, Result: " + (result ? "Success" : "Fail")));
        return result;
    }

    @Override
    public boolean disableUser(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return false;
        }
        logger.info((Object)("Excute disableUser method in Actor[" + this.servletAppActorv2 + "] Ready"));
        logger.info((Object)("SSOUser: " + user));
        boolean result = false;
        try {
            result = this.servletAppActorv2.disableUser(request, response, user);
        }
        catch (Exception e) {
            logger.error((Object)("Excute disableUser method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.info((Object)("Excute disableUser method in Actor[" + this.servletAppActorv2 + "] Finished, Result: " + (result ? "Success" : "Fail")));
        return result;
    }

    @Override
    public boolean enableUser(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return false;
        }
        logger.info((Object)("Excute enableUser method in Actor[" + this.servletAppActorv2 + "] Ready"));
        logger.info((Object)("SSOUser: " + user));
        boolean result = false;
        try {
            this.servletAppActorv2.enableUser(request, response, user);
        }
        catch (Exception e) {
            logger.error((Object)("Excute enableUser method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.info((Object)("Excute enableUser method in Actor[" + this.servletAppActorv2 + "] Finished, Result: " + (result ? "Success" : "Fail")));
        return result;
    }

    @Override
    public FormValues extractExtraInput(HttpServletRequest request, HttpServletResponse response) throws ActorException {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return null;
        }
        logger.info((Object)("Excute extractExtraInput method in Actor[" + this.servletAppActorv2 + "] Ready"));
        FormValues formValues = null;
        try {
            formValues = this.servletAppActorv2.extractExtraInput(request, response);
        }
        catch (Exception e) {
            logger.error((Object)("Excute extractExtraInput method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.info((Object)("Excute extractExtraInput method in Actor[" + this.servletAppActorv2 + "] Finished, FormValues: " + formValues));
        return formValues;
    }

    @Override
    public String extractUserName(HttpServletRequest request, HttpServletResponse response) throws ActorException {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return null;
        }
        logger.info((Object)("Excute extractUserName method in Actor[" + this.servletAppActorv2 + "] Ready"));
        String userName = null;
        try {
            userName = this.servletAppActorv2.extractUserName(request, response);
        }
        catch (Exception e) {
            logger.error((Object)("Excute extractUserName method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.info((Object)("Excute extractUserName method in Actor[" + this.servletAppActorv2 + "] Finished, userName: " + userName));
        return userName;
    }

    @Override
    public String extractUserPwd(HttpServletRequest request, HttpServletResponse response) throws ActorException {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return null;
        }
        logger.info((Object)("Excute extractUserPwd method in Actor[" + this.servletAppActorv2 + "] Ready"));
        String userPwd = null;
        try {
            userPwd = this.servletAppActorv2.extractUserPwd(request, response);
        }
        catch (Exception e) {
            logger.error((Object)("Excute extractUserPwd method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.info((Object)("Excute extractUserPwd method in Actor[" + this.servletAppActorv2 + "] Finished"));
        return userPwd;
    }

    @Override
    public String getSessionId(HttpServletRequest request, HttpServletResponse response, boolean create) throws ActorException {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return null;
        }
        logger.debug((Object)("Excute getSessionId method in Actor[" + this.servletAppActorv2 + "] Ready"));
        String getSessionId = null;
        try {
            getSessionId = this.servletAppActorv2.getSessionId(request, response, create);
        }
        catch (Exception e) {
            logger.error((Object)("Excute getSessionId method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.debug((Object)("Excute getSessionId method in Actor[" + this.servletAppActorv2 + "] Finished, coSessionId: " + getSessionId));
        return getSessionId;
    }

    @Override
    public void loadAnonymous(HttpServletRequest request, HttpServletResponse response) throws ActorException {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return;
        }
        logger.info((Object)("Excute loadAnonymous method in Actor[" + this.servletAppActorv2 + "] Ready"));
        try {
            this.servletAppActorv2.loadAnonymous(request, response);
        }
        catch (Exception e) {
            logger.error((Object)("Excute loadAnonymous method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.info((Object)("Excute loadAnonymous method in Actor[" + this.servletAppActorv2 + "] Finished"));
    }

    @Override
    public void loadLoginUser(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return;
        }
        boolean localLoginStatusBefore = this.checkLocalLogin(request, response);
        boolean localLoginStatusAfter = false;
        logger.info((Object)("Excute loadLoginUser method in Actor[" + this.servletAppActorv2 + "] Ready"));
        logger.info((Object)("SSOUser: " + user));
        logger.info((Object)("Before loadLoginUser , local login status is: " + localLoginStatusBefore));
        if (localLoginStatusBefore) {
            logger.warn((Object)("Before excute loadLoginUser method by  Actor[" + this.servletAppActorv2 + "] ,is already localLogin"));
        }
        try {
            this.servletAppActorv2.loadLoginUser(request, response, user);
            localLoginStatusAfter = this.checkLocalLogin(request, response);
        }
        catch (Exception e) {
            logger.error((Object)("Excute loadLoginUser method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.info((Object)("After loadLoginUser , local login status is: " + localLoginStatusAfter));
        if (!localLoginStatusAfter) {
            logger.error((Object)("After excute loadLoginUser method by  Actor[" + this.servletAppActorv2 + "] , still not local login"));
        }
        logger.info((Object)("Excute loadLoginUser method in Actor[" + this.servletAppActorv2 + "] Finished"));
    }

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response) throws ActorException {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return;
        }
        logger.info((Object)("Excute logout method in Actor[" + this.servletAppActorv2 + "] Ready"));
        try {
            this.servletAppActorv2.logout(request, response);
        }
        catch (Exception e) {
            logger.error((Object)("Excute logout method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.info((Object)("Excute logout method in Actor[" + this.servletAppActorv2 + "] Finished"));
    }

    @Override
    public boolean moveToGroup(HttpServletRequest request, HttpServletResponse response, SSOUser user, SSOGroup group) throws ActorException {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return false;
        }
        logger.info((Object)("Excute moveToGroup method in Actor[" + this.servletAppActorv2 + "] Ready"));
        logger.info((Object)("SSOUser: " + user));
        logger.info((Object)("SSOGroup: " + group));
        boolean result = false;
        try {
            result = this.servletAppActorv2.moveToGroup(request, response, user, group);
        }
        catch (Exception e) {
            logger.error((Object)("Excute moveToGroup method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.info((Object)("Excute moveToGroup method in Actor[" + this.servletAppActorv2 + "] Finished, Result: " + (result ? "Success" : "Fail")));
        return result;
    }

    @Override
    public boolean removeFromGroup(HttpServletRequest request, HttpServletResponse response, SSOUser user, SSOGroup group) throws ActorException {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return false;
        }
        logger.info((Object)("Excute removeFromGroup method in Actor[" + this.servletAppActorv2 + "] Ready"));
        logger.info((Object)("SSOUser: " + user));
        logger.info((Object)("SSOGroup: " + group));
        boolean result = false;
        try {
            result = this.servletAppActorv2.removeFromGroup(request, response, user, group);
        }
        catch (Exception e) {
            logger.error((Object)("Excute removeFromGroup method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.info((Object)("Excute removeFromGroup method in Actor[" + this.servletAppActorv2 + "] Finished, Result: " + (result ? "Success" : "Fail")));
        return result;
    }

    @Override
    public boolean removeUser(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return false;
        }
        logger.info((Object)("Excute removeUser method in Actor[" + this.servletAppActorv2 + "] Ready"));
        logger.info((Object)("SSOUser: " + user));
        boolean result = false;
        try {
            result = this.servletAppActorv2.removeUser(request, response, user);
        }
        catch (Exception e) {
            logger.error((Object)("Excute removeUser method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.info((Object)("Excute removeUser method in Actor[" + this.servletAppActorv2 + "] Finished, Result: " + (result ? "Success" : "Fail")));
        return result;
    }

    @Override
    public void start(ServletContext application) {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return;
        }
        logger.info((Object)("Excute start method in Actor[" + this.servletAppActorv2 + "] Ready"));
        try {
            this.servletAppActorv2.start(application);
        }
        catch (AbstractMethodError e) {
            logger.error((Object)("Excute start method in Actor[" + this.servletAppActorv2 + "] warn"), (Throwable)e);
        }
        logger.info((Object)("Excute start method in Actor[" + this.servletAppActorv2 + "] Finished"));
    }

    @Override
    public void stop() {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return;
        }
        logger.info((Object)("Excute stop method in Actor[" + this.servletAppActorv2 + "] Ready"));
        try {
            this.servletAppActorv2.stop();
        }
        catch (AbstractMethodError e) {
            logger.warn((Object)("Excute stop method in Actor[" + this.servletAppActorv2 + "] warn"), (Throwable)e);
        }
        logger.info((Object)("Excute stop method in Actor[" + this.servletAppActorv2 + "] Finished"));
    }

    @Override
    public boolean unremoveUser(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return false;
        }
        logger.info((Object)("Excute unremoveUser method in Actor[" + this.servletAppActorv2 + "] Ready"));
        logger.info((Object)("SSOUser: " + user));
        boolean result = false;
        try {
            result = this.servletAppActorv2.unremoveUser(request, response, user);
        }
        catch (Exception e) {
            logger.error((Object)("Excute unremoveUser method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.info((Object)("Excute unremoveUser method in Actor[" + this.servletAppActorv2 + "] Finished, Result: " + (result ? "Success" : "Fail")));
        return result;
    }

    @Override
    public boolean updateGroup(HttpServletRequest request, HttpServletResponse response, SSOGroup group) {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return false;
        }
        logger.info((Object)("Excute updateGroup method in Actor[" + this.servletAppActorv2 + "] Ready"));
        logger.info((Object)("SSOGroup: " + group));
        boolean result = false;
        try {
            result = this.servletAppActorv2.updateGroup(request, response, group);
        }
        catch (Exception e) {
            logger.error((Object)("Excute updateGroup method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.info((Object)("Excute updateGroup method in Actor[" + this.servletAppActorv2 + "] Finished, Result: " + (result ? "Success" : "Fail")));
        return result;
    }

    @Override
    public boolean updateUser(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return false;
        }
        logger.info((Object)("Excute updateUser method in Actor[" + this.servletAppActorv2 + "] Ready"));
        logger.info((Object)("SSOUser: " + user));
        boolean result = false;
        try {
            result = this.servletAppActorv2.updateUser(request, response, user);
        }
        catch (Exception e) {
            logger.error((Object)("Excute updateUser method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.info((Object)("Excute updateUser method in Actor[" + this.servletAppActorv2 + "] Finished, Result: " + (result ? "Success" : "Fail")));
        return result;
    }

    @Override
    public boolean useStandardHttpSession() {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return false;
        }
        logger.debug((Object)("Excute useStandardHttpSession method in Actor[" + this.servletAppActorv2 + "] Ready"));
        boolean result = false;
        try {
            result = this.servletAppActorv2.useStandardHttpSession();
        }
        catch (Exception e) {
            logger.error((Object)("Excute useStandardHttpSession method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.debug((Object)("Excute useStandardHttpSession method in Actor[" + this.servletAppActorv2 + "] Finished"));
        return result;
    }

    @Override
    public boolean userExist(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        if (this.servletAppActorv2 == null) {
            logger.error((Object)"ServletAppActorv2 in wrapper is null!", new Throwable());
            return false;
        }
        logger.info((Object)("Excute userExist method in Actor[" + this.servletAppActorv2 + "] Ready"));
        logger.info((Object)("SSOUser: " + user));
        boolean result = false;
        try {
            result = this.servletAppActorv2.userExist(request, response, user);
        }
        catch (Exception e) {
            logger.error((Object)("Excute userExist method in Actor[" + this.servletAppActorv2 + "] error"), (Throwable)e);
        }
        logger.info((Object)("Excute userExist method in Actor[" + this.servletAppActorv2 + "] Finished, Result: " + (result ? "Success" : "Fail")));
        return result;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ", wrapped class:  " + this.servletAppActorv2;
    }
}

